/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.alignment;

import jalview.analysis.AlignSeq;
import jalview.analysis.SeqsetUtils;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.ws2.actions.BaseJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class AlignmentJob
extends BaseJob {
    private final List<SequenceI> emptySeqs;
    private final Map<String, SeqsetUtils.SequenceInfo> names;
    private AlignmentI alignmentResult;

    AlignmentJob(List<SequenceI> inputSeqs, List<SequenceI> emptySeqs, Map<String, SeqsetUtils.SequenceInfo> names) {
        super(Collections.unmodifiableList(inputSeqs));
        this.emptySeqs = Collections.unmodifiableList(emptySeqs);
        this.names = Collections.unmodifiableMap(names);
    }

    public static AlignmentJob create(SequenceI[] seqs, int minlen, boolean keepGaps) {
        int nseqs = 0;
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].getEnd() - seqs[i].getStart() < minlen) continue;
            ++nseqs;
        }
        boolean valid = nseqs > 1;
        LinkedHashMap<String, SeqsetUtils.SequenceInfo> names = new LinkedHashMap<String, SeqsetUtils.SequenceInfo>();
        ArrayList<SequenceI> inputSeqs = new ArrayList<SequenceI>();
        ArrayList<SequenceI> emptySeqs = new ArrayList<SequenceI>();
        for (int i = 0; i < seqs.length; ++i) {
            String seqString;
            SequenceI seq = seqs[i];
            String newName = SeqsetUtils.unique_name(i);
            names.put(newName, SeqsetUtils.SeqCharacterHash(seq));
            if (valid && seq.getEnd() - seq.getStart() >= minlen) {
                seqString = seq.getSequenceAsString();
                if (!keepGaps) {
                    seqString = AlignSeq.extractGaps(Comparison.GapChars, seqString);
                }
                inputSeqs.add(new Sequence(newName, seqString));
                continue;
            }
            seqString = "";
            if (seq.getEnd() >= seq.getStart()) {
                seqString = seq.getSequenceAsString();
                if (!keepGaps) {
                    seqString = AlignSeq.extractGaps(Comparison.GapChars, seqString);
                }
            }
            emptySeqs.add(new Sequence(newName, seqString));
        }
        return new AlignmentJob(inputSeqs, emptySeqs, names);
    }

    @Override
    public boolean isInputValid() {
        return this.inputSeqs.size() >= 2;
    }

    List<SequenceI> getEmptySequences() {
        return this.emptySeqs;
    }

    Map<String, SeqsetUtils.SequenceInfo> getNames() {
        return this.names;
    }

    boolean hasResult() {
        return this.alignmentResult != null;
    }

    AlignmentI getAlignmentResult() {
        return this.alignmentResult;
    }

    void setAlignmentResult(AlignmentI alignment) {
        this.alignmentResult = alignment;
    }
}

