/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.ebi;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.FileParse;
import jalview.viewmodel.AlignmentViewport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class HmmerJSONProcessor {
    AlignmentI resultAl;
    AlignmentViewport viewAl = null;
    private String[] score = new String[]{"aliId", "ali_IdCount", "bitscore", "ievalue", "aliSim", "aliSimCount", "aliL", "aliSim", "ievalue", "cevalue"};
    private String[] attrib = new String[]{"bias", "oasc", "is_included", "is_reported"};
    private String[] label = new String[]{"alihmmname"};
    private String[] ipos = new String[]{"alihmmfrom", "alihmmto"};
    private String[] pos_l = new String[]{"alimline", "alimodel", "alirfline"};
    private String[] pos_nscore = new String[]{"alippline"};
    private List<Runnable> viewOps = new ArrayList<Runnable>();
    Map<String, SequenceGroup> groups = new HashMap<String, SequenceGroup>();

    public HmmerJSONProcessor(AlignmentI searchResult) {
        this.resultAl = searchResult;
    }

    public void parseFrom(FileParse jsonsource) throws IOException, OutOfMemoryError {
        JSONParser hmmerResultParser = new JSONParser();
        Object jsonResults = null;
        try {
            jsonResults = hmmerResultParser.parse(jsonsource.getReader());
        }
        catch (Exception p) {
            throw new IOException("While parsing from " + jsonsource.getInFile(), p);
        }
        if (jsonResults == null) {
            throw new IOException("No data at" + jsonsource.getInFile());
        }
        if (!(jsonResults instanceof JSONObject)) {
            throw new IOException("Unexpected JSON model at " + jsonsource.getInFile());
        }
        try {
            JSONObject hmmsearchr = (JSONObject)((JSONObject)jsonResults).get("results");
            this.addStatistics((JSONObject)hmmsearchr.get("stats"));
            JSONArray jsonArray = (JSONArray)hmmsearchr.get("hits");
            long p = 1L;
            for (Object hit : jsonArray) {
                JSONObject hmmhit = (JSONObject)hit;
                this.addHit(hmmhit, p++);
            }
        }
        catch (ClassCastException q) {
            throw new IOException("Unexpected JSON model content at " + jsonsource.getInFile(), q);
        }
    }

    public void addStatistics(JSONObject stats) {
        for (Object stat : stats.keySet()) {
            String key = (String)stat;
            Object val = stats.get(key);
            this.resultAl.setProperty(key, "" + val);
        }
    }

    public void addHit(JSONObject hmmrhit, long p) {
        String sname = (String)hmmrhit.get("name");
        SequenceI[] hits = this.resultAl.findSequenceMatch(sname);
        if (hits == null) {
            System.err.println("No seq for " + sname);
        }
        double pvalue = (Double)hmmrhit.get("pvalue");
        double evalue = Double.valueOf("" + hmmrhit.get("evalue"));
        for (Object domainhit : (JSONArray)hmmrhit.get("domains")) {
            JSONObject dhit = (JSONObject)domainhit;
            long alihmmfrom = (Long)dhit.get("alihmmfrom");
            long alihmmto = (Long)dhit.get("alihmmto");
            long alisqfrom = (Long)dhit.get("alisqfrom");
            long alisqto = (Long)dhit.get("alisqto");
            String aliaseq = (String)dhit.get("aliaseq");
            String alimodel = (String)dhit.get("alimodel");
            String ppline = (String)dhit.get("alippline");
            int found = 0;
            SequenceI firsthit = null;
            for (SequenceI hitseq : hits) {
                if ((long)hitseq.getStart() != alisqfrom || (long)hitseq.getEnd() != alisqto) continue;
                if (found == 0) {
                    firsthit = hitseq;
                }
                ++found;
                AlignmentAnnotation alipp = this.parsePosteriorProb(ppline);
                AlignmentAnnotation pval = new AlignmentAnnotation("p-value", "hmmer3 pvalue", pvalue);
                AlignmentAnnotation eval = new AlignmentAnnotation("e-value", "hmmer3 evalue", evalue);
                pval.setCalcId("HMMER3");
                eval.setCalcId("HMMER3");
                alipp.setCalcId("HMMER3");
                hitseq.addAlignmentAnnotation(pval);
                hitseq.addAlignmentAnnotation(eval);
                alipp.createSequenceMapping(hitseq, hitseq.getStart(), false);
                hitseq.addAlignmentAnnotation(alipp);
                String arch = (String)hmmrhit.get("arch");
                hitseq.addSequenceFeature(new SequenceFeature("Pfam Domain Architecture", hmmrhit.get("archindex") + " " + arch, 0, 0, hmmrhit.get("archScore") != null ? (float)Integer.valueOf((String)hmmrhit.get("archScore")).intValue() : 0.0f, "HMMER3"));
                this.addArchGroup(hitseq, arch);
                alipp.setScore(Double.valueOf("" + dhit.get("bitscore")));
                alipp.adjustForAlignment();
                this.resultAl.addAnnotation(pval);
                this.resultAl.addAnnotation(eval);
                this.resultAl.addAnnotation(alipp);
                alipp.validateRangeAndDisplay();
            }
            this.addRedundantSeqGroup(firsthit, alisqfrom, alisqto, (JSONArray)hmmrhit.get("seqs"), true);
        }
    }

    public void updateView(AlignmentViewport view) {
        this.viewAl = view;
        for (Runnable op : this.viewOps) {
            op.run();
        }
    }

    private void addRedundantSeqGroup(final SequenceI firsthit, long alisqfrom, long alisqto, JSONArray others, boolean justDelete) {
        if (others != null) {
            final SequenceGroup repgroup = new SequenceGroup();
            repgroup.setSeqrep(firsthit);
            repgroup.addOrRemove(firsthit, false);
            repgroup.setStartRes(0);
            repgroup.setEndRes(this.resultAl.getWidth() - 1);
            for (JSONObject otherseq : others.toArray(new JSONObject[0])) {
                String repseq = (String)otherseq.get("dn");
                SequenceI[] other = this.resultAl.findSequenceMatch(repseq);
                if (other == null || other.length <= 0) continue;
                if (justDelete) {
                    for (SequenceI oth : other) {
                        this.resultAl.deleteSequence(oth);
                    }
                    continue;
                }
                int ofound = 0;
                for (SequenceI oth : other) {
                    if ((long)oth.getStart() != alisqfrom || (long)oth.getEnd() != alisqto) continue;
                    ++ofound;
                    repgroup.addSequence(oth, false);
                }
                if (ofound == 0) {
                    System.err.println("Warn - no match for redundant hit " + repseq + "/" + alisqfrom + "-" + alisqto);
                }
                if (ofound <= true) continue;
                System.err.println("Warn - multiple matches for redundant hit " + repseq + "/" + alisqfrom + "-" + alisqto);
            }
            if (repgroup.getSequences().size() > 1) {
                final HmmerJSONProcessor me = this;
                this.viewOps.add(new Runnable(){

                    @Override
                    public void run() {
                        me.viewAl.hideRepSequences(firsthit, repgroup);
                    }
                });
            }
        }
    }

    private void addArchGroup(SequenceI seqToAdd, String groupNam) {
        SequenceGroup sg = this.groups.get(groupNam);
        if (sg == null) {
            sg = new SequenceGroup();
            sg.setName(groupNam);
            sg.addSequence(seqToAdd, false);
            sg.setStartRes(0);
            sg.setEndRes(this.resultAl.getWidth() - 1);
            this.groups.put(groupNam, sg);
            this.resultAl.addGroup(sg);
        } else {
            sg.addSequence(seqToAdd, false);
        }
    }

    private AlignmentAnnotation parsePosteriorProb(String ppline) {
        Annotation[] ae = new Annotation[ppline.length()];
        int spos = 0;
        int iSize = ppline.length();
        for (int i = 0; i < iSize; ++i) {
            char pp = ppline.charAt(i);
            if (pp == '*') {
                ae[spos++] = new Annotation(10.0f);
                continue;
            }
            if (pp < '0' || pp > '9') continue;
            ae[spos++] = new Annotation(Integer.valueOf("" + pp).intValue());
        }
        AlignmentAnnotation pprob = new AlignmentAnnotation("Posterior Probability", "Likelihood of HMM fit at each hit position.", ae);
        pprob.graph = 1;
        pprob.visible = false;
        return pprob;
    }
}

