/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.HMMProbabilityDistributionAnalyser;
import java.io.IOException;
import java.util.Scanner;

public class ProbabilityAnalyserKickstarter {
    public static void main(String[] args) throws IOException, InterruptedException {
        HMMProbabilityDistributionAnalyser analyser = new HMMProbabilityDistributionAnalyser();
        boolean running = true;
        System.out.println("ACTIVATED");
        while (running) {
            boolean keepRaw;
            Scanner keyboard = new Scanner(System.in);
            String command = keyboard.nextLine();
            Scanner inputScanner = new Scanner(command);
            if (command.indexOf("printFam") > -1) {
                try {
                    inputScanner.next();
                    int index = inputScanner.nextInt();
                    analyser.printFam(index);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
            }
            if (command.indexOf("printHMM") > -1) {
                try {
                    inputScanner.next();
                    int index = inputScanner.nextInt();
                    analyser.printHMM(index);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
            }
            if (command.indexOf("exportFam") > -1) {
                try {
                    inputScanner.next();
                    int index = inputScanner.nextInt();
                    String location = inputScanner.next();
                    analyser.exportFam(index, location);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
            }
            if (command.indexOf("exportHMM") > -1) {
                try {
                    inputScanner.next();
                    int index = inputScanner.nextInt();
                    String location = inputScanner.next();
                    analyser.exportHMM(index, location);
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
            }
            if (command.indexOf("run") > -1 && command.indexOf("ToEnd") <= -1) {
                try {
                    inputScanner.next();
                    int loops = inputScanner.nextInt();
                    int increments = inputScanner.nextInt();
                    keepRaw = inputScanner.nextBoolean();
                    for (int i = 0; i < loops; ++i) {
                        analyser.run(increments, keepRaw);
                        System.out.println("Saved");
                    }
                    System.out.println("Task completed");
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
                continue;
            }
            if (command.indexOf("runToEnd") > -1) {
                try {
                    inputScanner.next();
                    int minCount = inputScanner.nextInt();
                    int maxCount = inputScanner.nextInt();
                    keepRaw = inputScanner.nextBoolean();
                    boolean forClans = inputScanner.nextBoolean();
                    analyser.runToEnd(minCount, maxCount, keepRaw, forClans);
                    System.out.println("Task completed");
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
                continue;
            }
            if (command.indexOf("terminate") > -1) {
                running = false;
                continue;
            }
            if (command.indexOf("clear") > -1) {
                analyser.clear();
                continue;
            }
            if (command.indexOf("cd") > -1) {
                try {
                    inputScanner.next();
                    analyser.setFolder(inputScanner.next());
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
                continue;
            }
            if (command.indexOf("getFamName") > -1) {
                try {
                    inputScanner.next();
                    System.out.println(analyser.getFamilyName(inputScanner.nextInt()));
                }
                catch (Exception e) {
                    System.out.println("Command failed");
                }
                continue;
            }
            if (command.indexOf("sortIntoClans") > -1) {
                inputScanner.next();
                analyser.sortIntoClans(inputScanner.next());
                continue;
            }
            if (command.indexOf("setFamilies") > -1) {
                inputScanner.next();
                analyser.setFamilies(inputScanner.next());
                continue;
            }
            if (command.indexOf("setHMMs") > -1) {
                inputScanner.next();
                analyser.setHmms(inputScanner.next());
                continue;
            }
            if (command.indexOf("alignWithinClans") > -1) {
                inputScanner.next();
                String export = inputScanner.next();
                String clans = inputScanner.next();
                analyser.alignWithinClan(export, clans);
                continue;
            }
            System.out.println("Unrecognised command");
        }
    }
}

