/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.htsjdk;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import jalview.bin.Console;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public class VCFReader
implements Closeable,
Iterable<VariantContext> {
    private static final String GZ = "gz";
    private static final String TBI_EXTENSION = ".tbi";
    private static final String CSI_EXTENSION = ".csi";
    private boolean indexed = false;
    private VCFFileReader reader;

    public VCFReader(String filePath) throws IOException {
        if (filePath.endsWith(TBI_EXTENSION) || filePath.endsWith(CSI_EXTENSION)) {
            this.indexed = true;
            filePath = filePath.substring(0, filePath.length() - 4);
        } else if (new File(filePath + TBI_EXTENSION).exists()) {
            this.indexed = true;
        } else if (new File(filePath + CSI_EXTENSION).exists()) {
            this.indexed = true;
        }
        File file = new File(filePath);
        if (file.exists()) {
            this.reader = new VCFFileReader(file, this.indexed);
        } else {
            Console.error("File not found: " + filePath);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public CloseableIterator<VariantContext> iterator() {
        return this.reader == null ? null : this.reader.iterator();
    }

    public CloseableIterator<VariantContext> query(String chrom, int start, int end) {
        if (this.reader == null) {
            return null;
        }
        if (this.indexed) {
            return this.reader.query(chrom, start, end);
        }
        return this.queryUnindexed(chrom, start, end);
    }

    protected CloseableIterator<VariantContext> queryUnindexed(final String chrom, final int start, final int end) {
        final CloseableIterator it = this.reader.iterator();
        return new CloseableIterator<VariantContext>(){
            boolean atEnd = false;
            private VariantContext next = this.findNext();

            private VariantContext findNext() {
                if (this.atEnd) {
                    return null;
                }
                VariantContext variant = null;
                while (it.hasNext()) {
                    variant = (VariantContext)it.next();
                    int vstart = variant.getStart();
                    if (vstart > end) {
                        this.atEnd = true;
                        this.close();
                        return null;
                    }
                    int vend = variant.getEnd();
                    if (!chrom.equals(variant.getContig()) || vstart > end || vend < start) continue;
                    return variant;
                }
                return null;
            }

            public boolean hasNext() {
                boolean hasNext;
                boolean bl = hasNext = !this.atEnd && this.next != null;
                if (!hasNext) {
                    this.close();
                }
                return hasNext;
            }

            public VariantContext next() {
                VariantContext temp = this.next;
                this.next = this.findNext();
                return temp;
            }

            public void remove() {
            }

            public void close() {
                it.close();
            }
        };
    }

    public VCFHeader getFileHeader() {
        return this.reader == null ? null : this.reader.getFileHeader();
    }

    public boolean isIndex() {
        return this.indexed;
    }
}

