/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.MappedFeatures;
import jalview.datamodel.features.FeatureAttributeType;
import jalview.datamodel.features.FeatureAttributes;
import jalview.datamodel.features.FeatureLocationI;
import jalview.datamodel.features.FeatureSourceI;
import jalview.datamodel.features.FeatureSources;
import jalview.util.StringUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class SequenceFeature
implements FeatureLocationI {
    private static final float NO_SCORE = 0.0f;
    private static final String STATUS = "status";
    public static final String STRAND = "STRAND";
    public static final String PHASE = "!Phase";
    private static final String LOCATION = "!Location";
    private static final String ROW_DATA = "<tr><td>%s</td><td>%s</td><td>%s</td></tr>";
    public final String type;
    public final int begin;
    public final int end;
    public final String featureGroup;
    public final float score;
    private final boolean contactFeature;
    public String description;
    public Map<String, Object> otherDetails;
    public Vector<String> links;
    private String source;

    public SequenceFeature(SequenceFeature cpy) {
        this(cpy, cpy.getBegin(), cpy.getEnd(), cpy.getFeatureGroup(), cpy.getScore());
    }

    public SequenceFeature(String theType, String theDesc, int theBegin, int theEnd, String group) {
        this(theType, theDesc, theBegin, theEnd, 0.0f, group);
    }

    public SequenceFeature(String theType, String theDesc, int theBegin, int theEnd, float theScore, String group) {
        this.type = theType;
        this.description = theDesc;
        this.begin = theBegin;
        this.end = theEnd;
        this.featureGroup = group;
        this.score = theScore;
        this.contactFeature = "disulfide bond".equalsIgnoreCase(this.type) || "disulphide bond".equalsIgnoreCase(this.type);
    }

    public SequenceFeature(SequenceFeature sf, String newType, int newBegin, int newEnd, String newGroup, float newScore) {
        this(newType, sf.getDescription(), newBegin, newEnd, newScore, newGroup);
        this.source = sf.source;
        if (sf.otherDetails != null) {
            this.otherDetails = new LinkedHashMap<String, Object>();
            this.otherDetails.putAll(sf.otherDetails);
        }
        if (sf.links != null && sf.links.size() > 0) {
            this.links = new Vector();
            this.links.addAll(sf.links);
        }
    }

    public SequenceFeature(SequenceFeature sf, int newBegin, int newEnd, String newGroup, float newScore) {
        this(sf, sf.getType(), newBegin, newEnd, newGroup, newScore);
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean ignoreParent) {
        boolean sameScore;
        if (o == null || !(o instanceof SequenceFeature)) {
            return false;
        }
        SequenceFeature sf = (SequenceFeature)o;
        boolean bl = Float.isNaN(this.score) ? Float.isNaN(sf.score) : (sameScore = this.score == sf.score);
        if (this.begin != sf.begin || this.end != sf.end || !sameScore) {
            return false;
        }
        if (this.getStrand() != sf.getStrand()) {
            return false;
        }
        if (!(this.type + this.description + this.featureGroup + this.getPhase()).equals(sf.type + sf.description + sf.featureGroup + sf.getPhase())) {
            return false;
        }
        if (!SequenceFeature.equalAttribute(this.getValue("ID"), sf.getValue("ID"))) {
            return false;
        }
        if (!SequenceFeature.equalAttribute(this.getValue("Name"), sf.getValue("Name"))) {
            return false;
        }
        return ignoreParent || SequenceFeature.equalAttribute(this.getValue("Parent"), sf.getValue("Parent"));
    }

    protected static boolean equalAttribute(Object att1, Object att2) {
        if (att1 == null && att2 == null) {
            return true;
        }
        if (att1 != null) {
            return att1.equals(att2);
        }
        return att2.equals(att1);
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public void addLink(String labelLink) {
        if (this.links == null) {
            this.links = new Vector();
        }
        if (!this.links.contains(labelLink)) {
            this.links.insertElementAt(labelLink, 0);
        }
    }

    public float getScore() {
        return this.score;
    }

    public Object getValue(String key) {
        if (this.otherDetails == null) {
            return null;
        }
        return this.otherDetails.get(key);
    }

    public String getValueAsString(String ... key) {
        if (this.otherDetails == null) {
            return null;
        }
        Object value = this.otherDetails.get(key[0]);
        if (key.length > 1 && value instanceof Map) {
            value = ((Map)value).get(key[1]);
        }
        return value == null ? null : value.toString();
    }

    public Object getValue(String key, Object defaultValue) {
        Object value = this.getValue(key);
        return value == null ? defaultValue : value;
    }

    public void setValue(String key, Object value) {
        if (value != null) {
            if (this.otherDetails == null) {
                this.otherDetails = new LinkedHashMap<String, Object>();
            }
            this.otherDetails.put(key, value);
            this.recordAttribute(key, value);
        }
    }

    protected void recordAttribute(String key, Object value) {
        String attDesc = null;
        if (this.source != null) {
            attDesc = FeatureSources.getInstance().getSource(this.source).getAttributeName(key);
        }
        FeatureAttributes.getInstance().addAttribute(this.type, attDesc, value, key);
    }

    public void setStatus(String status) {
        this.setValue(STATUS, status);
    }

    public String getStatus() {
        return (String)this.getValue(STATUS);
    }

    public int getStrand() {
        int strand = 0;
        if (this.otherDetails != null) {
            Object str = this.otherDetails.get(STRAND);
            if ("-".equals(str)) {
                strand = -1;
            } else if ("+".equals(str)) {
                strand = 1;
            }
        }
        return strand;
    }

    public void setStrand(String strand) {
        this.setValue(STRAND, strand);
    }

    public void setPhase(String phase) {
        this.setValue(PHASE, phase);
    }

    public String getPhase() {
        return (String)this.getValue(PHASE);
    }

    public void setEnaLocation(String loc) {
        this.setValue(LOCATION, loc);
    }

    public String getEnaLocation() {
        return (String)this.getValue(LOCATION);
    }

    public String toString() {
        return String.format("%d %d %s %s", this.getBegin(), this.getEnd(), this.getType(), this.getDescription());
    }

    public int hashCode() {
        String s = this.getType() + this.getDescription() + this.getFeatureGroup() + this.getValue("ID") + this.getValue("Name") + this.getValue("Parent") + this.getPhase();
        return s.hashCode() + this.getBegin() + this.getEnd() + (int)this.getScore() + this.getStrand();
    }

    @Override
    public boolean isContactFeature() {
        return this.contactFeature;
    }

    public boolean isNonPositional() {
        return this.begin == 0 && this.end == 0;
    }

    public String getDetailsReport(String seqName, MappedFeatures mf) {
        FeatureSourceI metadata = FeatureSources.getInstance().getSource(this.source);
        StringBuilder sb = new StringBuilder(128);
        sb.append("<br>");
        sb.append("<table>");
        String name = mf == null ? seqName : mf.getLinkedSequenceName();
        sb.append(String.format(ROW_DATA, "Location", name, this.begin == this.end ? Integer.valueOf(this.begin) : this.begin + (this.isContactFeature() ? ":" : "-") + this.end));
        String consequence = "";
        if (mf != null) {
            int[] localRange = mf.getMappedPositions(this.begin, this.end);
            int from = localRange[0];
            int to = localRange[localRange.length - 1];
            String s = mf.isFromCds() ? "Peptide Location" : "Coding location";
            sb.append(String.format(ROW_DATA, s, seqName, from == to ? Integer.valueOf(from) : from + (this.isContactFeature() ? ":" : "-") + to));
            if (mf.isFromCds()) {
                consequence = mf.findProteinVariants(this);
            }
        }
        sb.append(String.format(ROW_DATA, "Type", this.type, ""));
        String desc = StringUtils.stripHtmlTags(this.description);
        sb.append(String.format(ROW_DATA, "Description", desc, ""));
        if (!Float.isNaN(this.score) && this.score != 0.0f) {
            sb.append(String.format(ROW_DATA, "Score", Float.valueOf(this.score), ""));
        }
        if (this.featureGroup != null) {
            sb.append(String.format(ROW_DATA, "Group", this.featureGroup, ""));
        }
        if (!consequence.isEmpty()) {
            sb.append(String.format(ROW_DATA, "Consequence", "<i>Translated by Jalview</i>", consequence));
        }
        if (this.otherDetails != null) {
            TreeMap<String, Object> ordered = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            ordered.putAll(this.otherDetails);
            for (Map.Entry entry : ordered.entrySet()) {
                String s;
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Map values = (Map)value;
                    TreeMap sm = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    sm.putAll(values);
                    for (Map.Entry e : sm.entrySet()) {
                        sb.append(String.format(ROW_DATA, key, e.getKey().toString(), e.getValue().toString()));
                    }
                    continue;
                }
                String attDesc = null;
                if (metadata != null) {
                    attDesc = metadata.getAttributeName(key);
                }
                if (!this.isValueInteresting(key, s = entry.getValue().toString(), metadata)) continue;
                sb.append(String.format(ROW_DATA, key, attDesc == null ? "" : attDesc, s));
            }
        }
        sb.append("</table>");
        String text = sb.toString();
        return text;
    }

    boolean isValueInteresting(String key, String value, FeatureSourceI metadata) {
        if (value == null || "".equals(value) || ".".equals(value) || "0".equals(value)) {
            return false;
        }
        if (metadata == null) {
            return true;
        }
        FeatureAttributeType attType = metadata.getAttributeType(key);
        if (attType != null && (attType == FeatureAttributeType.Float || attType.equals((Object)FeatureAttributeType.Integer))) {
            try {
                float fval = Float.valueOf(value).floatValue();
                if (fval == 0.0f) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    public void setSource(String theSource) {
        this.source = theSource;
    }
}

