/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.StringTokenizer;

public class Tooltip
extends Canvas
implements MouseListener,
MouseMotionListener {
    private String[] tip;
    private String lastTip = "";
    private boolean setPosition = false;
    protected Component owner;
    private Container mainContainer;
    private LayoutManager mainLayout;
    private boolean shown;
    private final int VERTICAL_OFFSET = 20;
    private final int HORIZONTAL_ENLARGE = 10;
    int fontHeight = 0;
    Image linkImage;
    FontMetrics fm;

    public Tooltip(String tip, Component owner) {
        this.owner = owner;
        owner.addMouseListener(this);
        owner.addMouseMotionListener(this);
        this.setBackground(new Color(255, 255, 220));
        this.setTip(tip);
        URL url = this.getClass().getResource("/images/link.gif");
        if (url != null) {
            this.linkImage = Toolkit.getDefaultToolkit().getImage(url);
        }
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.drawRect(0, 0, w - 1, h - 1);
        for (int i = 0; i < this.tip.length; ++i) {
            int x = 3;
            int lindex = this.tip[i].indexOf("%LINK%");
            if (lindex != -1) {
                if (lindex > 0) {
                    g.drawString(this.tip[i].substring(0, lindex), 3, (i + 1) * this.fontHeight - 3);
                    x += this.fm.stringWidth(this.tip[i].substring(0, lindex) + "3");
                }
                g.drawImage(this.linkImage, x, i * this.fontHeight + 1, this);
                if (lindex + 6 >= this.tip[i].length()) continue;
                g.drawString(this.tip[i].substring(lindex + 6), x + this.linkImage.getWidth(this), (i + 1) * this.fontHeight - 3);
                continue;
            }
            g.drawString(this.tip[i], 3, (i + 1) * this.fontHeight - 3);
        }
    }

    synchronized void setTip(String tip) {
        if (tip == null) {
            this.setTip("");
            return;
        }
        if (this.lastTip.equals(tip)) {
            return;
        }
        this.lastTip = tip;
        this.setPosition = true;
        this.fm = this.getFontMetrics(this.owner.getFont());
        this.fontHeight = this.fm.getHeight();
        int longestLine = 0;
        StringTokenizer st = new StringTokenizer(tip, "\n");
        this.tip = new String[st.countTokens()];
        int index = 0;
        while (st.hasMoreElements()) {
            this.tip[index] = st.nextToken();
            if (this.fm.stringWidth(this.tip[index]) > longestLine) {
                longestLine = this.fm.stringWidth(this.tip[index]);
            }
            ++index;
        }
        this.setSize(longestLine + 10, this.fontHeight * this.tip.length);
        this.repaint();
    }

    void setTipLocation(MouseEvent evt) {
        if (this.mainContainer == null || this.owner == null) {
            return;
        }
        this.setLocation(this.owner.getLocationOnScreen().x - this.mainContainer.getLocationOnScreen().x + evt.getX(), this.owner.getLocationOnScreen().y - this.mainContainer.getLocationOnScreen().y + 20 + evt.getY());
        if (this.mainContainer.getSize().width < this.getLocation().x + this.getSize().width) {
            this.setLocation(this.mainContainer.getSize().width - this.getSize().width, this.getLocation().y);
        }
    }

    private void removeToolTip() {
        if (this.shown) {
            this.mainContainer.remove(0);
            this.mainContainer.setLayout(this.mainLayout);
            this.mainContainer.validate();
        }
        this.shown = false;
    }

    private void findMainContainer() {
        Container parent = this.owner.getParent();
        while (true) {
            if (parent instanceof Applet || parent instanceof Frame) break;
            parent = parent.getParent();
        }
        this.mainContainer = parent;
        this.mainLayout = this.mainContainer.getLayout();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        this.setTipLocation(me);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        this.removeToolTip();
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.removeToolTip();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        if (!this.shown) {
            this.findMainContainer();
            this.mainContainer.setLayout(null);
            this.mainContainer.add((Component)this, 0);
            this.mainContainer.validate();
            this.shown = true;
            this.setTipLocation(me);
        } else if (this.setPosition) {
            this.setTipLocation(me);
            this.setPosition = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }
}

