/*
 * Decompiled with CFR 0.152.
 */
package jalview.analytics;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.util.ChannelProperties;
import jalview.util.HttpUtils;
import jalview.util.UserAgent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Plausible {
    private static final String USER_AGENT;
    private static final String JALVIEW_ID = "Jalview Desktop";
    private static final String DOMAIN = "jalview.org";
    private static final String CONFIG_API_BASE_URL = "https://www.jalview.org/services/config/analytics/url";
    private static final String DEFAULT_API_BASE_URL = "https://analytics.jalview.org/api/event";
    private static final String API_BASE_URL;
    private static final String clientId;
    public static final String APPLICATION_BASE_URL = "desktop://localhost";
    private List<Map.Entry<String, String>> queryStringValues;
    private List<Map.Entry<String, Object>> jsonObject;
    private List<Map.Entry<String, String>> cookieValues;
    private static boolean ENABLED;
    private static boolean DEBUG;
    private static Plausible instance;
    private static final Map<String, String> defaultProps;

    private Plausible() {
        this.resetLists();
    }

    public static void setEnabled(boolean b) {
        ENABLED = b;
    }

    public void sendEvent(String eventName, String urlString, String ... propsStrings) {
        this.sendEvent(eventName, urlString, false, propsStrings);
    }

    public void sendEvent(String eventName, String urlString, boolean sendDefaultProps, String ... propsStrings) {
        this.sendEvent(eventName, urlString, sendDefaultProps, propsStrings);
    }

    public void sendEvent(String eventName, String urlString, boolean sendDefaultProps, boolean appendQueryString, String ... propsStrings) {
        this.resetLists();
        if (!ENABLED) {
            Console.debug("Plausible not enabled.");
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (sendDefaultProps) {
            props.putAll(defaultProps);
        }
        if (propsStrings != null && propsStrings.length > 0) {
            if (propsStrings.length % 2 != 0) {
                Console.warn("Cannot addEvent with odd number of propsStrings.  Ignoring the last one.");
            }
            for (int i = 0; i < propsStrings.length - 1; i += 2) {
                String key = propsStrings[i];
                String value = propsStrings[i + 1];
                props.put(key, value);
            }
        }
        this.addJsonValue("domain", DOMAIN, appendQueryString);
        this.addJsonValue("name", eventName, appendQueryString);
        StringBuilder eventUrlSb = new StringBuilder(APPLICATION_BASE_URL);
        if (!APPLICATION_BASE_URL.endsWith("/") && !urlString.startsWith("/")) {
            eventUrlSb.append("/");
        }
        eventUrlSb.append(urlString);
        this.addJsonValue("url", eventUrlSb.toString(), appendQueryString);
        this.addJsonObject("props", props);
        StringBuilder urlSb = new StringBuilder();
        urlSb.append(API_BASE_URL);
        String qs = this.buildQueryString();
        if (qs != null && qs.length() > 0) {
            urlSb.append('?');
            urlSb.append(qs);
        }
        try {
            URL url = new URL(urlSb.toString());
            HttpURLConnection httpURLConnection = (HttpURLConnection)HttpUtils.openConnection(url);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            String jsonString = this.buildJson();
            Console.debug("Plausible: HTTP Request is: '" + urlSb.toString() + "'");
            if (DEBUG) {
                Console.debug("Plausible: User-Agent is: '" + USER_AGENT + "'");
            }
            Console.debug("Plausible: POSTed JSON is:\n" + jsonString);
            byte[] jsonBytes = jsonString.getBytes(StandardCharsets.UTF_8);
            int jsonLength = jsonBytes.length;
            httpURLConnection.setFixedLengthStreamingMode(jsonLength);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
            httpURLConnection.connect();
            try (OutputStream os = httpURLConnection.getOutputStream();){
                os.write(jsonBytes);
            }
            int responseCode = httpURLConnection.getResponseCode();
            String responseMessage = httpURLConnection.getResponseMessage();
            if (responseCode < 200 || responseCode > 299) {
                Console.warn("Plausible connection failed: '" + responseCode + " " + responseMessage + "'");
            } else {
                Console.debug("Plausible connection succeeded: '" + responseCode + " " + responseMessage + "'");
            }
            if (DEBUG) {
                String response;
                BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((response = br.readLine()) != null) {
                    sb.append(response);
                }
                String body = sb.toString();
                Console.debug("Plausible response content:\n" + body);
            }
        }
        catch (MalformedURLException e) {
            Console.debug("Somehow the Plausible BASE_URL and queryString is malformed: '" + urlSb.toString() + "'", e);
            return;
        }
        catch (IOException e) {
            Console.debug("Connection to Plausible BASE_URL '" + API_BASE_URL + "' failed.", e);
        }
        catch (ClassCastException e) {
            Console.debug("Couldn't cast URLConnection to HttpURLConnection in Plausible.", e);
        }
    }

    private void addJsonObject(String key, Map<String, String> map) {
        ArrayList<Map.Entry<String, ? extends Object>> list = new ArrayList<Map.Entry<String, ? extends Object>>();
        for (String k : map.keySet()) {
            list.add(Plausible.stringEntry(k, map.get(k)));
        }
        this.addJsonObject(key, list);
    }

    private void addJsonObject(String key, List<Map.Entry<String, ? extends Object>> object) {
        this.jsonObject.add(Plausible.objectEntry(key, object));
    }

    private void addJsonValues(String key, List<Object> values) {
        this.jsonObject.add(Plausible.objectEntry(key, values));
    }

    private void addJsonValue(String key, String value) {
        this.addJsonValue(key, value, false);
    }

    private void addJsonValue(String key, String value, boolean addToQueryString) {
        this.jsonObject.add(Plausible.objectEntry(key, value));
        if (addToQueryString) {
            this.addQueryStringValue(key, value);
        }
    }

    private void addJsonValue(String key, int value) {
        this.jsonObject.add(Plausible.objectEntry(key, value));
    }

    private void addJsonValue(String key, boolean value) {
        this.jsonObject.add(Plausible.objectEntry(key, value));
    }

    private void addQueryStringValue(String key, String value) {
        this.queryStringValues.add(Plausible.stringEntry(key, value));
    }

    private void addCookieValue(String key, String value) {
        this.cookieValues.add(Plausible.stringEntry(key, value));
    }

    private void resetLists() {
        this.jsonObject = new ArrayList<Map.Entry<String, Object>>();
        this.queryStringValues = new ArrayList<Map.Entry<String, String>>();
        this.cookieValues = new ArrayList<Map.Entry<String, String>>();
    }

    public static Plausible getInstance() {
        if (instance == null) {
            instance = new Plausible();
        }
        return instance;
    }

    public static void reset() {
        Plausible.getInstance().resetLists();
    }

    private String buildQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : this.queryStringValues) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            try {
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(entry.getKey());
            }
            sb.append('=');
            try {
                sb.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                sb.append(entry.getValue());
            }
        }
        return sb.toString();
    }

    private void buildCookieHeaders() {
    }

    private String buildJson() {
        StringBuilder sb = new StringBuilder();
        this.addJsonObject(sb, 0, this.jsonObject);
        return sb.toString();
    }

    private void addJsonObject(StringBuilder sb, int indent, List<Map.Entry<String, Object>> entries) {
        Plausible.indent(sb, indent);
        sb.append('{');
        Plausible.newline(sb);
        Iterator<Map.Entry<String, Object>> entriesI = entries.iterator();
        while (entriesI.hasNext()) {
            Map.Entry<String, Object> entry = entriesI.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            Plausible.indent(sb, indent + 1);
            sb.append('\"').append(Plausible.quoteEscape(key)).append('\"').append(':');
            Plausible.space(sb);
            if (value != null && value instanceof List) {
                Plausible.newline(sb);
            }
            this.addJsonValue(sb, indent + 2, value);
            if (entriesI.hasNext()) {
                sb.append(',');
            }
            Plausible.newline(sb);
        }
        Plausible.indent(sb, indent);
        sb.append('}');
    }

    private void addJsonValue(StringBuilder sb, int indent, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (value instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)value;
                ArrayList<Map.Entry<String, Object>> object = new ArrayList<Map.Entry<String, Object>>();
                object.add(entry);
                this.addJsonObject(sb, indent, object);
            } else if (value instanceof List) {
                List valueList = (List)value;
                if (valueList.size() > 0 && valueList.get(0) instanceof Map.Entry) {
                    List entryList = (List)value;
                    this.addJsonObject(sb, indent, entryList);
                } else {
                    Plausible.indent(sb, indent);
                    sb.append('[');
                    Plausible.newline(sb);
                    Iterator valueListI = valueList.iterator();
                    while (valueListI.hasNext()) {
                        Object v = valueListI.next();
                        this.addJsonValue(sb, indent + 1, v);
                        if (valueListI.hasNext()) {
                            sb.append(',');
                        }
                        Plausible.newline(sb);
                    }
                    Plausible.indent(sb, indent);
                    sb.append("]");
                }
            } else if (value instanceof String) {
                sb.append('\"').append(Plausible.quoteEscape((String)value)).append('\"');
            } else if (value instanceof Integer) {
                sb.append(((Integer)value).toString());
            } else if (value instanceof Boolean) {
                sb.append('\"').append(((Boolean)value).toString()).append('\"');
            }
        }
        catch (ClassCastException e) {
            Console.debug("Could not deal with type of json Object " + value.toString(), e);
        }
    }

    private static String quoteEscape(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("((?<!\\\\)(?:\\\\{2})*)\"", "$1\\\\\"");
    }

    private static void prettyWhitespace(StringBuilder sb, String whitespace, int repeat) {
        if (!Console.getLogger().isDebugEnabled()) {
            return;
        }
        if (repeat >= 0 && whitespace != null) {
            sb.append(String.join((CharSequence)"", Collections.nCopies(repeat, whitespace)));
        } else {
            sb.append(whitespace);
        }
    }

    private static void indent(StringBuilder sb, int indent) {
        Plausible.prettyWhitespace(sb, "  ", indent);
    }

    private static void newline(StringBuilder sb) {
        Plausible.prettyWhitespace(sb, "\n", -1);
    }

    private static void space(StringBuilder sb) {
        Plausible.prettyWhitespace(sb, " ", -1);
    }

    protected static Map.Entry<String, Object> objectEntry(String s, Object o) {
        return new AbstractMap.SimpleEntry<String, Object>(s, o);
    }

    protected static Map.Entry<String, String> stringEntry(String s, String v) {
        return new AbstractMap.SimpleEntry<String, String>(s, v);
    }

    private static String getAPIBaseURL() {
        try {
            String response;
            URL url = new URL(CONFIG_API_BASE_URL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)HttpUtils.openConnection(url);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("User-Agent", USER_AGENT);
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setReadTimeout(3000);
            httpURLConnection.connect();
            int responseCode = httpURLConnection.getResponseCode();
            String responseMessage = httpURLConnection.getResponseMessage();
            if (responseCode < 200 || responseCode > 299) {
                Console.warn("Config URL connection to 'https://www.jalview.org/services/config/analytics/url' failed: '" + responseCode + " " + responseMessage + "'");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((response = br.readLine()) != null) {
                sb.append(response);
            }
            if (sb.length() > 7 && sb.substring(0, 5).equals("https")) {
                return sb.toString();
            }
        }
        catch (MalformedURLException e) {
            Console.debug("Somehow the config URL is malformed: 'https://www.jalview.org/services/config/analytics/url'", e);
        }
        catch (IOException e) {
            Console.debug("Connection to Plausible BASE_URL '" + API_BASE_URL + "' failed.", e);
        }
        catch (ClassCastException e) {
            Console.debug("Couldn't cast URLConnection to HttpURLConnection in Plausible.", e);
        }
        return DEFAULT_API_BASE_URL;
    }

    static {
        ENABLED = false;
        DEBUG = true;
        instance = null;
        defaultProps = new HashMap<String, String>();
        defaultProps.put("app_name", ChannelProperties.getProperty("app_name") + " Desktop");
        defaultProps.put("version", Cache.getProperty("VERSION"));
        defaultProps.put("build_date", Cache.getDefault("BUILD_DATE", "unknown"));
        defaultProps.put("java_version", System.getProperty("java.version"));
        String val = System.getProperty("sys.install4jVersion");
        if (val != null) {
            defaultProps.put("install4j_version", val);
        }
        if ((val = System.getProperty("installer.template_version")) != null) {
            defaultProps.put("install4j_template_version", val);
        }
        if ((val = System.getProperty("launcher.version")) != null) {
            defaultProps.put("launcher.version", val);
        }
        defaultProps.put("java_arch", System.getProperty("os.arch") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version"));
        defaultProps.put("os", System.getProperty("os.name"));
        defaultProps.put("os_version", System.getProperty("os.version"));
        defaultProps.put("os_arch", System.getProperty("os.arch"));
        String installation = Cache.getProperty("INSTALLATION");
        if (installation != null) {
            defaultProps.put("installation", installation);
        }
        API_BASE_URL = Plausible.getAPIBaseURL();
        clientId = String.format("%08x", new Random().nextInt());
        USER_AGENT = UserAgent.getUserAgent(MethodHandles.lookup().lookupClass().getCanonicalName() + " " + clientId);
    }
}

