/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.util.StringUtil;

public enum SAMTag {
    AM,
    AS,
    BC,
    BQ,
    BZ,
    CB,
    CC,
    CG,
    CM,
    CO,
    CP,
    CQ,
    CR,
    CS,
    CT,
    CY,
    E2,
    FI,
    FS,
    FT,
    FZ,
    GC,
    GS,
    GQ,
    LB,
    H0,
    H1,
    H2,
    HI,
    IH,
    MC,
    MF,
    MI,
    MD,
    MQ,
    NH,
    NM,
    OA,
    OQ,
    OP,
    OC,
    OF,
    OR,
    OX,
    PG,
    PQ,
    PT,
    PU,
    Q2,
    QT,
    QX,
    R2,
    RG,
    RT,
    RX,
    S2,
    SA,
    SM,
    SQ,
    TC,
    U2,
    UQ;

    private static final String[] stringTags;
    private final short shortValue = SAMTag.makeBinaryTag(this.name());

    public static short makeBinaryTag(String tag) {
        if (tag.length() != 2) {
            throw new IllegalArgumentException("String tag does not have length() == 2: " + tag);
        }
        return (short)(tag.charAt(1) << 8 | tag.charAt(0));
    }

    public static String makeStringTag(short tag) {
        String ret = stringTags[tag];
        if (ret == null) {
            byte[] stringConversionBuf = new byte[]{(byte)(tag & 0xFF), (byte)(tag >> 8 & 0xFF)};
            SAMTag.stringTags[tag] = ret = StringUtil.bytesToString(stringConversionBuf);
        }
        return ret;
    }

    public short getBinaryTag() {
        return this.shortValue;
    }

    static {
        stringTags = new String[Short.MAX_VALUE];
    }
}

