/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.dundee.compbio.hmmerclient;

import java.io.Reader;
import java.util.Objects;
import uk.ac.dundee.compbio.hmmerclient.ExceptionUtils;

public class PhmmerRequest {
    private final Float incE;
    private final Float incdomE;
    private final Float E;
    private final Float domE;
    private final Float incT;
    private final Float incdomT;
    private final Float T;
    private final Float domT;
    private final Float popen;
    private final Float pextend;
    private final SubstitutionMatrix mx;
    private final boolean noBias;
    private final boolean compressedOut;
    private final boolean alignView;
    private final SequenceDatabase database;
    private final Float evalue;
    private final Reader sequence;
    private final Integer nhits;

    public static Builder newBuilder() {
        return new Builder();
    }

    private PhmmerRequest(Builder builder) {
        this.incE = builder.incE;
        this.incdomE = builder.incdomE;
        this.E = builder.E;
        this.domE = builder.domE;
        this.incT = builder.incT;
        this.incdomT = builder.incdomT;
        this.T = builder.T;
        this.domT = builder.domT;
        this.popen = builder.popen;
        this.pextend = builder.pextend;
        this.mx = builder.mx;
        this.noBias = builder.noBias;
        this.compressedOut = builder.compressedOut;
        this.alignView = builder.alignView;
        this.database = builder.database;
        this.evalue = builder.evalue;
        this.sequence = builder.sequence;
        this.nhits = builder.nhits;
    }

    public Float getIncE() {
        return this.incE;
    }

    public Float getIncdomE() {
        return this.incdomE;
    }

    public Float getE() {
        return this.E;
    }

    public Float getDomE() {
        return this.domE;
    }

    public Float getIncT() {
        return this.incT;
    }

    public Float getIncdomT() {
        return this.incdomT;
    }

    public Float getT() {
        return this.T;
    }

    public Float getDomT() {
        return this.domT;
    }

    public Float getPopen() {
        return this.popen;
    }

    public Float getPextend() {
        return this.pextend;
    }

    public SubstitutionMatrix getMx() {
        return this.mx;
    }

    public boolean getNoBias() {
        return this.noBias;
    }

    public boolean getCompressedOut() {
        return this.compressedOut;
    }

    public boolean getAlignView() {
        return this.alignView;
    }

    public SequenceDatabase getDatabase() {
        return this.database;
    }

    public Float getEvalue() {
        return this.evalue;
    }

    public Reader getSequence() {
        return this.sequence;
    }

    public Integer getNhits() {
        return this.nhits;
    }

    public static enum SequenceDatabase {
        SWISS_PROT("swissprot"),
        REFERENCE_PROTEOMES("uniprotrefprot"),
        UNIPROTKB("uniprotkb"),
        PDB("pdb"),
        RP75("rp75"),
        RP55("rp55"),
        RP35("rp35"),
        RP15("rp15"),
        ENSEMBL("ensembl"),
        MEROPS("merops"),
        QUEST_FOR_ORTHOLOGS("qfo"),
        CHEMBL("chembl");

        final String strvalue;

        private SequenceDatabase(String value) {
            this.strvalue = value;
        }
    }

    public static enum SubstitutionMatrix {
        BLOSUM45("BLOSUM45"),
        BLOSUM62("BLOSUM62"),
        BLOSUM90("BLOSUM90"),
        PAM30("PAM30"),
        PAM70("PAM70");

        final String strvalue;

        private SubstitutionMatrix(String value) {
            this.strvalue = value;
        }
    }

    public static class Builder {
        private Float incE;
        private Float incdomE;
        private Float E;
        private Float domE;
        private Float incT;
        private Float incdomT;
        private Float T;
        private Float domT;
        private Float popen;
        private Float pextend;
        private SubstitutionMatrix mx = SubstitutionMatrix.BLOSUM62;
        private boolean noBias = false;
        private boolean compressedOut = false;
        private boolean alignView = true;
        private SequenceDatabase database = SequenceDatabase.UNIPROTKB;
        private Float evalue;
        private Reader sequence;
        private Integer nhits;

        public Float incE() {
            return this.incE;
        }

        public Builder incE(Float incE) {
            if (incE != null && (incE.floatValue() <= 0.0f || incE.floatValue() > 10.0f)) {
                throw ExceptionUtils.newIAE("incE must be greater than 0 and less or equal to 10");
            }
            this.incE = incE;
            return this;
        }

        public Float incdomE() {
            return this.incdomE;
        }

        public Builder incdomE(Float incdomE) {
            if (incdomE != null && (incdomE.floatValue() <= 0.0f || incdomE.floatValue() > 10.0f)) {
                throw ExceptionUtils.newIAE("incdomE must be greater than 0 and less or equal to 10");
            }
            this.incdomE = incdomE;
            return this;
        }

        public Float E() {
            return this.E;
        }

        public Builder E(Float E) {
            if (E != null && (E.floatValue() <= 0.0f || E.floatValue() > 10.0f)) {
                throw ExceptionUtils.newIAE("E must be greater than 0 and less or equal to 10");
            }
            this.E = E;
            return this;
        }

        public Float getDomE() {
            return this.domE;
        }

        public Builder domE(Float domE) {
            if (domE != null && (domE.floatValue() <= 0.0f || domE.floatValue() > 10.0f)) {
                throw ExceptionUtils.newIAE("domE must be greater than 0 and less or equal to 10.");
            }
            this.domE = domE;
            return this;
        }

        public Float incT() {
            return this.incT;
        }

        public Builder incT(Float incT) {
            if (incT != null && incT.floatValue() <= 0.0f) {
                throw ExceptionUtils.newIAE("incT must be greater than 0.");
            }
            this.incT = incT;
            return this;
        }

        public Float incdomT() {
            return this.incdomT;
        }

        public Builder incdomT(Float incdomT) {
            if (incdomT != null && incdomT.floatValue() <= 0.0f) {
                throw ExceptionUtils.newIAE("incdomT must be greater than 0.");
            }
            this.incdomT = incdomT;
            return this;
        }

        public Float T() {
            return this.T;
        }

        public Builder T(Float T) {
            if (T != null && T.floatValue() <= 0.0f) {
                throw ExceptionUtils.newIAE("T must be greater than 0.");
            }
            this.T = T;
            return this;
        }

        public Float domT() {
            return this.domT;
        }

        public Builder domT(Float domT) {
            if (domT != null && domT.floatValue() <= 0.0f) {
                throw ExceptionUtils.newIAE("domT must be greater than 0.");
            }
            this.domT = domT;
            return this;
        }

        public Float popen() {
            return this.popen;
        }

        public Builder popen(Float popen) {
            if (popen != null && (popen.floatValue() < 0.0f || popen.floatValue() >= 0.5f)) {
                throw ExceptionUtils.newIAE("popen must be greater or equal to 0 and less than 0.5.");
            }
            this.popen = popen;
            return this;
        }

        public Float pextend() {
            return this.pextend;
        }

        public Builder pextend(Float pextend) {
            if (pextend != null && (pextend.floatValue() < 0.0f || pextend.floatValue() >= 1.0f)) {
                throw ExceptionUtils.newIAE("pextend must be greater or equal to 0 and less than 1.");
            }
            this.pextend = pextend;
            return this;
        }

        public SubstitutionMatrix mx() {
            return this.mx;
        }

        public Builder mx(SubstitutionMatrix mx) {
            this.mx = mx;
            return this;
        }

        public Boolean noBias() {
            return this.noBias;
        }

        public Builder noBias(boolean noBias) {
            this.noBias = noBias;
            return this;
        }

        public Boolean compressedOut() {
            return this.compressedOut;
        }

        public Builder compressedOut(boolean compressedOut) {
            this.compressedOut = compressedOut;
            return this;
        }

        public Boolean alignView() {
            return this.alignView;
        }

        public Builder alignView(boolean alignView) {
            this.alignView = alignView;
            return this;
        }

        public SequenceDatabase database() {
            return this.database;
        }

        public Builder database(SequenceDatabase database) {
            this.database = database;
            return this;
        }

        public Float evalue() {
            return this.evalue;
        }

        public Builder evalue(Float evalue) {
            this.evalue = evalue;
            return this;
        }

        public Reader sequence() {
            return this.sequence;
        }

        public Builder sequence(Reader sequence) {
            Objects.requireNonNull(sequence);
            this.sequence = sequence;
            return this;
        }

        public Integer nhits() {
            return this.nhits;
        }

        public Builder nhits(Integer nhits) {
            this.nhits = nhits;
            return this;
        }

        public PhmmerRequest build() {
            boolean usingT;
            if (this.sequence == null) {
                throw ExceptionUtils.newISE("sequence not set");
            }
            boolean usingE = this.incE != null || this.incdomE != null || this.E != null || this.domE != null;
            boolean bl = usingT = this.incT != null || this.incdomT != null || this.T != null || this.domT != null;
            if (usingE && usingT) {
                throw ExceptionUtils.newISE("using both E-value and bit scores is not allowed");
            }
            return new PhmmerRequest(this);
        }
    }
}

