/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurSliderLabel;
import fr.orsay.lri.varna.controlers.ControleurVueAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.views.VueFont;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.geom.Point2D;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicBorders;

public class VueAnnotation {
    private VARNAPanel _vp;
    private JSlider ySlider;
    private JSlider xSlider;
    private JButton colorButton;
    private JTextArea textArea;
    private JPanel panel;
    private TextAnnotation textAnnotation;
    private TextAnnotation textAnnotationSave;
    private VueFont vueFont;
    private ControleurVueAnnotation _controleurVueAnnotation;
    private boolean newAnnotation;
    private boolean limited;
    private Point2D.Double position;
    private JSlider rotationSlider;

    public VueAnnotation(VARNAPanel vARNAPanel, boolean bl) {
        this(vARNAPanel, (int)(vARNAPanel.getExtendedRNABBox().x + vARNAPanel.getExtendedRNABBox().width / 2.0), (int)(vARNAPanel.getExtendedRNABBox().y + vARNAPanel.getExtendedRNABBox().height / 2.0), bl);
    }

    public VueAnnotation(VARNAPanel vARNAPanel) {
        this(vARNAPanel, false);
    }

    public VueAnnotation(VARNAPanel vARNAPanel, int n, int n2) {
        this(vARNAPanel, n, n2, false);
    }

    public VueAnnotation(VARNAPanel vARNAPanel, int n, int n2, boolean bl) {
        this(vARNAPanel, new TextAnnotation("", n, n2), false, true);
    }

    public VueAnnotation(VARNAPanel vARNAPanel, TextAnnotation textAnnotation, boolean bl) {
        this(vARNAPanel, textAnnotation, textAnnotation.getType() != TextAnnotation.AnchorType.POSITION, bl);
    }

    public VueAnnotation(VARNAPanel vARNAPanel, TextAnnotation textAnnotation, boolean bl, boolean bl2) {
        this.limited = bl;
        this.newAnnotation = bl2;
        this._vp = vARNAPanel;
        this.textAnnotation = textAnnotation;
        this.textAnnotationSave = this.textAnnotation.clone();
        if (!this._vp.getListeAnnotations().contains(textAnnotation)) {
            this._vp.addAnnotation(this.textAnnotation);
        }
        this._controleurVueAnnotation = new ControleurVueAnnotation(this);
        this.position = this.textAnnotation.getCenterPosition();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(0, 1));
        jPanel.setLayout(new FlowLayout(0));
        jPanel2.setLayout(new FlowLayout(0));
        this.ySlider = new JSlider(0, 0, (int)this._vp.getExtendedRNABBox().height, Math.max(0, Math.min((int)this._vp.getExtendedRNABBox().height, (int)(this.position.y - this._vp.getExtendedRNABBox().y))));
        this.ySlider.setMajorTickSpacing(500);
        this.ySlider.setMinorTickSpacing(100);
        this.ySlider.setPaintTicks(true);
        this.ySlider.setPaintLabels(true);
        this.ySlider.setPreferredSize(new Dimension(400, this.ySlider.getPreferredSize().height));
        JLabel jLabel = new JLabel(String.valueOf((double)((int)this.position.y) - this._vp.getExtendedRNABBox().y));
        jLabel.setPreferredSize(new Dimension(50, jLabel.getPreferredSize().height));
        this.ySlider.addChangeListener(new ControleurSliderLabel(jLabel, false));
        this.ySlider.addChangeListener(this._controleurVueAnnotation);
        this.xSlider = new JSlider(0, 0, (int)this._vp.getExtendedRNABBox().width, Math.max(0, Math.min((int)this._vp.getExtendedRNABBox().width, (int)(this.position.x - this._vp.getExtendedRNABBox().x))));
        this.xSlider.setMajorTickSpacing(500);
        this.xSlider.setMinorTickSpacing(100);
        this.xSlider.setPaintTicks(true);
        this.xSlider.setPaintLabels(true);
        this.xSlider.setPreferredSize(new Dimension(400, this.xSlider.getPreferredSize().height));
        JLabel jLabel2 = new JLabel(String.valueOf((double)((int)this.position.x) - this._vp.getExtendedRNABBox().x));
        jLabel2.setPreferredSize(new Dimension(50, jLabel2.getPreferredSize().height));
        this.xSlider.addChangeListener(new ControleurSliderLabel(jLabel2, false));
        this.xSlider.addChangeListener(this._controleurVueAnnotation);
        JLabel jLabel3 = new JLabel("Y:");
        JLabel jLabel4 = new JLabel("X:");
        jPanel.add(jLabel3);
        jPanel.add(this.ySlider);
        jPanel.add(jLabel);
        jPanel2.add(jLabel4);
        jPanel2.add(this.xSlider);
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.textArea = new JTextArea(this.textAnnotation.getTexte());
        this.textArea.addCaretListener(this._controleurVueAnnotation);
        this.textArea.setPreferredSize(jPanel3.getSize());
        BasicBorders.FieldBorder fieldBorder = new BasicBorders.FieldBorder(Color.black, Color.black, Color.black, Color.black);
        this.textArea.setBorder(fieldBorder);
        JLabel jLabel5 = new JLabel("Text:");
        jPanel3.add((Component)this.textArea, "Center");
        jPanel3.add((Component)jLabel5, "North");
        this.panel.add(jPanel3);
        this.vueFont = new VueFont(textAnnotation.getFont());
        this.vueFont.getBoxPolice().addActionListener(this._controleurVueAnnotation);
        this.vueFont.getSizeSlider().addChangeListener(this._controleurVueAnnotation);
        this.vueFont.getStylesBox().addActionListener(this._controleurVueAnnotation);
        this.colorButton = new JButton("Set color");
        this.colorButton.setActionCommand("setcolor");
        this.colorButton.setForeground(textAnnotation.getColor());
        this.colorButton.addActionListener(this._controleurVueAnnotation);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.vueFont.getPanel());
        jPanel4.add(this.colorButton);
        this.panel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        this.rotationSlider = new JSlider(0, -360, 360, (int)this.textAnnotation.getAngleInDegres());
        this.rotationSlider.setMajorTickSpacing(60);
        this.rotationSlider.setPaintTicks(true);
        this.rotationSlider.setPaintLabels(true);
        this.rotationSlider.setPreferredSize(new Dimension(500, 50));
        JLabel jLabel6 = new JLabel(String.valueOf(0));
        jLabel6.setPreferredSize(new Dimension(50, jLabel6.getPreferredSize().height));
        this.rotationSlider.addChangeListener(new ControleurSliderLabel(jLabel6, false));
        this.rotationSlider.addChangeListener(this._controleurVueAnnotation);
        JLabel jLabel7 = new JLabel("Rotation (degrees):");
        jPanel5.add(jLabel7);
        jPanel5.add(this.rotationSlider);
        jPanel5.add(jLabel6);
        if (this.limited) {
            this.ySlider.setEnabled(false);
            this.xSlider.setEnabled(false);
            this.rotationSlider.setEnabled(false);
        }
        this.textArea.requestFocusInWindow();
    }

    private void applyFont() {
        this.textAnnotation.setFont(this.vueFont.getFont());
    }

    public void update() {
        this.applyFont();
        if (this.textAnnotation.getType() == TextAnnotation.AnchorType.POSITION) {
            this.textAnnotation.setAncrage((double)this.xSlider.getValue() + this._vp.getExtendedRNABBox().x, (double)this.ySlider.getValue() + this._vp.getExtendedRNABBox().y);
        }
        this.textAnnotation.setText(this.textArea.getText());
        this.textAnnotation.setAngleInDegres(this.rotationSlider.getValue());
        this._vp.clearSelection();
        this._vp.repaint();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public TextAnnotation getTextAnnotation() {
        return this.textAnnotation;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public void show() {
        this._vp.set_selectedAnnotation(this.textAnnotation);
        this._vp.highlightSelectedAnnotation();
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Add/edit annotation", 2, -1) == 0) {
            this.update();
        } else if (this.newAnnotation) {
            this._vp.set_selectedAnnotation(null);
            if (!this._vp.removeAnnotation(this.textAnnotation)) {
                this._vp.errorDialog(new Exception("Impossible de supprimer"));
            }
        } else {
            this.textAnnotation.copy(this.textAnnotationSave);
        }
        this._vp.resetAnnotationHighlight();
        this._vp.set_selectedAnnotation(null);
        this._vp.repaint();
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void setLimited(boolean bl) {
        this.limited = bl;
    }

    public boolean isNewAnnotation() {
        return this.newAnnotation;
    }

    public void updateColor(Color color) {
        this.colorButton.setForeground(color);
        this.textAnnotation.setColor(color);
    }
}

