/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.naView;

import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.naView.Base;
import fr.orsay.lri.varna.models.naView.Connection;
import fr.orsay.lri.varna.models.naView.Loop;
import fr.orsay.lri.varna.models.naView.Radloop;
import fr.orsay.lri.varna.models.naView.Region;
import java.util.ArrayList;

public class NAView {
    private final double ANUM = 9999.0;
    private final int MAXITER = 500;
    private ArrayList<Base> bases;
    private int nbase;
    private int nregion;
    private int loop_count;
    private Loop root = new Loop();
    private ArrayList<Loop> loops;
    private ArrayList<Region> regions;
    private Radloop rlphead = new Radloop();
    private double lencut = 0.8;
    private final double RADIUS_REDUCTION_FACTOR = 1.4;
    private boolean debug = false;
    private double angleinc;
    private double _h;
    private ArrayList<InterfaceVARNAListener> _listeVARNAListener = new ArrayList();
    private boolean noIterationFailureYet = true;
    double HELIX_FACTOR = 0.6;
    double BACKBONE_DISTANCE = 27.0;

    public int naview_xy_coordinates(ArrayList<Short> arrayList, ArrayList<Double> arrayList2, ArrayList<Double> arrayList3) throws ExceptionNAViewAlgorithm {
        int n;
        if (this.debug) {
            System.out.println("naview_xy_coordinates");
        }
        if (arrayList.size() == 0) {
            return 0;
        }
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>(arrayList.size() + 1);
        arrayList4.add(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList4.add(arrayList.get(n) + 1);
        }
        if (this.debug) {
            this.infoStructure(arrayList4);
        }
        this.nbase = arrayList4.get(0);
        this.bases = new ArrayList(this.nbase + 1);
        for (n = 0; n < this.bases.size(); ++n) {
            this.bases.add(new Base());
        }
        this.regions = new ArrayList();
        for (n = 0; n < this.nbase + 1; ++n) {
            this.regions.add(new Region());
        }
        this.read_in_bases(arrayList4);
        if (this.debug) {
            this.infoBasesMate();
        }
        this.rlphead = null;
        this.find_regions();
        if (this.debug) {
            this.infoRegions();
        }
        this.loop_count = 0;
        this.loops = new ArrayList(this.nbase + 1);
        for (n = 0; n < this.nbase + 1; ++n) {
            this.loops.add(new Loop());
        }
        this.construct_loop(0);
        if (this.debug) {
            this.infoBasesExtracted();
        }
        this.find_central_loop();
        if (this.debug) {
            this.infoRoot();
        }
        if (this.debug) {
            this.dump_loops();
        }
        this.traverse_loop(this.root, null);
        for (int i = 0; i < this.nbase; ++i) {
            arrayList2.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getX());
            arrayList3.add(100.0 + this.BACKBONE_DISTANCE * this.bases.get(i + 1).getY());
        }
        return this.nbase;
    }

    private void infoStructure(ArrayList<Integer> arrayList) {
        System.out.println("structure:");
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print("#" + i + ":" + arrayList.get(i) + "\t");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private void infoBasesMate() {
        System.out.println("Bases mate:");
        for (int i = 0; i < this.bases.size(); ++i) {
            System.out.print("#" + i + ":" + this.bases.get(i).getMate() + "\t");
            if (i % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private void infoRegions() {
        System.out.println("regions:");
        for (int i = 0; i < this.regions.size(); ++i) {
            System.out.print("(" + this.regions.get(i).getStart1() + "," + this.regions.get(i).getStart2() + ";" + this.regions.get(i).getEnd1() + "," + this.regions.get(i).getEnd2() + ")\t\t");
            if (i % 5 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private void infoBasesExtracted() {
        System.out.println("Bases extracted:");
        for (int i = 0; i < this.bases.size(); ++i) {
            System.out.print("i=" + i + ":" + this.bases.get(i).isExtracted() + "\t");
            if (i % 5 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    private void infoRoot() {
        System.out.println("root" + this.root.getNconnection() + ";" + this.root.getNumber());
        System.out.println("\troot : ");
        System.out.println("\tdepth=" + this.root.getDepth());
        System.out.println("\tmark=" + this.root.isMark());
        System.out.println("\tnumber=" + this.root.getNumber());
        System.out.println("\tradius=" + this.root.getRadius());
        System.out.println("\tx=" + this.root.getX());
        System.out.println("\ty=" + this.root.getY());
        System.out.println("\tnconnection=" + this.root.getNconnection());
    }

    private void read_in_bases(ArrayList<Integer> arrayList) {
        if (this.debug) {
            System.out.println("read_in_bases");
        }
        this.bases.add(new Base());
        this.bases.get(0).setMate(0);
        this.bases.get(0).setExtracted(false);
        this.bases.get(0).setX(9999.0);
        this.bases.get(0).setY(9999.0);
        int n = 0;
        for (int i = 1; i <= this.nbase; ++i) {
            this.bases.add(new Base());
            this.bases.get(i).setExtracted(false);
            this.bases.get(i).setX(9999.0);
            this.bases.get(i).setY(9999.0);
            this.bases.get(i).setMate(arrayList.get(i));
            if (arrayList.get(i) <= i) continue;
            ++n;
        }
        if (n == 0) {
            this.bases.get(1).setMate(this.nbase);
            this.bases.get(this.nbase).setMate(1);
        }
    }

    private void find_regions() {
        int n;
        if (this.debug) {
            System.out.println("find_regions");
        }
        int n2 = this.nbase + 1;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(n2);
        for (n = 0; n < n2; ++n) {
            arrayList.add(false);
        }
        this.nregion = 0;
        for (n = 0; n <= this.nbase; ++n) {
            int n3 = this.bases.get(n).getMate();
            if (n3 == 0 || ((Boolean)arrayList.get(n)).booleanValue()) continue;
            this.regions.get(this.nregion).setStart1(n);
            this.regions.get(this.nregion).setEnd2(n3);
            arrayList.set(n, true);
            arrayList.set(n3, true);
            this.bases.get(n).setRegion(this.regions.get(this.nregion));
            this.bases.get(n3).setRegion(this.regions.get(this.nregion));
            ++n;
            --n3;
            while (n < n3 && this.bases.get(n).getMate() == n3) {
                arrayList.set(n3, true);
                arrayList.set(n, true);
                this.bases.get(n).setRegion(this.regions.get(this.nregion));
                this.bases.get(n3).setRegion(this.regions.get(this.nregion));
                ++n;
                --n3;
            }
            this.regions.get(this.nregion).setEnd1(--n);
            this.regions.get(this.nregion).setStart2(n3 + 1);
            if (this.debug) {
                if (this.nregion == 0) {
                    System.out.printf("\nRegions are:\n", new Object[0]);
                }
                System.out.printf("Region %d is %d-%d and %d-%d with gap of %d.\n", this.nregion + 1, this.regions.get(this.nregion).getStart1(), this.regions.get(this.nregion).getEnd1(), this.regions.get(this.nregion).getStart2(), this.regions.get(this.nregion).getEnd2(), this.regions.get(this.nregion).getStart2() - this.regions.get(this.nregion).getEnd1() + 1);
            }
            ++this.nregion;
        }
    }

    private Loop construct_loop(int n) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("construct_loop");
        }
        Loop loop = new Loop();
        Loop loop2 = new Loop();
        Connection connection = new Connection();
        Region region = new Region();
        Radloop radloop = new Radloop();
        loop = this.loops.get(this.loop_count++);
        loop.setNconnection(0);
        loop.setDepth(0);
        loop.setNumber(this.loop_count);
        loop.setRadius(0.0);
        for (radloop = this.rlphead; radloop != null; radloop = radloop.getNext()) {
            if (radloop.getLoopnumber() != this.loop_count) continue;
            loop.setRadius(radloop.getRadius());
        }
        int n2 = n;
        do {
            int n3;
            if ((n3 = this.bases.get(n2).getMate()) != 0) {
                region = this.bases.get(n2).getRegion();
                if (!this.bases.get(region.getStart1()).isExtracted()) {
                    if (n2 == region.getStart1()) {
                        this.bases.get(region.getStart1()).setExtracted(true);
                        this.bases.get(region.getEnd1()).setExtracted(true);
                        this.bases.get(region.getStart2()).setExtracted(true);
                        this.bases.get(region.getEnd2()).setExtracted(true);
                        loop2 = this.construct_loop(region.getEnd1() < this.nbase ? region.getEnd1() + 1 : 0);
                    } else if (n2 == region.getStart2()) {
                        this.bases.get(region.getStart2()).setExtracted(true);
                        this.bases.get(region.getEnd2()).setExtracted(true);
                        this.bases.get(region.getStart1()).setExtracted(true);
                        this.bases.get(region.getEnd1()).setExtracted(true);
                        loop2 = this.construct_loop(region.getEnd2() < this.nbase ? region.getEnd2() + 1 : 0);
                    } else {
                        throw new ExceptionNAViewAlgorithm("naview:Error detected in construct_loop. i = " + n2 + " not found in region table.\n");
                    }
                    loop.setNconnection(loop.getNconnection() + 1);
                    connection = new Connection();
                    loop.setConnection(loop.getNconnection() - 1, connection);
                    loop.setConnection(loop.getNconnection(), null);
                    connection.setLoop(loop2);
                    connection.setRegion(region);
                    if (n2 == region.getStart1()) {
                        connection.setStart(region.getStart1());
                        connection.setEnd(region.getEnd2());
                    } else {
                        connection.setStart(region.getStart2());
                        connection.setEnd(region.getEnd1());
                    }
                    connection.setExtruded(false);
                    connection.setBroken(false);
                    loop2.setNconnection(loop2.getNconnection() + 1);
                    connection = new Connection();
                    loop2.setConnection(loop2.getNconnection() - 1, connection);
                    loop2.setConnection(loop2.getNconnection(), null);
                    connection.setLoop(loop);
                    connection.setRegion(region);
                    if (n2 == region.getStart1()) {
                        connection.setStart(region.getStart2());
                        connection.setEnd(region.getEnd1());
                    } else {
                        connection.setStart(region.getStart1());
                        connection.setEnd(region.getEnd2());
                    }
                    connection.setExtruded(false);
                    connection.setBroken(false);
                }
                n2 = n3;
            }
            if (++n2 <= this.nbase) continue;
            n2 = 0;
        } while (n2 != n);
        return loop;
    }

    private void dump_loops() {
        System.out.println("dump_loops");
        System.out.printf("\nRoot loop is #%d\n", this.loops.indexOf(this.root) + 1);
        for (int i = 0; i < this.loop_count; ++i) {
            Connection connection;
            Loop loop = this.loops.get(i);
            System.out.printf("Loop %d has %d connections:\n", i + 1, loop.getNconnection());
            int n = 0;
            while ((connection = loop.getConnection(n)) != null) {
                int n2 = this.loops.indexOf(connection.getLoop()) + 1;
                int n3 = this.regions.indexOf(connection.getRegion()) + 1;
                System.out.printf("  Loop %d Region %d (%d-%d)\n", n2, n3, connection.getStart(), connection.getEnd());
                ++n;
            }
        }
    }

    private void find_central_loop() {
        if (this.debug) {
            System.out.println("find_central_loop");
        }
        Loop loop = new Loop();
        this.determine_depths();
        int n = 0;
        int n2 = -1;
        for (int i = 0; i < this.loop_count; ++i) {
            loop = this.loops.get(i);
            if (loop.getNconnection() > n) {
                n2 = loop.getDepth();
                n = loop.getNconnection();
                this.root = loop;
                continue;
            }
            if (loop.getDepth() <= n2 || loop.getNconnection() != n) continue;
            n2 = loop.getDepth();
            this.root = loop;
        }
    }

    private void determine_depths() {
        if (this.debug) {
            System.out.println("determine_depths");
        }
        Loop loop = new Loop();
        for (int i = 0; i < this.loop_count; ++i) {
            loop = this.loops.get(i);
            for (int j = 0; j < this.loop_count; ++j) {
                this.loops.get(j).setMark(false);
            }
            loop.setDepth(this.depth(loop));
        }
    }

    private int depth(Loop loop) {
        if (this.debug) {
            System.out.println("depth");
        }
        if (loop.getNconnection() <= 1) {
            return 0;
        }
        if (loop.isMark()) {
            return -1;
        }
        loop.setMark(true);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (loop.getConnection(n3) != null) {
            int n4 = this.depth(loop.getConnection(n3).getLoop());
            if (n4 >= 0) {
                if (++n == 1) {
                    n2 = n4;
                } else if (n2 > n4) {
                    n2 = n4;
                }
            }
            ++n3;
        }
        loop.setMark(false);
        return n2 + 1;
    }

    private void traverse_loop(Loop loop, Connection connection) throws ExceptionNAViewAlgorithm {
        int n;
        Connection connection2;
        int n2;
        Connection connection3;
        if (this.debug) {
            System.out.println("  traverse_loop");
        }
        int n3 = 0;
        double d = Math.PI * 2 / (double)(this.nbase + 1);
        Connection connection4 = null;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while ((connection3 = loop.getConnection(n5)) != null) {
            double d2 = -Math.sin(d * (double)connection3.getStart());
            double d3 = Math.cos(d * (double)connection3.getStart());
            double d4 = -Math.sin(d * (double)connection3.getEnd());
            double d5 = Math.cos(d * (double)connection3.getEnd());
            double d6 = d5 - d3;
            double d7 = d2 - d4;
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            connection3.setXrad(d6 / d8);
            connection3.setYrad(d7 / d8);
            connection3.setAngle(Math.atan2(d7, d6));
            if (connection3.getAngle() < 0.0) {
                connection3.setAngle(connection3.getAngle() + Math.PI * 2);
            }
            if (connection != null && connection.getRegion() == connection3.getRegion()) {
                connection4 = connection3;
                n4 = n6;
            }
            ++n5;
            ++n6;
        }
        block1: while (true) {
            int n7;
            double d9;
            double d10;
            double d11;
            double d12;
            int n8;
            double d13;
            double d14;
            double d15;
            this.determine_radius(loop, this.lencut);
            double d16 = loop.getRadius() / 1.4;
            if (connection == null) {
                d15 = 0.0;
                d14 = 0.0;
            } else {
                double d17 = (this.bases.get(connection4.getStart()).getX() + this.bases.get(connection4.getEnd()).getX()) / 2.0;
                double d18 = (this.bases.get(connection4.getStart()).getY() + this.bases.get(connection4.getEnd()).getY()) / 2.0;
                d14 = d17 - d16 * connection4.getXrad();
                d15 = d18 - d16 * connection4.getYrad();
            }
            int n9 = n4 == -1 ? 0 : n4;
            connection3 = loop.getConnection(n9);
            int n10 = 0;
            if (this.debug) {
                System.out.printf("Now processing loop %d\n", loop.getNumber());
                System.out.println("  " + loop);
            }
            boolean bl = false;
            do {
                Connection connection5;
                if ((n2 = n9 - 1) < 0) {
                    n2 = loop.getNconnection() - 1;
                }
                if (!this.connected_connection(connection5 = loop.getConnection(n2), connection3)) {
                    bl = true;
                } else {
                    n9 = n2;
                    connection3 = connection5;
                }
                if (++n10 <= loop.getNconnection()) continue;
                double d19 = -1.0;
                for (n6 = 0; n6 < loop.getNconnection(); ++n6) {
                    n2 = n6 + 1;
                    if (n2 >= loop.getNconnection()) {
                        n2 = 0;
                    }
                    connection3 = loop.getConnection(n6);
                    connection2 = loop.getConnection(n2);
                    d13 = connection2.getAngle() - connection3.getAngle();
                    if (d13 < 0.0) {
                        d13 += Math.PI * 2;
                    }
                    if (!(d13 > d19)) continue;
                    d19 = d13;
                    n3 = n6;
                }
                n8 = n3;
                n9 = n3 + 1;
                if (n9 >= loop.getNconnection()) {
                    n9 = 0;
                }
                connection3 = loop.getConnection(n8);
                connection3.setBroken(true);
                bl = true;
            } while (!bl);
            boolean bl2 = false;
            int n11 = n9;
            if (this.debug) {
                System.out.printf("  Icstart1 = %d\n", n11);
            }
            while (!bl2) {
                int n12;
                int n13;
                n10 = 0;
                bl = false;
                n8 = n9;
                boolean bl3 = false;
                while (!bl) {
                    connection3 = loop.getConnection(n8);
                    if (n8 == n4) {
                        bl3 = true;
                    }
                    if ((n2 = n8 + 1) >= loop.getNconnection()) {
                        n2 = 0;
                    }
                    if (this.connected_connection(connection3, connection2 = loop.getConnection(n2))) {
                        if (++n10 >= loop.getNconnection()) break;
                        n8 = n2;
                        continue;
                    }
                    bl = true;
                }
                int n14 = n13 = (n12 = this.find_ic_middle(n9, n8, connection, connection4, loop));
                n6 = n13;
                if (this.debug) {
                    System.out.printf("  IC start = %d  middle = %d  end = %d\n", n9, n12, n8);
                }
                bl = false;
                int n15 = 0;
                while (!bl) {
                    n6 = n15 < 0 ? n14 : (n15 == 0 ? n12 : n13);
                    if (n6 >= 0) {
                        connection3 = loop.getConnection(n6);
                        if (connection == null || connection4 != connection3) {
                            double d20;
                            double d21;
                            double d22;
                            double d23;
                            double d24;
                            double d25;
                            if (n15 == 0) {
                                double d26 = connection3.getAngle() - Math.asin(0.5 / d16);
                                double d27 = connection3.getAngle() + Math.asin(0.5 / d16);
                                this.bases.get(connection3.getStart()).setX(d14 + d16 * Math.cos(d26));
                                this.bases.get(connection3.getStart()).setY(d15 + d16 * Math.sin(d26));
                                this.bases.get(connection3.getEnd()).setX(d14 + d16 * Math.cos(d27));
                                this.bases.get(connection3.getEnd()).setY(d15 + d16 * Math.sin(d27));
                            } else if (n15 < 0) {
                                n2 = n6 + 1;
                                if (n2 >= loop.getNconnection()) {
                                    n2 = 0;
                                }
                                connection3 = loop.getConnection(n6);
                                connection2 = loop.getConnection(n2);
                                double d28 = connection3.getXrad();
                                double d29 = connection3.getYrad();
                                d13 = (connection3.getAngle() + connection2.getAngle()) / 2.0;
                                if (connection3.getAngle() > connection2.getAngle()) {
                                    d13 -= Math.PI;
                                }
                                d25 = Math.cos(d13);
                                d23 = d24 = Math.sin(d13);
                                d22 = -d25;
                                d21 = connection2.getAngle() - connection3.getAngle();
                                if (d21 < 0.0) {
                                    d21 += Math.PI * 2;
                                }
                                d20 = connection3.isExtruded() ? (d21 <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                this.bases.get(connection3.getEnd()).setX(this.bases.get(connection2.getStart()).getX() + d20 * d23);
                                this.bases.get(connection3.getEnd()).setY(this.bases.get(connection2.getStart()).getY() + d20 * d22);
                                this.bases.get(connection3.getStart()).setX(this.bases.get(connection3.getEnd()).getX() + d29);
                                this.bases.get(connection3.getStart()).setY(this.bases.get(connection3.getEnd()).getY() - d28);
                            } else {
                                n2 = n6 - 1;
                                if (n2 < 0) {
                                    n2 = loop.getNconnection() - 1;
                                }
                                connection3 = loop.getConnection(n2);
                                connection2 = loop.getConnection(n6);
                                double d30 = connection2.getXrad();
                                double d31 = connection2.getYrad();
                                d13 = (connection3.getAngle() + connection2.getAngle()) / 2.0;
                                if (connection3.getAngle() > connection2.getAngle()) {
                                    d13 -= Math.PI;
                                }
                                d25 = Math.cos(d13);
                                d24 = Math.sin(d13);
                                d23 = -d24;
                                d22 = d25;
                                d21 = connection2.getAngle() - connection3.getAngle();
                                if (d21 < 0.0) {
                                    d21 += Math.PI * 2;
                                }
                                d20 = connection3.isExtruded() ? (d21 <= 1.5707963267948966 ? 2.0 : 1.5) : 1.0;
                                this.bases.get(connection2.getStart()).setX(this.bases.get(connection3.getEnd()).getX() + d20 * d23);
                                this.bases.get(connection2.getStart()).setY(this.bases.get(connection3.getEnd()).getY() + d20 * d22);
                                this.bases.get(connection2.getEnd()).setX(this.bases.get(connection2.getStart()).getX() - d31);
                                this.bases.get(connection2.getEnd()).setY(this.bases.get(connection2.getStart()).getY() + d30);
                            }
                        }
                    }
                    if (n15 < 0) {
                        if (n13 == n8) {
                            n13 = -1;
                        } else if (n13 >= 0 && ++n13 >= loop.getNconnection()) {
                            n13 = 0;
                        }
                        n15 = 1;
                    } else {
                        if (n14 == n9) {
                            n14 = -1;
                        } else if (n14 >= 0 && --n14 < 0) {
                            n14 = loop.getNconnection() - 1;
                        }
                        n15 = -1;
                    }
                    bl = n14 == -1 && n13 == -1;
                }
                int n16 = n8 + 1;
                if (n16 >= loop.getNconnection()) {
                    n16 = 0;
                }
                if (n8 != n9 && (n9 != n11 || n16 != n11)) {
                    connection3 = loop.getConnection(n9);
                    connection2 = loop.getConnection(n8);
                    d12 = this.bases.get(connection2.getEnd()).getX() - this.bases.get(connection3.getStart()).getX();
                    d11 = this.bases.get(connection2.getEnd()).getY() - this.bases.get(connection3.getStart()).getY();
                    double d32 = this.bases.get(connection3.getStart()).getX() + d12 / 2.0;
                    double d33 = this.bases.get(connection3.getStart()).getY() + d11 / 2.0;
                    d10 = Math.sqrt(d12 * d12 + d11 * d11);
                    double d34 = d12 / d10;
                    double d35 = d11 / d10;
                    double d36 = d14 - d32;
                    double d37 = d15 - d33;
                    d10 = Math.sqrt(d12 * d12 + d11 * d11);
                    double d38 = (d36 /= d10) * d34 + (d37 /= d10) * d35;
                    double d39 = d38 * d34 - d36;
                    double d40 = d38 * d35 - d37;
                    d10 = Math.sqrt(d39 * d39 + d40 * d40);
                    d39 /= d10;
                    d40 /= d10;
                    d12 = this.bases.get(connection3.getStart()).getX() - d14;
                    d11 = this.bases.get(connection3.getStart()).getY() - d15;
                    d13 = Math.atan2(d11, d12);
                    if (d13 < 0.0) {
                        d13 += Math.PI * 2;
                    }
                    d12 = this.bases.get(connection2.getEnd()).getX() - d14;
                    d11 = this.bases.get(connection2.getEnd()).getY() - d15;
                    d9 = Math.atan2(d11, d12);
                    if (d9 < 0.0) {
                        d9 += Math.PI * 2;
                    }
                    if (d9 < d13) {
                        d9 += Math.PI * 2;
                    }
                    int n17 = d9 - d13 > Math.PI ? -1 : 1;
                    double d41 = d14 + (double)n17 * d16 * d39;
                    double d42 = d15 + (double)n17 * d16 * d40;
                    if (bl3) {
                        d14 -= d41 - d32;
                        d15 -= d42 - d33;
                    } else {
                        n6 = n9;
                        while (true) {
                            connection3 = loop.getConnection(n6);
                            n7 = connection3.getStart();
                            this.bases.get(n7).setX(this.bases.get(n7).getX() + d41 - d32);
                            this.bases.get(n7).setY(this.bases.get(n7).getY() + d42 - d33);
                            n7 = connection3.getEnd();
                            this.bases.get(n7).setX(this.bases.get(n7).getX() + d41 - d32);
                            this.bases.get(n7).setY(this.bases.get(n7).getY() + d42 - d33);
                            if (n6 == n8) break;
                            if (++n6 < loop.getNconnection()) continue;
                            n6 = 0;
                        }
                    }
                }
                bl2 = (n9 = n16) == n11;
            }
            for (n6 = 0; n6 < loop.getNconnection(); ++n6) {
                connection3 = loop.getConnection(n6);
                n2 = n6 + 1;
                if (n2 >= loop.getNconnection()) {
                    n2 = 0;
                }
                connection2 = loop.getConnection(n2);
                d12 = this.bases.get(connection3.getEnd()).getX() - d14;
                d11 = this.bases.get(connection3.getEnd()).getY() - d15;
                double d43 = Math.sqrt(d12 * d12 + d11 * d11);
                d13 = Math.atan2(d11, d12);
                if (d13 < 0.0) {
                    d13 += Math.PI * 2;
                }
                d12 = this.bases.get(connection2.getStart()).getX() - d14;
                d11 = this.bases.get(connection2.getStart()).getY() - d15;
                double d44 = Math.sqrt(d12 * d12 + d11 * d11);
                d9 = Math.atan2(d11, d12);
                if (d9 < 0.0) {
                    d9 += Math.PI * 2;
                }
                if (d9 < d13) {
                    d9 += Math.PI * 2;
                }
                double d45 = d9 - d13;
                double d46 = connection2.getAngle() - connection3.getAngle();
                if (d46 <= 0.0) {
                    d46 += Math.PI * 2;
                }
                if (Math.abs(d45 - d46) > Math.PI) {
                    if (connection3.isExtruded()) {
                        this.warningEmition("Warning from traverse_loop. Loop " + loop.getNumber() + " has crossed regions\n");
                    } else if (connection2.getStart() - connection3.getEnd() != 1) {
                        connection3.setExtruded(true);
                        continue block1;
                    }
                }
                if (connection3.isExtruded()) {
                    this.construct_extruded_segment(connection3, connection2);
                    continue;
                }
                n = connection2.getStart() - connection3.getEnd();
                if (n < 0) {
                    n += this.nbase + 1;
                }
                d = d45 / (double)n;
                for (n2 = 1; n2 < n; ++n2) {
                    n7 = connection3.getEnd() + n2;
                    if (n7 > this.nbase) {
                        n7 -= this.nbase + 1;
                    }
                    double d47 = d13 + (double)n2 * d;
                    d10 = d43 + (d44 - d43) * (d47 - d13) / d45;
                    this.bases.get(n7).setX(d14 + d10 * Math.cos(d47));
                    this.bases.get(n7).setY(d15 + d10 * Math.sin(d47));
                }
            }
            break;
        }
        for (n6 = 0; n6 < loop.getNconnection(); ++n6) {
            if (n4 == n6) continue;
            connection3 = loop.getConnection(n6);
            this.generate_region(connection3);
            this.traverse_loop(connection3.getLoop(), connection3);
        }
        n = 0;
        double d48 = 0.0;
        double d49 = 0.0;
        for (n6 = 0; n6 < loop.getNconnection(); ++n6) {
            n2 = n6 + 1;
            if (n2 >= loop.getNconnection()) {
                n2 = 0;
            }
            connection3 = loop.getConnection(n6);
            connection2 = loop.getConnection(n2);
            n += 2;
            d48 += this.bases.get(connection3.getStart()).getX() + this.bases.get(connection3.getEnd()).getX();
            d49 += this.bases.get(connection3.getStart()).getY() + this.bases.get(connection3.getEnd()).getY();
            if (connection3.isExtruded()) continue;
            for (n2 = connection3.getEnd() + 1; n2 != connection2.getStart(); ++n2) {
                if (n2 > this.nbase) {
                    n2 -= this.nbase + 1;
                }
                ++n;
                d48 += this.bases.get(n2).getX();
                d49 += this.bases.get(n2).getY();
            }
        }
        loop.setX(d48 / (double)n);
        loop.setY(d49 / (double)n);
    }

    private void determine_radius(Loop loop, double d) {
        double d2;
        double d3;
        if (this.debug) {
            System.out.println("  Determine_radius");
        }
        int n = 0;
        Connection connection = new Connection();
        Connection connection2 = new Connection();
        double d4 = 0.7071068;
        do {
            d3 = 1.0E10;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i = 0; i < loop.getNconnection(); ++i) {
                double d7;
                connection = loop.getConnection(i);
                int n2 = i + 1;
                if (n2 >= loop.getNconnection()) {
                    n2 = 0;
                }
                connection2 = loop.getConnection(n2);
                int n3 = connection.getEnd();
                int n4 = connection2.getStart();
                if (n4 < n3) {
                    n4 += this.nbase + 1;
                }
                if ((d7 = connection2.getAngle() - connection.getAngle()) <= 0.0) {
                    d7 += Math.PI * 2;
                }
                double d8 = !connection.isExtruded() ? (double)(n4 - n3) : (d7 <= 1.5707963267948966 ? 2.0 : 1.5);
                d6 += d7 * (1.0 / d8 + 1.0);
                d5 += d7 * d7 / d8;
                double d9 = d7 / d8;
                if (!(d9 < d3) || connection.isExtruded() || !(d8 > 1.0)) continue;
                d3 = d9;
                n = i;
            }
            d2 = d6 / d5;
            if (d2 < d4) {
                d2 = d4;
            }
            if (!(d3 * d2 < d)) continue;
            loop.getConnection(n).setExtruded(true);
        } while (d3 * d2 < d);
        if (loop.getRadius() > 0.0) {
            d2 = loop.getRadius();
        } else {
            loop.setRadius(d2);
        }
    }

    private boolean connected_connection(Connection connection, Connection connection2) {
        if (this.debug) {
            System.out.println("  Connected_connection");
        }
        if (connection.isExtruded()) {
            return true;
        }
        return connection.getEnd() + 1 == connection2.getStart();
    }

    private int find_ic_middle(int n, int n2, Connection connection, Connection connection2, Loop loop) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("  Find_ic_middle");
        }
        int n3 = 0;
        int n4 = -1;
        int n5 = n;
        boolean bl = false;
        while (!bl) {
            if (n3++ > loop.getNconnection() * 2) {
                throw new ExceptionNAViewAlgorithm("Infinite loop detected in find_ic_middle");
            }
            if (connection != null && loop.getConnection(n5) == connection2) {
                n4 = n5;
            }
            boolean bl2 = bl = n5 == n2;
            if (++n5 < loop.getNconnection()) continue;
            n5 = 0;
        }
        if (n4 == -1) {
            n5 = n;
            for (int i = 1; i < (n3 + 1) / 2; ++i) {
                if (++n5 < loop.getNconnection()) continue;
                n5 = 0;
            }
            n4 = n5;
        }
        return n4;
    }

    private void generate_region(Connection connection) throws ExceptionNAViewAlgorithm {
        int n;
        int n2;
        if (this.debug) {
            System.out.println("  Generate_region");
        }
        Region region = connection.getRegion();
        int n3 = 0;
        if (connection.getStart() == region.getStart1()) {
            n2 = region.getStart1();
            n = region.getEnd1();
        } else {
            n2 = region.getStart2();
            n = region.getEnd2();
        }
        if (this.bases.get(connection.getStart()).getX() > 9899.0 || this.bases.get(connection.getEnd()).getX() > 9899.0) {
            throw new ExceptionNAViewAlgorithm("Bad region passed to generate_region. Coordinates not defined.");
        }
        for (int i = n2 + 1; i <= n; ++i) {
            this.bases.get(i).setX(this.bases.get(connection.getStart()).getX() + this.HELIX_FACTOR * (double)(++n3) * connection.getXrad());
            this.bases.get(i).setY(this.bases.get(connection.getStart()).getY() + this.HELIX_FACTOR * (double)n3 * connection.getYrad());
            int n4 = this.bases.get(i).getMate();
            this.bases.get(n4).setX(this.bases.get(connection.getEnd()).getX() + this.HELIX_FACTOR * (double)n3 * connection.getXrad());
            this.bases.get(n4).setY(this.bases.get(connection.getEnd()).getY() + this.HELIX_FACTOR * (double)n3 * connection.getYrad());
        }
    }

    private void construct_circle_segment(int n, int n2) throws ExceptionNAViewAlgorithm {
        if (this.debug) {
            System.out.println("  Construct_circle_segment");
        }
        double d = this.bases.get(n2).getX() - this.bases.get(n).getX();
        double d2 = this.bases.get(n2).getY() - this.bases.get(n).getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.nbase + 1;
        }
        if (d3 >= (double)n3) {
            d /= d3;
            d2 /= d3;
            for (int i = 1; i < n3; ++i) {
                int n4 = n + i;
                if (n4 > this.nbase) {
                    n4 -= this.nbase + 1;
                }
                this.bases.get(n4).setX(this.bases.get(n).getX() + d * (double)i / (double)n3);
                this.bases.get(n4).setY(this.bases.get(n).getY() + d2 * (double)i / (double)n3);
            }
        } else {
            this.find_center_for_arc(n3 - 1, d3);
            double d4 = this.bases.get(n).getX() + (d /= d3) * d3 / 2.0;
            double d5 = this.bases.get(n).getY() + (d2 /= d3) * d3 / 2.0;
            double d6 = d2;
            double d7 = -d;
            double d8 = d4 + this._h * d6;
            double d9 = d5 + this._h * d7;
            double d10 = this.bases.get(n).getX() - d8;
            double d11 = this.bases.get(n).getY() - d9;
            d3 = Math.sqrt(d10 * d10 + d11 * d11);
            double d12 = Math.atan2(d11, d10);
            for (int i = 1; i < n3; ++i) {
                int n5 = n + i;
                if (n5 > this.nbase) {
                    n5 -= this.nbase + 1;
                }
                this.bases.get(n5).setX(d8 + d3 * Math.cos(d12 + (double)i * this.angleinc));
                this.bases.get(n5).setY(d9 + d3 * Math.sin(d12 + (double)i * this.angleinc));
            }
        }
    }

    private void construct_extruded_segment(Connection connection, Connection connection2) throws ExceptionNAViewAlgorithm {
        double d;
        if (this.debug) {
            System.out.println("  Construct_extruded_segment");
        }
        double d2 = connection.getAngle();
        double d3 = connection2.getAngle();
        double d4 = d3;
        if (d4 < d2) {
            d4 += Math.PI * 2;
        }
        double d5 = (d2 + d4) / 2.0;
        int n = connection.getEnd();
        int n2 = connection2.getStart();
        int n3 = n2 - n;
        if (n3 < 0) {
            n3 += this.nbase + 1;
        }
        if ((d = connection2.getAngle() - connection.getAngle()) < 0.0) {
            d += Math.PI * 2;
        }
        if (n3 == 2) {
            this.construct_circle_segment(n, n2);
        } else {
            boolean bl;
            int n4;
            int n5;
            double d6 = this.bases.get(n2).getX() - this.bases.get(n).getX();
            double d7 = this.bases.get(n2).getY() - this.bases.get(n).getY();
            double d8 = Math.sqrt(d6 * d6 + d7 * d7);
            d6 /= d8;
            d7 /= d8;
            if (d8 >= 1.5 && d <= 1.5707963267948966) {
                n5 = n + 1;
                if (n5 > this.nbase) {
                    n5 -= this.nbase + 1;
                }
                if ((n4 = n2 - 1) < 0) {
                    n4 += this.nbase + 1;
                }
                this.bases.get(n5).setX(this.bases.get(n).getX() + 0.5 * d6);
                this.bases.get(n5).setY(this.bases.get(n).getY() + 0.5 * d7);
                this.bases.get(n4).setX(this.bases.get(n2).getX() - 0.5 * d6);
                this.bases.get(n4).setY(this.bases.get(n2).getY() - 0.5 * d7);
                n = n5;
                n2 = n4;
            }
            do {
                double d9;
                bl = false;
                this.construct_circle_segment(n, n2);
                n5 = n + 1;
                if (n5 > this.nbase) {
                    n5 -= this.nbase + 1;
                }
                d6 = this.bases.get(n5).getX() - this.bases.get(n).getX();
                d7 = this.bases.get(n5).getY() - this.bases.get(n).getY();
                double d10 = Math.atan2(d7, d6);
                if (d10 < 0.0) {
                    d10 += Math.PI * 2;
                }
                if ((d9 = d10 - d2) < 0.0) {
                    d9 += Math.PI * 2;
                }
                if (d9 > Math.PI) {
                    bl = true;
                }
                if ((n4 = n2 - 1) < 0) {
                    n4 += this.nbase + 1;
                }
                d6 = this.bases.get(n4).getX() - this.bases.get(n2).getX();
                d7 = this.bases.get(n4).getY() - this.bases.get(n2).getY();
                double d11 = Math.atan2(d7, d6);
                if (d11 < 0.0) {
                    d11 += Math.PI * 2;
                }
                if ((d9 = d3 - d11) < 0.0) {
                    d9 += Math.PI * 2;
                }
                if (d9 > Math.PI) {
                    bl = true;
                }
                if (!bl) continue;
                double d12 = this.minf2(d5, d2 + 0.5);
                this.bases.get(n5).setX(this.bases.get(n).getX() + Math.cos(d12));
                this.bases.get(n5).setY(this.bases.get(n).getY() + Math.sin(d12));
                n = n5;
                d12 = this.maxf2(d5, d4 - 0.5);
                this.bases.get(n4).setX(this.bases.get(n2).getX() + Math.cos(d12));
                this.bases.get(n4).setY(this.bases.get(n2).getY() + Math.sin(d12));
                n2 = n4;
                n3 -= 2;
            } while (bl && n3 > 1);
        }
    }

    private void find_center_for_arc(double d, double d2) throws ExceptionNAViewAlgorithm {
        double d3;
        double d4;
        double d5;
        if (this.debug) {
            System.out.println("  Find_center_for_arc");
        }
        double d6 = (d + 1.0) / Math.PI;
        double d7 = -d6 - d2 / (d + 1.000001 - d2);
        if (d2 < 1.0) {
            d7 = 0.0;
        }
        int n = 0;
        do {
            double d8;
            double d9;
            double d10;
            if (Math.abs(d10 = 1.0 - 0.5 / ((d9 = Math.sqrt((d4 = (d6 + d7) / 2.0) * d4 + d2 * d2 / 4.0)) * d9)) > 1.0) {
                throw new ExceptionNAViewAlgorithm("Unexpected large magnitude discriminant = " + d10 + " " + d9);
            }
            d3 = Math.acos(d10);
            d5 = d3 * (d + 1.0) + 2.0 * (d8 = Math.acos(d4 / d9)) - Math.PI * 2;
            if (d5 > 0.0) {
                d7 = d4;
                continue;
            }
            d6 = d4;
        } while (Math.abs(d5) > 1.0E-4 && ++n < 500);
        if (n >= 500) {
            if (this.noIterationFailureYet) {
                this.warningEmition("Iteration failed in find_center_for_arc");
                this.noIterationFailureYet = false;
            }
            d4 = 0.0;
            d3 = 0.0;
        }
        this._h = d4;
        this.angleinc = d3;
    }

    private double minf2(double d, double d2) {
        return d < d2 ? d : d2;
    }

    private double maxf2(double d, double d2) {
        return d > d2 ? d : d2;
    }

    public void warningEmition(String string) throws ExceptionNAViewAlgorithm {
        throw new ExceptionNAViewAlgorithm(string);
    }
}

