/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAFactory;
import fr.orsay.lri.varna.models.rna.RNA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;

public class RNAAlignment {
    private ArrayList<String> _lst = new ArrayList();
    private Hashtable<String, Integer> _index = new Hashtable();
    private Hashtable<String, String> _accession = new Hashtable();
    private String _secStr = "";

    public void addSequence(String string, String string2) {
        if (!this._index.containsKey(string)) {
            this._index.put(string, this._lst.size());
            this._lst.add(string2);
        }
        this._lst.set(this._index.get(string), string2);
    }

    public void setSecStr(String string) {
        this._secStr = string;
    }

    public void setAccession(String string, String string2) {
        this._accession.put(string, string2);
    }

    public ArrayList<RNA> getRNAs() throws ExceptionUnmatchedClosingParentheses {
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        int[] nArray = RNAFactory.parseSecStr(this._secStr);
        ArrayList<String> arrayList2 = new ArrayList<String>(this._index.keySet());
        Collections.sort(arrayList2, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareToIgnoreCase(string2);
            }
        });
        for (String string : arrayList2) {
            int n = this._index.get(string);
            String string2 = this._lst.get(n);
            String string3 = "";
            String string4 = "";
            for (int i = 0; i < string2.length(); ++i) {
                char c;
                char c2 = string2.charAt(i);
                int n2 = nArray[i];
                if (c2 == '.' || c2 == ':' || c2 == '-') continue;
                string3 = string3 + c2;
                string4 = n2 == -1 ? string4 + '.' : ((c = string2.charAt(n2)) == '.' || c == ':' || c == '-' ? string4 + '.' : string4 + this._secStr.charAt(i));
            }
            RNA rNA = new RNA();
            try {
                rNA.setRNA(string3, string4);
                rNA.setName(string);
                if (this._accession.containsKey(string)) {
                    rNA.setID(this._accession.get(string));
                } else {
                    rNA.setID(string);
                }
                arrayList.add(rNA);
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                exceptionFileFormatOrSyntax.printStackTrace();
            }
        }
        return arrayList;
    }
}

