/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.FileLock;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.NativeLock;

public class LockFactory {
    protected static Log log = LogFactory.getLog((Class)LockFactory.class);
    public static int locktype = 0;
    public static String[] locktypes = new String[]{"file", "native"};

    public LockFactory() {
        String lockt = System.getProperty("vamsas.locktype");
        if (lockt != null) {
            int i;
            int j = locktypes.length;
            for (i = 0; i < j && locktypes[i].equalsIgnoreCase(lockt); ++i) {
            }
            if (i >= j) {
                String lt = "'" + locktypes[0] + "'";
                for (i = 1; i < j; ++i) {
                    lt = lt + ",'" + locktypes[i] + "'";
                }
                log.warn((Object)("System property vamsas.locktype takes one of " + lt));
                log.warn((Object)("Defaulting to Locktype of " + locktypes[locktype]));
            }
        } else {
            log.debug((Object)("Defaulting to Locktype of " + locktypes[locktype]));
        }
    }

    public static Lock getLock(File target) {
        return LockFactory.getLock(target, true);
    }

    public static Lock getLock(File target, boolean block) {
        if (locktype == 0) {
            return new FileLock(target, block);
        }
        if (locktype == 1) {
            return new NativeLock(target, block);
        }
        log.fatal((Object)"Implementation Error! No valid Locktype value");
        return null;
    }

    public static Lock tryLock(File target) {
        return LockFactory.getLock(target, false);
    }
}

