/*
 * Decompiled with CFR 0.152.
 */
package mc_view;

import jalview.schemes.ResidueProperties;
import java.awt.Color;

public class Atom {
    public float x;
    public float y;
    public float z;
    public int number;
    public String name;
    public String resName;
    public int resNumber;
    public char insCode = (char)32;
    public String resNumIns = null;
    public int type;
    Color color = Color.lightGray;
    public String chain;
    public int alignmentMapping = -1;
    public int atomIndex;
    public float occupancy = 0.0f;
    public float tfactor = 0.0f;
    public boolean isSelected = false;

    public Atom(String str) {
        this.atomIndex = Integer.parseInt(str.substring(6, 11).trim());
        this.name = str.substring(12, 15).trim();
        this.resName = str.substring(17, 20);
        this.resName = ResidueProperties.getCanonicalAminoAcid(this.resName);
        this.chain = str.substring(21, 22);
        this.resNumber = Integer.parseInt(str.substring(22, 26).trim());
        this.resNumIns = str.substring(22, 27).trim();
        this.insCode = str.substring(26, 27).charAt(0);
        this.x = Float.valueOf(str.substring(30, 38).trim()).floatValue();
        this.y = Float.valueOf(str.substring(38, 46).trim()).floatValue();
        this.z = Float.valueOf(str.substring(47, 55).trim()).floatValue();
        String tm = str.substring(54, 60).trim();
        this.occupancy = tm.length() > 0 ? Float.valueOf(tm).floatValue() : 1.0f;
        tm = str.substring(60, 66).trim();
        this.tfactor = tm.length() > 0 ? Float.valueOf(tm).floatValue() : 1.0f;
    }

    public boolean equals(Object that) {
        if (this == that || that == null) {
            return true;
        }
        if (that instanceof Atom) {
            Atom other = (Atom)that;
            return other.resName.equals(this.resName) && other.resNumber == this.resNumber && other.resNumIns.equals(this.resNumIns) && other.chain.equals(this.chain);
        }
        return false;
    }

    public Atom(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

