/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.alignment;

import jalview.analysis.AlignmentSorter;
import jalview.analysis.SeqsetUtils;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.ServiceInputInvalidException;
import jalview.ws2.actions.alignment.AlignmentAction;
import jalview.ws2.actions.alignment.AlignmentJob;
import jalview.ws2.actions.alignment.AlignmentResult;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class AlignmentTask
extends BaseTask<AlignmentJob, AlignmentResult> {
    private final AlignmentWebServiceClientI client;
    private final AlignmentAction action;
    private final AlignmentView msa;
    private final boolean submitGaps;
    private final AlignmentI currentView;
    private final AlignmentI dataset;
    private final char gapChar;
    private final List<AlignedCodonFrame> codonFrame = new ArrayList<AlignedCodonFrame>();

    AlignmentTask(AlignmentWebServiceClientI client, AlignmentAction action, List<ArgumentI> args, Credentials credentials, AlignViewportI viewport, boolean submitGaps) {
        super(client, args, credentials);
        this.client = client;
        this.action = action;
        this.msa = viewport.getAlignmentView(true);
        this.submitGaps = submitGaps;
        this.currentView = viewport.getAlignment();
        this.dataset = viewport.getAlignment().getDataset();
        this.gapChar = viewport.getGapCharacter();
        List<AlignedCodonFrame> cf = viewport.getAlignment().getCodonFrames();
        if (cf != null) {
            this.codonFrame.addAll(cf);
        }
    }

    @Override
    protected List<AlignmentJob> prepareJobs() throws ServiceInputInvalidException {
        Console.info(String.format("starting alignment service %s:%s", this.client.getClientName(), this.action.getName()));
        SequenceI[][] conmsa = this.msa.getVisibleContigs(this.gapChar);
        if (conmsa == null) {
            throw new ServiceInputInvalidException("no visible contigs for alignment");
        }
        ArrayList<AlignmentJob> jobs = new ArrayList<AlignmentJob>(conmsa.length);
        boolean validInput = false;
        for (int i = 0; i < conmsa.length; ++i) {
            AlignmentJob job = AlignmentJob.create(conmsa[i], 2, this.submitGaps);
            validInput |= job.isInputValid();
            job.setStatus(job.isInputValid() ? JobStatus.READY : JobStatus.INVALID);
            jobs.add(job);
        }
        this.jobs = jobs;
        if (!validInput) {
            throw new ServiceInputInvalidException("no valid sequences for alignment");
        }
        return jobs;
    }

    @Override
    protected AlignmentResult collectResult(List<AlignmentJob> jobs) throws IOException {
        IOException lastIOE = null;
        for (AlignmentJob job : jobs) {
            if (!job.isInputValid() || job.getStatus() != JobStatus.COMPLETED || job.hasResult()) continue;
            try {
                job.setAlignmentResult(this.client.getAlignment(job.getServerJob()));
            }
            catch (IOException e) {
                lastIOE = e;
            }
        }
        if (lastIOE != null) {
            throw lastIOE;
        }
        ArrayList<AlignmentOrder> alorders = new ArrayList<AlignmentOrder>();
        SequenceI[][] results = new SequenceI[jobs.size()][];
        AlignmentOrder[] orders = new AlignmentOrder[jobs.size()];
        for (int i = 0; i < jobs.size(); ++i) {
            AlignmentJob job = jobs.get(i);
            if (!job.hasResult()) continue;
            AlignmentI alignment = job.getAlignmentResult();
            int alnSize = alignment.getSequences().size();
            char gapChar = alnSize > 0 ? (char)alignment.getGapCharacter() : (char)'-';
            List<SequenceI> emptySeqs = job.getEmptySequences();
            ArrayList<Sequence> alnSeqs = new ArrayList<Sequence>(alnSize);
            for (SequenceI sequenceI : alignment.getSequences()) {
                alnSeqs.add(new Sequence(sequenceI));
            }
            for (SequenceI sequenceI : emptySeqs) {
                alnSeqs.add(new Sequence(sequenceI));
            }
            int width = 0;
            for (SequenceI seq3 : alnSeqs) {
                width = Integer.max(width, seq3.getLength());
            }
            Object gaps = new char[width];
            Arrays.fill((char[])gaps, gapChar);
            String string = new String((char[])gaps);
            gaps = alnSeqs.iterator();
            while (gaps.hasNext()) {
                SequenceI seq4 = (SequenceI)gaps.next();
                if (seq4.getLength() >= width) continue;
                seq4.setSequence(seq4.getSequenceAsString() + string.substring(seq4.getLength()));
            }
            SequenceI[] result = alnSeqs.toArray(new SequenceI[0]);
            AlignmentOrder msaOrder = new AlignmentOrder(result);
            AlignmentSorter.recoverOrder(result);
            HashMap<String, SeqsetUtils.SequenceInfo> names = new HashMap<String, SeqsetUtils.SequenceInfo>(job.getNames());
            SeqsetUtils.deuniquify(names, result);
            alorders.add(msaOrder);
            results[i] = result;
            orders[i] = msaOrder;
        }
        Object[] newView = this.msa.getUpdatedView(results, orders, this.gapChar);
        for (int i = 0; i < jobs.size(); ++i) {
            results[i] = null;
            orders[i] = null;
        }
        SequenceI[] alignment = (SequenceI[])newView[0];
        HiddenColumns hidden = (HiddenColumns)newView[1];
        Alignment aln = new Alignment(alignment);
        aln.setProperty("Alignment Program", this.action.getName());
        if (this.dataset != null) {
            aln.setDataset(this.dataset);
        }
        this.propagateDatasetMappings(aln);
        return new AlignmentResult(aln, alorders, hidden);
    }

    private void propagateDatasetMappings(AlignmentI aln) {
        if (this.codonFrame != null) {
            SequenceI[] alignment;
            block0: for (SequenceI seq : alignment = aln.getSequencesArray()) {
                for (AlignedCodonFrame acf : this.codonFrame) {
                    if (acf == null || !acf.involvesSequence(seq)) continue;
                    aln.addCodonFrame(acf);
                    continue block0;
                }
            }
        }
    }
}

