/*
 * Decompiled with CFR 0.152.
 */
package jalview.util.matcher;

import jalview.util.matcher.Condition;
import jalview.util.matcher.MatcherI;
import java.util.Locale;
import java.util.Objects;

public class Matcher
implements MatcherI {
    private final Condition condition;
    private String pattern;
    private final String uppercasePattern;
    private float floatValue = 0.0f;
    private long longValue = 0L;
    private PatternType patternType;

    public Matcher(Condition cond, String compareTo) {
        Objects.requireNonNull(cond);
        this.condition = cond;
        if (cond.isNumeric()) {
            try {
                this.longValue = Long.valueOf(compareTo);
                this.pattern = String.valueOf(this.longValue);
                this.patternType = PatternType.Integer;
            }
            catch (NumberFormatException e) {
                this.floatValue = Float.valueOf(compareTo).floatValue();
                this.pattern = String.valueOf(this.floatValue);
                this.patternType = PatternType.Float;
            }
        } else {
            this.pattern = compareTo;
            this.patternType = PatternType.String;
        }
        this.uppercasePattern = this.pattern == null ? null : this.pattern.toUpperCase(Locale.ROOT);
    }

    public Matcher(Condition cond, float compareTo) {
        this(cond, String.valueOf(compareTo));
    }

    public Matcher(Condition cond, long compareTo) {
        this(cond, String.valueOf(compareTo));
    }

    @Override
    public boolean matches(String compareTo) {
        if (compareTo == null) {
            return this.matchesNull();
        }
        boolean matched = false;
        switch (this.patternType) {
            case Float: {
                matched = this.matchesFloat(compareTo, this.floatValue);
                break;
            }
            case Integer: {
                matched = this.matchesLong(compareTo);
                break;
            }
            default: {
                matched = this.matchesString(compareTo);
            }
        }
        return matched;
    }

    boolean matchesString(String compareTo) {
        boolean matched = false;
        String upper = compareTo.toUpperCase(Locale.ROOT).trim();
        switch (this.condition) {
            case Matches: {
                matched = upper.equals(this.uppercasePattern);
                break;
            }
            case NotMatches: {
                matched = !upper.equals(this.uppercasePattern);
                break;
            }
            case Contains: {
                matched = upper.indexOf(this.uppercasePattern) > -1;
                break;
            }
            case NotContains: {
                matched = upper.indexOf(this.uppercasePattern) == -1;
                break;
            }
            case Present: {
                matched = true;
                break;
            }
        }
        return matched;
    }

    boolean matchesFloat(String testee, float compareTo) {
        if (!this.condition.isNumeric()) {
            return this.matches(testee);
        }
        float f = 0.0f;
        try {
            f = Float.valueOf(testee).floatValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
        boolean matched = false;
        switch (this.condition) {
            case LT: {
                matched = f < compareTo;
                break;
            }
            case LE: {
                matched = f <= compareTo;
                break;
            }
            case EQ: {
                matched = f == compareTo;
                break;
            }
            case NE: {
                matched = f != compareTo;
                break;
            }
            case GT: {
                matched = f > compareTo;
                break;
            }
            case GE: {
                matched = f >= compareTo;
                break;
            }
        }
        return matched;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.condition.hashCode() + (int)this.floatValue;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Matcher)) {
            return false;
        }
        Matcher m = (Matcher)obj;
        if (this.condition != m.condition || this.floatValue != m.floatValue || this.longValue != m.longValue) {
            return false;
        }
        if (this.pattern == null) {
            return m.pattern == null;
        }
        return this.uppercasePattern.equals(m.uppercasePattern);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition.toString()).append(" ");
        if (this.condition.isNumeric()) {
            sb.append(this.pattern);
        } else {
            sb.append("'").append(this.pattern).append("'");
        }
        return sb.toString();
    }

    boolean matchesLong(String compareTo) {
        if (!this.condition.isNumeric()) {
            return this.matches(String.valueOf(compareTo));
        }
        long val = 0L;
        try {
            val = Long.valueOf(compareTo);
        }
        catch (NumberFormatException e) {
            return this.matchesFloat(compareTo, this.longValue);
        }
        boolean matched = false;
        switch (this.condition) {
            case LT: {
                matched = val < this.longValue;
                break;
            }
            case LE: {
                matched = val <= this.longValue;
                break;
            }
            case EQ: {
                matched = val == this.longValue;
                break;
            }
            case NE: {
                matched = val != this.longValue;
                break;
            }
            case GT: {
                matched = val > this.longValue;
                break;
            }
            case GE: {
                matched = val >= this.longValue;
                break;
            }
        }
        return matched;
    }

    boolean matchesNull() {
        if (this.condition.isNumeric()) {
            return false;
        }
        return this.condition == Condition.NotContains || this.condition == Condition.NotMatches || this.condition == Condition.NotPresent;
    }

    public static enum PatternType {
        String,
        Integer,
        Float;

    }
}

