/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;

public class NewickFile
extends FileParse {
    BinaryNode root;
    private boolean HasBootstrap = false;
    private boolean HasDistances = false;
    private boolean RootHasDistance = false;
    private boolean ReplaceUnderscores = false;
    private boolean printRootInfo = true;
    private static final int REGEX_PERL_NODE_REQUIRE_QUOTE = 0;
    private static final int REGEX_PERL_NODE_ESCAPE_QUOTE = 1;
    private static final int REGEX_PERL_NODE_UNQUOTED_WHITESPACE = 2;
    private static final int REGEX_MAJOR_SYMS = 3;
    private static final int REGEX_QNODE_NAME = 4;
    private static final int REGEX_COMMENT = 5;
    private static final int REGEX_UQNODE_NAME = 6;
    private static final int REGEX_NBOOTSTRAP = 7;
    private static final int REGEX_NDIST = 8;
    private static final int REGEX_NO_LINES = 9;
    private static final int REGEX_PERL_EXPAND_QUOTES = 10;
    private static final int REGEX_MAX = 11;
    private static final Regex[] REGEX = new Regex[11];
    private char quoteChar = (char)39;

    private static Regex getRegex(int id) {
        if (REGEX[id] == null) {
            String code = null;
            String code2 = null;
            String codePerl = null;
            switch (id) {
                case 0: {
                    codePerl = "m/[\\[,:'()]/";
                    break;
                }
                case 1: {
                    codePerl = "s/'/''/";
                    break;
                }
                case 2: {
                    codePerl = "s/\\/w/_/";
                    break;
                }
                case 10: {
                    codePerl = "s/''/'/";
                    break;
                }
                case 3: {
                    code = "[(\\['),;]";
                    break;
                }
                case 4: {
                    code = "'([^']|'')+'";
                    break;
                }
                case 5: {
                    code = "]";
                    break;
                }
                case 6: {
                    code = "\\b([^' :;\\](),]+)";
                    break;
                }
                case 7: {
                    code = "\\s*([0-9+]+)\\s*:";
                    break;
                }
                case 8: {
                    code = ":([-0-9Ee.+]+)";
                    break;
                }
                case 9: {
                    code = "\n+";
                    code2 = "";
                    break;
                }
                default: {
                    return null;
                }
            }
            return codePerl == null ? Platform.newRegex(code, code2) : Platform.newRegexPerl(codePerl);
        }
        return REGEX[id];
    }

    public NewickFile(String inStr) throws IOException {
        super(inStr, DataSourceType.PASTE);
    }

    public NewickFile(String inFile, DataSourceType protocol) throws IOException {
        super(inFile, protocol);
    }

    public NewickFile(FileParse source) throws IOException {
        super(source);
    }

    public NewickFile(BinaryNode newtree) {
        this.root = newtree;
    }

    public NewickFile(SequenceNode newtree, boolean bootstrap) {
        this.HasBootstrap = bootstrap;
        this.root = newtree;
    }

    public NewickFile(BinaryNode newtree, boolean bootstrap, boolean distances) {
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
    }

    public NewickFile(BinaryNode newtree, boolean bootstrap, boolean distances, boolean rootdistance) {
        this.root = newtree;
        this.HasBootstrap = bootstrap;
        this.HasDistances = distances;
        this.RootHasDistance = rootdistance;
    }

    private String ErrorStringrange(String Error2, String Er, int r, int p, String s) {
        return (Error2 == null ? "" : Error2) + Er + " at position " + p + " ( " + s.substring(p - r < 0 ? 0 : p - r, p + r > s.length() ? s.length() : p + r) + " )\n";
    }

    public boolean HasBootstrap() {
        return this.HasBootstrap;
    }

    public boolean HasDistances() {
        return this.HasDistances;
    }

    public boolean HasRootDistance() {
        return this.RootHasDistance;
    }

    public void parse() throws IOException {
        String nf;
        Platform.ensureRegex();
        StringBuffer file = new StringBuffer();
        while ((nf = this.nextLine()) != null) {
            file.append(nf);
        }
        nf = file.toString();
        this.root = new SequenceNode();
        BinaryNode<SequenceI> realroot = null;
        BinaryNode<SequenceI> c = this.root;
        int d = -1;
        int cp = 0;
        String Error2 = null;
        String nodename = null;
        String commentString2 = null;
        double DefDistance = 0.001f;
        int DefBootstrap = -1;
        double distance = DefDistance;
        int bootstrap = DefBootstrap;
        boolean ascending = false;
        Regex majorsyms = NewickFile.getRegex(3);
        int nextcp = 0;
        int ncp = cp;
        boolean parsednodename = false;
        block9: while (majorsyms.searchFrom(nf, cp) && Error2 == null) {
            int fcp = majorsyms.matchedFrom();
            char schar = nf.charAt(fcp);
            switch (schar) {
                case '(': {
                    if (ascending) {
                        Error2 = this.ErrorStringrange(Error2, "Unexpected '('", 7, fcp, nf);
                        continue block9;
                    }
                    ++d;
                    if (c.right() == null) {
                        c.setRight(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = c.right();
                    } else {
                        if (c.left() != null) {
                            SequenceNode tmpn = new SequenceNode(null, c, null, 0.0, 0, true);
                            tmpn.SetChildren(c.left(), c.right());
                            c.setRight(tmpn);
                        }
                        c.setLeft(new SequenceNode(null, c, null, DefDistance, DefBootstrap, false));
                        c = c.left();
                    }
                    if (realroot == null) {
                        realroot = c;
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                    cp = fcp + 1;
                    break;
                }
                case '\'': {
                    Regex qnodename = NewickFile.getRegex(4);
                    if (qnodename.searchFrom(nf, fcp)) {
                        String widernodename;
                        int nl = qnodename.stringMatched().length();
                        nodename = new String(qnodename.stringMatched().substring(1, nl - 1));
                        Regex xpandquotes = NewickFile.getRegex(10);
                        nodename = widernodename = xpandquotes.replaceAll(nodename);
                        nextcp = fcp + nl + 1;
                        parsednodename = true;
                        break;
                    }
                    Error2 = this.ErrorStringrange(Error2, "Unterminated quotes for nodename", 7, fcp, nf);
                    break;
                }
                default: {
                    if (schar == ';' && d != -1) {
                        Error2 = this.ErrorStringrange(Error2, "Wayward semicolon (depth=" + d + ")", 7, fcp, nf);
                    }
                    if (schar == '[') {
                        Regex comment = NewickFile.getRegex(5);
                        if (comment.searchFrom(nf, fcp)) {
                            nextcp = comment.matchedFrom() + 1;
                            this.warningMessage = "Tree file contained comments which may confuse input algorithm.";
                            break;
                        }
                        Error2 = this.ErrorStringrange(Error2, "Unterminated comment", 3, fcp, nf);
                    }
                    Object fstring = nf.substring(ncp, fcp);
                    while (((String)fstring).indexOf(93) > -1) {
                        int cstart = ((String)fstring).indexOf(91);
                        int cend = ((String)fstring).indexOf(93);
                        commentString2 = ((String)fstring).substring(cstart + 1, cend);
                        fstring = ((String)fstring).substring(0, cstart) + ((String)fstring).substring(cend + 1);
                    }
                    Regex uqnodename = NewickFile.getRegex(6);
                    Regex nbootstrap = NewickFile.getRegex(7);
                    Regex ndist = NewickFile.getRegex(8);
                    if (!parsednodename && uqnodename.search((String)fstring) && (uqnodename.matchedFrom(1) == 0 || ((String)fstring).charAt(uqnodename.matchedFrom(1) - 1) != ':')) {
                        if (nodename == null) {
                            nodename = this.ReplaceUnderscores ? uqnodename.stringMatched(1).replace('_', ' ') : uqnodename.stringMatched(1);
                        } else {
                            Error2 = this.ErrorStringrange(Error2, "File has broken algorithm - overwritten nodename", 10, fcp, nf);
                        }
                    }
                    if (nbootstrap.search((String)fstring)) {
                        if (nbootstrap.stringMatched(1).equals(uqnodename.stringMatched(1))) {
                            nodename = null;
                        }
                        if (nodename == null || nodename.length() == 0 || nbootstrap.matchedFrom(1) > uqnodename.matchedFrom(1) + uqnodename.stringMatched().length()) {
                            try {
                                bootstrap = Integer.valueOf(nbootstrap.stringMatched(1));
                                this.HasBootstrap = true;
                            }
                            catch (Exception e) {
                                Error2 = this.ErrorStringrange(Error2, "Can't parse bootstrap value", 4, ncp + nbootstrap.matchedFrom(), nf);
                            }
                        }
                    }
                    boolean nodehasdistance = false;
                    if (ndist.search((String)fstring)) {
                        try {
                            distance = Double.valueOf(ndist.stringMatched(1)).floatValue();
                            this.HasDistances = true;
                            nodehasdistance = true;
                        }
                        catch (Exception e) {
                            Error2 = this.ErrorStringrange(Error2, "Can't parse node distance value", 7, ncp + ndist.matchedFrom(), nf);
                        }
                    }
                    if (ascending) {
                        c.setName(nodename);
                        c.dist = this.HasDistances ? distance : DefDistance;
                        c.setBootstrap(this.HasBootstrap ? bootstrap : DefBootstrap);
                        if (c == realroot) {
                            this.RootHasDistance = nodehasdistance;
                        }
                        this.parseNHXNodeProps(c, commentString2);
                        commentString2 = null;
                    } else {
                        SequenceNode newnode = new SequenceNode(null, c, nodename, this.HasDistances ? distance : DefDistance, this.HasBootstrap ? bootstrap : DefBootstrap, false);
                        this.parseNHXNodeProps(c, commentString2);
                        commentString2 = null;
                        if (c.right() == null) {
                            c.setRight(newnode);
                        } else if (c.left() == null) {
                            c.setLeft(newnode);
                        } else {
                            SequenceNode newdummy = new SequenceNode(null, c, null, this.HasDistances ? 0.0 : DefDistance, 0, true);
                            newdummy.SetChildren(c.left(), newnode);
                            c.setLeft(newdummy);
                        }
                    }
                    if (ascending) {
                        c = c.AscendTree();
                        if (d > -1 && c == null) {
                            Error2 = this.ErrorStringrange(Error2, "File broke algorithm: Lost place in tree (is there an extra ')' ?)", 7, fcp, nf);
                        }
                    }
                    if (nf.charAt(fcp) == ')') {
                        --d;
                        ascending = true;
                    } else if (nf.charAt(fcp) == ',') {
                        if (ascending) {
                            ascending = false;
                        } else if (c.left() != null && !c.left().isLeaf()) {
                            c = c.left();
                        }
                    }
                    nodename = null;
                    distance = DefDistance;
                    bootstrap = DefBootstrap;
                    commentString2 = null;
                    parsednodename = false;
                }
            }
            if (nextcp == 0) {
                ncp = cp = fcp + 1;
                continue;
            }
            cp = nextcp;
            nextcp = 0;
        }
        if (Error2 != null) {
            throw new IOException(MessageManager.formatMessage("exception.newfile", new String[]{Error2.toString()}));
        }
        if (this.root == null) {
            throw new IOException(MessageManager.formatMessage("exception.newfile", new String[]{MessageManager.getString("label.no_tree_read_in")}));
        }
        this.root = this.root.right().detach();
        if (!this.RootHasDistance) {
            this.root.dist = this.HasDistances ? 0.0 : DefDistance;
        }
    }

    private void parseNHXNodeProps(BinaryNode c, String commentString) {
        if (commentString != null && commentString.startsWith("&&NHX")) {
            StringTokenizer st = new StringTokenizer(commentString.substring(5), ":");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int colpos = tok.indexOf("=");
                if (colpos <= -1) continue;
                String code = tok.substring(0, colpos);
                String value = tok.substring(colpos + 1);
                try {
                    if (!code.toLowerCase(Locale.ROOT).equals("b")) continue;
                    int v = -1;
                    Float iv = Float.valueOf(value);
                    v = iv.intValue();
                    c.setBootstrap(v);
                    this.HasBootstrap = true;
                }
                catch (Exception e) {
                    Console.errPrintln("Couldn't parse code '" + code + "' = '" + value + "'");
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public BinaryNode getTree() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print() {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            StringBuffer tf = new StringBuffer();
            this.print(tf, this.root);
            return tf.append(";").toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean boots = this.HasBootstrap;
            this.HasBootstrap = withbootstraps;
            String rv = this.print();
            this.HasBootstrap = boots;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean dists = this.HasDistances;
            this.HasDistances = withdists;
            String rv = this.print(withbootstraps);
            this.HasDistances = dists;
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String print(boolean withbootstraps, boolean withdists, boolean printRootInfo) {
        NewickFile newickFile = this;
        synchronized (newickFile) {
            boolean rootinfo = printRootInfo;
            this.printRootInfo = printRootInfo;
            String rv = this.print(withbootstraps, withdists);
            this.printRootInfo = rootinfo;
            return rv;
        }
    }

    char getQuoteChar() {
        return this.quoteChar;
    }

    char setQuoteChar(char c) {
        char old = this.quoteChar;
        this.quoteChar = c;
        return old;
    }

    private String nodeName(String name) {
        if (NewickFile.getRegex(0).search(name)) {
            return this.quoteChar + NewickFile.getRegex(1).replaceAll(name) + this.quoteChar;
        }
        return NewickFile.getRegex(2).replaceAll(name);
    }

    public String getNodenameFor(BinaryNode c) {
        if (c == null) {
            return null;
        }
        return c.getName();
    }

    private String printNodeField(BinaryNode c) {
        return (this.getNodenameFor(c) == null ? "" : this.nodeName(this.getNodenameFor(c))) + (String)(this.HasBootstrap ? (c.getBootstrap() > -1 ? (this.getNodenameFor(c) != null ? " " : "") + c.getBootstrap() : "") : "") + (String)(this.HasDistances ? ":" + c.dist : "");
    }

    private String printRootField(BinaryNode root) {
        return this.printRootInfo ? (this.getNodenameFor(root) == null ? "" : this.nodeName(this.getNodenameFor(root))) + (String)(this.HasBootstrap ? (root.getBootstrap() > -1 ? (this.getNodenameFor(root) != null ? " " : "") + root.getBootstrap() : "") : "") + (String)(this.RootHasDistance ? ":" + root.dist : "") : "";
    }

    public void print(StringBuffer tf, BinaryNode root) {
        if (root != null) {
            if (root.isLeaf() && this.printRootInfo) {
                tf.append(this.printRootField(root));
            } else if (root.isDummy()) {
                this._print(tf, root.right());
                this._print(tf, root.left());
            } else {
                tf.append("(");
                this._print(tf, root.right());
                if (root.left() != null) {
                    tf.append(",");
                }
                this._print(tf, root.left());
                tf.append(")" + this.printRootField(root));
            }
        }
    }

    public void _print(StringBuffer tf, BinaryNode c) {
        if (c != null) {
            if (c.isLeaf()) {
                tf.append(this.printNodeField(c));
            } else if (c.isDummy()) {
                this._print(tf, c.left());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, c.right());
            } else {
                tf.append("(");
                this._print(tf, c.right());
                if (c.left() != null) {
                    tf.append(",");
                }
                this._print(tf, c.left());
                tf.append(")" + this.printNodeField(c));
            }
        }
    }

    public static void main(String[] args) {
        try {
            String l;
            if (args == null || args.length != 1) {
                Jalview.exit("Takes one argument - file name of a newick tree file.", Jalview.ExitCode.INVALID_ARGUMENT);
            }
            File fn = new File(args[0]);
            StringBuffer newickfile = new StringBuffer();
            BufferedReader treefile = new BufferedReader(new FileReader(fn));
            while ((l = treefile.readLine()) != null) {
                newickfile.append(l);
            }
            treefile.close();
            Console.outPrintln("Read file :\n");
            NewickFile trf = new NewickFile(args[0], DataSourceType.FILE);
            trf.parse();
            Console.outPrintln("Original file :\n");
            Regex nonl = NewickFile.getRegex(9);
            Console.outPrintln(nonl.replaceAll(newickfile.toString()) + "\n");
            Console.outPrintln("Parsed file.\n");
            Console.outPrintln("Default output type for original input.\n");
            Console.outPrintln(trf.print());
            Console.outPrintln("Without bootstraps.\n");
            Console.outPrintln(trf.print(false));
            Console.outPrintln("Without distances.\n");
            Console.outPrintln(trf.print(true, false));
            Console.outPrintln("Without bootstraps but with distanecs.\n");
            Console.outPrintln(trf.print(false, true));
            Console.outPrintln("Without bootstraps or distanecs.\n");
            Console.outPrintln(trf.print(false, false));
            Console.outPrintln("With bootstraps and with distances.\n");
            Console.outPrintln(trf.print(true, true));
        }
        catch (IOException e) {
            Console.errPrintln("Exception\n" + e);
            e.printStackTrace();
        }
    }
}

