/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.JvOptionPane;
import jalview.gui.ProgressBar;
import jalview.jbgui.GWebserviceInfo;
import jalview.util.ChannelProperties;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.WSClientI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class WebserviceInfo
extends GWebserviceInfo
implements HyperlinkListener,
IProgressIndicator {
    public static final int STATE_QUEUING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_STOPPED_OK = 2;
    public static final int STATE_CANCELLED_OK = 3;
    public static final int STATE_STOPPED_ERROR = 4;
    public static final int STATE_STOPPED_SERVERERROR = 5;
    int currentStatus = 0;
    Image image;
    float angle = 0.0f;
    String title = "";
    WSClientI thisService;
    boolean serviceIsCancellable;
    JInternalFrame frame;
    private IProgressIndicator progressBar;
    JTabbedPane subjobs = null;
    Vector jobPanes = null;
    private boolean serviceCanMergeResults = false;
    private boolean viewResultsImmediatly = true;
    boolean renderAsHtml = false;

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.frame.setVisible(aFlag);
    }

    public boolean isViewResultsImmediatly() {
        return this.viewResultsImmediatly;
    }

    public void setViewResultsImmediatly(boolean viewResultsImmediatly) {
        this.viewResultsImmediatly = viewResultsImmediatly;
    }

    private StyleSheet getStyleSheet(HTMLEditorKit editorKit) {
        StyleSheet myStyleSheet = new StyleSheet();
        myStyleSheet.addStyleSheet(editorKit.getStyleSheet());
        editorKit.setStyleSheet(myStyleSheet);
        return myStyleSheet;
    }

    public synchronized int addJobPane() {
        JTextComponent _progressText;
        JTextComponent progressText;
        JScrollPane jobpane = new JScrollPane();
        if (this.renderAsHtml) {
            progressText = new JEditorPane("text/html", "");
            ((JEditorPane)progressText).addHyperlinkListener(this);
            _progressText = progressText;
            progressText.setEditable(false);
            ((JEditorPane)progressText).setText("<html><h1>WS Job</h1></html>");
        } else {
            progressText = new JTextArea();
            _progressText = progressText;
            ((JTextArea)progressText).setFont(new Font("Verdana", 0, 10));
            progressText.setBorder(null);
            progressText.setEditable(false);
            progressText.setText("WS Job");
            ((JTextArea)progressText).setLineWrap(true);
            ((JTextArea)progressText).setWrapStyleWord(true);
        }
        jobpane.setName("JobPane");
        jobpane.getViewport().add((Component)_progressText, null);
        jobpane.setBorder(null);
        if (this.jobPanes == null) {
            this.jobPanes = new Vector();
        }
        int newpane = this.jobPanes.size();
        this.jobPanes.add(jobpane);
        if (newpane == 0) {
            this.add((Component)jobpane, "Center");
        } else {
            if (newpane == 1) {
                JScrollPane firstpane = (JScrollPane)this.jobPanes.get(0);
                this.remove(firstpane);
                this.subjobs = new JTabbedPane();
                this.add((Component)this.subjobs, "Center");
                this.subjobs.add(firstpane);
                this.subjobs.setTitleAt(0, firstpane.getName());
            }
            this.subjobs.add(jobpane);
        }
        return newpane;
    }

    public WebserviceInfo(String title, String info, boolean makeVisible) {
        this.init(title, info, 520, 500, makeVisible);
    }

    public WebserviceInfo(String title, String info, int width, int height, boolean makeVisible) {
        this.init(title, info, width, height, makeVisible);
    }

    public WSClientI getthisService() {
        return this.thisService;
    }

    public void setthisService(WSClientI newservice) {
        this.thisService = newservice;
        this.serviceIsCancellable = newservice.isCancellable();
        this.frame.setClosable(!this.serviceIsCancellable);
        this.serviceCanMergeResults = newservice.canMergeResults();
        this.rebuildButtonPanel();
    }

    private void rebuildButtonPanel() {
        if (this.buttonPanel != null) {
            this.buttonPanel.removeAll();
            if (this.serviceIsCancellable) {
                this.buttonPanel.add(this.cancel);
                this.frame.setClosable(false);
            } else {
                this.frame.setClosable(true);
            }
        }
    }

    void init(String title, String info, int width, int height, boolean makeVisible) {
        this.frame = new JInternalFrame();
        this.frame.setFrameIcon(null);
        this.frame.setContentPane(this);
        Desktop.addInternalFrame(this.frame, title, makeVisible, width, height, true, false);
        this.frame.setClosable(false);
        this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        this.title = title;
        this.setInfoText(info);
        this.image = ChannelProperties.getImage("rotatable_logo.48");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.image, 0);
        try {
            mt.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        AnimatedPanel ap = new AnimatedPanel();
        ap.setPreferredSize(new Dimension(60, 60));
        this.titlePanel.add((Component)ap, "West");
        this.titlePanel.add((Component)this.titleText, "Center");
        this.setStatus(this.currentStatus);
        if (!Platform.isJS()) {
            Thread thread = new Thread(ap);
            thread.start();
        }
        final WebserviceInfo thisinfo = this;
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                WSClientI service = thisinfo.getthisService();
                if (service != null && service.isCancellable()) {
                    service.cancelJob();
                }
            }
        });
        this.frame.validate();
    }

    public void setStatus(int status) {
        this.currentStatus = status;
        String message = null;
        switch (this.currentStatus) {
            case 0: {
                message = MessageManager.getString("label.state_queueing");
                break;
            }
            case 1: {
                message = MessageManager.getString("label.state_running");
                break;
            }
            case 2: {
                message = MessageManager.getString("label.state_completed");
                break;
            }
            case 3: {
                message = MessageManager.getString("label.state_job_cancelled");
                break;
            }
            case 4: {
                message = MessageManager.getString("label.state_job_error");
                break;
            }
            case 5: {
                message = MessageManager.getString("label.server_error_try_later");
            }
        }
        this.titleText.setText(this.title + (String)(message == null ? "" : " - " + message));
        this.titleText.repaint();
    }

    public void setStatus(int jobpane, int status) {
        if (jobpane < 0 || jobpane >= this.jobPanes.size()) {
            throw new Error(MessageManager.formatMessage("error.setstatus_called_non_existent_job_pane", new String[]{Integer.valueOf(jobpane).toString()}));
        }
        switch (status) {
            case 0: {
                this.setProgressName(jobpane + " - QUEUED", jobpane);
                break;
            }
            case 1: {
                this.setProgressName(jobpane + " - RUNNING", jobpane);
                break;
            }
            case 2: {
                this.setProgressName(jobpane + " - FINISHED", jobpane);
                break;
            }
            case 3: {
                this.setProgressName(jobpane + " - CANCELLED", jobpane);
                break;
            }
            case 4: {
                this.setProgressName(jobpane + " - BROKEN", jobpane);
                break;
            }
            case 5: {
                this.setProgressName(jobpane + " - ALERT", jobpane);
                break;
            }
            default: {
                this.setProgressName(jobpane + " - UNKNOWN STATE", jobpane);
            }
        }
    }

    public String getInfoText() {
        return this.infoText.getText();
    }

    public void setInfoText(String text) {
        this.infoText.setText(text);
    }

    public void appendInfoText(String text) {
        this.infoText.append(text);
    }

    public String getProgressText(int which) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        if (this.renderAsHtml) {
            return ((JEditorPane)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).getText();
        }
        return ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).getText();
    }

    public void setProgressText(int which, String text) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        if (this.renderAsHtml) {
            ((JEditorPane)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).setText(this.ensureHtmlTagged(text));
        } else {
            ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).setText(text);
        }
    }

    private String getHtmlFragment(String text, boolean leaveFirst, boolean leaveLast) {
        if (text == null) {
            return null;
        }
        String lowertxt = text.toLowerCase(Locale.ROOT);
        int htmlpos = leaveFirst ? -1 : lowertxt.indexOf("<body");
        int htmlend = leaveLast ? -1 : lowertxt.indexOf("</body");
        int htmlpose = lowertxt.indexOf(">", htmlpos);
        int htmlende = lowertxt.indexOf(">", htmlend);
        if (htmlend == -1 && htmlpos == -1) {
            return text;
        }
        if (htmlend > -1) {
            return text.substring(htmlpos == -1 ? 0 : htmlpose + 1, htmlend);
        }
        return text.substring(htmlpos == -1 ? 0 : htmlpose + 1);
    }

    private String ensureHtmlTagged(String text) {
        if (text == null) {
            return "";
        }
        String lowertxt = ((String)text).toLowerCase(Locale.ROOT);
        int htmlpos = lowertxt.indexOf("<body");
        int htmlend = lowertxt.indexOf("</body");
        int doctype = lowertxt.indexOf("<!doctype");
        int xmltype = lowertxt.indexOf("<?xml");
        if (htmlend == -1) {
            text = (String)text + "</body></html>";
        }
        if (htmlpos > -1) {
            if (doctype > -1 && htmlpos > doctype || xmltype > -1 && htmlpos > xmltype) {
                text = "<html><head></head><body>\n" + ((String)text).substring(htmlpos - 1);
            }
        } else {
            text = "<html><head></head><body>\n" + (String)text;
        }
        if (((String)text).indexOf("<meta") > -1) {
            System.err.println("HTML COntent: \n" + (String)text + "<< END HTML CONTENT\n");
        }
        return text;
    }

    public void appendProgressText(int which, String text) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        if (this.renderAsHtml) {
            String txt = this.getHtmlFragment(((JEditorPane)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).getText(), true, false);
            ((JEditorPane)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).setText(this.ensureHtmlTagged(txt + this.getHtmlFragment(text, false, true)));
        } else {
            ((JTextArea)((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0)).append(text);
        }
    }

    public void setProgressText(String text) {
        this.setProgressText(0, text);
    }

    public void appendProgressText(String text) {
        this.appendProgressText(0, text);
    }

    public String getProgressText() {
        return this.getProgressText(0);
    }

    public String getProgressName(int which) {
        if (this.jobPanes == null) {
            this.addJobPane();
        }
        if (this.subjobs != null) {
            return this.subjobs.getTitleAt(which);
        }
        return ((JScrollPane)this.jobPanes.get(which)).getViewport().getComponent(0).getName();
    }

    public void setProgressName(String name, int which) {
        if (this.subjobs != null) {
            this.subjobs.setTitleAt(which, name);
            this.subjobs.revalidate();
            this.subjobs.repaint();
        }
        JScrollPane c = (JScrollPane)this.jobPanes.get(which);
        c.getViewport().getComponent(0).setName(name);
        c.repaint();
    }

    @Override
    protected void cancel_actionPerformed(ActionEvent e) {
        if (!this.serviceIsCancellable) {
            this.warnUser(MessageManager.getString("warn.job_cannot_be_cancelled_close_window"), MessageManager.getString("action.cancel_job"));
        } else {
            this.thisService.cancelJob();
        }
        this.frame.setClosable(true);
    }

    public void warnUser(final String message, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JvOptionPane.showInternalMessageDialog((Component)Desktop.getDesktopPane(), message, title, 2);
            }
        });
    }

    public void setResultsReady() {
        this.frame.setClosable(true);
        this.buttonPanel.remove(this.cancel);
        this.buttonPanel.add(this.showResultsNewFrame);
        if (this.serviceCanMergeResults) {
            this.buttonPanel.add(this.mergeResults);
            this.buttonPanel.setLayout(new GridLayout(2, 1, 5, 5));
        }
        this.buttonPanel.validate();
        this.validate();
        if (this.viewResultsImmediatly) {
            this.showResultsNewFrame.doClick();
        }
    }

    public void setFinishedNoResults() {
        this.frame.setClosable(true);
        this.buttonPanel.remove(this.cancel);
        this.buttonPanel.validate();
        this.validate();
    }

    public void setRenderAsHtml(boolean b) {
        this.renderAsHtml = b;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Desktop.hyperlinkUpdate(e);
    }

    @Override
    public void setProgressBar(String message, long id) {
        this.progressBar.setProgressBar(message, id);
    }

    @Override
    public void addProgressBar(long id, String message) {
        this.progressBar.addProgressBar(id, message);
    }

    @Override
    public void removeProgressBar(long id) {
        this.progressBar.removeProgressBar(id);
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        this.progressBar.registerHandler(id, handler);
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar.operationInProgress();
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        return this.progressBar.getProgressBar(id);
    }

    @Override
    public String getMessage(long id) {
        return this.progressBar.getMessage(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        this.progressBar.setProgressBarMessage(id, message);
    }

    class AnimatedPanel
    extends JPanel
    implements Runnable {
        long startTime = 0L;
        BufferedImage offscreen;

        AnimatedPanel() {
        }

        @Override
        public void run() {
            this.startTime = System.currentTimeMillis();
            float invSpeed = 15.0f;
            float factor = 1.0f;
            while (WebserviceInfo.this.currentStatus < 2) {
                if (WebserviceInfo.this.currentStatus == 0) {
                    invSpeed = 25.0f;
                    factor = 1.0f;
                } else if (WebserviceInfo.this.currentStatus == 1) {
                    invSpeed = 10.0f;
                    factor = (float)(0.5 + 1.5 * (0.5 - 0.5 * Math.sin(0.017453277777777776 * (double)(WebserviceInfo.this.angle + 45.0f))));
                }
                try {
                    Thread.sleep(50L);
                    float delta = (float)(System.currentTimeMillis() - this.startTime) / invSpeed;
                    WebserviceInfo.this.angle += delta * factor;
                    WebserviceInfo.this.angle %= 360.0f;
                    this.startTime = System.currentTimeMillis();
                    if (WebserviceInfo.this.currentStatus >= 2) {
                        this.park();
                        WebserviceInfo.this.angle = 0.0f;
                    }
                    this.repaint();
                }
                catch (Exception exception) {}
            }
            WebserviceInfo.this.cancel.setEnabled(false);
        }

        public void park() {
            this.startTime = System.currentTimeMillis();
            while (WebserviceInfo.this.angle < 360.0f) {
                float invSpeed = 5.0f;
                float factor = 1.0f;
                try {
                    Thread.sleep(25L);
                    float delta = (float)(System.currentTimeMillis() - this.startTime) / invSpeed;
                    WebserviceInfo.this.angle += delta * factor;
                    this.startTime = System.currentTimeMillis();
                    if (WebserviceInfo.this.angle >= 360.0f) {
                        WebserviceInfo.this.angle = 360.0f;
                    }
                    this.repaint();
                }
                catch (Exception exception) {}
            }
        }

        void drawPanel() {
            if (this.offscreen == null || this.offscreen.getWidth(this) != this.getWidth() || this.offscreen.getHeight(this) != this.getHeight()) {
                this.offscreen = new BufferedImage(this.getWidth(), this.getHeight(), 1);
            }
            Graphics2D g = (Graphics2D)this.offscreen.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (WebserviceInfo.this.image != null) {
                int x = WebserviceInfo.this.image.getWidth(this) / 2;
                int y = WebserviceInfo.this.image.getHeight(this) / 2;
                g.rotate(0.017453277777777776 * (double)WebserviceInfo.this.angle, x, y);
                g.drawImage(WebserviceInfo.this.image, 0, 0, this);
                g.rotate(-0.017453277777777776 * (double)WebserviceInfo.this.angle, x, y);
            }
        }

        @Override
        public void paintComponent(Graphics g1) {
            this.drawPanel();
            g1.drawImage(this.offscreen, 0, 0, this);
        }
    }
}

