/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureColourI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.FeatureSettings;
import jalview.gui.FeatureTypeSettings;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.io.FeaturesFile;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FeatureEditor {
    static String lastFeatureAdded = "feature_1";
    static String lastFeatureGroupAdded = "Jalview";
    final List<SequenceI> sequences;
    final List<SequenceFeature> features;
    final boolean forCreate;
    int featureIndex;
    FeatureColourI oldColour;
    FeatureColourI featureColour;
    FeatureRenderer fr;
    AlignmentPanel ap;
    JTextField name;
    JTextField group;
    JTextArea description;
    JSpinner start;
    JSpinner end;
    JPanel mainPanel;

    public FeatureEditor(AlignmentPanel alignPanel, List<SequenceI> seqs, List<SequenceFeature> feats, boolean create) {
        this.ap = alignPanel;
        this.fr = alignPanel.getSeqPanel().seqCanvas.fr;
        this.sequences = seqs;
        this.features = feats;
        this.forCreate = create;
        this.init();
    }

    protected void init() {
        this.featureIndex = 0;
        this.mainPanel = new JPanel(new BorderLayout());
        this.name = new JTextField(25);
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfTypeHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.name.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfTypeHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.name.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfTypeHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.name.getText());
            }
        });
        this.group = new JTextField(25);
        this.group.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfGroupHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.group.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfGroupHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.group.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FeatureEditor.this.warnIfGroupHidden(FeatureEditor.this.mainPanel, FeatureEditor.this.group.getText());
            }
        });
        this.description = new JTextArea(3, 25);
        this.start = new JSpinner();
        this.end = new JSpinner();
        this.start.setPreferredSize(new Dimension(80, 20));
        this.end.setPreferredSize(new Dimension(80, 20));
        this.start.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer startVal = (Integer)FeatureEditor.this.start.getValue();
                ((SpinnerNumberModel)FeatureEditor.this.end.getModel()).setMinimum(startVal);
            }
        });
        this.end.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer endVal = (Integer)FeatureEditor.this.end.getValue();
                ((SpinnerNumberModel)FeatureEditor.this.start.getModel()).setMaximum(endVal);
            }
        });
        final JLabel colour = new JLabel();
        colour.setOpaque(true);
        colour.setMaximumSize(new Dimension(30, 16));
        colour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (FeatureEditor.this.featureColour.isSimpleColour()) {
                    String title = MessageManager.getString("label.select_feature_colour");
                    JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

                        @Override
                        public void colourSelected(Color c) {
                            FeatureEditor.this.featureColour = new FeatureColour(c);
                            FeatureEditor.this.updateColourButton(FeatureEditor.this.mainPanel, colour, FeatureEditor.this.featureColour);
                        }
                    };
                    JalviewColourChooser.showColourChooser(Desktop.getDesktopPane(), title, FeatureEditor.this.featureColour.getColour(), listener);
                } else {
                    final String ft = FeatureEditor.this.features.get(FeatureEditor.this.featureIndex).getType();
                    final String type = ft == null ? lastFeatureAdded : ft;
                    FeatureTypeSettings fcc = new FeatureTypeSettings(FeatureEditor.this.fr, type, true);
                    fcc.setRequestFocusEnabled(true);
                    fcc.requestFocus();
                    fcc.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            FeatureEditor.this.featureColour = FeatureEditor.this.fr.getFeatureStyle(ft);
                            FeatureEditor.this.fr.setColour(type, FeatureEditor.this.featureColour);
                            FeatureEditor.this.updateColourButton(FeatureEditor.this.mainPanel, colour, FeatureEditor.this.featureColour);
                        }
                    });
                }
            }
        });
        JPanel gridPanel = new JPanel(new GridLayout(3, 1));
        if (!this.forCreate && this.features.size() > 1) {
            gridPanel = new JPanel(new GridLayout(4, 1));
            JPanel choosePanel = new JPanel();
            choosePanel.add(new JLabel(MessageManager.getString("label.select_feature") + ":"));
            final JComboBox<String> overlaps = new JComboBox<String>();
            ArrayList<Object> added = new ArrayList<Object>();
            for (SequenceFeature sf : this.features) {
                Object text = String.format("%s/%d-%d (%s)", sf.getType(), sf.getBegin(), sf.getEnd(), sf.getFeatureGroup());
                while (added.contains(text)) {
                    text = (String)text + " ";
                }
                overlaps.addItem((String)text);
                added.add(text);
            }
            choosePanel.add(overlaps);
            overlaps.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FeatureColourI col;
                    int index = overlaps.getSelectedIndex();
                    if (index != -1) {
                        FeatureEditor.this.featureIndex = index;
                        SequenceFeature sf = FeatureEditor.this.features.get(index);
                        FeatureEditor.this.name.setText(sf.getType());
                        FeatureEditor.this.description.setText(sf.getDescription());
                        FeatureEditor.this.group.setText(sf.getFeatureGroup());
                        FeatureEditor.this.start.setValue(sf.getBegin());
                        FeatureEditor.this.end.setValue(sf.getEnd());
                        ((SpinnerNumberModel)FeatureEditor.this.start.getModel()).setMaximum(Integer.valueOf(sf.getEnd()));
                        ((SpinnerNumberModel)FeatureEditor.this.end.getModel()).setMinimum(Integer.valueOf(sf.getBegin()));
                        SearchResults highlight = new SearchResults();
                        highlight.addResult(FeatureEditor.this.sequences.get(0), sf.getBegin(), sf.getEnd());
                        FeatureEditor.this.ap.getSeqPanel().seqCanvas.highlightSearchResults(highlight);
                    }
                    if ((col = FeatureEditor.this.fr.getFeatureStyle(FeatureEditor.this.name.getText())) == null) {
                        col = new FeatureColour(ColorUtils.createColourFromName(FeatureEditor.this.name.getText()));
                    }
                    FeatureEditor.this.oldColour = FeatureEditor.this.featureColour = col;
                    FeatureEditor.this.updateColourButton(FeatureEditor.this.mainPanel, colour, col);
                }
            });
            gridPanel.add(choosePanel);
        }
        JPanel namePanel = new JPanel();
        gridPanel.add(namePanel);
        namePanel.add(new JLabel(MessageManager.getString("label.name:"), 4));
        namePanel.add(this.name);
        JPanel groupPanel = new JPanel();
        gridPanel.add(groupPanel);
        groupPanel.add(new JLabel(MessageManager.getString("label.group:"), 4));
        groupPanel.add(this.group);
        JPanel colourPanel = new JPanel();
        gridPanel.add(colourPanel);
        colourPanel.add(new JLabel(MessageManager.getString("label.colour"), 4));
        colourPanel.add(colour);
        colour.setPreferredSize(new Dimension(150, 15));
        colour.setFont(new Font("Verdana", 0, 9));
        colour.setForeground(Color.black);
        colour.setHorizontalAlignment(0);
        colour.setVerticalAlignment(0);
        colour.setHorizontalTextPosition(0);
        colour.setVerticalTextPosition(0);
        this.mainPanel.add((Component)gridPanel, "North");
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.add(new JLabel(MessageManager.getString("label.description:"), 4));
        this.description.setFont(JvSwingUtils.getTextAreaFont());
        this.description.setLineWrap(true);
        descriptionPanel.add(new JScrollPane(this.description));
        if (!this.forCreate) {
            this.mainPanel.add((Component)descriptionPanel, "South");
            JPanel startEndPanel = new JPanel();
            startEndPanel.add(new JLabel(MessageManager.getString("label.start"), 4));
            startEndPanel.add(this.start);
            startEndPanel.add(new JLabel(MessageManager.getString("label.end"), 4));
            startEndPanel.add(this.end);
            this.mainPanel.add((Component)startEndPanel, "Center");
        } else {
            this.mainPanel.add((Component)descriptionPanel, "Center");
        }
        SequenceFeature firstFeature = this.features.get(0);
        boolean useLastDefaults = firstFeature.getType() == null;
        String featureType = useLastDefaults ? lastFeatureAdded : firstFeature.getType();
        String featureGroup = useLastDefaults ? lastFeatureGroupAdded : firstFeature.getFeatureGroup();
        this.name.setText(featureType);
        this.group.setText(featureGroup);
        this.start.setValue(firstFeature.getBegin());
        this.end.setValue(firstFeature.getEnd());
        ((SpinnerNumberModel)this.start.getModel()).setMaximum(Integer.valueOf(firstFeature.getEnd()));
        ((SpinnerNumberModel)this.end.getModel()).setMinimum(Integer.valueOf(firstFeature.getBegin()));
        this.description.setText(firstFeature.getDescription());
        this.oldColour = this.featureColour = this.fr.getFeatureStyle(featureType);
        this.updateColourButton(this.mainPanel, colour, this.oldColour);
    }

    public void showDialog() {
        Runnable okAction = this.forCreate ? this.getCreateAction() : this.getAmendAction();
        Runnable cancelAction = this.getCancelAction();
        JvOptionPane dialog = JvOptionPane.newOptionDialog(this.ap.alignFrame).setResponseHandler(0, okAction).setResponseHandler(2, cancelAction);
        if (!this.forCreate) {
            dialog.setResponseHandler(1, this.getDeleteAction());
        }
        String title = null;
        Object[] options = null;
        if (this.forCreate) {
            title = MessageManager.getString("label.create_new_sequence_features");
            options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        } else {
            title = MessageManager.formatMessage("label.amend_delete_features", new String[]{this.sequences.get(0).getName()});
            options = new Object[]{MessageManager.getString("label.amend"), MessageManager.getString("action.delete"), MessageManager.getString("action.cancel")};
        }
        dialog.showInternalDialog(this.mainPanel, title, 1, -1, null, options, MessageManager.getString("action.ok"));
    }

    protected Runnable getCancelAction() {
        Runnable okAction = () -> {
            this.ap.highlightSearchResults(null);
            this.ap.paintAlignment(false, false);
        };
        return okAction;
    }

    protected Runnable getCreateAction() {
        Runnable okAction = new Runnable(){
            boolean useLastDefaults;
            {
                this.useLastDefaults = FeatureEditor.this.features.get(0).getType() == null;
            }

            @Override
            public void run() {
                String enteredType = FeatureEditor.this.name.getText().trim();
                String enteredGroup = FeatureEditor.this.group.getText().trim();
                String enteredDescription = FeatureEditor.this.description.getText().replaceAll("\n", " ");
                if (enteredType.length() > 0 && this.useLastDefaults) {
                    lastFeatureAdded = enteredType;
                    lastFeatureGroupAdded = enteredGroup;
                    if (lastFeatureGroupAdded.length() < 1) {
                        lastFeatureGroupAdded = null;
                    }
                }
                if (enteredType.length() > 0) {
                    for (int i = 0; i < FeatureEditor.this.sequences.size(); ++i) {
                        SequenceFeature sf = FeatureEditor.this.features.get(i);
                        SequenceFeature sf2 = new SequenceFeature(enteredType, enteredDescription, sf.getBegin(), sf.getEnd(), enteredGroup);
                        new FeaturesFile().parseDescriptionHTML(sf2, false);
                        FeatureEditor.this.sequences.get(i).addSequenceFeature(sf2);
                    }
                    FeatureEditor.this.fr.setColour(enteredType, FeatureEditor.this.featureColour);
                    FeatureEditor.this.fr.featuresAdded();
                    FeatureEditor.this.repaintPanel();
                }
            }
        };
        return okAction;
    }

    protected Runnable getDeleteAction() {
        Runnable deleteAction = () -> {
            SequenceFeature sf = this.features.get(this.featureIndex);
            this.sequences.get(0).getDatasetSequence().deleteFeature(sf);
            this.fr.featuresAdded();
            this.ap.getSeqPanel().seqCanvas.highlightSearchResults(null);
            this.ap.paintAlignment(true, true);
        };
        return deleteAction;
    }

    protected void updateColourButton(JPanel bigPanel, JLabel colour, FeatureColourI col) {
        colour.removeAll();
        colour.setIcon(null);
        colour.setText("");
        if (col.isSimpleColour()) {
            colour.setToolTipText(null);
            colour.setBackground(col.getColour());
        } else {
            colour.setBackground(bigPanel.getBackground());
            colour.setForeground(Color.black);
            colour.setToolTipText(FeatureSettings.getColorTooltip(col, false));
            FeatureSettings.renderGraduatedColor(colour, col);
        }
    }

    protected void warnIfGroupHidden(JPanel panel, String group) {
        if (!this.fr.isGroupVisible(group)) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.group"), group);
            JvOptionPane.showMessageDialog((Component)panel, msg, "", 0);
        }
    }

    protected void warnIfTypeHidden(JPanel panel, String type) {
        if (this.fr.getRenderOrder().contains(type) && !this.fr.showFeatureOfType(type)) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.feature_type"), type);
            JvOptionPane.showMessageDialog((Component)panel, msg, "", 0);
        }
    }

    protected void repaintPanel() {
        this.ap.alignFrame.showSeqFeatures.setSelected(true);
        this.ap.av.setShowSequenceFeatures(true);
        this.ap.av.setSearchResults(null);
        this.ap.paintAlignment(true, true);
    }

    protected Runnable getAmendAction() {
        Runnable okAction = new Runnable(){
            boolean useLastDefaults;
            String featureType;
            String featureGroup;
            {
                this.useLastDefaults = FeatureEditor.this.features.get(0).getType() == null;
                this.featureType = FeatureEditor.this.name.getText();
                this.featureGroup = FeatureEditor.this.group.getText();
            }

            @Override
            public void run() {
                String enteredType = FeatureEditor.this.name.getText().trim();
                String enteredGroup = FeatureEditor.this.group.getText().trim();
                String enteredDescription = FeatureEditor.this.description.getText().replaceAll("\n", " ");
                if (enteredType.length() > 0 && this.useLastDefaults) {
                    lastFeatureAdded = enteredType;
                    lastFeatureGroupAdded = enteredGroup;
                    if (lastFeatureGroupAdded.length() < 1) {
                        lastFeatureGroupAdded = null;
                    }
                }
                SequenceFeature sf = FeatureEditor.this.features.get(FeatureEditor.this.featureIndex);
                boolean refreshSettings = !this.featureType.equals(enteredType) || !this.featureGroup.equals(enteredGroup);
                refreshSettings |= FeatureEditor.this.featureColour != FeatureEditor.this.oldColour;
                FeatureEditor.this.fr.setColour(enteredType, FeatureEditor.this.featureColour);
                int newBegin = sf.begin;
                int newEnd = sf.end;
                try {
                    newBegin = (Integer)FeatureEditor.this.start.getValue();
                    newEnd = (Integer)FeatureEditor.this.end.getValue();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                FeatureEditor.this.sequences.get(0).deleteFeature(sf);
                SequenceFeature newSf = new SequenceFeature(sf, enteredType, newBegin, newEnd, enteredGroup, sf.getScore());
                newSf.setDescription(enteredDescription);
                new FeaturesFile().parseDescriptionHTML(newSf, false);
                FeatureEditor.this.sequences.get(0).addSequenceFeature(newSf);
                if (refreshSettings) {
                    FeatureEditor.this.fr.featuresAdded();
                }
                FeatureEditor.this.repaintPanel();
            }
        };
        return okAction;
    }
}

