/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringLike;
import com.stevesoft.pat.TransPat;
import com.stevesoft.pat.TransRepRule;
import com.stevesoft.pat.wrap.StringWrap;
import jalview.util.MessageManager;

public class Transformer {
    TransPat tp;
    Regex rp = new Regex();
    boolean auto_optimize;
    Replacer repr = new Replacer();

    public Replacer getReplacer() {
        return this.rp.getReplacer();
    }

    public Transformer(boolean auto) {
        this.auto_optimize = auto;
        this.tp = new TransPat();
        this.rp.setReplaceRule(new TransRepRule(this));
        this.rp.thePattern = this.tp;
    }

    public void add(Regex r) {
        if (this.auto_optimize) {
            r.optimize();
        }
        this.tp.ra[this.tp.ra_len++] = r;
        if (this.tp.ra.length == this.tp.ra_len) {
            Regex[] ra2 = new Regex[this.tp.ra_len + 10];
            for (int i = 0; i < this.tp.ra_len; ++i) {
                ra2[i] = this.tp.ra[i];
            }
            this.tp.ra = ra2;
        }
        this.rp.numSubs_ = r.numSubs_ > this.rp.numSubs_ ? r.numSubs_ : this.rp.numSubs_;
    }

    public int patterns() {
        return this.tp.ra_len;
    }

    public Regex getRegexAt(int i) {
        if (i >= this.tp.ra_len) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + ">=" + this.patterns());
        }
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + "< 0");
        }
        return this.tp.ra[i];
    }

    public void setRegexAt(Regex rx, int i) {
        if (i >= this.tp.ra_len) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + ">=" + this.patterns());
        }
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException("i=" + i + "< 0");
        }
        this.tp.ra[i] = rx;
    }

    public void add(String rs) {
        Regex r = Regex.perlCode(rs);
        if (r == null) {
            throw new NullPointerException(MessageManager.formatMessage("exception.bad_pattern_to_regex_perl_code", new String[]{rs}));
        }
        this.add(r);
    }

    public void add(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.add(array[i]);
        }
    }

    public String replaceAll(String s) {
        return this.dorep(s, 0, s.length());
    }

    public StringLike replaceAll(StringLike s) {
        return this.dorep(s, 0, s.length());
    }

    public String replaceAllFrom(String s, int start) {
        return this.dorep(s, start, s.length());
    }

    public String replaceAllRegion(String s, int start, int end) {
        return this.dorep(s, start, end);
    }

    final StringLike dorep(StringLike s, int start, int end) {
        StringLike tfmd = this.repr.replaceAllRegion(s, this.rp, start, end);
        this.tp.lastMatchedTo = this.repr.lastMatchedTo;
        return tfmd;
    }

    final String dorep(String s, int start, int end) {
        return this.dorep(new StringWrap(s), start, end).toString();
    }

    public String replaceFirst(String s) {
        return this.dorep(s, 0, s.length());
    }

    public String replaceFirstFrom(String s, int start) {
        return this.dorep(s, start, s.length());
    }

    public String replaceFirstRegion(String s, int start, int end) {
        return this.dorep(s, start, end);
    }
}

