/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.api.AlignmentColsCollectionI;
import jalview.api.AlignmentRowsCollectionI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.VisibleColsCollection;
import jalview.datamodel.VisibleRowsCollection;
import jalview.viewmodel.OverviewDimensions;
import jalview.viewmodel.ViewportRanges;

public class OverviewDimensionsHideHidden
extends OverviewDimensions {
    private ViewportRanges ranges;
    private int xdiff;
    private int ydiff;

    public OverviewDimensionsHideHidden(ViewportRanges vpranges, boolean showAnnotationPanel) {
        super(vpranges, showAnnotationPanel);
        this.ranges = vpranges;
        this.resetAlignmentDims();
    }

    @Override
    public void updateViewportFromMouse(int mousex, int mousey, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int xAsRes = this.getLeftXFromCentreX(mousex, hiddenCols);
        int yAsSeq = this.getTopYFromCentreY(mousey, hiddenSeqs);
        this.updateViewportFromTopLeft(xAsRes, yAsSeq, hiddenSeqs, hiddenCols);
    }

    @Override
    public void adjustViewportFromMouse(int mousex, int mousey, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int vpx = Math.round((float)mousex * this.widthRatio);
        int vpy = Math.round((float)mousey * this.heightRatio);
        this.updateViewportFromTopLeft(vpx + this.xdiff, vpy + this.ydiff, hiddenSeqs, hiddenCols);
    }

    @Override
    protected void updateViewportFromTopLeft(int leftx, int topy, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        int vpheight;
        int vpwidth;
        int xAsRes = leftx;
        int yAsSeq = topy;
        if (xAsRes < 0) {
            xAsRes = 0;
        }
        if (yAsSeq < 0) {
            yAsSeq = 0;
        }
        if (this.ranges.isWrappedMode()) {
            yAsSeq = 0;
        }
        if (xAsRes + (vpwidth = this.ranges.getViewportWidth()) > this.alwidth) {
            xAsRes = this.ranges.getStartRes() < this.alwidth ? this.alwidth - vpwidth : this.ranges.getStartRes();
        }
        if (yAsSeq + (vpheight = this.ranges.getViewportHeight()) > this.alheight) {
            yAsSeq = this.ranges.getEndSeq() < this.alheight ? this.alheight - vpheight : this.ranges.getStartSeq();
        }
        this.ranges.setStartResAndSeq(xAsRes, yAsSeq);
    }

    @Override
    public void setBoxPosition(HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.setBoxPosition(this.ranges.getStartRes(), this.ranges.getStartSeq(), this.ranges.getViewportWidth(), this.ranges.getViewportHeight());
    }

    @Override
    public AlignmentColsCollectionI getColumns(AlignmentI al) {
        return new VisibleColsCollection(0, this.ranges.getAbsoluteAlignmentWidth() - 1, al.getHiddenColumns());
    }

    @Override
    public AlignmentRowsCollectionI getRows(AlignmentI al) {
        return new VisibleRowsCollection(0, this.ranges.getAbsoluteAlignmentHeight() - 1, al);
    }

    @Override
    protected void resetAlignmentDims() {
        this.alwidth = this.ranges.getVisibleAlignmentWidth();
        this.alheight = this.ranges.getVisibleAlignmentHeight();
        this.widthRatio = (float)this.alwidth / (float)this.width;
        this.heightRatio = (float)this.alheight / (float)this.sequencesHeight;
    }

    @Override
    protected int getLeftXFromCentreX(int mousex, HiddenColumns hidden) {
        int vpx = Math.round((float)mousex * this.widthRatio);
        return vpx - this.ranges.getViewportWidth() / 2;
    }

    @Override
    protected int getTopYFromCentreY(int mousey, HiddenSequences hidden) {
        int vpy = Math.round((float)mousey * this.heightRatio);
        return vpy - this.ranges.getViewportHeight() / 2;
    }

    @Override
    public void setDragPoint(int x, int y, HiddenSequences hiddenSeqs, HiddenColumns hiddenCols) {
        this.resetAlignmentDims();
        int vpx = Math.round((float)x * this.widthRatio);
        int vpy = Math.round((float)y * this.heightRatio);
        this.xdiff = this.ranges.getStartRes() - vpx;
        this.ydiff = this.ranges.getStartSeq() - vpy;
    }
}

