/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.api.DBRefEntryI;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import java.util.List;
import java.util.Locale;

public class DBRefEntry
implements DBRefEntryI {
    String source = "";
    private String version = "";
    private String ucversion;
    private String accessionId = "";
    int sourceKey = Integer.MIN_VALUE;
    String canonicalSourceName;
    boolean isCanonicalAccession = false;
    Mapping map = null;

    public DBRefEntry() {
    }

    public DBRefEntry(String source, String version, String accessionId) {
        this(source, version, accessionId, null, false);
    }

    public DBRefEntry(String source, String version, String accessionId, Mapping map) {
        this(source, version, accessionId, map, false);
    }

    public DBRefEntry(String source, String version, String accessionId, Mapping map, boolean isCanonical) {
        this.source = source.toUpperCase(Locale.ROOT);
        this.setVersion(version);
        this.accessionId = accessionId;
        this.map = map;
        this.isCanonicalAccession = isCanonical;
    }

    public DBRefEntry(DBRefEntryI entry) {
        this(entry.getSource() == null ? "" : new String(entry.getSource()), entry.getVersion() == null ? "" : new String(entry.getVersion()), entry.getAccessionId() == null ? "" : new String(entry.getAccessionId()), entry.getMap() == null ? null : new Mapping(entry.getMap()), entry.isCanonical());
    }

    public boolean equals(Object o) {
        Mapping em;
        return o != null && o instanceof DBRefEntry && (o == this || this.equalRef((DBRefEntry)o) && this.map == null == ((em = ((DBRefEntry)o).map) == null) && (this.map == null || this.map.equals(em)));
    }

    @Override
    public boolean updateFrom(DBRefEntryI other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        boolean improved = false;
        String otherSource = other.getSource();
        if (this.source == null && otherSource != null || this.source != null && otherSource == null || this.source != null && !this.source.equalsIgnoreCase(otherSource)) {
            return false;
        }
        String otherAccession = other.getAccessionId();
        if (this.accessionId == null && otherAccession != null || this.accessionId != null && otherAccession == null || this.accessionId != null && !this.accessionId.equalsIgnoreCase(otherAccession)) {
            return false;
        }
        if (!this.isCanonicalAccession && other.isCanonical()) {
            this.isCanonicalAccession = true;
            improved = true;
        } else if (this.isCanonicalAccession && !other.isCanonical()) {
            return false;
        }
        String otherVersion = other.getVersion();
        if ((this.version == null || this.version.equals("0") || this.version.endsWith(":0")) && otherVersion != null) {
            this.setVersion(otherVersion);
        } else if (!(this.version == null || otherVersion != null && this.version.equalsIgnoreCase(otherVersion))) {
            return improved;
        }
        if (this.map == null) {
            this.setMap(other.getMap());
        }
        return true;
    }

    @Override
    public boolean equalRef(DBRefEntryI entry) {
        if (entry == null) {
            return false;
        }
        if (entry == this) {
            return true;
        }
        return entry != null && this.source != null && entry.getSource() != null && this.source.equalsIgnoreCase(entry.getSource()) && this.accessionId != null && entry.getAccessionId() != null && this.accessionId.equalsIgnoreCase(entry.getAccessionId()) && this.version != null && entry.getVersion() != null && this.version.equalsIgnoreCase(entry.getVersion());
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public int getSourceKey() {
        return this.sourceKey == Integer.MIN_VALUE ? (this.sourceKey = DBRefSource.getSourceKey(this.getCanonicalSourceName())) : this.sourceKey;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAccessionId() {
        return this.accessionId;
    }

    @Override
    public void setAccessionId(String accessionId) {
        this.accessionId = accessionId;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
        this.ucversion = version == null ? null : version.toUpperCase(Locale.ROOT);
    }

    @Override
    public Mapping getMap() {
        return this.map;
    }

    public void setMap(Mapping map) {
        this.map = map;
    }

    public boolean hasMap() {
        return this.map != null;
    }

    public String getSrcAccString() {
        return (this.source != null ? this.source : "") + ":" + (this.accessionId != null ? this.accessionId : "");
    }

    public String toString() {
        return this.getSrcAccString();
    }

    @Override
    public boolean isPrimaryCandidate() {
        if (this.map != null) {
            List<int[]> toRanges;
            SequenceI mto = this.map.getTo();
            if (mto != null) {
                return false;
            }
            MapList ml = this.map.getMap();
            if (ml.getFromRatio() != ml.getToRatio() || ml.getFromRatio() != 1) {
                return false;
            }
            List<int[]> fromRanges = ml.getFromRanges();
            if (fromRanges.size() != 1 || (toRanges = ml.getToRanges()).size() != 1) {
                return false;
            }
            if (fromRanges.get(0)[0] != toRanges.get(0)[0] || fromRanges.get(0)[1] != toRanges.get(0)[1]) {
                return false;
            }
        }
        if (this.version == null) {
            return false;
        }
        return DBRefSource.isPrimaryCandidate(this.ucversion);
    }

    public String getCanonicalSourceName() {
        return this.canonicalSourceName == null ? (this.canonicalSourceName = DBRefUtils.getCanonicalName(this.source)) : this.canonicalSourceName;
    }

    public void setCanonical(boolean canonical) {
        this.isCanonicalAccession = canonical;
    }

    @Override
    public boolean isCanonical() {
        return this.isCanonicalAccession;
    }
}

