/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.UserDefinedColours;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.renderer.AnnotationRenderer;
import jalview.renderer.AwtRenderPanelI;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.ViewportListenerI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;

public class AnnotationPanel
extends Panel
implements AwtRenderPanelI,
AdjustmentListener,
ActionListener,
MouseListener,
MouseMotionListener,
ViewportListenerI {
    AlignViewport av;
    AlignmentPanel ap;
    int activeRow = -1;
    final String HELIX = "Helix";
    final String SHEET = "Sheet";
    final String STEM = "RNA Helix";
    final String LABEL = "Label";
    final String REMOVE = "Remove Annotation";
    final String COLOUR = "Colour";
    final Color HELIX_COLOUR = Color.red.darker();
    final Color SHEET_COLOUR = Color.green.darker().darker();
    Image image;
    Graphics gg;
    FontMetrics fm;
    int imgWidth = 0;
    boolean fastPaint = false;
    int graphStretch = -1;
    int graphStretchY = -1;
    boolean mouseDragging = false;
    public static int GRAPH_HEIGHT = 40;
    public final AnnotationRenderer renderer;
    boolean needValidating = false;
    int scrollOffset = 0;
    private int[] bounds = new int[2];

    public AnnotationPanel(AlignmentPanel ap) {
        new Platform();
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        int height = this.adjustPanelHeight();
        ap.apvscroll.setValues(0, this.getSize().height, 0, height);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.renderer = new AnnotationRenderer();
        this.av.getRanges().addPropertyChangeListener(this);
    }

    public AnnotationPanel(AlignViewport av) {
        this.av = av;
        this.renderer = new AnnotationRenderer();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        Annotation[] anot = aa[this.activeRow].annotations;
        if (anot.length < this.av.getColumnSelection().getMax()) {
            Annotation[] temp = new Annotation[this.av.getColumnSelection().getMax() + 2];
            System.arraycopy(anot, 0, temp, 0, anot.length);
            aa[this.activeRow].annotations = anot = temp;
        }
        String label = "";
        if (this.av.getColumnSelection() != null && !this.av.getColumnSelection().isEmpty() && anot[this.av.getColumnSelection().getMin()] != null) {
            label = anot[this.av.getColumnSelection().getMin()].displayCharacter;
        }
        if (evt.getActionCommand().equals("Remove Annotation")) {
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                anot[index] = null;
            }
        } else if (evt.getActionCommand().equals("Label")) {
            if ((label = this.enterLabel(label, "Enter Label")) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", ' ', 0.0f);
                }
                anot[index].displayCharacter = label;
            }
        } else if (evt.getActionCommand().equals("Colour")) {
            UserDefinedColours udc = new UserDefinedColours(this, Color.black, this.ap.alignFrame);
            Color col = udc.getColor();
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation("", "", ' ', 0.0f);
                }
                anot[index].colour = col;
            }
        } else {
            int type = 0;
            String symbol = "\u03b1";
            if (evt.getActionCommand().equals("Helix")) {
                type = 72;
            } else if (evt.getActionCommand().equals("Sheet")) {
                type = 69;
                symbol = "\u03b2";
            } else if (evt.getActionCommand().equals("RNA Helix")) {
                type = 83;
                int column = this.av.getColumnSelection().getSelectedRanges().get(0)[0];
                symbol = aa[this.activeRow].getDefaultRnaHelixSymbol(column);
            }
            if (!aa[this.activeRow].hasIcons) {
                aa[this.activeRow].hasIcons = true;
            }
            if ((label = this.enterLabel(symbol, "Enter Label")) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
                if (evt.getActionCommand().equals("RNA Helix")) {
                    aa[this.activeRow].showAllColLabels = true;
                }
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", (char)type, 0.0f);
                }
                anot[index].secondaryStructure = type != 83 ? type : (label.length() == 0 ? 32 : (int)label.charAt(0));
                anot[index].displayCharacter = label;
            }
        }
        this.av.getAlignment().validateAnnotation(aa[this.activeRow]);
        this.ap.alignmentChanged();
        this.adjustPanelHeight();
        this.repaint();
    }

    String enterLabel(String text, String label) {
        EditNameDialog dialog = new EditNameDialog(text, null, label, null, this.ap.alignFrame, "Enter Label", 400, 200, true);
        if (dialog.accept) {
            return dialog.getName();
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        int height = -this.scrollOffset;
        this.activeRow = -1;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            if (aa[i].editable) {
                this.activeRow = i;
                break;
            }
            if (aa[i].graph == 0) break;
            this.graphStretch = i;
            this.graphStretchY = evt.getY();
            break;
        }
        if ((evt.getModifiersEx() & 0x1000) == 4096 && this.activeRow != -1) {
            MenuItem item;
            if (this.av.getColumnSelection() == null || this.av.getColumnSelection().isEmpty()) {
                return;
            }
            PopupMenu pop = new PopupMenu(MessageManager.getString("label.structure_type"));
            if (this.av.getAlignment().isNucleotide()) {
                item = new MenuItem("RNA Helix");
                item.addActionListener(this);
                pop.add(item);
            } else {
                item = new MenuItem("Helix");
                item.addActionListener(this);
                pop.add(item);
                item = new MenuItem("Sheet");
                item.addActionListener(this);
                pop.add(item);
            }
            item = new MenuItem("Label");
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem("Colour");
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem("Remove Annotation");
            item.addActionListener(this);
            pop.add(item);
            this.ap.alignFrame.add(pop);
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        this.ap.scalePanel.mousePressed(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.graphStretch = -1;
        this.graphStretchY = -1;
        this.mouseDragging = false;
        if (this.needValidating) {
            this.ap.validate();
            this.needValidating = false;
        }
        this.ap.scalePanel.mouseReleased(evt);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.graphStretch > -1) {
            this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch].graphHeight += this.graphStretchY - evt.getY();
            if (this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch].graphHeight < 0) {
                this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch].graphHeight = 0;
            }
            this.graphStretchY = evt.getY();
            this.av.calcPanelHeight();
            this.needValidating = true;
            this.ap.paintAlignment(true, false);
        } else {
            this.ap.scalePanel.mouseDragged(evt);
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        int row = -1;
        int height = -this.scrollOffset;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            row = i;
            break;
        }
        int column = evt.getX() / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        if (this.av.hasHiddenColumns()) {
            column = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(column);
        }
        if (row > -1 && column < aa[row].annotations.length && aa[row].annotations[column] != null) {
            int seqIndex;
            SequenceI seqref;
            StringBuilder text = new StringBuilder();
            text.append(MessageManager.getString("label.column")).append(" ").append(column + 1);
            String description = aa[row].annotations[column].description;
            if (description != null && description.length() > 0) {
                text.append("  ").append(description);
            }
            if ((seqref = aa[row].sequenceRef) != null && (seqIndex = this.av.getAlignment().findIndex(seqref)) != -1) {
                text.append(", ").append(MessageManager.getString("label.sequence")).append(" ").append(seqIndex + 1);
                char residue = seqref.getCharAt(column);
                if (!Comparison.isGap(residue)) {
                    text.append(" ");
                    if (this.av.getAlignment().isNucleotide()) {
                        String name = ResidueProperties.nucleotideName.get(String.valueOf(residue));
                        text.append(" Nucleotide: ").append(name != null ? name : Character.valueOf(residue));
                    } else {
                        String name = 'X' == residue ? "X" : ('*' == residue ? "STOP" : ResidueProperties.aa2Triplet.get(String.valueOf(residue)));
                        text.append(" Residue: ").append(name != null ? name : Character.valueOf(residue));
                    }
                    int residuePos = seqref.findPosition(column);
                    text.append(" (").append(residuePos).append(")");
                }
            }
            this.ap.alignFrame.statusBar.setText(text.toString());
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.ap.scalePanel.mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.ap.scalePanel.mouseExited(evt);
    }

    public int adjustPanelHeight() {
        return this.adjustPanelHeight(true);
    }

    public int adjustPanelHeight(boolean repaint) {
        int height = this.av.calcPanelHeight();
        this.setSize(new Dimension(this.getSize().width, height));
        if (repaint) {
            this.repaint();
        }
        return height;
    }

    public void addEditableColumn(int i) {
        if (this.activeRow == -1) {
            AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
            if (aa == null) {
                return;
            }
            for (int j = 0; j < aa.length; ++j) {
                if (!aa[j].editable) continue;
                this.activeRow = j;
                break;
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        this.imgWidth = d.width;
        if (this.imgWidth < 1 || d.height < 1) {
            return;
        }
        if (this.image == null || this.imgWidth != this.image.getWidth(this) || d.height != this.image.getHeight(this)) {
            this.image = this.createImage(this.imgWidth, d.height);
            this.gg = this.image.getGraphics();
            this.gg.setFont(this.av.getFont());
            this.fm = this.gg.getFontMetrics();
            this.fastPaint = false;
        }
        if (this.fastPaint) {
            g.drawImage(this.image, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.drawComponent(this.gg, this.av.getRanges().getStartRes(), this.av.getRanges().getEndRes() + 1);
        g.drawImage(this.image, 0, 0, this);
    }

    public void fastPaint(int horizontal) {
        if (horizontal == 0 || this.gg == null || this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1) {
            this.repaint();
            return;
        }
        this.gg.copyArea(0, 0, this.imgWidth, this.getSize().height, -horizontal * this.av.getCharWidth(), 0);
        int sr = this.av.getRanges().getStartRes();
        int er = this.av.getRanges().getEndRes() + 1;
        int transX = 0;
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.av.getCharWidth();
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        }
        this.gg.translate(transX, 0);
        this.drawComponent(this.gg, sr, er);
        this.gg.translate(-transX, 0);
        this.fastPaint = true;
        this.repaint();
    }

    public void drawComponent(Graphics g, int startRes, int endRes) {
        Font ofont = this.av.getFont();
        g.setFont(ofont);
        g.setColor(Color.white);
        g.fillRect(0, 0, (endRes - startRes) * this.av.getCharWidth(), this.getSize().height);
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.black);
            if (this.av.validCharWidth) {
                g.drawString(MessageManager.getString("label.alignment_has_no_annotations"), 20, 15);
            }
            return;
        }
        g.translate(0, -this.scrollOffset);
        this.renderer.drawComponent(this, this.av, g, this.activeRow, startRes, endRes);
        g.translate(0, this.scrollOffset);
    }

    public void setScrollOffset(int value, boolean repaint) {
        this.scrollOffset = value;
        if (repaint) {
            this.repaint();
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public Image getFadedImage() {
        return this.image;
    }

    @Override
    public int getFadedImageWidth() {
        return this.imgWidth;
    }

    @Override
    public int[] getVisibleVRange() {
        if (this.ap != null && this.ap.alabels != null) {
            int sOffset = -this.ap.alabels.scrollOffset;
            int visHeight = sOffset + this.ap.annotationPanelHolder.getHeight();
            this.bounds[0] = sOffset;
            this.bounds[1] = visHeight;
            return this.bounds;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("startres")) {
            this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (evt.getPropertyName().equals("startresandseq")) {
            this.fastPaint(((int[])evt.getNewValue())[0] - ((int[])evt.getOldValue())[0]);
        } else if (evt.getPropertyName().equals("move_viewport")) {
            this.repaint();
        }
    }
}

