/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

public class ConnectivityException
extends RuntimeException {
    private String sequence;
    private int connection;
    private byte dim;

    public ConnectivityException(String sequence, int connection, byte dim) {
        this("Insufficient number of connections", sequence, connection, dim);
    }

    public ConnectivityException(String message, String sequence, int connection, byte dim) {
        super(String.format("%s for %s (%d, should be %d or more)", message, sequence, connection, dim));
        this.sequence = sequence;
        this.connection = connection;
        this.dim = dim;
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getConnection() {
        return this.connection;
    }

    public byte getDim() {
        return this.dim;
    }
}

