/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.treealign;

import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.Tree;
import fr.orsay.lri.varna.models.treealign.TreeAlignException;
import fr.orsay.lri.varna.models.treealign.TreeAlignLabelDistanceAsymmetric;
import fr.orsay.lri.varna.models.treealign.TreeAlignResult;
import java.util.ArrayList;
import java.util.List;

public class TreeAlign<ValueType1, ValueType2> {
    private TreeAlignLabelDistanceAsymmetric<ValueType1, ValueType2> labelDist;

    public TreeAlign(TreeAlignLabelDistanceAsymmetric<ValueType1, ValueType2> treeAlignLabelDistanceAsymmetric) {
        this.labelDist = treeAlignLabelDistanceAsymmetric;
    }

    public TreeAlignResult<ValueType1, ValueType2> align(Tree<ValueType1> tree, Tree<ValueType2> tree2) throws TreeAlignException {
        TreeAlignResult treeAlignResult = new TreeAlignResult();
        Aligner aligner = new Aligner(tree, tree2);
        treeAlignResult.setDistance(aligner.align());
        treeAlignResult.setAlignment(aligner.computeAlignment());
        return treeAlignResult;
    }

    public float distanceFromAlignment(Tree<AlignedNode<ValueType1, ValueType2>> tree) {
        Tree<ValueType1> tree2 = tree.getValue().getLeftNode();
        Tree<ValueType2> tree3 = tree.getValue().getRightNode();
        float f = (float)this.labelDist.f(tree2 != null ? (Object)tree2.getValue() : null, tree3 != null ? (Object)tree3.getValue() : null);
        for (Tree<AlignedNode<ValueType1, ValueType2>> tree4 : tree.getChildren()) {
            f += this.distanceFromAlignment(tree4);
        }
        return f;
    }

    private class Aligner {
        private TreeData<ValueType1> treeData1;
        private TreeData<ValueType2> treeData2;
        private float[][][][] DF1;
        private float[][][][] DF2;
        private byte[][][][] DF1Decisions1;
        private short[][][][] DF1Decisions2;
        private byte[][][][] DF2Decisions1;
        private short[][][][] DF2Decisions2;
        private float[][] DT;
        private byte[][] DTDecisions1;
        private short[][] DTDecisions2;
        private float[][] DL;
        private float[] DET1;
        private float[] DET2;
        private float[] DEF1;
        private float[] DEF2;

        private void computeAlignmentP1(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            int n8;
            float[][] fArray = new float[n3 - n2 + 2][n6 - n5 + 2];
            fArray[0][0] = 0.0f;
            byte[][] byArray = new byte[n3 - n2 + 2][n6 - n5 + 2];
            short[][] sArray = new short[n3 - n2 + 2][n6 - n5 + 2];
            int n9 = n3 != 0 ? this.treeData1.children[n][n2] : -1;
            int n10 = n6 != 0 ? this.treeData2.children[n4][n5] : -1;
            for (n8 = n2; n8 < n3; ++n8) {
                fArray[n8 - n2 + 1][0] = fArray[n8 - n2][0] + this.DET1[this.treeData1.children[n][n8]];
            }
            for (n8 = n5; n8 < n6; ++n8) {
                fArray[0][n8 - n5 + 1] = fArray[0][n8 - n5] + this.DET2[this.treeData2.children[n4][n8]];
            }
            for (n8 = n2; n8 < n3; ++n8) {
                int n11 = this.treeData1.children[n][n8];
                for (int i = n5; i < n6; ++i) {
                    float f;
                    int n12;
                    int n13 = this.treeData2.children[n4][i];
                    float f2 = Float.POSITIVE_INFINITY;
                    int n14 = -1;
                    int n15 = -1;
                    float f3 = fArray[n8 - n2][i - n5 + 1] + this.DET1[n11];
                    if (f3 < f2) {
                        f2 = f3;
                        n14 = 1;
                    }
                    if ((f3 = fArray[n8 - n2 + 1][i - n5] + this.DET2[n13]) < f2) {
                        f2 = f3;
                        n14 = 2;
                    }
                    if ((f3 = fArray[n8 - n2][i - n5] + this.DT[n11][n13]) < f2) {
                        f2 = f3;
                        n14 = 3;
                    }
                    f3 = Float.POSITIVE_INFINITY;
                    int n16 = -1;
                    for (n12 = n2; n12 < n8; ++n12) {
                        f = fArray[n12 - n2][i - n5] + this.DF2[n13][this.treeData1.children[n][n12]][n8 - n12 + 1][this.treeData2.degrees[n13]];
                        if (!(f < f3)) continue;
                        f3 = f;
                        n16 = n12;
                    }
                    if ((f3 += this.DL[this.treeData1.size][n13]) < f2) {
                        f2 = f3;
                        n14 = 4;
                        n15 = n16;
                    }
                    f3 = Float.POSITIVE_INFINITY;
                    n16 = -1;
                    for (n12 = n5; n12 < i; ++n12) {
                        f = fArray[n8 - n2][n12 - n5] + this.DF1[n11][this.treeData2.children[n4][n12]][this.treeData1.degrees[n11]][i - n12 + 1];
                        if (!(f < f3)) continue;
                        f3 = f;
                        n16 = n12;
                    }
                    if ((f3 += this.DL[n11][this.treeData2.size]) < f2) {
                        f2 = f3;
                        n14 = 5;
                        n15 = n16;
                    }
                    fArray[n8 - n2 + 1][i - n5 + 1] = f2;
                    byArray[n8 - n2 + 1][i - n5 + 1] = (byte)n14;
                    sArray[n8 - n2 + 1][i - n5 + 1] = (short)n15;
                }
            }
            if (n7 == 2) {
                this.DF2[n4][n9] = fArray;
                this.DF2Decisions1[n4][n9] = byArray;
                this.DF2Decisions2[n4][n9] = sArray;
            } else {
                this.DF1[n][n10] = fArray;
                this.DF1Decisions1[n][n10] = byArray;
                this.DF1Decisions2[n][n10] = sArray;
            }
        }

        public float align() throws TreeAlignException {
            int n;
            int n2;
            int n3;
            new ConvertTreeToArray(this.treeData1).convert();
            new ConvertTreeToArray(this.treeData2).convert();
            this.DT = new float[this.treeData1.size][this.treeData2.size];
            this.DTDecisions1 = new byte[this.treeData1.size][this.treeData2.size];
            this.DTDecisions2 = new short[this.treeData1.size][this.treeData2.size];
            this.DL = new float[this.treeData1.size + 1][this.treeData2.size + 1];
            this.DET1 = new float[this.treeData1.size];
            this.DET2 = new float[this.treeData2.size];
            this.DEF1 = new float[this.treeData1.size];
            this.DEF2 = new float[this.treeData2.size];
            this.DF1 = new float[this.treeData1.size][this.treeData2.size][][];
            this.DF1Decisions1 = new byte[this.treeData1.size][this.treeData2.size][][];
            this.DF1Decisions2 = new short[this.treeData1.size][this.treeData2.size][][];
            this.DF2 = new float[this.treeData2.size][this.treeData1.size][][];
            this.DF2Decisions1 = new byte[this.treeData2.size][this.treeData1.size][][];
            this.DF2Decisions2 = new short[this.treeData2.size][this.treeData1.size][][];
            this.DL[this.treeData1.size][this.treeData2.size] = (float)TreeAlign.this.labelDist.f(null, null);
            for (n3 = 0; n3 < this.treeData1.size; ++n3) {
                n2 = this.treeData1.degrees[n3];
                this.DEF1[n3] = 0.0f;
                for (n = 0; n < n2; ++n) {
                    int n4 = n3;
                    this.DEF1[n4] = this.DEF1[n4] + this.DET1[this.treeData1.children[n3][n]];
                }
                this.DL[n3][this.treeData2.size] = (float)TreeAlign.this.labelDist.f(this.treeData1.values[n3], null);
                this.DET1[n3] = this.DEF1[n3] + this.DL[n3][this.treeData2.size];
            }
            for (n3 = 0; n3 < this.treeData2.size; ++n3) {
                n2 = this.treeData2.degrees[n3];
                this.DEF2[n3] = 0.0f;
                for (n = 0; n < n2; ++n) {
                    int n5 = n3;
                    this.DEF2[n5] = this.DEF2[n5] + this.DET2[this.treeData2.children[n3][n]];
                }
                this.DL[this.treeData1.size][n3] = (float)TreeAlign.this.labelDist.f(null, this.treeData2.values[n3]);
                this.DET2[n3] = this.DEF2[n3] + this.DL[this.treeData1.size][n3];
            }
            for (n3 = 0; n3 < this.treeData1.size; ++n3) {
                n2 = this.treeData1.degrees[n3];
                for (n = 0; n < this.treeData2.size; ++n) {
                    float f;
                    int n6;
                    int n7;
                    int n8 = this.treeData2.degrees[n];
                    this.DL[n3][n] = (float)TreeAlign.this.labelDist.f(this.treeData1.values[n3], this.treeData2.values[n]);
                    for (n7 = 0; n7 < n2; ++n7) {
                        this.computeAlignmentP1(n3, n7, n2, n, 0, n8, 2);
                    }
                    for (n7 = 0; n7 < n8; ++n7) {
                        this.computeAlignmentP1(n3, 0, n2, n, n7, n8, 1);
                    }
                    this.DT[n3][n] = Float.POSITIVE_INFINITY;
                    float f2 = Float.POSITIVE_INFINITY;
                    int n9 = -1;
                    for (n6 = 0; n6 < n8; ++n6) {
                        f = this.DT[n3][this.treeData2.children[n][n6]] - this.DET2[this.treeData2.children[n][n6]];
                        if (!(f < f2)) continue;
                        f2 = f;
                        n9 = n6;
                    }
                    if ((f2 += this.DET2[n]) < this.DT[n3][n]) {
                        this.DT[n3][n] = f2;
                        this.DTDecisions1[n3][n] = 1;
                        this.DTDecisions2[n3][n] = (short)n9;
                    }
                    f2 = Float.POSITIVE_INFINITY;
                    n9 = -1;
                    for (n6 = 0; n6 < n2; ++n6) {
                        f = this.DT[this.treeData1.children[n3][n6]][n] - this.DET1[this.treeData1.children[n3][n6]];
                        if (!(f < f2)) continue;
                        f2 = f;
                        n9 = n6;
                    }
                    if ((f2 += this.DET1[n3]) < this.DT[n3][n]) {
                        this.DT[n3][n] = f2;
                        this.DTDecisions1[n3][n] = 2;
                        this.DTDecisions2[n3][n] = (short)n9;
                    }
                    f2 = n8 != 0 ? this.DF1[n3][this.treeData2.children[n][0]][n2][n8] : (n2 != 0 ? this.DF2[n][this.treeData1.children[n3][0]][n2][n8] : 0.0f);
                    if (!((f2 += this.DL[n3][n]) < this.DT[n3][n])) continue;
                    this.DT[n3][n] = f2;
                    this.DTDecisions1[n3][n] = 3;
                }
            }
            return this.DT[this.treeData1.size - 1][this.treeData2.size - 1];
        }

        public Aligner(Tree<ValueType1> tree, Tree<ValueType2> tree2) {
            this.treeData1 = new TreeData();
            this.treeData1.tree = tree;
            this.treeData2 = new TreeData();
            this.treeData2.tree = tree2;
        }

        private List<Tree<AlignedNode<ValueType1, ValueType2>>> computeForestAlignment(int n, int n2, int n3, int n4, int n5, int n6) {
            short s;
            byte by;
            if (n3 == n2 - 1) {
                ArrayList arrayList = new ArrayList();
                for (int i = n5; i <= n6; ++i) {
                    arrayList.add(this.treeInserted(this.treeData2.children[n4][i]));
                }
                return arrayList;
            }
            if (n6 == n5 - 1) {
                ArrayList arrayList = new ArrayList();
                for (int i = n2; i <= n3; ++i) {
                    arrayList.add(this.treeDeleted(this.treeData1.children[n][i]));
                }
                return arrayList;
            }
            if (n2 == 0) {
                by = this.DF1Decisions1[n][this.treeData2.children[n4][n5]][n3 - n2 + 1][n6 - n5 + 1];
                s = this.DF1Decisions2[n][this.treeData2.children[n4][n5]][n3 - n2 + 1][n6 - n5 + 1];
            } else if (n5 == 0) {
                by = this.DF2Decisions1[n4][this.treeData1.children[n][n2]][n3 - n2 + 1][n6 - n5 + 1];
                s = this.DF2Decisions2[n4][this.treeData1.children[n][n2]][n3 - n2 + 1][n6 - n5 + 1];
            } else {
                throw new Error("TreeAlignSymmetric bug: both s and t are non-zero");
            }
            switch (by) {
                case 1: {
                    List list = this.computeForestAlignment(n, n2, n3 - 1, n4, n5, n6);
                    list.add(this.treeDeleted(this.treeData1.children[n][n3]));
                    return list;
                }
                case 2: {
                    List list = this.computeForestAlignment(n, n2, n3, n4, n5, n6 - 1);
                    list.add(this.treeInserted(this.treeData2.children[n4][n6]));
                    return list;
                }
                case 3: {
                    List list = this.computeForestAlignment(n, n2, n3 - 1, n4, n5, n6 - 1);
                    list.add(this.computeTreeAlignment(this.treeData1.children[n][n3], this.treeData2.children[n4][n6]));
                    return list;
                }
                case 4: {
                    List list = this.computeForestAlignment(n, n2, s - 1, n4, n5, n6 - 1);
                    int n7 = this.treeData2.children[n4][n6];
                    Tree tree = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(null);
                    alignedNode.setRightNode(this.treeData2.nodes[n7]);
                    tree.setValue(alignedNode);
                    tree.replaceChildrenListBy(this.computeForestAlignment(n, s, n3, n7, 0, this.treeData2.degrees[n7] - 1));
                    list.add(tree);
                    return list;
                }
                case 5: {
                    List list = this.computeForestAlignment(n, n2, n3 - 1, n4, n5, s - 1);
                    int n8 = this.treeData1.children[n][n3];
                    Tree tree = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(this.treeData1.nodes[n8]);
                    alignedNode.setRightNode(null);
                    tree.setValue(alignedNode);
                    tree.replaceChildrenListBy(this.computeForestAlignment(n8, 0, this.treeData1.degrees[n8] - 1, n4, s, n6));
                    list.add(tree);
                    return list;
                }
            }
            throw new Error("TreeAlign: decision1 = " + by);
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> treeDeleted(int n) {
            Tree tree = new Tree();
            AlignedNode alignedNode = new AlignedNode();
            alignedNode.setLeftNode(this.treeData1.nodes[n]);
            alignedNode.setRightNode(null);
            tree.setValue(alignedNode);
            for (int i = 0; i < this.treeData1.degrees[n]; ++i) {
                tree.getChildren().add(this.treeDeleted(this.treeData1.children[n][i]));
            }
            return tree;
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> treeInserted(int n) {
            Tree tree = new Tree();
            AlignedNode alignedNode = new AlignedNode();
            alignedNode.setLeftNode(null);
            alignedNode.setRightNode(this.treeData2.nodes[n]);
            tree.setValue(alignedNode);
            for (int i = 0; i < this.treeData2.degrees[n]; ++i) {
                tree.getChildren().add(this.treeInserted(this.treeData2.children[n][i]));
            }
            return tree;
        }

        private Tree<AlignedNode<ValueType1, ValueType2>> computeTreeAlignment(int n, int n2) {
            switch (this.DTDecisions1[n][n2]) {
                case 1: {
                    Tree tree = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(null);
                    alignedNode.setRightNode(this.treeData2.nodes[n2]);
                    tree.setValue(alignedNode);
                    for (int i = 0; i < this.treeData2.degrees[n2]; ++i) {
                        if (i == this.DTDecisions2[n][n2]) {
                            tree.getChildren().add(this.computeTreeAlignment(n, this.treeData2.children[n2][i]));
                            continue;
                        }
                        tree.getChildren().add(this.treeInserted(this.treeData2.children[n2][i]));
                    }
                    return tree;
                }
                case 2: {
                    Tree tree = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(this.treeData1.nodes[n]);
                    alignedNode.setRightNode(null);
                    tree.setValue(alignedNode);
                    for (int i = 0; i < this.treeData1.degrees[n]; ++i) {
                        if (i == this.DTDecisions2[n][n2]) {
                            tree.getChildren().add(this.computeTreeAlignment(this.treeData1.children[n][i], n2));
                            continue;
                        }
                        tree.getChildren().add(this.treeDeleted(this.treeData1.children[n][i]));
                    }
                    return tree;
                }
                case 3: {
                    Tree tree = new Tree();
                    AlignedNode alignedNode = new AlignedNode();
                    alignedNode.setLeftNode(this.treeData1.nodes[n]);
                    alignedNode.setRightNode(this.treeData2.nodes[n2]);
                    tree.setValue(alignedNode);
                    List list = this.computeForestAlignment(n, 0, this.treeData1.degrees[n] - 1, n2, 0, this.treeData2.degrees[n2] - 1);
                    tree.replaceChildrenListBy(list);
                    return tree;
                }
            }
            throw new Error("TreeAlign: DTDecisions1[i][j] = " + this.DTDecisions1[n][n2]);
        }

        public Tree<AlignedNode<ValueType1, ValueType2>> computeAlignment() {
            return this.computeTreeAlignment(this.treeData1.size - 1, this.treeData2.size - 1);
        }
    }

    private class ConvertTreeToArray<ValueType> {
        private int nextNodeIndex = 0;
        private TreeData<ValueType> treeData;

        public ConvertTreeToArray(TreeData<ValueType> treeData) {
            this.treeData = treeData;
        }

        private void convertTreeToArrayAux(Tree<ValueType> tree, int[] nArray, int n) throws TreeAlignException {
            List<Tree<ValueType>> list = tree.getChildren();
            int n2 = list.size();
            int[] nArray2 = new int[n2];
            int n3 = -1;
            int n4 = 0;
            for (Tree<ValueType> tree2 : list) {
                this.convertTreeToArrayAux(tree2, nArray2, n4);
                ++n4;
            }
            if (n2 > this.treeData.degree) {
                this.treeData.degree = n2;
            }
            n3 = this.nextNodeIndex++;
            this.treeData.nodes[n3] = tree;
            this.treeData.degrees[n3] = n2;
            ValueType ValueType = tree.getValue();
            this.treeData.values[n3] = ValueType;
            nArray[n] = n3;
            this.treeData.children[n3] = nArray2;
        }

        public void convert() throws TreeAlignException {
            this.treeData.degree = 0;
            this.treeData.size = this.treeData.tree.countNodes();
            this.treeData.nodes = new Tree[this.treeData.size];
            this.treeData.children = new int[this.treeData.size][];
            this.treeData.degrees = new int[this.treeData.size];
            this.treeData.values = new Object[this.treeData.size];
            int[] nArray = new int[1];
            this.convertTreeToArrayAux(this.treeData.tree, nArray, 0);
        }
    }

    private class TreeData<ValueType> {
        public Tree<ValueType> tree;
        public int size = -1;
        public int degree = -1;
        public int[] degrees;
        public Tree<ValueType>[] nodes;
        public int[][] children;
        public ValueType[] values;

        private TreeData() {
        }
    }
}

