/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class SiestaReader
extends AtomSetCollectionReader {
    private int noAtoms;
    private String acfUnits = "bohr";
    private String[] tokens;
    private final int STATE_UNKNOWN = 0;
    private final int STATE_INPUT = 1;
    private final int STATE_OUTPUT = 2;
    private int state = 0;
    private float acfFactor;
    Map<String, String[]> htSpecies;
    private float[] unitCellVectors;
    private float[] unitCellParamsS;
    private float latticeConstant = 1.0f;
    private String latticeUnits;
    private static final double ACF_M = 1.0E10;
    private static final double ACF_NM = 10.0;
    private static final double ACF_ANG = 1.0;
    private static final double ACF_BOHR = 0.529177;

    @Override
    protected void initializeReader() {
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.length() == 0 || this.line.charAt(0) == '#' || this.line.indexOf(32) < 0) {
            return true;
        }
        switch (this.state) {
            case 0: {
                if (this.line.indexOf("Dump of input data file") >= 0) {
                    this.state = 1;
                    return true;
                }
                this.tokens = this.getTokens();
                if (this.fixToken(0).equals("numberofspecies")) {
                    this.state = 1;
                    return false;
                }
                return true;
            }
            case 1: {
                if (this.line.indexOf("End of input data file") >= 0) {
                    this.state = 2;
                    return true;
                }
                this.tokens = this.getTokens();
                if (this.tokens[0].equals("%block")) {
                    this.readBlock(this.fixToken(1));
                } else {
                    this.readValue(this.fixToken(0));
                }
                return true;
            }
        }
        if (this.line.contains("outcoor: Atomic coordinates")) {
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomsCartGeomThenCell();
            }
            return true;
        }
        return true;
    }

    private void readValue(String key) throws Exception {
        if (key.equals("latticeconstant")) {
            this.setCell("latticeconstant");
        } else if (key.equals("atomiccoordinatesformat")) {
            this.readAtomicCoordinatesFormat();
        }
    }

    private boolean readBlock(String key) throws Exception {
        if (key.equals("latticevectors") || key.equals("latticeparameters")) {
            return this.setCell(key);
        }
        if (key.equals("chemicalspecieslabel")) {
            return this.readSpecies();
        }
        if (key.equals("atomiccoordinatesandatomicspecies")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                this.skipModel();
                return false;
            }
            return this.readAtoms();
        }
        this.discardLinesUntilContains("%endblock");
        return true;
    }

    private boolean readSpecies() throws Exception {
        this.htSpecies = new Hashtable<String, String[]>();
        while (this.rdSiesta().indexOf("%") < 0) {
            this.tokens = this.getTokens();
            this.htSpecies.put(this.tokens[0], this.tokens);
        }
        return false;
    }

    private String fixToken(int i) {
        String s = this.tokens[i];
        return PT.replaceAllCharacters(this.tokens[i], "_.-", "").toLowerCase();
    }

    public String rdSiesta() throws Exception {
        String s = this.rd();
        int pt = s.indexOf("#");
        return (pt < 0 ? s : s.substring(pt)).trim();
    }

    private float getACFValue(float v) {
        if (this.acfFactor == 0.0f) {
            boolean isScaledCartesian;
            boolean bl = isScaledCartesian = this.acfUnits == "scaledcartesian";
            if (isScaledCartesian) {
                this.acfUnits = this.latticeUnits;
            }
            this.acfUnits = PT.rep(this.acfUnits, "notscaledcartesian", "");
            switch (this.acfUnits.charAt(0)) {
                default: {
                    this.setFractionalCoordinates(isScaledCartesian);
                    this.acfFactor = 1.8897269f;
                    break;
                }
                case 'm': {
                    this.setFractionalCoordinates(isScaledCartesian);
                    this.acfFactor = 1.0E-10f;
                    break;
                }
                case 'n': {
                    this.setFractionalCoordinates(isScaledCartesian);
                    this.acfFactor = 0.1f;
                    break;
                }
                case 'a': {
                    this.setFractionalCoordinates(isScaledCartesian);
                    this.acfFactor = 1.0f;
                    break;
                }
                case 'f': 
                case 's': {
                    this.setFractionalCoordinates(true);
                    this.acfFactor = 1.0f;
                }
            }
            if (isScaledCartesian) {
                this.acfFactor /= this.latticeConstant;
                this.setFractionalCoordinates(true);
            }
        }
        return this.acfFactor * v;
    }

    private void readAtomicCoordinatesFormat() {
        this.acfUnits = this.tokens[1].toLowerCase().intern();
    }

    private void skipModel() throws Exception {
        this.discardLinesUntilContains("%endblock AtomicCoordinatesAndAtomicSpecies");
    }

    private boolean setCell(String key) throws Exception {
        if (key.equals("latticevectors")) {
            this.unitCellVectors = new float[9];
            this.fillFloatArray(null, 0, this.unitCellVectors);
        } else if (key.equals("latticeconstant")) {
            String[] tokens = this.getTokens();
            this.latticeConstant = this.parseFloatStr(tokens[1]);
            this.latticeUnits = tokens[2].toLowerCase();
        } else if (key.equals("latticeparameters")) {
            this.unitCellParamsS = new float[6];
            this.fillFloatArray(this.line.substring(this.line.indexOf("ters") + 4), 0, this.unitCellParamsS);
        }
        return true;
    }

    private boolean readAtoms() throws Exception {
        this.newAtomSet();
        if (this.unitCellVectors != null) {
            this.addExplicitLatticeVector(0, this.unitCellVectors, 0);
            this.addExplicitLatticeVector(1, this.unitCellVectors, 3);
            this.addExplicitLatticeVector(2, this.unitCellVectors, 6);
        } else if (this.unitCellParamsS != null) {
            this.setUnitCell(this.unitCellParamsS[0] * this.latticeConstant, this.unitCellParamsS[1] * this.latticeConstant, this.unitCellParamsS[2] * this.latticeConstant, this.unitCellParamsS[3], this.unitCellParamsS[4], this.unitCellParamsS[5]);
        }
        while (this.rdSiesta() != null && this.line.indexOf("%endblock Atomic") < 0) {
            String[] stringArray;
            String[] tokens = this.getTokens();
            if (this.htSpecies == null) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = null;
                stringArray2[1] = null;
                stringArray = stringArray2;
                stringArray2[2] = tokens[4];
            } else {
                stringArray = this.htSpecies.get(tokens[3]);
            }
            String[] species = stringArray;
            String name = species[2];
            String sym = species[1] == null ? name : SiestaReader.getElementSymbol(this.parseIntStr(species[1]));
            this.addAtomXYZSymName(tokens, 0, sym, name);
        }
        this.noAtoms = this.asc.ac;
        return true;
    }

    @Override
    public void setAtomCoordXYZ(Atom atom, float x, float y, float z) {
        super.setAtomCoordXYZ(atom, this.getACFValue(x), this.getACFValue(y), this.getACFValue(z));
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readAtomsCartGeomThenCell() throws Exception {
        this.readLines(1);
        this.newAtomSet();
        int atom0 = this.asc.ac;
        for (int i = 0; i < this.noAtoms; ++i) {
            String[] tokens = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = tokens[4];
            float x = this.parseFloatStr(tokens[0]);
            float y = this.parseFloatStr(tokens[1]);
            float z = this.parseFloatStr(tokens[2]);
            atom.set(x, y, z);
            this.rdSiesta();
        }
        this.discardLinesUntilContains("outcell: Unit cell vectors");
        this.setCell("vectors");
        Atom[] atoms = this.asc.atoms;
        int ac = this.asc.ac;
        for (int i = atom0; i < ac; ++i) {
            this.setAtomCoord(atoms[i]);
        }
        this.discardLinesUntilContains("siesta: E_KS(eV) = ");
        String[] tokens = this.getTokens();
        Double energy = Double.parseDouble(tokens[3]);
        this.asc.setAtomSetEnergy("" + energy, energy.floatValue());
        this.asc.setCurrentModelInfo("Energy", energy);
        this.asc.setInfo("Energy", energy);
        this.asc.setAtomSetName("Energy = " + energy + " eV");
    }
}

