/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFlagFile {
    private static Log log = LogFactory.getLog((Class)SessionFlagFile.class);
    protected File flagFile = null;

    private void checkFlagFile() {
        if (this.flagFile == null) {
            log.fatal((Object)"Implementation error - uninitialized SessionFlagFile", (Throwable)new Error("Implementation error - uninitialized SessionFlagFile"));
        }
    }

    public boolean setFlag() {
        this.checkFlagFile();
        try {
            if (this.flagFile.createNewFile()) {
                log.debug((Object)("Set session flag " + this.flagFile));
            } else {
                log.debug((Object)("Session flag already set " + this.flagFile));
            }
            return true;
        }
        catch (Exception e) {
            log.warn((Object)("Couldn't set session flag " + this.flagFile), (Throwable)e);
            return false;
        }
    }

    public boolean clearFlag() {
        this.checkFlagFile();
        if (this.flagFile.exists()) {
            log.debug((Object)("clearing session flag " + this.flagFile));
            if (!this.flagFile.delete()) {
                log.warn((Object)("failed to clear session flag " + this.flagFile));
                return false;
            }
        } else {
            log.debug((Object)("clearFlag called for already cleared flag " + this.flagFile));
        }
        return true;
    }

    public boolean checkFlag() {
        this.checkFlagFile();
        if (this.flagFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Flag '" + this.flagFile + "' is set."));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flag '" + this.flagFile + "' is not set."));
        }
        return false;
    }

    public SessionFlagFile(File flagFile) {
        this.flagFile = flagFile;
    }
}

