/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.LockFactory;

public class SessionFile {
    private static Log log = LogFactory.getLog((Class)SessionFile.class);
    protected File sessionFile;
    protected Lock fileLock = null;

    protected SessionFile(File file) {
        this.sessionFile = file;
    }

    protected boolean lockFile(Lock extantlock) {
        if (this.fileLock != null && !this.fileLock.isLocked()) {
            this.fileLock.release();
            this.fileLock = null;
        }
        if (extantlock != null && extantlock.isLocked()) {
            this.fileLock = extantlock;
        }
        return this.lockFile();
    }

    private boolean ensureSessionFile() {
        if (this.sessionFile != null) {
            if (!this.sessionFile.exists()) {
                try {
                    if (!this.sessionFile.createNewFile()) {
                        log.error((Object)("Failed to create file prior to locking: " + this.sessionFile));
                        return false;
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Exception when trying to create file " + this.sessionFile), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        log.error((Object)"ensureSessionFile called for non-initialised SessionFile!");
        return false;
    }

    protected boolean lockFile() {
        if (this.fileLock != null) {
            if (this.fileLock.isLocked()) {
                return this.ensureSessionFile();
            }
            this.fileLock.release();
            log.info((Object)"Unexpected session file lock failure. Trying to get it again.");
            this.fileLock = null;
        }
        if (!this.ensureSessionFile()) {
            return false;
        }
        long tries = 5000L;
        do {
            --tries;
            if (this.fileLock != null && this.fileLock.isLocked()) continue;
            this.fileLock = LockFactory.getLock(this.sessionFile, true);
        } while (tries > 0L && !this.fileLock.isLocked());
        if (!this.fileLock.isLocked()) {
            log.error((Object)("Failed to get lock for " + this.sessionFile));
        }
        return this.fileLock.isLocked();
    }

    protected void unlockFile() {
        if (this.fileLock != null) {
            this.fileLock.release();
            this.fileLock = null;
        }
    }

    protected File backupSessionFile() {
        return this.backupSessionFile(this.fileLock, this.sessionFile.getName(), ".old", this.sessionFile.getParentFile());
    }

    protected File backupSessionFile(Lock extantLock, String backupPrefix, String backupSuffix, File backupDir) {
        File tempfile = null;
        if (this.lockFile(extantLock)) {
            try {
                tempfile = File.createTempFile(backupPrefix, backupSuffix, backupDir);
                long sourceln = this.fileLock.length();
                if (sourceln > 0L) {
                    long tlen;
                    FileOutputStream tos = new FileOutputStream(tempfile);
                    FileChannel channel = this.fileLock.getRaChannel().position(0L);
                    for (long ntrans = 0L; ntrans < sourceln; ntrans += tlen) {
                        tlen = tos.getChannel().transferFrom(channel, ntrans, sourceln);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Transferred " + tlen + " out of " + sourceln + " bytes"));
                    }
                    tos.close();
                    if (!channel.isOpen()) {
                        throw new Error("LIBRARY PORTABILITY ISSUE: " + tos.getChannel().getClass() + ".transferFrom closes source channel!");
                    }
                    if (!this.lockFile(extantLock)) {
                        throw new Error("LIBRARY PORTABILITY ISSUE: Lost lock for " + this.sessionFile.getName() + " after backup.");
                    }
                }
            }
            catch (FileNotFoundException e1) {
                log.warn((Object)("Can't create temp file for " + this.sessionFile.getName()), (Throwable)e1);
                tempfile = null;
            }
            catch (IOException e1) {
                log.warn((Object)("Error when copying content to temp file for " + this.sessionFile.getName()), (Throwable)e1);
                tempfile = null;
            }
        }
        return tempfile;
    }

    protected void updateFrom(Lock extantLock, SessionFile newData) throws IOException {
        log.debug((Object)("Updating " + this.sessionFile.getAbsolutePath() + " from " + newData.sessionFile.getAbsolutePath()));
        if (newData == null) {
            throw new IOException("Null newData object.");
        }
        if (newData.sessionFile == null) {
            throw new IOException("Null SessionFile in newData.");
        }
        if (!this.lockFile(extantLock)) {
            throw new IOException("Failed to get write lock for " + this.sessionFile);
        }
        if (!newData.lockFile()) {
            throw new IOException("Failed to get lock for updateFrom " + newData.sessionFile);
        }
        RandomAccessFile nrafile = newData.fileLock.getRaFile();
        nrafile.seek(0L);
        RandomAccessFile trafile = this.fileLock.getRaFile();
        trafile.seek(0L);
        trafile.getChannel().transferFrom(nrafile.getChannel(), 0L, nrafile.length());
    }

    protected void eraseExistence() {
        this.unlockFile();
        if (this.sessionFile != null) {
            this.sessionFile.delete();
            this.sessionFile = null;
        }
    }

    public BufferedInputStream getBufferedInputStream(boolean atStart) throws IOException {
        this.lockFile();
        return this.fileLock.getBufferedInputStream(atStart);
    }

    public BufferedOutputStream getBufferedOutputStream(boolean clear) throws IOException {
        this.lockFile();
        return this.fileLock.getBufferedOutputStream(clear);
    }

    public FileInputStream getFileInputStream(boolean atStart) throws IOException {
        this.lockFile();
        return this.fileLock.getFileInputStream(atStart);
    }

    public FileOutputStream getFileOutputStream(boolean clear) throws IOException {
        this.lockFile();
        return this.fileLock.getFileOutputStream(clear);
    }
}

