/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.action;

import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.KeyStroke;
import org.robsite.jswingreader.action.UpdatableAction;
import org.robsite.jswingreader.model.Channel;
import org.robsite.jswingreader.model.ChannelListModel;
import org.robsite.jswingreader.model.SimpleRSSParser;
import org.robsite.jswingreader.ui.Main;

public class RefreshChannelAction
extends AbstractAction
implements UpdatableAction {
    private JList _listChannels;

    public RefreshChannelAction(JList listChannels) {
        super("Refresh");
        this.putValue("MnemonicKey", new Integer(82));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 8));
        this.putValue("SmallIcon", new ImageIcon(Main.class.getResource("image/Refresh16.gif")));
        this._listChannels = listChannels;
    }

    public void actionPerformed(ActionEvent e) {
        ChannelListModel model = (ChannelListModel)this._listChannels.getModel();
        int selectedIndex = this._listChannels.getSelectedIndex();
        if (selectedIndex > -1) {
            try {
                try {
                    Channel channel = (Channel)model.getElementAt(selectedIndex);
                    SimpleRSSParser.parse(channel);
                    model.replaceChannelAt(selectedIndex, channel);
                }
                catch (MalformedURLException ex) {
                    String text = ex.toString();
                    Main.getMainWindow().setStatusBarText("Unable to refresh channel ");
                    this._listChannels.setSelectedIndex(selectedIndex);
                }
                catch (Exception ex) {
                    String text = ex.toString();
                    Main.getMainWindow().setStatusBarText("Unable to refresh channel: " + text);
                    this._listChannels.setSelectedIndex(selectedIndex);
                }
            }
            finally {
                this._listChannels.setSelectedIndex(selectedIndex);
            }
        }
    }

    public void update(Object o) {
        if (this._listChannels == null || this._listChannels.getModel().getSize() == 0) {
            this.setEnabled(false);
        } else if (this._listChannels.getSelectedIndex() == -1) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

