/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.dm;

import compbio.metadata.Argument;
import jalview.util.MessageManager;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.ParameterUtils;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.AutoCalcSetting;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.List;

public class AAConSettings
extends AutoCalcSetting {
    Jws2Instance service;

    public AAConSettings(boolean autoUpdate, Jws2Instance service, WsParamSetI preset, List<ArgumentI> jobArgset) {
        super(preset, jobArgset, autoUpdate);
        this.service = service;
    }

    public Jws2Instance getService() {
        return this.service;
    }

    public void setService(Jws2Instance service) {
        this.service = service;
        if (this.preset != null) {
            for (String url : this.preset.getApplicableUrls()) {
                if (!url.equals(service.getUri())) continue;
                return;
            }
            WsParamSetI pr = service.getParamStore().getPreset(this.preset.getName());
            if (pr instanceof JabaPreset && this.preset instanceof JabaPreset) {
                this.preset = pr;
                return;
            }
            ArrayList<ArgumentI> oldargs = new ArrayList<ArgumentI>();
            ArrayList<ArgumentI> newargs = new ArrayList<ArgumentI>();
            oldargs.addAll(this.preset.getArguments());
            for (ArgumentI newparg : pr.getArguments()) {
                if (oldargs.remove(newparg)) continue;
                newargs.add(newparg);
            }
            if (oldargs.size() == 0 && newargs.size() == 0) {
                this.preset = pr;
                return;
            }
            throw new Error(MessageManager.getString("error.parameter_migration_not_implemented_yet"));
        }
    }

    public List<Argument> getJobArgset() {
        return this.jobArgset == null ? null : JabaParamStore.getJabafromJwsArgs(this.jobArgset);
    }

    public void setJobArgset(List<Argument> jobArgset) {
        this.jobArgset = jobArgset == null ? null : JabaParamStore.getJwsArgsfromJaba(jobArgset);
    }

    @Override
    public String getWsParamFile() {
        List opts = null;
        if (this.jobArgset != null) {
            opts = JabaParamStore.getJabafromJwsArgs(this.jobArgset);
        } else if (this.preset != null) {
            opts = JabaParamStore.getJabafromJwsArgs(this.preset.getArguments());
        }
        if (opts == null || opts.size() == 0) {
            return "";
        }
        StringBuffer pset = new StringBuffer();
        for (String ps : ParameterUtils.writeParameterSet(opts, " ")) {
            pset.append(ps);
            pset.append("\n");
        }
        return pset.toString();
    }

    @Override
    public String getServiceURI() {
        return this.service.getServiceTypeURI();
    }

    @Override
    public String[] getServiceURLs() {
        return new String[]{this.service.getUri()};
    }
}

