/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;

public class MessageManager {
    private static ResourceBundle rb;
    private static Locale loc;
    private static Set<String> reportedMissing;

    public static String getString(String key) {
        Object value = "[missing key] " + key;
        try {
            value = rb.getString(key);
        }
        catch (Exception e) {
            String msg = "I18N missing: " + loc + "\t" + key;
            MessageManager.logWarning(key, msg);
        }
        return value;
    }

    public static Locale getLocale() {
        return loc;
    }

    public static String formatMessage(String key, Object ... params) {
        try {
            return MessageFormat.format(rb.getString(key), params);
        }
        catch (Exception e) {
            Console.warn("I18N missing: " + loc + "\t" + key);
            String value = "[missing key] " + key;
            for (Object p : params) {
                value = value + " '" + p.toString() + "'";
            }
            return value;
        }
    }

    public static String formatMessage(String key, String[] params) {
        return MessageManager.formatMessage(key, (Object[])params);
    }

    public static String getStringOrReturn(String keyroot, String name) {
        String smkey = keyroot + name.toLowerCase(Locale.ROOT).replaceAll(" ", "");
        try {
            name = rb.getString(smkey);
        }
        catch (Exception x) {
            String msg = "I18N missing key with root " + keyroot + ": " + loc + "\t" + smkey;
            MessageManager.logWarning(smkey, msg);
        }
        return name;
    }

    private static void logWarning(String key, String msg) {
        if (!reportedMissing.contains(key)) {
            reportedMissing.add(key);
            Console.info(msg);
        }
    }

    static {
        reportedMissing = new HashSet<String>();
        try {
            loc = Locale.getDefault();
            Console.info("Getting messages for lang: " + loc);
            ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
            rb = ResourceBundle.getBundle("lang.Messages", loc, control);
        }
        catch (Exception q) {
            Console.warn("Exception when initting Locale for i18n messages\n" + q.getMessage());
            q.printStackTrace();
        }
        catch (Error v) {
            Console.warn("Error when initting Locale for i18n messages\n" + v.getMessage());
            v.printStackTrace();
        }
    }
}

