/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer.seqfeatures;

import jalview.api.AlignViewportI;
import jalview.api.FeatureRenderer;
import jalview.api.FeaturesDisplayedI;
import jalview.datamodel.SequenceI;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class FeatureColourFinder {
    private FeatureRenderer featureRenderer;
    private BufferedImage offscreenImage;

    public FeatureColourFinder(FeatureRenderer fr) {
        this.featureRenderer = fr;
        this.offscreenImage = new BufferedImage(1, 1, 2);
    }

    public Color findFeatureColour(Color defaultColour, SequenceI seq, int column) {
        Color c;
        if (this.noFeaturesDisplayed()) {
            return defaultColour;
        }
        Graphics g = null;
        if (this.featureRenderer.getTransparency() != 1.0f) {
            g = this.offscreenImage.getGraphics();
            if (defaultColour != null) {
                this.offscreenImage.setRGB(0, 0, defaultColour.getRGB());
            }
        }
        if ((c = this.featureRenderer.findFeatureColour(seq, column + 1, g)) == null) {
            return defaultColour;
        }
        if (g != null) {
            c = new Color(this.offscreenImage.getRGB(0, 0));
        }
        return c;
    }

    boolean noFeaturesDisplayed() {
        if (this.featureRenderer == null) {
            return true;
        }
        AlignViewportI av = this.featureRenderer.getViewport();
        if (av.isShowComplementFeatures()) {
            return false;
        }
        if (!av.isShowSequenceFeatures()) {
            return true;
        }
        if (!((FeatureRendererModel)this.featureRenderer).hasRenderOrder()) {
            return true;
        }
        FeaturesDisplayedI displayed = this.featureRenderer.getFeaturesDisplayed();
        return displayed == null || displayed.getVisibleFeatureCount() == 0;
    }
}

