/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LineartOptions
extends JPanel {
    public static final String PROMPT_EACH_TIME = "Prompt each time";
    JvOptionPane dialog;
    public boolean cancelled = false;
    String value;
    JRadioButton lineartRB;
    JCheckBox askAgainCB = new JCheckBox();
    AtomicBoolean asText;
    private String dialogTitle;

    public LineartOptions(String formatType, AtomicBoolean textOption) {
        this.asText = textOption;
        this.dialogTitle = MessageManager.formatMessage("label.select_character_style_title", formatType);
        String preferencesKey = formatType + "_RENDERING";
        try {
            this.jbInit(preferencesKey, formatType);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.dialog = JvOptionPane.newOptionDialog(Desktop.desktop);
    }

    public void setResponseAction(Object response, Runnable action) {
        this.dialog.setResponseHandler(response, action);
    }

    public void showDialog() {
        Object[] options = new Object[]{MessageManager.getString("action.ok"), MessageManager.getString("action.cancel")};
        this.dialog.showInternalDialog(this, this.dialogTitle, 2, -1, null, options, MessageManager.getString("action.ok"));
    }

    private void jbInit(String preferencesKey, String formatType) throws Exception {
        this.lineartRB = new JRadioButton(MessageManager.getString("label.lineart"));
        this.lineartRB.setFont(JvSwingUtils.getLabelFont());
        this.lineartRB.setSelected(!this.asText.get());
        this.lineartRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineartOptions.this.asText.set(!LineartOptions.this.lineartRB.isSelected());
            }
        });
        final JRadioButton textRB = new JRadioButton(MessageManager.getString("action.text"));
        textRB.setFont(JvSwingUtils.getLabelFont());
        textRB.setSelected(this.asText.get());
        textRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LineartOptions.this.asText.set(textRB.isSelected());
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.lineartRB);
        bg.add(textRB);
        this.askAgainCB.setFont(JvSwingUtils.getLabelFont());
        this.askAgainCB.setText(MessageManager.getString("label.dont_ask_me_again"));
        JLabel prompt = new JLabel(MessageManager.formatMessage("label.select_character_rendering_style", formatType));
        prompt.setFont(JvSwingUtils.getLabelFont());
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(prompt);
        this.add(textRB);
        this.add(this.lineartRB);
        this.add(this.askAgainCB);
    }

    protected void updatePreference(String preferencesKey) {
        String string = this.value = this.lineartRB.isSelected() ? "Lineart" : "Text";
        if (this.askAgainCB.isSelected()) {
            Cache.setProperty(preferencesKey, this.value);
        } else {
            Cache.applicationProperties.remove(preferencesKey);
        }
    }

    public String getValue() {
        return this.value;
    }
}

