/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.pdb;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import jalview.bin.Console;
import jalview.datamodel.SequenceI;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.api.StructureFTSRestClientI;
import jalview.fts.core.FTSDataColumnPreferences;
import jalview.fts.core.FTSRestClient;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.javascript.web.Client;
import jalview.util.JSONUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.simple.parser.ParseException;

public class PDBFTSRestClient
extends FTSRestClient
implements StructureFTSRestClientI {
    private static FTSRestClientI instance = null;
    public static final String PDB_SEARCH_ENDPOINT = "https://www.ebi.ac.uk/pdbe/search/pdb/select?";
    private Collection<FTSDataColumnI> allDefaultDisplayedStructureDataColumns;

    protected PDBFTSRestClient() {
    }

    @Override
    public FTSRestResponse executeRequest(FTSRestRequest pdbRestRequest) throws Exception {
        try {
            Class clientResponseClass;
            com.sun.jersey.api.client.Client client;
            String wantedFields = this.getDataColumnsFieldsAsCommaDelimitedString(pdbRestRequest.getWantedFields());
            int responseSize = pdbRestRequest.getResponseSize() == 0 ? this.getDefaultResponsePageSize() : pdbRestRequest.getResponseSize();
            int offSet = pdbRestRequest.getOffSet();
            Object sortParam = null;
            sortParam = pdbRestRequest.getFieldToSortBy() == null || pdbRestRequest.getFieldToSortBy().trim().isEmpty() ? "" : (pdbRestRequest.getFieldToSortBy().equalsIgnoreCase("Resolution") ? pdbRestRequest.getFieldToSortBy() + (pdbRestRequest.isAscending() ? " asc" : " desc") : pdbRestRequest.getFieldToSortBy() + (pdbRestRequest.isAscending() ? " desc" : " asc"));
            String facetPivot = pdbRestRequest.getFacetPivot() == null || pdbRestRequest.getFacetPivot().isEmpty() ? "" : pdbRestRequest.getFacetPivot();
            String facetPivotMinCount = String.valueOf(pdbRestRequest.getFacetPivotMinCount());
            String query = pdbRestRequest.getFieldToSearchBy() + pdbRestRequest.getSearchTerm() + (pdbRestRequest.isAllowEmptySeq() ? "" : " AND molecule_sequence:['' TO *]") + (pdbRestRequest.isAllowUnpublishedEntries() ? "" : " AND status:REL");
            if (Platform.isJS()) {
                client = (com.sun.jersey.api.client.Client)new Client();
                clientResponseClass = jalview.javascript.web.ClientResponse.class;
            } else {
                client = com.sun.jersey.api.client.Client.create((ClientConfig)new DefaultClientConfig());
                clientResponseClass = ClientResponse.class;
            }
            WebResource webResource = pdbRestRequest.isFacet() ? client.resource(PDB_SEARCH_ENDPOINT).queryParam("wt", "json").queryParam("fl", wantedFields).queryParam("rows", String.valueOf(responseSize)).queryParam("q", query).queryParam("start", String.valueOf(offSet)).queryParam("sort", (String)sortParam).queryParam("facet", "true").queryParam("facet.pivot", facetPivot).queryParam("facet.pivot.mincount", facetPivotMinCount) : client.resource(PDB_SEARCH_ENDPOINT).queryParam("wt", "json").queryParam("fl", wantedFields).queryParam("rows", String.valueOf(responseSize)).queryParam("start", String.valueOf(offSet)).queryParam("q", query).queryParam("sort", (String)sortParam);
            URI uri = webResource.getURI();
            Console.outPrintln(uri);
            ClientResponse clientResponse = null;
            int responseStatus = -1;
            Map jsonObj = null;
            String responseString = null;
            Console.outPrintln("query >>>>>>> " + pdbRestRequest.toString());
            if (!this.isMocked()) {
                clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(clientResponseClass);
                responseStatus = clientResponse.getStatus();
            } else {
                responseStatus = this.mockQueries.containsKey(uri.toString()) ? 200 : 400;
            }
            switch (responseStatus) {
                case 200: {
                    if (this.isMocked()) {
                        responseString = (String)this.mockQueries.get(uri.toString());
                        break;
                    }
                    if (Platform.isJS()) {
                        jsonObj = (Map)clientResponse.getEntity(Map.class);
                        break;
                    }
                    responseString = (String)clientResponse.getEntity(String.class);
                    break;
                }
                case 400: {
                    throw new Exception(this.isMocked() ? "400 response (Mocked)" : PDBFTSRestClient.parseJsonExceptionString(responseString));
                }
                default: {
                    throw new Exception(PDBFTSRestClient.getMessageByHTTPStatusCode(responseStatus, "PDB"));
                }
            }
            return PDBFTSRestClient.parsePDBJsonResponse(responseString, jsonObj, pdbRestRequest);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                throw e;
            }
            String exceptionMsg = e.getMessage();
            if (exceptionMsg.contains("SocketException")) {
                throw new Exception(MessageManager.getString("exception.unable_to_detect_internet_connection"));
            }
            if (exceptionMsg.contains("UnknownHostException")) {
                throw new Exception(MessageManager.formatMessage("exception.fts_server_unreachable", "PDB Solr"));
            }
            throw e;
        }
    }

    public static String parseJsonExceptionString(String jsonErrorResponse) {
        StringBuilder errorMessage = new StringBuilder("\n============= PDB Rest Client RunTime error =============\n");
        try {
            Map jsonObj = (Map)JSONUtils.parse(jsonErrorResponse);
            Map errorResponse = (Map)jsonObj.get("error");
            Map responseHeader = (Map)jsonObj.get("responseHeader");
            Map paramsObj = (Map)responseHeader.get("params");
            String status = responseHeader.get("status").toString();
            String message = errorResponse.get("msg").toString();
            String query = paramsObj.get("q").toString();
            String fl = paramsObj.get("fl").toString();
            errorMessage.append("Status: ").append(status).append("\n");
            errorMessage.append("Message: ").append(message).append("\n");
            errorMessage.append("query: ").append(query).append("\n");
            errorMessage.append("fl: ").append(fl).append("\n");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return errorMessage.toString();
    }

    public static FTSRestResponse parsePDBJsonResponse(String pdbJsonResponseString, FTSRestRequest pdbRestRequest) {
        return PDBFTSRestClient.parsePDBJsonResponse(pdbJsonResponseString, null, pdbRestRequest);
    }

    public static FTSRestResponse parsePDBJsonResponse(String pdbJsonResponseString, Map<String, Object> jsonObj, FTSRestRequest pdbRestRequest) {
        FTSRestResponse searchResult = new FTSRestResponse();
        ArrayList<FTSData> result = null;
        try {
            if (jsonObj == null) {
                jsonObj = (Map)JSONUtils.parse(pdbJsonResponseString);
            }
            Map pdbResponse = (Map)jsonObj.get("response");
            String queryTime = ((Map)jsonObj.get("responseHeader")).get("QTime").toString();
            int numFound = Integer.valueOf(pdbResponse.get("numFound").toString());
            List docs = (List)pdbResponse.get("docs");
            result = new ArrayList<FTSData>();
            if (numFound > 0) {
                for (Map doc : docs) {
                    result.add(PDBFTSRestClient.getFTSData(doc, pdbRestRequest));
                }
            }
            searchResult.setNumberOfItemsFound(numFound);
            searchResult.setResponseTime(queryTime);
            searchResult.setSearchSummary(result);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return searchResult;
    }

    public static FTSData getFTSData(Map<String, Object> pdbJsonDoc, FTSRestRequest request) {
        String primaryKey = null;
        Collection<FTSDataColumnI> diplayFields = request.getWantedFields();
        SequenceI associatedSeq = request.getAssociatedSequence();
        int colCounter = 0;
        Object[] summaryRowData = new Object[associatedSeq != null ? diplayFields.size() + 1 : diplayFields.size()];
        if (associatedSeq != null) {
            SequenceI associatedSequence = associatedSeq;
            summaryRowData[0] = associatedSequence;
            colCounter = 1;
        }
        for (FTSDataColumnI field : diplayFields) {
            String fieldData;
            String string = fieldData = pdbJsonDoc.get(field.getCode()) == null ? "" : pdbJsonDoc.get(field.getCode()).toString();
            if (field.isPrimaryKeyColumn()) {
                primaryKey = fieldData;
                summaryRowData[colCounter++] = primaryKey;
                continue;
            }
            if (fieldData == null || fieldData.isEmpty()) {
                summaryRowData[colCounter++] = null;
                continue;
            }
            try {
                summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(fieldData) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(fieldData) : PDBFTSRestClient.sanitiseData(fieldData));
            }
            catch (Exception e) {
                e.printStackTrace();
                Console.outPrintln("offending value:" + fieldData);
            }
        }
        final String primaryKey1 = primaryKey;
        final Object[] summaryRowData1 = summaryRowData;
        return new FTSData(){

            @Override
            public Object[] getSummaryData() {
                return summaryRowData1;
            }

            @Override
            public Object getPrimaryKey() {
                return primaryKey1;
            }

            public String toString() {
                StringBuilder summaryFieldValues = new StringBuilder();
                for (Object summaryField : summaryRowData1) {
                    summaryFieldValues.append(summaryField == null ? " " : summaryField.toString()).append("\t");
                }
                return summaryFieldValues.toString();
            }

            public int hashCode() {
                return Objects.hash(primaryKey1, this.toString());
            }

            public boolean equals(Object that) {
                return this.toString().equals(that.toString());
            }
        };
    }

    private static String sanitiseData(String data) {
        String cleanData = data.replaceAll("\\[\"", "").replaceAll("\\]\"", "").replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\",\"", ", ").replaceAll("\"", "");
        return cleanData;
    }

    @Override
    public String getColumnDataConfigFileName() {
        return "/fts/pdb_data_columns.txt";
    }

    public static FTSRestClientI getInstance() {
        if (instance == null) {
            instance = new PDBFTSRestClient();
        }
        return instance;
    }

    @Override
    public Collection<FTSDataColumnI> getAllDefaultDisplayedStructureDataColumns() {
        if (this.allDefaultDisplayedStructureDataColumns == null || this.allDefaultDisplayedStructureDataColumns.isEmpty()) {
            this.allDefaultDisplayedStructureDataColumns = new ArrayList<FTSDataColumnI>();
            this.allDefaultDisplayedStructureDataColumns.addAll(super.getAllDefaultDisplayedFTSDataColumns());
        }
        return this.allDefaultDisplayedStructureDataColumns;
    }

    @Override
    public String[] getPreferencesColumnsFor(FTSDataColumnPreferences.PreferenceSource source) {
        String[] columnNames = null;
        switch (source) {
            case SEARCH_SUMMARY: {
                columnNames = new String[]{"", "Display", "Group"};
                break;
            }
            case STRUCTURE_CHOOSER: {
                columnNames = new String[]{"", "Display", "Group"};
                break;
            }
            case PREFERENCES: {
                columnNames = new String[]{"PDB Field", "Show in search summary", "Show in structure summary"};
                break;
            }
        }
        return columnNames;
    }
}

