/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import com.stevesoft.pat.Regex;
import jalview.bin.Cache;
import jalview.ws.seqfetcher.DbSourceProxyImpl;

abstract class EnsemblSequenceFetcher
extends DbSourceProxyImpl {
    protected static final String ENSEMBL_BASEURL = "ENSEMBL_BASEURL";
    protected static final String ENSEMBL_GENOMES_BASEURL = "ENSEMBL_GENOMES_BASEURL";
    protected static final String DEFAULT_ENSEMBL_BASEURL = "https://rest.ensembl.org";
    protected static final String DEFAULT_ENSEMBL_GENOMES_BASEURL = "https://rest.ensembl.org";
    private static final Regex ACCESSION_REGEX = new Regex("(ENS([A-Z]{3}|)[GTEP]{1}[0-9]{11}$)|(CCDS[0-9.]{3,}$)");
    protected final String ensemblGenomesDomain;
    protected final String ensemblDomain = Cache.getDefault("ENSEMBL_BASEURL", "https://rest.ensembl.org").trim();
    protected static final String OBJECT_TYPE_TRANSLATION = "Translation";
    protected static final String OBJECT_TYPE_TRANSCRIPT = "Transcript";
    protected static final String OBJECT_TYPE_GENE = "Gene";
    protected static final String PARENT = "Parent";
    protected static final String JSON_ID = "id";
    protected static final String OBJECT_TYPE = "object_type";
    private String domain;

    public EnsemblSequenceFetcher() {
        this.ensemblGenomesDomain = Cache.getDefault(ENSEMBL_GENOMES_BASEURL, "https://rest.ensembl.org").trim();
        this.domain = this.ensemblDomain;
    }

    @Override
    public String getDbSource() {
        return "ENSEMBL";
    }

    @Override
    public String getAccessionSeparator() {
        return " ";
    }

    @Override
    public Regex getAccessionValidator() {
        return ACCESSION_REGEX;
    }

    @Override
    public boolean isValidReference(String accession) {
        return this.getAccessionValidator().search(accession);
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public String getTestQuery() {
        return "ENST00000288602";
    }

    @Override
    public boolean isDnaCoding() {
        return true;
    }

    protected String getDomain() {
        return this.domain;
    }

    protected void setDomain(String d) {
        this.domain = d == null ? null : d.trim();
    }

    protected static enum EnsemblFeatureType {
        gene,
        transcript,
        cds,
        exon,
        repeat,
        simple,
        misc,
        variation,
        somatic_variation,
        structural_variation,
        somatic_structural_variation,
        constrained,
        regulatory;

    }
}

