/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.Dna;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeatures;
import jalview.exceptions.JalviewException;
import jalview.ext.ensembl.EnsemblFeatures;
import jalview.ext.ensembl.EnsemblProtein;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.ext.ensembl.EnsemblXref;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.IntRangeComparator;
import jalview.util.MapList;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.ParseException;

public abstract class EnsemblSeqProxy
extends EnsemblRestClient {
    protected static final String DESCRIPTION = "description";
    int bhtest = 0;

    public EnsemblSeqProxy() {
    }

    public EnsemblSeqProxy(String d) {
        super(d);
    }

    @Override
    public AlignmentI getSequenceRecords(String query) throws Exception {
        List<String> allIds = Arrays.asList(query.split(this.getAccessionSeparator()));
        AlignmentI alignment = null;
        this.inProgress = true;
        int maxQueryCount = this.getMaximumQueryCount();
        int vSize = allIds.size();
        for (int v = 0; v < vSize; v += maxQueryCount) {
            int p = Math.min(vSize, v + maxQueryCount);
            List<String> ids = allIds.subList(v, p);
            try {
                alignment = this.fetchSequences(ids, alignment);
                continue;
            }
            catch (Throwable r) {
                this.inProgress = false;
                String msg = "Aborting ID retrieval after " + v + " chunks. Unexpected problem (" + r.getLocalizedMessage() + ")";
                Console.errPrintln(msg);
                r.printStackTrace();
                break;
            }
        }
        if (alignment == null) {
            return null;
        }
        int n = allIds.size();
        for (int i = 0; i < n; ++i) {
            this.addFeaturesAndProduct(allIds.get(i), alignment);
        }
        List<SequenceI> seqs = alignment.getSequences();
        int n2 = seqs.size();
        for (int i = 0; i < n2; ++i) {
            this.getCrossReferences(seqs.get(i));
        }
        return alignment;
    }

    protected void addFeaturesAndProduct(String accId, AlignmentI alignment) {
        if (alignment == null) {
            return;
        }
        try {
            SequenceI querySeq;
            SequenceI genomicSequence = null;
            EnsemblFeatures gffFetcher = new EnsemblFeatures(this.getDomain());
            EnsemblSequenceFetcher.EnsemblFeatureType[] features = this.getFeaturesToFetch();
            AlignmentI geneFeatures = gffFetcher.getSequenceRecords(accId, features);
            if (geneFeatures != null && geneFeatures.getHeight() > 0) {
                genomicSequence = geneFeatures.getSequenceAt(0);
            }
            if (genomicSequence != null && this.transferFeatures(accId, genomicSequence, querySeq = alignment.findName(accId, true))) {
                this.addProteinProduct(querySeq);
            }
        }
        catch (IOException e) {
            Console.errPrintln("Error transferring Ensembl features: " + e.getMessage());
        }
    }

    protected abstract EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch();

    protected void addProteinProduct(SequenceI querySeq) {
        String accId = querySeq.getName();
        try {
            Console.outPrintln("Adding protein product for " + accId);
            AlignmentI protein = new EnsemblProtein(this.getDomain()).getSequenceRecords(accId);
            if (protein == null || protein.getHeight() == 0) {
                Console.outPrintln("No protein product found for " + accId);
                return;
            }
            SequenceI proteinSeq = protein.getSequenceAt(0);
            proteinSeq.createDatasetSequence();
            querySeq.createDatasetSequence();
            MapList mapList = AlignmentUtils.mapCdsToProtein(querySeq, proteinSeq);
            if (mapList != null) {
                SequenceI ds = proteinSeq.getDatasetSequence();
                Mapping map = new Mapping(ds, mapList);
                DBRefEntry dbr = new DBRefEntry(this.getDbSource(), this.getEnsemblDataVersion(), proteinSeq.getName(), map);
                querySeq.getDatasetSequence().addDBRef(dbr);
                List<DBRefEntry> uprots = DBRefUtils.selectRefs(ds.getDBRefs(), new String[]{"UNIPROT"});
                List<DBRefEntry> upxrefs = DBRefUtils.selectRefs(querySeq.getDBRefs(), new String[]{"UNIPROT"});
                if (uprots != null) {
                    for (DBRefEntry up : uprots) {
                        DBRefEntry upxref;
                        List<DBRefEntry> upx = DBRefUtils.searchRefs(upxrefs, up.getAccessionId());
                        if (upx.size() != 0) {
                            upxref = upx.get(0);
                            if (upx.size() > 1) {
                                Console.warn("Implementation issue - multiple uniprot acc on product sequence.");
                            }
                        } else {
                            upxref = new DBRefEntry("UNIPROT", this.getEnsemblDataVersion(), up.getAccessionId());
                        }
                        Mapping newMap = new Mapping(ds, mapList);
                        upxref.setVersion(this.getEnsemblDataVersion());
                        upxref.setMap(newMap);
                        if (upx.size() != 0) continue;
                        querySeq.getDatasetSequence().addDBRef(upxref);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error retrieving protein for %s: %s", accId, e.getMessage()));
        }
    }

    protected void getCrossReferences(SequenceI seq) {
        while (seq.getDatasetSequence() != null) {
            seq = seq.getDatasetSequence();
        }
        EnsemblXref xrefFetcher = new EnsemblXref(this.getDomain(), this.getDbSource(), this.getEnsemblDataVersion());
        List<DBRefEntry> xrefs = xrefFetcher.getCrossReferences(seq.getName());
        int n = xrefs.size();
        for (int i = 0; i < n; ++i) {
            seq.addDBRef(xrefs.get(i));
        }
        DBRefEntry self = new DBRefEntry(this.getDbSource(), this.getEnsemblDataVersion(), seq.getName());
        seq.addDBRef(self);
    }

    protected AlignmentI fetchSequences(List<String> ids, AlignmentI alignment) throws JalviewException, IOException {
        if (!this.isEnsemblAvailable()) {
            this.inProgress = false;
            throw new JalviewException("ENSEMBL Rest API not available.");
        }
        List<SequenceI> seqs = this.parseSequenceJson(ids);
        if (seqs == null) {
            return alignment;
        }
        if (seqs.isEmpty()) {
            throw new IOException("No data returned for " + ids);
        }
        if (seqs.size() != ids.size()) {
            Console.outPrintln(String.format("Only retrieved %d sequences for %d query strings", seqs.size(), ids.size()));
        }
        if (!seqs.isEmpty()) {
            Alignment seqal = new Alignment(seqs.toArray(new SequenceI[seqs.size()]));
            for (SequenceI seq : seqs) {
                String name;
                if (seq.getDescription() == null) {
                    seq.setDescription(this.getDbName());
                }
                if (!ids.contains(name = seq.getName()) && !ids.contains(name.replace("ENSP", "ENST"))) continue;
                DBRefEntry dbref = DBRefUtils.parseToDbRef(seq, this.getDbSource(), this.getEnsemblDataVersion(), name);
                seq.addDBRef(dbref);
            }
            if (alignment == null) {
                alignment = seqal;
            } else {
                alignment.append(seqal);
            }
        }
        return alignment;
    }

    protected List<SequenceI> parseSequenceJson(List<String> ids) {
        ArrayList<SequenceI> result = new ArrayList<SequenceI>();
        try {
            Map val = (Map)this.getJSON(null, ids, -1, 1, null);
            if (val == null) {
                return null;
            }
            Object s = val.get("desc");
            String desc = s == null ? null : s.toString();
            s = val.get("id");
            String id = s == null ? null : s.toString();
            s = val.get("seq");
            String seq = s == null ? null : s.toString();
            Sequence sequence = new Sequence(id, seq);
            if (desc != null) {
                sequence.setDescription(desc);
            }
            result.add(sequence);
        }
        catch (IOException | ParseException e) {
            Console.errPrintln("Error processing JSON response: " + e.toString());
        }
        return result;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        StringBuffer urlstring = new StringBuffer(128);
        urlstring.append(this.getDomain() + "/sequence/id");
        if (ids.size() == 1) {
            urlstring.append("/").append(ids.get(0));
        }
        urlstring.append("?type=").append(this.getSourceEnsemblType().getType());
        urlstring.append("&Accept=application/json");
        urlstring.append("&content-type=application/json");
        String objectType = this.getObjectType();
        if (objectType != null) {
            urlstring.append("&").append("object_type").append("=").append(objectType);
        }
        URL url = new URL(urlstring.toString());
        return url;
    }

    protected String getObjectType() {
        return null;
    }

    @Override
    public int getMaximumQueryCount() {
        return 50;
    }

    @Override
    protected boolean useGetRequest() {
        return false;
    }

    protected abstract EnsemblSeqType getSourceEnsemblType();

    protected MapList getGenomicRangesFromFeatures(SequenceI sourceSequence, String accId, int start) {
        List<SequenceFeature> sfs = this.getIdentifyingFeatures(sourceSequence, accId);
        if (sfs.isEmpty()) {
            return null;
        }
        ArrayList<int[]> regions = new ArrayList<int[]>(100);
        int mappedLength = 0;
        int direction = 1;
        boolean directionSet = false;
        for (SequenceFeature sf : sfs) {
            int strand = sf.getStrand();
            int n = strand = strand == 0 ? 1 : strand;
            if (directionSet && strand != direction) {
                System.err.println("Error: forward and backward strand for " + accId);
                return null;
            }
            direction = strand;
            directionSet = true;
            if (strand < 0) {
                regions.add(0, new int[]{sf.getEnd(), sf.getBegin()});
            } else {
                regions.add(new int[]{sf.getBegin(), sf.getEnd()});
            }
            mappedLength += Math.abs(sf.getEnd() - sf.getBegin() + 1);
        }
        if (regions.isEmpty()) {
            Console.outPrintln("Failed to identify target sequence for " + accId + " from genomic features");
            return null;
        }
        Collections.sort(regions, direction == 1 ? IntRangeComparator.ASCENDING : IntRangeComparator.DESCENDING);
        List<int[]> to = Arrays.asList(new int[][]{{start, start + mappedLength - 1}});
        return new MapList(regions, to, 1, 1);
    }

    protected abstract List<SequenceFeature> getIdentifyingFeatures(SequenceI var1, String var2);

    protected void transferFeature(SequenceFeature sf, SequenceI targetSequence, MapList mapping, boolean forwardStrand) {
        int end;
        int start = sf.getBegin();
        int[] mappedRange = mapping.locateInTo(start, end = sf.getEnd());
        if (mappedRange != null) {
            String group = sf.getFeatureGroup();
            if (".".equals(group)) {
                group = this.getDbSource();
            }
            int newBegin = Math.min(mappedRange[0], mappedRange[1]);
            int newEnd = Math.max(mappedRange[0], mappedRange[1]);
            ++this.bhtest;
            SequenceFeature copy = new SequenceFeature(sf, newBegin, newEnd, group, sf.getScore());
            targetSequence.addSequenceFeature(copy);
            if (!forwardStrand && SequenceOntologyFactory.getInstance().isA(sf.getType(), "sequence_variant")) {
                EnsemblSeqProxy.reverseComplementAlleles(copy);
            }
        }
    }

    static void reverseComplementAlleles(SequenceFeature sf) {
        String alleles = (String)sf.getValue("alleles");
        if (alleles == null) {
            return;
        }
        StringBuilder complement = new StringBuilder(alleles.length());
        for (String allele : alleles.split(",")) {
            EnsemblSeqProxy.reverseComplementAllele(complement, allele);
        }
        String comp = complement.toString();
        sf.setValue("alleles", comp);
        sf.setDescription(comp);
    }

    static void reverseComplementAllele(StringBuilder complement, String allele) {
        if (complement.length() > 0) {
            complement.append(",");
        }
        if (!Comparison.isNucleotideSequence(allele, true)) {
            complement.append(allele);
        } else {
            for (int i = allele.length() - 1; i >= 0; --i) {
                complement.append(Dna.getComplement(allele.charAt(i)));
            }
        }
    }

    protected boolean transferFeatures(String accessionId, SequenceI sourceSequence, SequenceI targetSequence) {
        if (sourceSequence == null || targetSequence == null) {
            return false;
        }
        List<SequenceFeature> sfs = sourceSequence.getFeatures().getPositionalFeatures(new String[0]);
        MapList mapping = this.getGenomicRangesFromFeatures(sourceSequence, accessionId, targetSequence.getStart());
        if (mapping == null) {
            return false;
        }
        boolean result = this.transferFeatures(sfs, targetSequence, mapping, accessionId);
        return result;
    }

    protected boolean transferFeatures(List<SequenceFeature> sfs, SequenceI targetSequence, MapList mapping, String parentId) {
        boolean forwardStrand = mapping.isFromForwardStrand();
        SequenceFeatures.sortFeatures(sfs, forwardStrand);
        boolean transferred = false;
        int n = sfs.size();
        for (int i = 0; i < n; ++i) {
            SequenceFeature sf = sfs.get(i);
            if (!this.retainFeature(sf, parentId)) continue;
            this.transferFeature(sf, targetSequence, mapping, forwardStrand);
            transferred = true;
        }
        return transferred;
    }

    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        return true;
    }

    protected boolean featureMayBelong(SequenceFeature sf, String identifier) {
        String parent = (String)sf.getValue("Parent");
        return parent == null || parent.equalsIgnoreCase(identifier);
    }

    @Override
    public String getDescription() {
        return "Ensembl " + this.getSourceEnsemblType().getType() + " sequence with variant features";
    }

    protected List<SequenceFeature> findFeatures(SequenceI sequence, String term, String parentId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = sequence.getFeatures().getFeaturesByOntology(term);
        for (SequenceFeature sf : sfs) {
            String parent = (String)sf.getValue("Parent");
            if (parent == null || !parent.equalsIgnoreCase(parentId)) continue;
            result.add(sf);
        }
        return result;
    }

    public static boolean isTranscript(String featureType) {
        return "NMD_transcript_variant".equals(featureType) || SequenceOntologyFactory.getInstance().isA(featureType, "transcript");
    }

    public static enum EnsemblSeqType {
        GENOMIC("genomic"),
        CDNA("cdna"),
        CDS("cds"),
        PROTEIN("protein");

        private String type;

        private EnsemblSeqType(String t) {
            this.type = t;
        }

        public String getType() {
            return this.type;
        }
    }
}

