/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ContactListI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceGroup;
import jalview.viewmodel.annotationfilter.AnnotationFilterParameter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.regex.PatternSyntaxException;

public class ColumnSelection {
    private IntList selection = new IntList();

    public void addElement(int col) {
        this.selection.add(col);
    }

    public void addRangeOfElements(int[] rng, boolean baseOne) {
        int base = baseOne ? -1 : 0;
        for (int c = 0; c < rng.length; c += 2) {
            for (int p = rng[c]; p <= rng[c + 1]; ++p) {
                this.selection.add(base + p);
            }
        }
    }

    public void clear() {
        this.selection.clear();
    }

    public void removeElement(int col) {
        this.selection.remove(col);
    }

    public void removeElements(int start, int end) {
        for (int i = start; i < end; ++i) {
            Integer colInt = i;
            if (!this.selection.contains(colInt)) continue;
            this.selection.remove(colInt);
        }
    }

    public List<Integer> getSelected() {
        return this.selection.getList();
    }

    public List<int[]> getSelectedRanges() {
        return this.selection.getRanges();
    }

    public boolean contains(int col) {
        return col > -1 ? this.selection.isSelected(col) : false;
    }

    public boolean intersects(int from, int to) {
        for (int f = from; f <= to; ++f) {
            if (!this.selection.isSelected(f)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.selection == null || this.selection.isEmpty();
    }

    public int getMax() {
        if (this.selection.isEmpty()) {
            return -1;
        }
        return this.selection.getMaxColumn();
    }

    public int getMin() {
        if (this.selection.isEmpty()) {
            return 1000000000;
        }
        return this.selection.getMinColumn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSelectedColumns(AlignmentI al) {
        IntList intList = this.selection;
        synchronized (intList) {
            for (int[] selregions : this.selection.getRanges()) {
                al.getHiddenColumns().hideColumns(selregions[0], selregions[1]);
            }
            this.selection.clear();
        }
    }

    public void hideSelectedColumns(int col, HiddenColumns hidden) {
        this.removeElement(col);
        int min = col - 1;
        int max = col + 1;
        while (this.contains(min)) {
            this.removeElement(min);
            --min;
        }
        while (this.contains(max)) {
            this.removeElement(max);
            ++max;
        }
        if (++min > --max) {
            min = max;
        }
        hidden.hideColumns(min, max);
    }

    public ColumnSelection(ColumnSelection copy) {
        if (copy != null) {
            this.selection = new IntList(copy.selection);
        }
    }

    public ColumnSelection() {
    }

    public void invertColumnSelection(int first, int width, AlignmentI al) {
        boolean hasHidden = al.getHiddenColumns().hasHiddenColumns();
        for (int i = first; i < width; ++i) {
            if (this.contains(i)) {
                this.removeElement(i);
                continue;
            }
            if (hasHidden && !al.getHiddenColumns().isVisible(i)) continue;
            this.addElement(i);
        }
    }

    public void setElementsFrom(ColumnSelection colsel, HiddenColumns hiddenColumns) {
        block4: {
            this.selection = new IntList();
            if (colsel.selection == null || colsel.selection.size() <= 0) break block4;
            if (hiddenColumns.hasHiddenColumns()) {
                for (Integer col : colsel.getSelected()) {
                    if (hiddenColumns == null || !hiddenColumns.isVisible(col)) continue;
                    this.selection.add(col);
                }
            } else {
                for (Integer col : colsel.getSelected()) {
                    this.addElement(col);
                }
            }
        }
    }

    public boolean hasSelectedColumns() {
        return this.selection != null && this.selection.size() > 0;
    }

    public int filterAnnotations(AlignmentAnnotation ann_row, AnnotationFilterParameter filterParams) {
        Annotation[] annotations = ann_row.annotations;
        this.clear();
        if (ann_row.graph == 4 && (filterParams.getThresholdType() == AnnotationFilterParameter.ThresholdType.ABOVE_THRESHOLD || filterParams.getThresholdType() == AnnotationFilterParameter.ThresholdType.BELOW_THRESHOLD)) {
            float tVal = filterParams.getThresholdValue();
            if (ann_row.sequenceRef != null) {
                block2: for (int column = 0; column < annotations.length; ++column) {
                    if (ann_row.annotations[column] == null) continue;
                    int cpos = ann_row.sequenceRef.findPosition(column) - 1;
                    ContactListI clist = ann_row.sequenceRef.getContactListFor(ann_row, cpos);
                    int rowEnd = clist.getContactHeight();
                    for (int row = column + 8; row < rowEnd; ++row) {
                        if (!(filterParams.getThresholdType() == AnnotationFilterParameter.ThresholdType.ABOVE_THRESHOLD ? clist.getContactAt(row) > (double)tVal : clist.getContactAt(row) < (double)tVal)) continue;
                        this.addElement(column);
                        continue block2;
                    }
                }
            }
            return this.selection.size();
        }
        int addedCount = 0;
        int column = 0;
        do {
            Annotation ann;
            if ((ann = annotations[column]) == null) continue;
            float value = ann.value;
            boolean matched = false;
            if (filterParams.getThresholdType() == AnnotationFilterParameter.ThresholdType.ABOVE_THRESHOLD && value > filterParams.getThresholdValue()) {
                matched = true;
            }
            if (!matched && filterParams.getThresholdType() == AnnotationFilterParameter.ThresholdType.BELOW_THRESHOLD && value < filterParams.getThresholdValue()) {
                matched = true;
            }
            if (!matched && filterParams.isFilterAlphaHelix() && ann.secondaryStructure == 'H') {
                matched = true;
            }
            if (!matched && filterParams.isFilterBetaSheet() && ann.secondaryStructure == 'E') {
                matched = true;
            }
            if (!matched && filterParams.isFilterTurn() && ann.secondaryStructure == 'S') {
                matched = true;
            }
            String regexSearchString = filterParams.getRegexString();
            if (!matched && regexSearchString != null) {
                List<AnnotationFilterParameter.SearchableAnnotationField> fields = filterParams.getRegexSearchFields();
                for (AnnotationFilterParameter.SearchableAnnotationField field : fields) {
                    block15: {
                        String compareTo = field == AnnotationFilterParameter.SearchableAnnotationField.DISPLAY_STRING ? ann.displayCharacter : ann.description;
                        if (compareTo == null) continue;
                        try {
                            if (compareTo.matches(regexSearchString)) {
                                matched = true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            if (!compareTo.equals(regexSearchString)) break block15;
                            matched = true;
                        }
                    }
                    if (!matched) continue;
                    break;
                }
            }
            if (!matched) continue;
            this.addElement(column);
            ++addedCount;
        } while (++column < annotations.length);
        return addedCount;
    }

    public int hashCode() {
        return this.selection.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnSelection)) {
            return false;
        }
        ColumnSelection that = (ColumnSelection)obj;
        if (this.selection == null && that.selection != null) {
            return false;
        }
        return this.selection.equals(that.selection);
    }

    public boolean markColumns(BitSet markedColumns, int startCol, int endCol, boolean invert, boolean extendCurrent, boolean toggle) {
        boolean changed = false;
        if (!extendCurrent && !toggle) {
            changed = !this.isEmpty();
            this.clear();
        }
        if (invert) {
            int i = markedColumns.nextClearBit(startCol);
            int ibs = markedColumns.nextSetBit(startCol);
            while (i >= startCol && i <= endCol) {
                if (ibs < 0 || i < ibs) {
                    changed = true;
                    if (toggle && this.contains(i)) {
                        this.removeElement(i++);
                        continue;
                    }
                    this.addElement(i++);
                    continue;
                }
                i = markedColumns.nextClearBit(ibs);
                ibs = markedColumns.nextSetBit(i);
            }
        } else {
            int i = markedColumns.nextSetBit(startCol);
            while (i >= startCol && i <= endCol) {
                changed = true;
                if (toggle && this.contains(i)) {
                    this.removeElement(i);
                } else {
                    this.addElement(i);
                }
                i = markedColumns.nextSetBit(i + 1);
            }
        }
        return changed;
    }

    public void stretchGroup(int res, SequenceGroup sg, int min, int max) {
        if (!this.contains(res)) {
            this.addElement(res);
        }
        if (res > sg.getStartRes()) {
            sg.setEndRes(res);
        }
        if (res < sg.getStartRes()) {
            sg.setStartRes(res);
        }
        for (int col = min; col <= max; ++col) {
            if (col < sg.getStartRes() || col > sg.getEndRes()) {
                this.removeElement(col);
                continue;
            }
            this.addElement(col);
        }
    }

    private class IntList {
        private List<Integer> order = new ArrayList<Integer>();
        private List<Integer> _uorder = Collections.unmodifiableList(this.order);
        private BitSet selected = new BitSet();

        IntList() {
        }

        IntList(IntList other) {
            this();
            if (other != null) {
                int j = other.size();
                for (int i = 0; i < j; ++i) {
                    this.add(other.elementAt(i));
                }
            }
        }

        void add(int i) {
            if (!this.selected.get(i)) {
                this.order.add(i);
                this.selected.set(i);
            }
        }

        void clear() {
            this.order.clear();
            this.selected.clear();
        }

        void remove(int col) {
            Integer colInt = col;
            if (this.selected.get(col)) {
                this.order.remove(colInt);
                this.selected.clear(col);
            }
        }

        boolean contains(Integer colInt) {
            return this.selected.get(colInt);
        }

        boolean isEmpty() {
            return this.order.isEmpty();
        }

        List<Integer> getList() {
            return this._uorder;
        }

        int size() {
            return this.order.size();
        }

        int elementAt(int i) {
            return this.order.get(i);
        }

        protected boolean pruneColumnList(List<int[]> shifts) {
            int s = 0;
            int t = shifts.size();
            int[] sr = shifts.get(s++);
            boolean pruned = false;
            int i = 0;
            int j = this.order.size();
            while (i < j && s <= t) {
                int c;
                if (sr[0] > (c = this.order.get(i++).intValue())) continue;
                if (sr[1] + sr[0] >= c) {
                    this.order.remove(--i);
                    this.selected.clear(c);
                    --j;
                    continue;
                }
                if (s < t) {
                    sr = shifts.get(s);
                }
                ++s;
            }
            return pruned;
        }

        void compensateForEdits(int start, int change) {
            BitSet mask = new BitSet();
            for (int i = 0; i < this.order.size(); ++i) {
                int temp = this.order.get(i);
                if (temp < start) continue;
                this.selected.clear(temp);
                mask.set(temp - change);
                this.order.set(i, temp - change);
            }
            this.selected.or(mask);
        }

        boolean isSelected(int column) {
            return this.selected.get(column);
        }

        int getMaxColumn() {
            return this.selected.length() - 1;
        }

        int getMinColumn() {
            return this.selected.get(0) ? 0 : this.selected.nextSetBit(0);
        }

        List<int[]> getRanges() {
            ArrayList<int[]> rlist = new ArrayList<int[]>();
            if (this.selected.isEmpty()) {
                return rlist;
            }
            int next = this.selected.nextSetBit(0);
            int clear = -1;
            while (next != -1) {
                clear = this.selected.nextClearBit(next);
                rlist.add(new int[]{next, clear - 1});
                next = this.selected.nextSetBit(clear);
            }
            return rlist;
        }

        public int hashCode() {
            return this.selected.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof IntList) {
                return ((IntList)obj).selected.equals(this.selected);
            }
            return false;
        }
    }
}

