/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import jalview.bin.ArgsParser;
import jalview.bin.Cache;
import jalview.bin.Commands;
import jalview.bin.Console;
import jalview.bin.GetdownLauncherUpdate;
import jalview.bin.JalviewTaskbar;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.bin.argparser.BootstrapArgs;
import jalview.bin.groovy.JalviewObject;
import jalview.bin.groovy.JalviewObjectI;
import jalview.ext.so.SequenceOntology;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.PromptUserConfig;
import jalview.gui.QuitHandler;
import jalview.gui.StructureViewerBase;
import jalview.io.AppletFormatAdapter;
import jalview.io.BioJsHTMLOutput;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.HtmlSvgOutput;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.util.ChannelProperties;
import jalview.util.HttpUtils;
import jalview.util.LaunchUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.UserAgent;
import jalview.ws.jws2.Jws2Discoverer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Jalview
implements JalviewObjectI {
    private static Jalview instance;
    private Desktop desktop;
    protected Commands cmds;
    public AlignFrame currentAlignFrame = null;
    private ArgParser argparser = null;
    private BootstrapArgs bootstrapArgs = null;
    private boolean QUIET = false;

    public static boolean quiet() {
        return Jalview.getInstance() != null && Jalview.getInstance().QUIET;
    }

    public static Jalview getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        instance = new Jalview();
        instance.doMain(args);
    }

    private static void logClass(String name) {
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        Logger logger = Logger.getLogger(name);
        logger.setLevel(Level.ALL);
        logger.addHandler(consoleHandler);
    }

    private static void setLogging() {
        Console.outPrintln("not in js");
        if (!Platform.isJS()) {
            Logger.getLogger("").setLevel(Level.ALL);
            Jalview.logClass("java.awt.EventDispatchThread");
            Jalview.logClass("java.awt.EventQueue");
            Jalview.logClass("java.awt.Component");
            Jalview.logClass("java.awt.focus.Component");
            Jalview.logClass("java.awt.focus.DefaultKeyboardFocusManager");
        }
    }

    void doMain(String[] args) {
        boolean soDefault;
        String appdirString;
        if (!Platform.isJS()) {
            System.setSecurityManager(null);
        }
        if (args == null || args.length == 0 || args.length == 1 && (args[0] == null || args[0].length() == 0)) {
            args = new String[]{};
        }
        this.bootstrapArgs = BootstrapArgs.getBootstrapArgs(args);
        boolean usingLogfile = false;
        if (!Platform.isJS()) {
            System.setProperty("log4j2.isWebapp", "false");
            String logfilename = System.getProperty("installer.logfile");
            boolean append = Boolean.parseBoolean(System.getProperty("installer.logfile_append"));
            usingLogfile = Console.setLogFile(logfilename, append);
            if (!usingLogfile && this.bootstrapArgs.contains(Arg.QUIET)) {
                this.QUIET = true;
                OutputStream devNull = new OutputStream(){

                    @Override
                    public void write(int b) {
                    }
                };
                System.setOut(new PrintStream(devNull));
                if (this.bootstrapArgs.getList(Arg.QUIET).size() > 1) {
                    System.setErr(new PrintStream(devNull));
                }
            }
            if (this.bootstrapArgs.contains(Arg.HELP) || this.bootstrapArgs.contains(Arg.VERSION)) {
                this.QUIET = true;
            }
        }
        if (this.bootstrapArgs.contains(Arg.P)) {
            for (String kev : this.bootstrapArgs.getValueList(Arg.P)) {
                int equalsIndex;
                if (kev == null || (equalsIndex = kev.indexOf(61)) <= -1) continue;
                String key = kev.substring(0, equalsIndex);
                String val = kev.substring(equalsIndex + 1);
                Cache.setSessionProperty(key, val);
            }
        }
        String string = appdirString = System.getProperty("launcher.appdir") != null ? System.getProperty("launcher.appdir") : System.getProperty("getdownappdir");
        if (appdirString != null && appdirString.length() > 0) {
            Console.errPrintln("launcher.appdir property: " + appdirString);
            new Thread(){

                @Override
                public void run() {
                    GetdownLauncherUpdate.main(new String[]{appdirString});
                }
            }.start();
        } else {
            Console.errPrintln("launcher.appdir property not found");
        }
        if (usingLogfile || !Jalview.quiet() || !this.bootstrapArgs.outputToStdout() || this.bootstrapArgs.contains(Arg.VERSION)) {
            if (usingLogfile) {
                Console.outPrintln("-------");
            }
            Console.outPrint(Cache.getVersionDetailsForConsole());
            if (usingLogfile) {
                Console.outPrintln("-------");
            }
        }
        if (Platform.isLinux() && LaunchUtils.getJavaVersion() < 11) {
            System.setProperty("flatlaf.uiScale", "1");
        }
        Properties bootstrapProperties = Cache.bootstrapProperties(this.bootstrapArgs.getValue(Arg.PROPS));
        Cache.loadBuildProperties(!Jalview.quiet() || this.bootstrapArgs.contains(Arg.VERSION));
        if (this.bootstrapArgs.contains(Arg.VERSION)) {
            Jalview.exit(null, ExitCode.OK);
        }
        ArgsParser aparser = new ArgsParser(args);
        boolean headless = false;
        boolean headlessArg = false;
        try {
            String logLevel = null;
            if (this.bootstrapArgs.contains(Arg.TRACE)) {
                logLevel = "TRACE";
            } else if (this.bootstrapArgs.contains(Arg.DEBUG)) {
                String string2 = logLevel = this.bootstrapArgs.getBoolean(Arg.DEBUG) ? "DEBUG" : "INFO";
            }
            if (logLevel == null && bootstrapProperties != null) {
                logLevel = bootstrapProperties.getProperty("logs.Jalview.level");
            }
            Console.initLogger(logLevel);
        }
        catch (NoClassDefFoundError error) {
            error.printStackTrace();
            String message = "\nEssential logging libraries not found.\nUse: java -classpath \"$PATH_TO_LIB$/*:$PATH_TO_CLASSES$\" jalview.bin.Jalview";
            Jalview.exit(message, ExitCode.OK);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Console.debug("Running shutdown hook");
                QuitHandler.startForceQuit();
                boolean closeExternal = Cache.getDefault("DEFAULT_CLOSE_EXTERNAL_VIEWERS", false) || Cache.getDefault("ALWAYS_CLOSE_EXTERNAL_VIEWERS", false);
                StructureViewerBase.setQuitClose(closeExternal);
                if (Jalview.this.desktop != null) {
                    for (JInternalFrame frame : Desktop.desktop.getAllFrames()) {
                        if (!(frame instanceof StructureViewerBase)) continue;
                        ((StructureViewerBase)frame).closeViewer(closeExternal);
                    }
                }
                if (QuitHandler.gotQuitResponse() == QuitHandler.QResponse.CANCEL_QUIT) {
                    Console.debug("Checking for saving files");
                    QuitHandler.getQuitResponse(false);
                } else {
                    Console.debug("Nothing more to do");
                }
                Console.debug("Exiting, bye!");
            }
        });
        String usrPropsFile = this.bootstrapArgs.contains(Arg.PROPS) ? this.bootstrapArgs.getValue(Arg.PROPS) : aparser.getValue("props");
        Cache.loadProperties(usrPropsFile);
        if (usrPropsFile != null) {
            Console.outPrintln("CMD [-props " + usrPropsFile + "] executed successfully!");
            Jalview.testoutput(this.bootstrapArgs, Arg.PROPS, "test/jalview/bin/testProps.jvprops", usrPropsFile);
        }
        this.argparser = this.bootstrapArgs.contains(Arg.ARGFILE) ? ArgParser.parseArgFiles(this.bootstrapArgs.getValueList(Arg.ARGFILE), this.bootstrapArgs.getBoolean(Arg.INITSUBSTITUTIONS), this.bootstrapArgs) : new ArgParser(args, this.bootstrapArgs.getBoolean(Arg.INITSUBSTITUTIONS), this.bootstrapArgs);
        if (!Platform.isJS()) {
            if (this.bootstrapArgs.contains(Arg.HELP)) {
                List<Map.Entry<Arg.Type, String>> helpArgs = this.bootstrapArgs.getList(Arg.HELP);
                Console.outPrintln(Arg.usage(helpArgs.stream().map(e -> (Arg.Type)((Object)((Object)e.getKey()))).collect(Collectors.toList())));
                Jalview.exit(null, ExitCode.OK);
            }
            if (aparser.contains("help") || aparser.contains("h")) {
                Console.outPrintln(Arg.usage());
                Jalview.exit(null, ExitCode.OK);
            }
            if (headlessArg = this.bootstrapArgs.isHeadless()) {
                System.setProperty("java.awt.headless", "true");
            }
            if (aparser.contains("nodisplay") || aparser.contains("nogui") || aparser.contains("headless")) {
                System.setProperty("java.awt.headless", "true");
                headless = true;
            }
            System.setProperty("com.sun.security.enableAIAcaIssuers", "true");
            String jabawsUrl = this.bootstrapArgs.getValue(Arg.JABAWS);
            if (jabawsUrl == null) {
                jabawsUrl = aparser.getValue("jabaws");
            }
            if (jabawsUrl != null) {
                try {
                    Jws2Discoverer.getDiscoverer().setPreferredUrl(jabawsUrl);
                    Console.outPrintln("CMD [-jabaws " + jabawsUrl + "] executed successfully!");
                    Jalview.testoutput(this.bootstrapArgs, Arg.JABAWS, "http://www.compbio.dundee.ac.uk/jabaws", jabawsUrl);
                }
                catch (MalformedURLException e2) {
                    Console.errPrintln("Invalid jabaws parameter: " + jabawsUrl + " ignored");
                }
            }
        }
        List<Object> setprops = new ArrayList();
        if (this.bootstrapArgs.contains(Arg.SETPROP)) {
            setprops = this.bootstrapArgs.getValueList(Arg.SETPROP);
        } else {
            Object sp = aparser.getValue("setprop");
            while (sp != null) {
                setprops.add(sp);
                sp = aparser.getValue("setprop");
            }
        }
        for (String string3 : setprops) {
            int p = string3.indexOf(61);
            if (p == -1) {
                System.err.println("Ignoring invalid setprop argument : " + string3);
                continue;
            }
            Console.errPrintln("Executing setprop argument: " + string3);
            if (!Platform.isJS()) continue;
            Cache.setProperty(string3.substring(0, p), string3.substring(p + 1));
        }
        if (System.getProperty("java.awt.headless") != null && System.getProperty("java.awt.headless").equals("true")) {
            headless = true;
        }
        System.setProperty("http.agent", UserAgent.getUserAgent());
        try {
            Console.initLogger();
        }
        catch (NoClassDefFoundError error) {
            error.printStackTrace();
            String string4 = "\nEssential logging libraries not found.\nUse: java -classpath \"$PATH_TO_LIB$/*:$PATH_TO_CLASSES$\" jalview.bin.Jalview";
            Jalview.exit(string4, ExitCode.NO_LOGGING);
        }
        this.desktop = null;
        if (!headless && !headlessArg) {
            Jalview.setLookAndFeel();
        }
        boolean bl = soDefault = !Platform.isJS();
        if (Cache.getDefault("USE_FULL_SO", soDefault)) {
            SequenceOntologyFactory.setInstance(new SequenceOntology());
        }
        if (!headless && !headlessArg) {
            Desktop.nosplash = "false".equals(this.bootstrapArgs.getValue(Arg.SPLASH)) || aparser.contains("nosplash") || Cache.getDefault("SPLASH", "true").equals("false");
            this.desktop = new Desktop();
            this.desktop.setInBatchMode(true);
            this.mixedCliWarning();
            try {
                JalviewTaskbar.setTaskbar(this);
            }
            catch (Exception exception) {
                Console.info("Cannot set Taskbar");
                Console.error(exception.getMessage());
            }
            catch (Throwable throwable) {
                Console.info("Cannot set Taskbar");
                Console.error(throwable.getMessage());
            }
            Cache.setProxyPropertiesFromPreferences();
            this.desktop.setVisible(true);
            if (!Platform.isJS()) {
                boolean usagestats;
                String string5 = ChannelProperties.getProperty("app_name");
                if (!LaunchUtils.checkJavaVersion()) {
                    Console.warn("The Java version being used (Java " + LaunchUtils.getJavaVersion() + ") may lead to problems. This installation of " + string5 + " should be used with Java " + LaunchUtils.getJavaCompileVersion() + ".");
                    if (!LaunchUtils.getBooleanUserPreference("IGNORE_JVM_WARNING_POPUP")) {
                        Object[] options = new Object[]{MessageManager.getString("label.continue")};
                        JOptionPane.showOptionDialog(null, MessageManager.formatMessage("warning.wrong_jvm_version_message", LaunchUtils.getJavaVersion(), LaunchUtils.getJavaCompileVersion()), MessageManager.getString("warning.wrong_jvm_version_title"), -1, 2, null, options, options[0]);
                    }
                }
                String installerappdirString = System.getProperty("installer.appdir");
                if (Platform.isMac() && installerappdirString != null && installerappdirString.startsWith("/Volumes/")) {
                    Console.warn("You appear to be running " + string5 + " from the Installer volume.  Please drag and drop the " + string5 + " icon into the Applications folder.");
                    Object[] options = new Object[]{MessageManager.getString("action.quit")};
                    JOptionPane.showOptionDialog(null, MessageManager.formatMessage("warning.running_from_installer_volume_message", string5), MessageManager.getString("warning.running_from_installer_volume_title"), -1, 2, null, options, options[0]);
                    this.quit();
                }
                boolean webservicediscovery = this.bootstrapArgs.getBoolean(Arg.WEBSERVICEDISCOVERY);
                if (aparser.contains("nowebservicediscovery")) {
                    webservicediscovery = false;
                }
                if (webservicediscovery) {
                    this.desktop.startServiceDiscovery();
                } else {
                    Jalview.testoutput(this.argparser, Arg.WEBSERVICEDISCOVERY);
                }
                boolean bl2 = usagestats = !this.bootstrapArgs.getBoolean(Arg.NOUSAGESTATS);
                if (aparser.contains("nousagestats")) {
                    usagestats = false;
                }
                if (usagestats) {
                    Jalview.startUsageStats(this.desktop);
                    Jalview.testoutput(this.argparser, Arg.NOUSAGESTATS);
                } else {
                    Console.outPrintln("CMD [-nousagestats] executed successfully!");
                    Jalview.testoutput(this.argparser, Arg.NOUSAGESTATS);
                }
                boolean questionnaire = this.bootstrapArgs.getBoolean(Arg.QUESTIONNAIRE);
                if (aparser.contains("noquestionnaire")) {
                    questionnaire = false;
                }
                if (questionnaire) {
                    String url = aparser.getValue("questionnaire");
                    if (url != null) {
                        Console.debug("Starting questionnaire url at " + url);
                        this.desktop.checkForQuestionnaire(url);
                        Console.outPrintln("CMD questionnaire[-" + url + "] executed successfully!");
                    } else if (Cache.getProperty("NOQUESTIONNAIRES") == null) {
                        String defurl = "https://www.jalview.org/cgi-bin/questionnaire.pl";
                        Console.debug("Starting questionnaire with default url: " + defurl);
                        this.desktop.checkForQuestionnaire(defurl);
                    }
                } else {
                    Console.outPrintln("CMD [-noquestionnaire] executed successfully!");
                    Jalview.testoutput(this.argparser, Arg.QUESTIONNAIRE);
                }
                if (!aparser.contains("nonews") && Cache.getProperty("NONEWS") == null && !"false".equals(this.bootstrapArgs.getValue(Arg.NEWS)) || "true".equals(this.bootstrapArgs.getValue(Arg.NEWS))) {
                    this.desktop.checkForNews();
                }
                if (!aparser.contains("nohtmltemplates") && Cache.getProperty("NOHTMLTEMPLATES") == null) {
                    BioJsHTMLOutput.updateBioJS();
                }
            }
        } else {
            if (this.getArgParser().isMixedStyle()) {
                String string6 = MessageManager.formatMessage("warning.using_mixed_command_line_arguments", this.getArgParser().getMixedExamples());
                Console.warn(string6);
                Jalview.exit("Exiting due to mixed old and new command line arguments", ExitCode.INVALID_ARGUMENT);
            }
            if (this.getArgParser().isOldStyle()) {
                String string7 = MessageManager.getString("warning.using_old_command_line_arguments").replace("\n", " ") + "https://www.jalview.org/help/html/features/commandline.html";
                Console.warn(string7);
            }
        }
        this.cmds = new Commands(this.argparser, headlessArg);
        this.cmds.processArgs();
        boolean bl3 = this.cmds.argsWereParsed();
        if (bl3) {
            if (headlessArg) {
                if (this.argparser.getBoolean(Arg.NOQUIT)) {
                    Console.warn("Completed " + Arg.HEADLESS.getName() + " commands, but " + Arg.NOQUIT + " is set so not quitting!");
                } else {
                    Jalview.exit("Successfully completed commands in headless mode", ExitCode.OK);
                }
            }
            Console.info("Successfully completed commands");
        } else {
            if (headlessArg) {
                Jalview.exit("Error when running Commands in headless mode", ExitCode.ERROR_RUNNING_COMMANDS);
            }
            Console.warn("Error when running commands");
        }
        if (headless && !Platform.isJS() && !LaunchUtils.checkJavaVersion()) {
            Console.warn("The Java version being used (Java " + LaunchUtils.getJavaVersion() + ") may lead to problems. This installation of Jalview should be used with Java " + LaunchUtils.getJavaCompileVersion() + ".");
        }
        String file = null;
        String data = null;
        FileFormatI format = null;
        DataSourceType protocol = null;
        FileLoader fileLoader = new FileLoader(!headless);
        String groovyscript = null;
        groovyscript = aparser.getValue("groovy", true);
        file = aparser.getValue("open", true);
        if (file == null && this.desktop == null && !bl3) {
            Jalview.exit("No files to open!", ExitCode.NO_FILES);
        }
        long progress = -1L;
        if (file != null) {
            if (!headless) {
                progress = System.currentTimeMillis();
                this.desktop.setProgressBar(MessageManager.getString("status.processing_commandline_args"), progress);
            }
            Console.outPrintln("CMD [-open " + file + "] executed successfully!");
            if (!(Platform.isJS() || HttpUtils.startsWithHttpOrHttps(file) || new File(file).exists())) {
                if (headless) {
                    Jalview.exit("Can't find file '" + file + "' in headless mode", ExitCode.FILE_NOT_FOUND);
                }
                Console.warn("Can't find file'" + file + "'");
            }
            protocol = AppletFormatAdapter.checkProtocol(file);
            try {
                format = new IdentifyFile().identify(file, protocol);
            }
            catch (FileNotFoundException e4) {
                Console.error("File at '" + file + "' not found", e4);
            }
            catch (FileFormatException e5) {
                Console.error("File '" + file + "' format not recognised", e5);
            }
            AlignFrame af = fileLoader.LoadFileWaitTillLoaded(file, protocol, format);
            if (af == null) {
                Console.outPrintln("error");
            } else {
                this.setCurrentAlignFrame(af);
                data = aparser.getValue("colour", true);
                if (data != null) {
                    data.replaceAll("%20", " ");
                    ColourSchemeI cs = ColourSchemeProperty.getColourScheme(af.getViewport(), af.getViewport().getAlignment(), data);
                    if (cs != null) {
                        Console.outPrintln("CMD [-colour " + data + "] executed successfully!");
                    }
                    af.changeColour(cs);
                }
                if ((data = aparser.getValue("groups", true)) != null) {
                    af.parseFeaturesFile(data, AppletFormatAdapter.checkProtocol(data));
                    Console.outPrintln("CMD groups[-" + data + "]  executed successfully!");
                }
                if ((data = aparser.getValue("features", true)) != null) {
                    af.parseFeaturesFile(data, AppletFormatAdapter.checkProtocol(data));
                    Console.outPrintln("CMD [-features " + data + "]  executed successfully!");
                }
                if ((data = aparser.getValue("annotations", true)) != null) {
                    af.loadJalviewDataFile(data, null, null, null);
                    Console.outPrintln("CMD [-annotations " + data + "] executed successfully!");
                }
                if (aparser.contains("sortbytree")) {
                    af.getViewport().setSortByTree(true);
                    if (af.getViewport().getSortByTree()) {
                        Console.outPrintln("CMD [-sortbytree] executed successfully!");
                    }
                }
                if (aparser.contains("no-annotation")) {
                    af.getViewport().setShowAnnotation(false);
                    if (!af.getViewport().isShowAnnotation()) {
                        Console.outPrintln("CMD no-annotation executed successfully!");
                    }
                }
                if (aparser.contains("nosortbytree")) {
                    af.getViewport().setSortByTree(false);
                    if (!af.getViewport().getSortByTree()) {
                        Console.outPrintln("CMD [-nosortbytree] executed successfully!");
                    }
                }
                if ((data = aparser.getValue("tree", true)) != null) {
                    try {
                        Console.outPrintln("CMD [-tree " + data + "] executed successfully!");
                        NewickFile nf = new NewickFile(data, AppletFormatAdapter.checkProtocol(data));
                        af.getViewport().setCurrentTree(af.showNewickTree(nf, data).getTree());
                    }
                    catch (IOException ex) {
                        Console.errPrintln("Couldn't add tree " + data);
                        ex.printStackTrace(System.err);
                    }
                }
                if (groovyscript != null) {
                    Console.outPrintln("Executing script " + groovyscript);
                    this.executeGroovyScript(groovyscript, af);
                    Console.outPrintln("CMD groovy[" + groovyscript + "] executed successfully!");
                    groovyscript = null;
                }
                String imageName = "unnamed.png";
                while (aparser.getSize() > 1) {
                    try {
                        File imageFile;
                        String outputFormat = aparser.nextValue();
                        file = aparser.nextValue();
                        if (outputFormat.equalsIgnoreCase("png")) {
                            Console.outPrintln("Creating PNG image: " + file);
                            af.createPNG(new File(file));
                            imageName = new File(file).getName();
                            continue;
                        }
                        if (outputFormat.equalsIgnoreCase("svg")) {
                            Console.outPrintln("Creating SVG image: " + file);
                            imageFile = new File(file);
                            imageName = imageFile.getName();
                            af.createSVG(imageFile);
                            continue;
                        }
                        if (outputFormat.equalsIgnoreCase("html")) {
                            imageFile = new File(file);
                            imageName = imageFile.getName();
                            HtmlSvgOutput htmlSVG = new HtmlSvgOutput(af.alignPanel);
                            Console.outPrintln("Creating HTML image: " + file);
                            htmlSVG.exportHTML(file);
                            continue;
                        }
                        if (outputFormat.equalsIgnoreCase("biojsmsa")) {
                            if (file == null) {
                                Console.errPrintln("The output html file must not be null");
                                return;
                            }
                            try {
                                BioJsHTMLOutput.refreshVersionInfo(BioJsHTMLOutput.BJS_TEMPLATES_LOCAL_DIRECTORY);
                            }
                            catch (URISyntaxException e6) {
                                e6.printStackTrace();
                            }
                            BioJsHTMLOutput bjs = new BioJsHTMLOutput(af.alignPanel);
                            Console.outPrintln("Creating BioJS MSA Viwer HTML file: " + file);
                            bjs.exportHTML(file);
                            continue;
                        }
                        if (outputFormat.equalsIgnoreCase("imgMap")) {
                            Console.outPrintln("Creating image map: " + file);
                            af.createImageMap(new File(file), imageName);
                            continue;
                        }
                        if (outputFormat.equalsIgnoreCase("eps")) {
                            File outputFile = new File(file);
                            Console.outPrintln("Creating EPS file: " + outputFile.getAbsolutePath());
                            af.createEPS(outputFile);
                            continue;
                        }
                        FileFormatI outFormat = null;
                        try {
                            outFormat = FileFormats.getInstance().forName(outputFormat);
                        }
                        catch (Exception formatP) {
                            Console.outPrintln("Couldn't parse " + outFormat + " as a valid Jalview format string.");
                        }
                        if (outFormat == null) continue;
                        if (!outFormat.isWritable()) {
                            Console.outPrintln("This version of Jalview does not support alignment export as " + outputFormat);
                            continue;
                        }
                        af.saveAlignment(file, outFormat);
                        if (af.isSaveAlignmentSuccessful()) {
                            Console.outPrintln("Written alignment in " + outFormat.getName() + " format to " + file);
                            continue;
                        }
                        Console.outPrintln("Error writing file " + file + " in " + outFormat.getName() + " format!!");
                    }
                    catch (ImageOutputException ioexc) {
                        Console.outPrintln("Unexpected error whilst exporting image to " + file);
                        ioexc.printStackTrace();
                    }
                }
                while (aparser.getSize() > 0) {
                    Console.outPrintln("Unknown arg: " + aparser.nextValue());
                }
            }
        }
        AlignFrame startUpAlframe = null;
        if (!(Platform.isJS() || headless || file != null || !Cache.getDefault("SHOW_STARTUP_FILE", true) || this.cmds.commandArgsProvided() || this.bootstrapArgs.getBoolean(Arg.NOSTARTUPFILE))) {
            file = Cache.getDefault("STARTUP_FILE", Cache.getDefault("www.jalview.org", "https://www.jalview.org") + "/examples/exampleFile_2_7.jvp");
            if (file.equals("http://www.jalview.org/examples/exampleFile_2_3.jar") || file.equals("http://www.jalview.org/examples/exampleFile_2_7.jar")) {
                file.replace("http:", "https:");
                file.replace("_2_3", "_2_7");
                file.replace("2_7.jar", "2_7.jvp");
                Cache.removeProperty("STARTUP_FILE");
            }
            protocol = AppletFormatAdapter.checkProtocol(file);
            if (file.endsWith(".jar")) {
                format = FileFormat.Jalview;
            } else {
                try {
                    format = new IdentifyFile().identify(file, protocol);
                }
                catch (FileNotFoundException e7) {
                    Console.error("File at '" + file + "' not found", e7);
                }
                catch (FileFormatException e8) {
                    Console.error("File '" + file + "' format not recognised", e8);
                }
            }
            startUpAlframe = fileLoader.LoadFileWaitTillLoaded(file, protocol, format);
            Console.debug("Resetting up-to-date flag for startup file");
            startUpAlframe.getViewport().setSavedUpToDate(true);
        }
        if (groovyscript != null) {
            if (Cache.groovyJarsPresent()) {
                Console.outPrintln("Executing script " + groovyscript);
                this.executeGroovyScript(groovyscript, startUpAlframe);
            } else {
                Console.errPrintln("Sorry. Groovy Support is not available, so ignoring the provided groovy script " + groovyscript);
            }
        }
        if (this.desktop != null) {
            if (progress != -1L) {
                this.desktop.setProgressBar(null, progress);
            }
            this.desktop.setInBatchMode(false);
        }
        this.cliWarning();
    }

    private static void setLookAndFeel() {
        if (!Platform.isJS()) {
            String lafProp = System.getProperty("laf");
            String lafSetting = Cache.getDefault("PREFERRED_LAF", null);
            String laf = "none";
            if (lafProp != null) {
                laf = lafProp;
            } else if (lafSetting != null) {
                laf = lafSetting;
            }
            boolean lafSet = false;
            switch (laf) {
                case "crossplatform": {
                    lafSet = Jalview.setCrossPlatformLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "system": {
                    lafSet = Jalview.setSystemLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "gtk": {
                    lafSet = Jalview.setGtkLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "metal": {
                    lafSet = Jalview.setMetalLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "nimbus": {
                    lafSet = Jalview.setNimbusLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "flat": {
                    lafSet = Jalview.setFlatLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "mac": {
                    lafSet = Jalview.setMacLookAndFeel();
                    if (lafSet) break;
                    Console.error("Could not set requested laf=" + laf);
                    break;
                }
                case "none": {
                    break;
                }
                default: {
                    Console.error("Requested laf=" + laf + " not implemented");
                }
            }
            if (!lafSet) {
                lafSet = Jalview.setFlatLookAndFeel();
                if (!lafSet) {
                    Jalview.setSystemLookAndFeel();
                }
                if (Platform.isLinux()) {
                    Jalview.setLinuxLookAndFeel();
                }
                if (Platform.isMac()) {
                    Jalview.setMacLookAndFeel();
                }
            }
        }
    }

    private static boolean setCrossPlatformLookAndFeel() {
        boolean set = false;
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            set = true;
        }
        catch (Exception ex) {
            Console.error("Unexpected Look and Feel Exception");
            Console.error(ex.getMessage());
            Console.debug(Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setSystemLookAndFeel() {
        boolean set = false;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            set = true;
        }
        catch (Exception ex) {
            Console.error("Unexpected Look and Feel Exception");
            Console.error(ex.getMessage());
            Console.debug(Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setSpecificLookAndFeel(String name, String className, boolean nameStartsWith) {
        boolean set = false;
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!(info.getName() != null && nameStartsWith ? info.getName().toLowerCase(Locale.ROOT).startsWith(name.toLowerCase(Locale.ROOT)) : info.getName().toLowerCase(Locale.ROOT).equals(name.toLowerCase(Locale.ROOT)))) continue;
                className = info.getClassName();
                break;
            }
            UIManager.setLookAndFeel(className);
            set = true;
        }
        catch (Exception ex) {
            Console.error("Unexpected Look and Feel Exception");
            Console.error(ex.getMessage());
            Console.debug(Cache.getStackTraceString(ex));
        }
        return set;
    }

    private static boolean setGtkLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("gtk", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", true);
    }

    private static boolean setMetalLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("metal", "javax.swing.plaf.metal.MetalLookAndFeel", false);
    }

    private static boolean setNimbusLookAndFeel() {
        return Jalview.setSpecificLookAndFeel("nimbus", "javax.swing.plaf.nimbus.NimbusLookAndFeel", false);
    }

    private static boolean setFlatLookAndFeel() {
        boolean set = false;
        if (SystemInfo.isMacOS) {
            try {
                UIManager.setLookAndFeel("com.formdev.flatlaf.themes.FlatMacLightLaf");
                set = true;
                Console.debug("Using FlatMacLightLaf");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                Console.debug("Exception loading FlatLightLaf", e);
            }
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.application.name", ChannelProperties.getProperty("app_name"));
            System.setProperty("apple.awt.application.appearance", "system");
            if (SystemInfo.isMacFullWindowContentSupported && Desktop.desktop != null) {
                Console.debug("Setting transparent title bar");
                Desktop.desktop.getRootPane().putClientProperty("apple.awt.fullWindowContent", true);
                Desktop.desktop.getRootPane().putClientProperty("apple.awt.transparentTitleBar", true);
                Desktop.desktop.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
            }
            SwingUtilities.invokeLater(() -> FlatMacLightLaf.setup());
            Console.debug("Using FlatMacLightLaf");
            set = true;
        }
        if (!set) {
            try {
                UIManager.setLookAndFeel("com.formdev.flatlaf.FlatLightLaf");
                set = true;
                Console.debug("Using FlatLightLaf");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                Console.debug("Exception loading FlatLightLaf", e);
            }
            SwingUtilities.invokeLater(() -> FlatLightLaf.setup());
            Console.debug("Using FlatLightLaf");
            set = true;
        } else if (SystemInfo.isLinux) {
            try {
                UIManager.setLookAndFeel("com.formdev.flatlaf.FlatLightLaf");
                set = true;
                Console.debug("Using FlatLightLaf");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                Console.debug("Exception loading FlatLightLaf", e);
            }
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            SwingUtilities.invokeLater(() -> FlatLightLaf.setup());
            Console.debug("Using FlatLightLaf");
            set = true;
        }
        if (!set) {
            try {
                UIManager.setLookAndFeel("com.formdev.flatlaf.FlatLightLaf");
                set = true;
                Console.debug("Using FlatLightLaf");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                Console.debug("Exception loading FlatLightLaf", e);
            }
        }
        if (set) {
            UIManager.put("TabbedPane.tabType", "card");
            UIManager.put("TabbedPane.showTabSeparators", true);
            UIManager.put("TabbedPane.showContentSeparator", true);
            UIManager.put("TabbedPane.tabsOverlapBorder", true);
            UIManager.put("TabbedPane.hasFullBorder", true);
            UIManager.put("TabbedPane.tabLayoutPolicy", "scroll");
            UIManager.put("TabbedPane.scrollButtonsPolicy", "asNeeded");
            UIManager.put("TabbedPane.smoothScrolling", true);
            UIManager.put("TabbedPane.tabWidthMode", "compact");
            UIManager.put("TabbedPane.selectedBackground", Color.white);
            UIManager.put("TabbedPane.background", new Color(236, 236, 236));
            UIManager.put("TabbedPane.hoverColor", Color.lightGray);
        }
        Desktop.setLiveDragMode(Cache.getDefault("FLAT_LIVE_DRAG_MODE", true));
        return set;
    }

    private static boolean setMacLookAndFeel() {
        boolean set = false;
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", ChannelProperties.getProperty("app_name"));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        set = Jalview.setFlatLookAndFeel();
        return set;
    }

    private static boolean setLinuxLookAndFeel() {
        boolean set = false;
        set = Jalview.setFlatLookAndFeel();
        if (!set) {
            set = Jalview.setMetalLookAndFeel();
        }
        if (!set) {
            set = Jalview.setNimbusLookAndFeel();
        }
        return set;
    }

    private static void startUsageStats(Desktop desktop) {
        PromptUserConfig prompter = new PromptUserConfig(Desktop.desktop, "USAGESTATS", MessageManager.getString("prompt.analytics_title"), MessageManager.getString("prompt.analytics"), new Runnable(){

            @Override
            public void run() {
                Console.debug("Initialising analytics for usage stats.");
                Cache.initAnalytics();
                Console.debug("Tracking enabled.");
            }
        }, new Runnable(){

            @Override
            public void run() {
                Console.debug("Not enabling analytics.");
            }
        }, null, true);
        desktop.addDialogThread(prompter);
    }

    protected void executeGroovyScript(String groovyscript, AlignFrame af) {
        File tfile = null;
        URL sfile = null;
        if (groovyscript.trim().equals("STDIN")) {
            try {
                tfile = File.createTempFile("jalview", "groovy");
                PrintWriter outfile = new PrintWriter(new OutputStreamWriter(new FileOutputStream(tfile)));
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String line = null;
                while ((line = br.readLine()) != null) {
                    outfile.write(line + "\n");
                }
                br.close();
                outfile.flush();
                outfile.close();
            }
            catch (Exception ex) {
                Console.errPrintln("Failed to read from STDIN into tempfile " + (tfile == null ? "(tempfile wasn't created)" : tfile.toString()));
                ex.printStackTrace();
                return;
            }
            try {
                sfile = tfile.toURI().toURL();
            }
            catch (Exception x) {
                Console.errPrintln("Unexpected Malformed URL Exception for temporary file created from STDIN: " + tfile.toURI());
                x.printStackTrace();
                return;
            }
        }
        try {
            sfile = new URI(groovyscript).toURL();
        }
        catch (Exception x) {
            tfile = new File(groovyscript);
            if (!tfile.exists()) {
                Console.errPrintln("File '" + groovyscript + "' does not exist.");
                return;
            }
            if (!tfile.canRead()) {
                Console.errPrintln("File '" + groovyscript + "' cannot be read.");
                return;
            }
            if (tfile.length() < 1L) {
                Console.errPrintln("File '" + groovyscript + "' is empty.");
                return;
            }
            try {
                sfile = tfile.getAbsoluteFile().toURI().toURL();
            }
            catch (Exception ex) {
                Console.errPrintln("Failed to create a file URL for " + tfile.getAbsoluteFile());
                return;
            }
        }
        try {
            JalviewObject j = new JalviewObject(this);
            HashMap<String, Object> vbinding = new HashMap<String, Object>();
            vbinding.put("Jalview", j);
            vbinding.put("currentAlFrame", af != null ? af : this.getCurrentAlignFrame());
            Binding gbinding = new Binding(vbinding);
            GroovyScriptEngine gse = new GroovyScriptEngine(new URL[]{sfile});
            gse.run(sfile.toString(), gbinding);
            if ("STDIN".equals(groovyscript)) {
                tfile.delete();
            }
        }
        catch (Exception e) {
            Console.errPrintln("Exception Whilst trying to execute file " + sfile + " as a groovy script.");
            e.printStackTrace(System.err);
        }
    }

    public static boolean isHeadlessMode() {
        String isheadless = System.getProperty("java.awt.headless");
        return isheadless != null && isheadless.equalsIgnoreCase("true");
    }

    @Override
    public AlignFrame[] getAlignFrames() {
        AlignFrame[] alignFrameArray;
        if (this.desktop == null) {
            AlignFrame[] alignFrameArray2 = new AlignFrame[1];
            alignFrameArray = alignFrameArray2;
            alignFrameArray2[0] = this.getCurrentAlignFrame();
        } else {
            alignFrameArray = Desktop.getDesktopAlignFrames();
        }
        return alignFrameArray;
    }

    @Override
    public void quit() {
        Jalview.exit("Quitting now. Bye!", ExitCode.OK);
    }

    @Override
    public AlignFrame getCurrentAlignFrame() {
        return this.currentAlignFrame;
    }

    public void setCurrentAlignFrame(AlignFrame af) {
        this.currentAlignFrame = af;
    }

    public Commands getCommands() {
        return this.cmds;
    }

    public static void exit(String message, ExitCode ec) {
        int exitcode;
        int n = exitcode = ec == ExitCode.OK ? 0 : ec.ordinal() + 1;
        if (Console.log == null) {
            if (message != null) {
                if (exitcode == 0) {
                    Console.outPrintln(message);
                } else {
                    Console.errPrintln(message);
                }
            }
        } else {
            Console.debug("Using Jalview.exit");
            if (message != null) {
                if (exitcode == 0) {
                    Console.info(message);
                } else {
                    Console.error(message);
                }
            }
        }
        if (exitcode > -1) {
            System.exit(exitcode);
        }
    }

    protected static void testoutput(ArgParser ap, Arg a, String s1, String s2) {
        boolean isset;
        BootstrapArgs bsa = ap.getBootstrapArgs();
        if (!bsa.getBoolean(Arg.TESTOUTPUT)) {
            return;
        }
        if (!(s1 == null && s2 == null || s1 != null && s1.equals(s2))) {
            Console.debug("testoutput with unmatching values '" + s1 + "' and '" + s2 + "' for arg " + a.argString());
            return;
        }
        boolean bl = isset = a.hasOption(Arg.Opt.BOOTSTRAP) ? bsa.contains(a) : ap.isSet(a);
        if (!isset) {
            Console.warn("Arg '" + a.getName() + "' not set at all");
            return;
        }
        Jalview.testoutput(true, a, s1, s2);
    }

    protected static void testoutput(BootstrapArgs bsa, Arg a, String s1, String s2) {
        if (!bsa.getBoolean(Arg.TESTOUTPUT)) {
            return;
        }
        if (!(s1 == null && s2 == null || s1 != null && s1.equals(s2))) {
            Console.debug("testoutput with unmatching values '" + s1 + "' and '" + s2 + "' for arg " + a.argString());
            return;
        }
        if (!a.hasOption(Arg.Opt.BOOTSTRAP)) {
            Console.error("Non-bootstrap Arg '" + a.getName() + "' given to testoutput(BootstrapArgs bsa, Arg a, String s1, String s2) with only BootstrapArgs");
        }
        if (!bsa.contains(a)) {
            Console.warn("Arg '" + a.getName() + "' not set at all");
            return;
        }
        Jalview.testoutput(true, a, s1, s2);
    }

    private static void testoutput(boolean yes, Arg a, String s1, String s2) {
        if (yes && (s1 == null && s2 == null || s1 != null && s1.equals(s2))) {
            Console.outPrintln("[TESTOUTPUT] arg " + a.argString() + "='" + s1 + "' was set");
        }
    }

    protected static void testoutput(ArgParser ap, Arg a) {
        boolean isset;
        if (ap == null) {
            return;
        }
        BootstrapArgs bsa = ap.getBootstrapArgs();
        if (bsa == null) {
            return;
        }
        if (!bsa.getBoolean(Arg.TESTOUTPUT)) {
            return;
        }
        boolean val = a.hasOption(Arg.Opt.BOOTSTRAP) ? bsa.getBoolean(a) : ap.getBoolean(a);
        boolean bl = isset = a.hasOption(Arg.Opt.BOOTSTRAP) ? bsa.contains(a) : ap.isSet(a);
        if (!isset) {
            Console.warn("Arg '" + a.getName() + "' not set at all");
            return;
        }
        Jalview.testoutput(val, a);
    }

    protected static void testoutput(BootstrapArgs bsa, Arg a) {
        if (!bsa.getBoolean(Arg.TESTOUTPUT)) {
            return;
        }
        if (!a.hasOption(Arg.Opt.BOOTSTRAP)) {
            Console.warn("Non-bootstrap Arg '" + a.getName() + "' given to testoutput(BootstrapArgs bsa, Arg a) with only BootstrapArgs");
        }
        if (!bsa.contains(a)) {
            Console.warn("Arg '" + a.getName() + "' not set at all");
            return;
        }
        Jalview.testoutput(bsa.getBoolean(a), a);
    }

    private static void testoutput(boolean yes, Arg a) {
        String message = null;
        if (a.hasOption(Arg.Opt.BOOLEAN)) {
            message = (yes ? a.argString() : a.negateArgString()) + " was set";
        } else if (a.hasOption(Arg.Opt.UNARY)) {
            message = a.argString() + (yes ? " was set" : " was not set");
        }
        Console.outPrintln("[TESTOUTPUT] arg " + message);
    }

    public ArgParser getArgParser() {
        return this.argparser;
    }

    public BootstrapArgs getBootstrapArgs() {
        return this.bootstrapArgs;
    }

    public static boolean isBatchMode() {
        return Jalview.getInstance() != null && (Jalview.getInstance().desktop == null || Jalview.getInstance().desktop.isInBatchMode());
    }

    private void mixedCliWarning() {
        Jalview j = Jalview.getInstance();
        boolean mixedStyle = j.getArgParser() != null && j.getArgParser().isMixedStyle();
        String title = MessageManager.getString("label.command_line_arguments");
        if (mixedStyle) {
            String warning = MessageManager.formatMessage("warning.using_mixed_command_line_arguments", j.getArgParser().getMixedExamples());
            String quit = MessageManager.getString("action.quit");
            Desktop.instance.nonBlockingDialog(title, warning, null, quit, 2, false, false, true, 30000);
            Jalview.exit("Exiting due to mixed old and new command line arguments.", ExitCode.MIXED_CLI_ARGUMENTS);
        }
    }

    private void cliWarning() {
        Jalview j = Jalview.getInstance();
        Commands c = j.getCommands();
        boolean oldStyle = j.getArgParser() != null && j.getArgParser().isOldStyle();
        String title = MessageManager.getString("label.command_line_arguments");
        if (oldStyle) {
            String warning = MessageManager.getString("warning.using_old_command_line_arguments");
            String url = "<a href=\"https://www.jalview.org/help/html/features/commandline.html\">https://www.jalview.org/help/html/features/commandline.html</a>";
            if (Desktop.instance != null) {
                String cont = MessageManager.getString("label.continue");
                Desktop.instance.nonBlockingDialog(title, warning, url, cont, 2, false, true, true, 30000);
            }
        }
        if (j.getCommands() != null && j.getCommands().getErrors().size() > 0 && Desktop.instance != null) {
            String message = MessageManager.getString("warning.the_following_errors");
            String ok = MessageManager.getString("action.ok");
            int shortest = 60;
            List<String> errors = j.getCommands().getErrors();
            for (int i = 0; i < errors.size(); ++i) {
                shortest = Math.min(shortest, errors.get(i).length());
            }
            Desktop.instance.nonBlockingDialog(Math.max(message.length(), Math.min(60, shortest)), Math.min(errors.size(), 20), title, message, j.getCommands().errorsToString(), ok, 2, true, false, true, -1);
        }
    }

    static {
        Platform.getURLCommandArguments();
        Platform.addJ2SDirectDatabaseCall("https://www.jalview.org");
        Platform.addJ2SDirectDatabaseCall("http://www.jalview.org");
        Platform.addJ2SDirectDatabaseCall("http://www.compbio.dundee.ac.uk");
        Platform.addJ2SDirectDatabaseCall("https://www.compbio.dundee.ac.uk");
        if (!Platform.isJS()) {
            Policy.setPolicy(new Policy(){

                @Override
                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }

                @Override
                public void refresh() {
                }
            });
        }
    }

    public static enum ExitCode {
        OK,
        FILE_NOT_FOUND,
        FILE_NOT_READABLE,
        NO_FILES,
        INVALID_FORMAT,
        INVALID_ARGUMENT,
        INVALID_VALUE,
        MIXED_CLI_ARGUMENTS,
        ERROR_RUNNING_COMMANDS,
        NO_LOGGING,
        GROOVY_ERROR;

    }

    class FeatureFetcher {
        private int queued = 0;
        private int running = 0;

        public void addFetcher(final AlignFrame af, Vector<String> dasSources) {
            final long id = System.currentTimeMillis();
            ++this.queued;
            final FeatureFetcher us = this;
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FeatureFetcher featureFetcher = us;
                    synchronized (featureFetcher) {
                        --FeatureFetcher.this.queued;
                        ++FeatureFetcher.this.running;
                    }
                    af.setProgressBar(MessageManager.getString("status.das_features_being_retrived"), id);
                    af.featureSettings_actionPerformed(null);
                    af.setProgressBar(null, id);
                    featureFetcher = us;
                    synchronized (featureFetcher) {
                        --FeatureFetcher.this.running;
                    }
                }
            }).start();
        }

        public synchronized boolean allFinished() {
            return this.queued == 0 && this.running == 0;
        }
    }
}

