/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.OverviewCanvas;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.OverviewDimensions;
import jalview.viewmodel.OverviewDimensionsHideHidden;
import jalview.viewmodel.OverviewDimensionsShowHidden;
import jalview.viewmodel.ViewportListenerI;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;

public class OverviewPanel
extends Panel
implements Runnable,
MouseMotionListener,
MouseListener,
ViewportListenerI {
    private OverviewDimensions od;
    private OverviewCanvas oviewCanvas;
    private AlignViewport av;
    private AlignmentPanel ap;
    private boolean showHidden = true;
    private boolean updateRunning = false;
    private boolean draggingBox = false;

    public OverviewPanel(AlignmentPanel alPanel) {
        this.av = alPanel.av;
        this.ap = alPanel;
        this.setLayout(null);
        this.od = new OverviewDimensionsShowHidden(this.av.getRanges(), this.av.isShowAnnotation() && this.av.getSequenceConsensusHash() != null);
        this.oviewCanvas = new OverviewCanvas(this.od, this.av);
        this.setLayout(new BorderLayout());
        this.add((Component)this.oviewCanvas, "Center");
        this.setSize(new Dimension(this.od.getWidth(), this.od.getHeight()));
        this.av.getRanges().addPropertyChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (OverviewPanel.this.getWidth() != OverviewPanel.this.od.getWidth() || OverviewPanel.this.getHeight() != OverviewPanel.this.od.getHeight()) {
                    OverviewPanel.this.updateOverviewImage();
                }
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.updateOverviewImage();
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if ((evt.getModifiersEx() & 0x1000) == 4096) {
            this.showPopupMenu(evt);
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        if (this.od.isPositionInBox(evt.getX(), evt.getY())) {
            this.getParent().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.getParent().setCursor(Cursor.getPredefinedCursor(1));
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if ((evt.getModifiersEx() & 0x1000) == 4096) {
            if (!Platform.isMac()) {
                this.showPopupMenu(evt);
            }
        } else if (!this.od.isPositionInBox(evt.getX(), evt.getY())) {
            this.draggingBox = false;
            this.setCursor(Cursor.getPredefinedCursor(13));
            this.od.updateViewportFromMouse(evt.getX(), evt.getY(), this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
            this.getParent().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.draggingBox = true;
            this.od.setDragPoint(evt.getX(), evt.getY(), this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.draggingBox = false;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (Platform.isWinRightButton(evt)) {
            this.showPopupMenu(evt);
            return;
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            return;
        }
        if (this.draggingBox) {
            this.od.adjustViewportFromMouse(evt.getX(), evt.getY(), this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
        } else {
            this.od.updateViewportFromMouse(evt.getX(), evt.getY(), this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
        }
        this.ap.paintAlignment(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOverviewImage() {
        if (this.oviewCanvas == null) {
            return;
        }
        if (this.getSize().width > 0 && this.getSize().height > 0) {
            this.od.setWidth(this.getSize().width);
            this.od.setHeight(this.getSize().height);
        }
        this.setSize(new Dimension(this.od.getWidth(), this.od.getHeight()));
        OverviewPanel overviewPanel = this;
        synchronized (overviewPanel) {
            if (this.updateRunning) {
                this.oviewCanvas.restartDraw();
                return;
            }
            this.updateRunning = true;
        }
        Thread thread = new Thread(this);
        thread.start();
        this.repaint();
        this.updateRunning = false;
    }

    @Override
    public void run() {
        this.oviewCanvas.draw(this.av.isShowSequenceFeatures(), this.av.isShowAnnotation() && this.av.getAlignmentConservationAnnotation() != null, this.ap.seqPanel.seqCanvas.getFeatureRenderer());
        this.setBoxPosition();
    }

    private void setBoxPosition() {
        this.od.setBoxPosition(this.av.getAlignment().getHiddenSequences(), this.av.getAlignment().getHiddenColumns());
        this.repaint();
    }

    private void showPopupMenu(MouseEvent e) {
        PopupMenu popup = new PopupMenu();
        ItemListener menuListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OverviewPanel.this.toggleHiddenColumns();
            }
        };
        CheckboxMenuItem item = new CheckboxMenuItem(MessageManager.getString("label.togglehidden"));
        item.setState(this.showHidden);
        popup.add(item);
        item.addItemListener(menuListener);
        this.add(popup);
        popup.show(this, e.getX(), e.getY());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setBoxPosition();
    }

    private void toggleHiddenColumns() {
        if (this.showHidden) {
            this.showHidden = false;
            this.od = new OverviewDimensionsHideHidden(this.av.getRanges(), this.av.isShowAnnotation() && this.av.getAlignmentConservationAnnotation() != null);
        } else {
            this.showHidden = true;
            this.od = new OverviewDimensionsShowHidden(this.av.getRanges(), this.av.isShowAnnotation() && this.av.getAlignmentConservationAnnotation() != null);
        }
        this.oviewCanvas.resetOviewDims(this.od);
        this.updateOverviewImage();
    }

    protected void dispose() {
        try {
            this.av.getRanges().removePropertyChangeListener(this);
            Frame parent = (Frame)this.getParent();
            parent.dispose();
            parent.setVisible(false);
        }
        finally {
            this.av = null;
            if (this.oviewCanvas != null) {
                this.oviewCanvas.dispose();
            }
            this.oviewCanvas = null;
            this.ap = null;
            this.od = null;
        }
    }
}

