/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimUtils;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraChain;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraStructuralObject;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;

public class ChimeraModel
implements ChimeraStructuralObject {
    private String name;
    private StructureManager.ModelType type;
    private int modelNumber;
    private int subModelNumber;
    private Color modelColor = null;
    private Object userData = null;
    private boolean selected = false;
    private TreeMap<String, ChimeraChain> chainMap;
    private HashSet<ChimeraResidue> funcResidues;

    public ChimeraModel(String name, StructureManager.ModelType type, int modelNumber, int subModelNumber) {
        this.name = name;
        this.type = type;
        this.modelNumber = modelNumber;
        this.subModelNumber = subModelNumber;
        this.chainMap = new TreeMap();
        this.funcResidues = new HashSet();
    }

    public ChimeraModel(String inputLine) {
        this.name = ChimUtils.parseModelName(inputLine);
        this.type = this.name.startsWith("smiles") ? StructureManager.ModelType.SMILES : StructureManager.ModelType.PDB_MODEL;
        this.modelNumber = ChimUtils.parseModelNumber(inputLine)[0];
        this.subModelNumber = ChimUtils.parseModelNumber(inputLine)[1];
        this.chainMap = new TreeMap();
        this.funcResidues = new HashSet();
    }

    public void addResidue(ChimeraResidue residue) {
        residue.setChimeraModel(this);
        String chainId = residue.getChainId();
        if (chainId != null) {
            this.addResidue(chainId, residue);
        } else {
            this.addResidue("_", residue);
        }
    }

    public void addResidue(String chainId, ChimeraResidue residue) {
        ChimeraChain chain = null;
        if (!this.chainMap.containsKey(chainId)) {
            chain = new ChimeraChain(this.modelNumber, this.subModelNumber, chainId);
            chain.setChimeraModel(this);
            this.chainMap.put(chainId, chain);
        } else {
            chain = this.chainMap.get(chainId);
        }
        chain.addResidue(residue);
    }

    @Override
    public ChimeraModel getChimeraModel() {
        return this;
    }

    public Color getModelColor() {
        return this.modelColor;
    }

    public void setModelColor(Color color) {
        this.modelColor = color;
    }

    public String getModelName() {
        return this.name;
    }

    public void setModelName(String name) {
        this.name = name;
    }

    public int getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(int modelNumber) {
        this.modelNumber = modelNumber;
    }

    public int getSubModelNumber() {
        return this.subModelNumber;
    }

    public void setSubModelNumber(int subModelNumber) {
        this.subModelNumber = subModelNumber;
    }

    public StructureManager.ModelType getModelType() {
        return this.type;
    }

    public void setModelType(StructureManager.ModelType type) {
        this.type = type;
    }

    public HashSet<ChimeraResidue> getFuncResidues() {
        return this.funcResidues;
    }

    public void setFuncResidues(List<String> residues) {
        for (String residue : residues) {
            for (ChimeraChain chain : this.getChains()) {
                if (residue.indexOf("-") > 0) {
                    this.funcResidues.addAll(chain.getResidueRange(residue));
                    continue;
                }
                this.funcResidues.add(chain.getResidue(residue));
            }
        }
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public void setUserData(Object data) {
        this.userData = data;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public List<ChimeraStructuralObject> getChildren() {
        return new ArrayList<ChimeraStructuralObject>(this.chainMap.values());
    }

    public Collection<ChimeraChain> getChains() {
        return this.chainMap.values();
    }

    public int getChainCount() {
        return this.chainMap.size();
    }

    public Collection<String> getChainNames() {
        return this.chainMap.keySet();
    }

    public Collection<ChimeraResidue> getResidues() {
        ArrayList<ChimeraResidue> residues = new ArrayList<ChimeraResidue>();
        for (ChimeraChain chain : this.getChains()) {
            residues.addAll(chain.getResidues());
        }
        return residues;
    }

    public int getResidueCount() {
        int count = 0;
        for (ChimeraChain chain : this.getChains()) {
            count += chain.getResidueCount();
        }
        return count;
    }

    public ChimeraChain getChain(String chain) {
        if (this.chainMap.containsKey(chain)) {
            return this.chainMap.get(chain);
        }
        return null;
    }

    public ChimeraResidue getResidue(String chainId, String index) {
        if (this.chainMap.containsKey(chainId)) {
            return this.chainMap.get(chainId).getResidue(index);
        }
        return null;
    }

    @Override
    public boolean hasSelectedChildren() {
        if (this.selected) {
            return true;
        }
        for (ChimeraChain chain : this.getChains()) {
            if (!chain.hasSelectedChildren()) continue;
            return true;
        }
        return false;
    }

    public List<ChimeraResidue> getSelectedResidues() {
        ArrayList<ChimeraResidue> residueList = new ArrayList<ChimeraResidue>();
        for (ChimeraChain chain : this.getChains()) {
            if (this.selected) {
                residueList.addAll(chain.getSelectedResidues());
                continue;
            }
            residueList.addAll(this.getResidues());
        }
        return residueList;
    }

    @Override
    public String toSpec() {
        if (this.subModelNumber == 0) {
            return "#" + this.modelNumber;
        }
        return "#" + this.modelNumber + "." + this.subModelNumber;
    }

    @Override
    public String toString() {
        String nodeName;
        Object modelName = "";
        modelName = this.getChainCount() > 0 ? "Model " + this.toSpec() + " " + this.name + " (" + this.getChainCount() + " chains, " + this.getResidueCount() + " residues)" : (this.getResidueCount() > 0 ? "Model " + this.toSpec() + " " + this.name + " (" + this.getResidueCount() + " residues)" : "Model " + this.toSpec() + " " + this.name);
        HashSet networkNames = new HashSet();
        HashSet nodeNames = new HashSet();
        HashSet edgeNames = new HashSet();
        Object cytoName = " [";
        if (networkNames.size() > 0) {
            if (networkNames.size() == 1) {
                cytoName = (String)cytoName + "Network {";
            } else if (networkNames.size() > 1) {
                cytoName = (String)cytoName + "Networks {";
            }
            for (String cName : networkNames) {
                cytoName = (String)cytoName + cName + ",";
            }
            cytoName = ((String)cytoName).substring(0, ((String)cytoName).length() - 1) + "}, ";
        }
        if (nodeNames.size() > 0) {
            if (nodeNames.size() == 1) {
                cytoName = (String)cytoName + "Node {";
            } else if (nodeNames.size() > 1) {
                cytoName = (String)cytoName + "Nodes {";
            }
            for (String cName : nodeNames) {
                cytoName = (String)cytoName + cName + ",";
            }
            cytoName = ((String)cytoName).substring(0, ((String)cytoName).length() - 1) + "}, ";
        }
        if (edgeNames.size() > 0) {
            if (edgeNames.size() == 1) {
                cytoName = (String)cytoName + "Edge {";
            } else if (edgeNames.size() > 1) {
                cytoName = (String)cytoName + "Edges {";
            }
            for (String cName : edgeNames) {
                cytoName = (String)cytoName + cName + ",";
            }
            cytoName = ((String)cytoName).substring(0, ((String)cytoName).length() - 1) + "}, ";
        }
        if (((String)cytoName).endsWith(", ")) {
            cytoName = ((String)cytoName).substring(0, ((String)cytoName).length() - 2);
        }
        if ((nodeName = (String)modelName + (String)(cytoName = (String)cytoName + "]")).length() > 100) {
            nodeName = nodeName.substring(0, 100) + "...";
        }
        return nodeName;
    }

    public boolean equals(Object otherChimeraModel) {
        if (!(otherChimeraModel instanceof ChimeraModel)) {
            return false;
        }
        ChimeraModel otherCM = (ChimeraModel)otherChimeraModel;
        return this.name.equals(otherCM.name) && this.modelNumber == otherCM.modelNumber && this.type == otherCM.type;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.name.hashCode();
        hashCode = hashCode * 37 + this.type.hashCode();
        hashCode = hashCode * 37 + this.modelNumber;
        return hashCode;
    }
}

