/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.utils;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.annotations.TextAnnotation;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBPStyle;
import fr.orsay.lri.varna.models.rna.ModeleBackbone;
import fr.orsay.lri.varna.models.rna.ModeleBackboneElement;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.ModeleBasesComparison;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.TreeSet;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VARNASessionParser
extends DefaultHandler {
    StringBuffer _buffer = null;
    ModeleBaseNucleotide mbn = null;
    ModeleBasesComparison mbc = null;
    ModeleBP mbp = null;
    ModeleBPStyle mbps = null;
    ModelBaseStyle msb = null;
    TextAnnotation ta = null;
    ModeleBackbone backbone = null;
    HighlightRegionAnnotation hra = null;
    RNA rna = null;
    Font f = null;
    VARNAConfig config = null;
    private TreeSet<String> _context = new TreeSet();

    public InputSource createSourceFromURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            InputStream inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            return new InputSource(inputStreamReader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new InputSource(new StringReader(""));
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new StringReader(""));
    }

    private void addToContext(String string) {
        this._context.add(string);
    }

    private void removeFromContext(String string) {
        this._context.remove(string);
    }

    private boolean contextContains(String string) {
        return this._context.contains(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!string3.equals(VARNAPanel.XML_ELEMENT_NAME)) {
            if (string3.equals(VARNAConfig.XML_ELEMENT_NAME)) {
                this.config = new VARNAConfig();
                this.config.loadFromXMLAttributes(attributes);
            } else if (string3.equals(RNA.XML_ELEMENT_NAME)) {
                this.rna = new RNA();
                int n = Integer.parseInt(attributes.getValue(RNA.XML_VAR_DRAWN_MODE_NAME));
                this.rna.setDrawMode(n);
            } else if (string3.equals(ModeleBackbone.XML_ELEMENT_NAME)) {
                this.backbone = new ModeleBackbone();
                this.rna.setBackbone(this.backbone);
            } else if (string3.equals(ModeleBackboneElement.XML_ELEMENT_NAME)) {
                if (this.backbone != null) {
                    int n = Integer.parseInt(attributes.getValue(ModeleBackboneElement.XML_VAR_INDEX_NAME));
                    ModeleBackboneElement.BackboneType backboneType = ModeleBackboneElement.BackboneType.getType(attributes.getValue(ModeleBackboneElement.XML_VAR_TYPE_NAME));
                    Color color = null;
                    if (backboneType == ModeleBackboneElement.BackboneType.CUSTOM_COLOR) {
                        color = Color.decode(attributes.getValue(TextAnnotation.XML_VAR_COLOR_NAME));
                        this.backbone.addElement(new ModeleBackboneElement(n, color));
                    } else {
                        this.backbone.addElement(new ModeleBackboneElement(n, backboneType));
                    }
                }
            } else if (string3.equals(ModeleBackbone.XML_ELEMENT_NAME)) {
                this.backbone = new ModeleBackbone();
            } else if (string3.equals(ModeleBaseNucleotide.XML_ELEMENT_NAME)) {
                if (this.rna != null) {
                    this.mbn = new ModeleBaseNucleotide(this.rna.getSize());
                    if (this.mbn.getIndex() != Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_INDEX_NAME))) {
                        throw new SAXException("Index mismatch for Base");
                    }
                    this.mbn.setBaseNumber(Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_NUMBER_NAME)));
                    this.mbn.setLabel(attributes.getValue(ModeleBase.XML_VAR_LABEL_NAME));
                    this.mbn.setColorie(Boolean.parseBoolean(attributes.getValue(ModeleBase.XML_VAR_CUSTOM_DRAWN_NAME)));
                    this.mbn.setValue(Double.parseDouble(attributes.getValue(ModeleBase.XML_VAR_VALUE_NAME)));
                    this.rna.addBase(this.mbn);
                }
            } else if (string3.equals(XMLUtils.XML_FONT_ELEMENT_NAME)) {
                this.f = XMLUtils.getFont(string3, attributes);
                if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                    this.ta.setFont(this.f);
                    this.f = null;
                } else if (this.contextContains(VARNAConfig.XML_ELEMENT_NAME)) {
                    String string4 = attributes.getValue(XMLUtils.XML_ROLE_NAME);
                    if (string4.equals(VARNAConfig.XML_VAR_TITLE_FONT)) {
                        this.config._titleFont = XMLUtils.getFont(string3, attributes);
                    } else if (string4.equals(VARNAConfig.XML_VAR_NUMBERS_FONT)) {
                        this.config._numbersFont = XMLUtils.getFont(string3, attributes);
                    } else if (string4.equals(VARNAConfig.XML_VAR_FONT_BASES)) {
                        this.config._fontBasesGeneral = XMLUtils.getFont(string3, attributes);
                    }
                }
            } else if (string3.equals(ModeleBaseNucleotide.XML_VAR_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(ModeleBasesComparison.XML_VAR_FIRST_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(ModeleBasesComparison.XML_VAR_SECOND_CONTENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(ModeleBasesComparison.XML_ELEMENT_NAME)) {
                if (this.rna != null) {
                    this.mbc = new ModeleBasesComparison(this.rna.getSize());
                    if (this.mbc.getIndex() != Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_INDEX_NAME))) {
                        throw new SAXException("Index mismatch for Base");
                    }
                    this.mbc.setBaseNumber(Integer.parseInt(attributes.getValue(ModeleBase.XML_VAR_NUMBER_NAME)));
                    this.mbc.setLabel(attributes.getValue(ModeleBase.XML_VAR_LABEL_NAME));
                    this.mbc.set_appartenance(Integer.parseInt(attributes.getValue(ModeleBasesComparison.XML_VAR_MEMBERSHIP_NAME)));
                    this.mbc.setColorie(Boolean.parseBoolean(attributes.getValue(ModeleBase.XML_VAR_CUSTOM_DRAWN_NAME)));
                    this.mbc.setValue(Double.parseDouble(attributes.getValue(ModeleBase.XML_VAR_VALUE_NAME)));
                    this.rna.addBase(this.mbc);
                }
            } else if (string3.equals(RNA.XML_VAR_NAME_NAME)) {
                if (this.rna != null) {
                    this._buffer = new StringBuffer();
                }
            } else if (string3.equals(ModeleBP.XML_ELEMENT_NAME)) {
                ModeleBP.Edge edge = ModeleBP.Edge.valueOf(attributes.getValue(ModeleBP.XML_VAR_EDGE5_NAME));
                ModeleBP.Edge edge2 = ModeleBP.Edge.valueOf(attributes.getValue(ModeleBP.XML_VAR_EDGE3_NAME));
                ModeleBP.Stericity stericity = ModeleBP.Stericity.valueOf(attributes.getValue(ModeleBP.XML_VAR_STERICITY_NAME));
                int n = Integer.parseInt(attributes.getValue(ModeleBP.XML_VAR_PARTNER5_NAME));
                int n2 = Integer.parseInt(attributes.getValue(ModeleBP.XML_VAR_PARTNER3_NAME));
                boolean bl = Boolean.parseBoolean(attributes.getValue(ModeleBP.XML_VAR_SEC_STR_NAME));
                this.mbp = new ModeleBP(this.rna.getBaseAt(n), this.rna.getBaseAt(n2), edge, edge2, stericity);
                if (bl) {
                    this.rna.addBP(n, n2, this.mbp);
                } else {
                    this.rna.addBPAux(n, n2, this.mbp);
                }
            } else if (string3.equals(ChemProbAnnotation.XML_ELEMENT_NAME)) {
                int n = Integer.parseInt(attributes.getValue(ChemProbAnnotation.XML_VAR_INDEX5_NAME));
                int n3 = Integer.parseInt(attributes.getValue(ChemProbAnnotation.XML_VAR_INDEX3_NAME));
                ChemProbAnnotation chemProbAnnotation = new ChemProbAnnotation(this.rna.getBaseAt(n), this.rna.getBaseAt(n3));
                chemProbAnnotation.setColor(Color.decode(attributes.getValue(ChemProbAnnotation.XML_VAR_COLOR_NAME)));
                chemProbAnnotation.setIntensity(Double.parseDouble(attributes.getValue(ChemProbAnnotation.XML_VAR_INTENSITY_NAME)));
                chemProbAnnotation.setType(ChemProbAnnotation.ChemProbAnnotationType.valueOf(attributes.getValue(ChemProbAnnotation.XML_VAR_TYPE_NAME)));
                chemProbAnnotation.setOut(Boolean.parseBoolean(attributes.getValue(ChemProbAnnotation.XML_VAR_OUTWARD_NAME)));
                this.rna.addChemProbAnnotation(chemProbAnnotation);
            } else if (string3.equals(TextAnnotation.XML_VAR_TEXT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(VARNAConfig.XML_VAR_TITLE)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(VARNAConfig.XML_VAR_CM_CAPTION)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(TextAnnotation.XML_ELEMENT_NAME)) {
                TextAnnotation.AnchorType anchorType = TextAnnotation.AnchorType.valueOf(attributes.getValue(TextAnnotation.XML_VAR_TYPE_NAME));
                this.ta = new TextAnnotation("");
                this.ta.setColor(Color.decode(attributes.getValue(TextAnnotation.XML_VAR_COLOR_NAME)));
                this.ta.setAngleInDegres(Double.parseDouble(attributes.getValue(TextAnnotation.XML_VAR_ANGLE_NAME)));
                this.ta.setType(anchorType);
            } else if (string3.equals(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
                this.hra = new HighlightRegionAnnotation();
                this.rna.addHighlightRegion(this.hra);
                this.hra.setOutlineColor(Color.decode(attributes.getValue(HighlightRegionAnnotation.XML_VAR_OUTLINE_NAME)));
                this.hra.setFillColor(Color.decode(attributes.getValue(HighlightRegionAnnotation.XML_VAR_FILL_NAME)));
                this.hra.setRadius(Double.parseDouble(attributes.getValue(HighlightRegionAnnotation.XML_VAR_RADIUS_NAME)));
            } else if (string3.equals(XMLUtils.XML_BASELIST_ELEMENT_NAME)) {
                this._buffer = new StringBuffer();
            } else if (string3.equals(VARNAPoint.XML_ELEMENT_NAME)) {
                Point2D.Double double_ = new Point2D.Double();
                double_.x = Double.parseDouble(attributes.getValue(VARNAPoint.XML_VAR_X_NAME));
                double_.y = Double.parseDouble(attributes.getValue(VARNAPoint.XML_VAR_Y_NAME));
                String string5 = attributes.getValue(VARNAPoint.XML_VAR_ROLE_NAME);
                if (this.contextContains(ModeleBaseNucleotide.XML_ELEMENT_NAME) && string5 != null) {
                    if (string5.equals(ModeleBase.XML_VAR_POSITION_NAME)) {
                        if (this.mbn == null) throw new SAXException("No Base model for this position Point");
                        this.mbn.setCoords(double_);
                    } else if (string5.equals(ModeleBase.XML_VAR_CENTER_NAME)) {
                        if (this.mbn == null) throw new SAXException("No Base model for this center Point");
                        this.mbn.setCenter(double_);
                    }
                }
                if (this.contextContains(ModeleBasesComparison.XML_ELEMENT_NAME) && string5 != null) {
                    if (string5.equals(ModeleBase.XML_VAR_POSITION_NAME)) {
                        if (this.mbc == null) throw new SAXException("No Base model for this position Point");
                        this.mbc.setCoords(double_);
                    } else if (string5.equals(ModeleBase.XML_VAR_CENTER_NAME)) {
                        if (this.mbc == null) throw new SAXException("No Base model for this center Point");
                        this.mbc.setCenter(double_);
                    }
                }
                if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                    if (this.ta == null) throw new SAXException("No TextAnnotation model for this Point");
                    this.ta.setAncrage(double_.x, double_.y);
                }
            } else if (string3.equals(ModelBaseStyle.XML_ELEMENT_NAME)) {
                this.msb = new ModelBaseStyle();
                this.msb.setBaseOutlineColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_OUTLINE_NAME)));
                this.msb.setBaseInnerColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_INNER_NAME)));
                this.msb.setBaseNameColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_NAME_NAME)));
                this.msb.setBaseNumberColor(Color.decode(attributes.getValue(ModelBaseStyle.XML_VAR_NUMBER_NAME)));
                if (this.mbn != null) {
                    this.mbn.setStyleBase(this.msb);
                } else if (this.mbc != null) {
                    this.mbc.setStyleBase(this.msb);
                }
                this.msb = null;
            } else if (string3.equals(ModeleBPStyle.XML_ELEMENT_NAME)) {
                this.mbps = new ModeleBPStyle();
                boolean bl = Boolean.parseBoolean(attributes.getValue(ModeleBPStyle.XML_VAR_CUSTOM_STYLED_NAME));
                if (bl) {
                    this.mbps.setCustomColor(Color.decode(attributes.getValue(ModeleBPStyle.XML_VAR_COLOR_NAME)));
                }
                this.mbps.setThickness(Double.parseDouble(attributes.getValue(ModeleBPStyle.XML_VAR_THICKNESS_NAME)));
                this.mbps.setBent(Double.parseDouble(attributes.getValue(ModeleBPStyle.XML_VAR_BENT_NAME)));
                if (this.mbp != null) {
                    this.mbp.setStyle(this.mbps);
                }
                this.mbps = null;
            }
        }
        this.addToContext(string3);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(ModeleBaseNucleotide.XML_VAR_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbn == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String string4 = this._buffer.toString();
            this.mbn.setContent(string4);
        } else if (string3.equals(ModeleBasesComparison.XML_VAR_FIRST_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbc == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String string5 = this._buffer.toString();
            this.mbc.setBase1(Character.valueOf(string5.trim().charAt(0)));
        } else if (string3.equals(ModeleBasesComparison.XML_VAR_SECOND_CONTENT_NAME)) {
            if (this._buffer == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            if (this.mbc == null) {
                throw new SAXException("Invalid location for tag " + ModeleBaseNucleotide.XML_VAR_CONTENT_NAME);
            }
            String string6 = this._buffer.toString();
            this.mbc.setBase2(Character.valueOf(string6.trim().charAt(0)));
        } else if (string3.equals(ModeleBaseNucleotide.XML_ELEMENT_NAME)) {
            this.mbn = null;
        } else if (string3.equals(ModeleBP.XML_ELEMENT_NAME)) {
            this.mbp = null;
        } else if (string3.equals(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
            this.hra = null;
        } else if (string3.equals(TextAnnotation.XML_VAR_TEXT_NAME)) {
            String string7 = this._buffer.toString();
            this.ta.setText(string7);
            this._buffer = null;
        } else if (string3.equals(RNA.XML_VAR_NAME_NAME)) {
            if (this.rna != null) {
                this.rna.setName(this._buffer.toString());
                this._buffer = null;
            }
        } else if (string3.equals(VARNAConfig.XML_VAR_CM_CAPTION)) {
            this.config._colorMapCaption = this._buffer.toString();
            this._buffer = null;
        } else if (string3.equals(TextAnnotation.XML_ELEMENT_NAME)) {
            this.rna.addAnnotation(this.ta);
            this.ta = null;
        } else if (string3.equals(XMLUtils.XML_BASELIST_ELEMENT_NAME)) {
            String string8 = this._buffer.toString();
            ArrayList<ModeleBase> arrayList = XMLUtils.toModeleBaseArray(string8, this.rna);
            if (this.contextContains(TextAnnotation.XML_ELEMENT_NAME)) {
                switch (this.ta.getType()) {
                    case POSITION: {
                        break;
                    }
                    case BASE: {
                        this.ta.setAncrage(arrayList.get(0));
                        break;
                    }
                    case HELIX: 
                    case LOOP: {
                        try {
                            this.ta.setAncrage(arrayList, this.ta.getType());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break;
                    }
                }
            }
            if (this.contextContains(HighlightRegionAnnotation.XML_ELEMENT_NAME)) {
                this.hra.setBases(arrayList);
            }
            this._buffer = null;
        }
        this.removeFromContext(string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._buffer != null) {
            this._buffer.append(string);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    public RNA getRNA() {
        return this.rna;
    }

    public VARNAConfig getVARNAConfig() {
        return this.config;
    }
}

