/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.GraphicalTemplateElement;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.geom.CubicBezierCurve;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class UnpairedRegion
extends GraphicalTemplateElement {
    private RNATemplate.RNATemplateUnpairedSequence _e;
    public static final double DEFAULT_VECTOR_LENGTH = 35.0;
    public static final double DEFAULT_VECTOR_DISTANCE = 35.0;
    private Point2D.Double[] sequenceBasesCoords = null;
    public static final double MAX_UNPAIRED_CONTROL_DISTANCE = 10.0;
    public static final double UNPAIRED_ARROW_WIDTH = 6.0;

    public UnpairedRegion(double d, double d2, RNATemplate rNATemplate) {
        RNATemplate rNATemplate2 = rNATemplate;
        rNATemplate2.getClass();
        this._e = new RNATemplate.RNATemplateUnpairedSequence(rNATemplate2, "");
        this._e.setVertex5(new Point2D.Double(d, d2));
        this._e.setVertex3(new Point2D.Double(d + 35.0, d2));
        this._e.setInTangentVectorLength(35.0);
        this._e.setInTangentVectorAngle(-1.5707963267948966);
        this._e.setOutTangentVectorLength(35.0);
        this._e.setOutTangentVectorAngle(-1.5707963267948966);
        this.updateLength();
    }

    public UnpairedRegion(RNATemplate.RNATemplateUnpairedSequence rNATemplateUnpairedSequence) {
        this._e = rNATemplateUnpairedSequence;
    }

    public Point2D.Double getEdge5() {
        GraphicalTemplateElement.RelativePosition relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
        Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> couple = this.getAttachedElement(relativePosition);
        return this.isAnchored5() ? ((GraphicalTemplateElement)couple.second).getEdgePosition((GraphicalTemplateElement.RelativePosition)((Object)couple.first)) : this._e.getVertex5();
    }

    public Point2D.Double getEdge3() {
        GraphicalTemplateElement.RelativePosition relativePosition = GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
        Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> couple = this.getAttachedElement(relativePosition);
        return this.isAnchored3() ? ((GraphicalTemplateElement)couple.second).getEdgePosition((GraphicalTemplateElement.RelativePosition)((Object)couple.first)) : this._e.getVertex3();
    }

    public Point2D.Double getCenter() {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        return new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
    }

    public void setEdge5(Point2D.Double double_) {
        this._e.setVertex5(double_);
        this.updateLength();
    }

    public void setEdge3(Point2D.Double double_) {
        this._e.setVertex3(double_);
        this.updateLength();
    }

    public void setCenter(Point2D.Double double_) {
        Point2D.Double double_2 = this.getEdge5();
        Point2D.Double double_3 = this.getEdge3();
        double d = double_2.x - double_3.x;
        double d2 = double_2.y - double_3.y;
        this._e.setVertex3(new Point2D.Double(double_.x - d / 2.0, double_.y - d2 / 2.0));
        this._e.setVertex5(new Point2D.Double(double_.x + d / 2.0, double_.y + d2 / 2.0));
        this.invalidateCoords();
    }

    public boolean isAnchored5() {
        return this._e.getIn().getOtherElement() != null;
    }

    public boolean isAnchored3() {
        return this._e.getOut().getOtherElement() != null;
    }

    public static Shape bezToShape(CubicBezierCurve cubicBezierCurve) {
        GeneralPath generalPath = new GeneralPath();
        int n = 9;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = cubicBezierCurve.getApproxCurveLength() * (double)i / (double)n;
        }
        Point2D.Double[] doubleArray = cubicBezierCurve.uniformParam(dArray);
        System.out.println(doubleArray.length);
        generalPath.moveTo((float)doubleArray[0].x, (float)doubleArray[0].y);
        for (int i = 1; i < n; ++i) {
            Point2D.Double double_ = doubleArray[i];
            System.out.println(double_);
            generalPath.lineTo((float)double_.x, (float)double_.y);
        }
        generalPath.lineTo((float)cubicBezierCurve.getP3().x, (float)cubicBezierCurve.getP3().y);
        return generalPath;
    }

    public Shape getCurve() {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        Point2D.Double double_3 = this.getControl5();
        Point2D.Double double_4 = this.getControl3();
        return new CubicCurve2D.Double(double_.x, double_.y, double_3.x, double_3.y, double_4.x, double_4.y, double_2.x, double_2.y);
    }

    private int estimateNumberOfBases() {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        Point2D.Double double_3 = this.getControl5();
        Point2D.Double double_4 = this.getControl3();
        CubicBezierCurve cubicBezierCurve = new CubicBezierCurve(double_, double_3, double_4, double_2, 30);
        return Math.max((int)Math.round(cubicBezierCurve.getApproxCurveLength() / 40.0) - 1, 1);
    }

    private void updateLength() {
        this._e.setLength(this.estimateNumberOfBases());
        this.invalidateCoords();
    }

    private void invalidateCoords() {
        this.sequenceBasesCoords = null;
    }

    private void calculeCoords() {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        Point2D.Double double_3 = this.getControl5();
        Point2D.Double double_4 = this.getControl3();
        int n = this._e.getLength();
        CubicBezierCurve cubicBezierCurve = new CubicBezierCurve(double_, double_3, double_4, double_2, 10 * n);
        double d = cubicBezierCurve.getApproxCurveLength();
        double d2 = d / (double)(n + 1);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)(i + 1) * d2;
        }
        this.sequenceBasesCoords = cubicBezierCurve.uniformParam(dArray);
    }

    @Override
    public void draw(Graphics2D graphics2D, boolean bl) {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        Point2D.Double double_3 = this.getControl5();
        Point2D.Double double_4 = this.getControl3();
        if (bl) {
            graphics2D.setStroke(this._dashedStroke);
            graphics2D.setColor(BACKBONE_COLOR);
            graphics2D.draw(this.getBoundingPolygon());
            graphics2D.setStroke(this._solidStroke);
            this.drawAnchor(graphics2D, double_3);
            this.drawAnchor(graphics2D, double_4);
            double d = (double_3.x - double_.x) / double_3.distance(double_);
            double d2 = (double_3.y - double_.y) / double_3.distance(double_);
            double d3 = (double_4.x - double_2.x) / double_4.distance(double_2);
            double d4 = (double_4.y - double_2.y) / double_4.distance(double_2);
            double d5 = -3.5;
            Point2D.Double double_5 = new Point2D.Double(double_3.x - d5 * d, double_3.y - d5 * d2);
            Point2D.Double double_6 = new Point2D.Double(double_4.x - d5 * d3, double_4.y - d5 * d4);
            this.drawArrow(graphics2D, double_, double_5, 6.0);
            this.drawArrow(graphics2D, double_2, double_6, 6.0);
        }
        graphics2D.setColor(BACKBONE_COLOR);
        graphics2D.setStroke(this._solidStroke);
        graphics2D.draw(this.getCurve());
        if (this.sequenceBasesCoords == null) {
            this.calculeCoords();
        }
        for (int i = 0; i < this.sequenceBasesCoords.length; ++i) {
            this.drawBase(graphics2D, this.sequenceBasesCoords[i]);
        }
        if (!this.isAnchored5()) {
            this.drawAnchor5(graphics2D, double_);
        } else {
            this.drawMagnet(graphics2D, double_);
        }
        if (!this.isAnchored3()) {
            this.drawAnchor3(graphics2D, double_2);
        } else {
            this.drawMagnet(graphics2D, double_2);
        }
        if (!this.isAnchored5() && !this.isAnchored3()) {
            this.drawMove(graphics2D, this.getCenter());
        }
    }

    public Point2D.Double getControl5() {
        Point2D.Double double_ = this.getEdge5();
        double d = this._e.getInTangentVectorAngle();
        return new Point2D.Double(double_.x + Math.cos(d) * this._e.getInTangentVectorLength(), double_.y + Math.sin(d) * this._e.getInTangentVectorLength());
    }

    public Point2D.Double getControl3() {
        Point2D.Double double_ = this.getEdge3();
        double d = this._e.getOutTangentVectorAngle();
        return new Point2D.Double(double_.x + Math.cos(d) * this._e.getOutTangentVectorLength(), double_.y + Math.sin(d) * this._e.getOutTangentVectorLength());
    }

    @Override
    public Polygon getBoundingPolygon() {
        Point2D.Double double_ = this.getEdge5();
        Point2D.Double double_2 = this.getEdge3();
        Point2D.Double double_3 = this.getControl5();
        Point2D.Double double_4 = this.getControl3();
        double d = Math.min(double_.x, Math.min(double_2.x, Math.min(double_3.x, double_4.x)));
        double d2 = Math.max(double_.x, Math.max(double_2.x, Math.max(double_3.x, double_4.x)));
        double d3 = Math.min(double_.y, Math.min(double_2.y, Math.min(double_3.y, double_4.y)));
        double d4 = Math.max(double_.y, Math.max(double_2.y, Math.max(double_3.y, double_4.y)));
        int[] nArray = new int[]{(int)(d -= 10.0), (int)(d2 += 10.0), (int)d2, (int)d};
        int[] nArray2 = new int[]{(int)(d3 -= 10.0), (int)d3, (int)(d4 += 10.0), (int)d4};
        return new Polygon(nArray, nArray2, 4);
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getClosestEdge(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = this.getEdge5();
        Point2D.Double double_3 = this.getEdge3();
        Point2D.Double double_4 = this.getControl5();
        Point2D.Double double_5 = this.getControl3();
        Point2D.Double double_6 = this.getCenter();
        ArrayList<Couple<Double, GraphicalTemplateElement.RelativePosition>> arrayList = new ArrayList<Couple<Double, GraphicalTemplateElement.RelativePosition>>();
        arrayList.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(double_.distance(double_2), GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5));
        arrayList.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(double_.distance(double_3), GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3));
        arrayList.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(double_.distance(double_4), GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_5));
        arrayList.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(double_.distance(double_5), GraphicalTemplateElement.RelativePosition.RP_EDIT_TANGENT_3));
        arrayList.add(new Couple<Double, GraphicalTemplateElement.RelativePosition>(double_.distance(double_6), GraphicalTemplateElement.RelativePosition.RP_INNER_MOVE));
        double d3 = Double.MAX_VALUE;
        GraphicalTemplateElement.RelativePosition relativePosition = GraphicalTemplateElement.RelativePosition.RP_OUTER;
        for (Couple couple : arrayList) {
            if (!((Double)couple.first < d3)) continue;
            d3 = (Double)couple.first;
            relativePosition = (GraphicalTemplateElement.RelativePosition)((Object)couple.second);
        }
        return relativePosition;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getConnectedEdge(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
            case RP_CONNECT_END3: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public Point2D.Double getEdgePosition(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_INNER_MOVE: {
                return this.getCenter();
            }
            case RP_CONNECT_START5: {
                return this.getEdge5();
            }
            case RP_CONNECT_END3: {
                return this.getEdge3();
            }
            case RP_EDIT_TANGENT_5: {
                return this.getControl5();
            }
            case RP_EDIT_TANGENT_3: {
                return this.getControl3();
            }
        }
        return this.getEdge5();
    }

    double v2a(Point2D.Double double_) {
        return Math.atan2(double_.y, double_.x);
    }

    public void updateControl5(Point2D.Double double_) {
        Point2D.Double double_2 = this.getEdge5();
        this._e.setInTangentVectorLength(double_2.distance(double_));
        Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
        this._e.setInTangentVectorAngle(this.v2a(double_3));
        this.updateLength();
    }

    public void updateControl3(Point2D.Double double_) {
        Point2D.Double double_2 = this.getEdge3();
        this._e.setOutTangentVectorLength(double_2.distance(double_));
        Point2D.Double double_3 = new Point2D.Double(double_.x - double_2.x, double_.y - double_2.y);
        this._e.setOutTangentVectorAngle(this.v2a(double_3));
        this.updateLength();
    }

    @Override
    public void translate(double d, double d2) {
        this._e.getVertex5().x += d;
        this._e.getVertex5().y += d2;
        this._e.getVertex3().x += d;
        this._e.getVertex3().y += d2;
        this.invalidateCoords();
    }

    @Override
    public GraphicalTemplateElement.RelativePosition getRelativePosition(double d, double d2) {
        GraphicalTemplateElement.RelativePosition relativePosition = this.getClosestEdge(d, d2);
        double d3 = this.getEdgePosition(relativePosition).distance(new Point2D.Double(d, d2));
        if (d3 < 10.0) {
            return relativePosition;
        }
        if (this.getCurve().contains(new Point2D.Double(d, d2))) {
            return GraphicalTemplateElement.RelativePosition.RP_INNER_GENERAL;
        }
        return GraphicalTemplateElement.RelativePosition.RP_OUTER;
    }

    @Override
    public Shape getArea() {
        return this.getCurve();
    }

    @Override
    public void attach(GraphicalTemplateElement graphicalTemplateElement, GraphicalTemplateElement.RelativePosition relativePosition, GraphicalTemplateElement.RelativePosition relativePosition2) throws ExceptionInvalidRNATemplate {
        super.attach(graphicalTemplateElement, relativePosition, relativePosition2);
        if (graphicalTemplateElement instanceof Helix) {
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint = this.getEndPoint(relativePosition);
            RNATemplate.RNATemplateElement.EdgeEndPoint edgeEndPoint2 = graphicalTemplateElement.getEndPoint(relativePosition2);
            boolean bl = this.isIn(relativePosition);
            boolean bl2 = graphicalTemplateElement.isIn(relativePosition2);
            if (edgeEndPoint != null && edgeEndPoint2 != null && bl != bl2) {
                edgeEndPoint.disconnect();
                edgeEndPoint2.disconnect();
                edgeEndPoint.connectTo(edgeEndPoint2);
            }
        }
    }

    @Override
    public RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                return this._e.getIn();
            }
            case RP_CONNECT_END3: {
                return this._e.getOut();
            }
        }
        return null;
    }

    @Override
    public boolean isIn(GraphicalTemplateElement.RelativePosition relativePosition) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                return true;
            }
            case RP_CONNECT_END3: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void detach(GraphicalTemplateElement.RelativePosition relativePosition) {
        if (this.getEndPoint(relativePosition).isConnected()) {
            Couple<GraphicalTemplateElement.RelativePosition, GraphicalTemplateElement> couple = this.getAttachedElement(relativePosition);
            this.getEndPoint(relativePosition).disconnect();
        }
        super.detach(relativePosition);
    }

    @Override
    public void setEdgePosition(GraphicalTemplateElement.RelativePosition relativePosition, Point2D.Double double_) {
        switch (relativePosition) {
            case RP_CONNECT_START5: {
                this.setEdge5(double_);
                break;
            }
            case RP_INNER_MOVE: {
                this.setCenter(double_);
                break;
            }
            case RP_CONNECT_END3: {
                this.setEdge3(double_);
                break;
            }
            case RP_EDIT_TANGENT_5: {
                this.updateControl5(double_);
                break;
            }
            case RP_EDIT_TANGENT_3: {
                this.updateControl3(double_);
            }
        }
    }

    @Override
    public ArrayList<GraphicalTemplateElement.RelativePosition> getConnectedEdges() {
        ArrayList<GraphicalTemplateElement.RelativePosition> arrayList = new ArrayList<GraphicalTemplateElement.RelativePosition>();
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5);
        arrayList.add(GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3);
        return arrayList;
    }

    @Override
    public RNATemplate.RNATemplateElement getTemplateElement() {
        return this._e;
    }

    @Override
    public GraphicalTemplateElement.RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition edgeEndPointPosition) {
        switch (edgeEndPointPosition) {
            case IN1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_START5;
            }
            case OUT1: {
                return GraphicalTemplateElement.RelativePosition.RP_CONNECT_END3;
            }
        }
        return null;
    }
}

