/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.GenericPlatform;
import org.jmol.api.Interface;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STER;
import org.jmol.g3d.CircleRenderer;
import org.jmol.g3d.CylinderRenderer;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.g3d.LineRenderer;
import org.jmol.g3d.Pixelator;
import org.jmol.g3d.PixelatorScreened;
import org.jmol.g3d.PixelatorShaded;
import org.jmol.g3d.PixelatorT;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.g3d.SphereRenderer;
import org.jmol.g3d.TextRenderer;
import org.jmol.g3d.TextString;
import org.jmol.g3d.TriangleRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.GData;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.util.Rgb16;
import org.jmol.viewer.Viewer;

public final class Graphics3D
extends GData
implements JmolRendererInterface {
    Platform3D platform;
    LineRenderer line3d;
    private SphereRenderer sphere3d;
    private CylinderRenderer cylinder3d;
    private G3DRenderer triangle3d;
    private G3DRenderer circle3d;
    private G3DRenderer hermite3d;
    private boolean isFullSceneAntialiasingEnabled;
    private boolean antialias2;
    private TextString[] strings = null;
    private int stringCount;
    private byte[] anaglyphChannelBytes;
    private boolean twoPass = false;
    private boolean haveTranslucentObjects;
    protected int[] pbuf;
    protected int[] pbufT;
    protected int[] zbuf;
    protected int[] zbufT;
    protected int translucencyMask;
    private boolean renderLow;
    private int[] shadesCurrent;
    private int anaglyphLength;
    Pixelator pixel;
    Pixelator pixel0;
    private PixelatorT pixelT0;
    private PixelatorScreened pixelScreened;
    private PixelatorShaded pixelShaded;
    protected int zMargin;
    int currentShadeIndex;
    private int lastRawColor;
    int translucencyLog;
    private boolean wasScreened;
    private int saveAmbient;
    private int saveDiffuse;
    public static Comparator<TextString> sort;
    private P3i sA = new P3i();
    private P3i sB = new P3i();
    private P3i sC = new P3i();
    private static byte nullShadeIndex;
    private final V3 vectorAB = new V3();
    private final V3 vectorAC = new V3();
    private final V3 vectorNormal = new V3();
    private final byte[] shadeIndexes = new byte[normixCount];
    private final byte[] shadeIndexes2Sided = new byte[normixCount];
    public int pass2Flag01;

    @Override
    public boolean isWebGL() {
        return false;
    }

    @Override
    public void clear() {
        this.stringCount = 0;
        this.strings = null;
        TextRenderer.clearFontCache();
    }

    @Override
    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
        this.pixelShaded = null;
        this.pixel0 = null;
        this.pixel = null;
        this.pixelT0 = null;
        this.pixelScreened = null;
        this.graphicsForMetrics = null;
    }

    void setZMargin(int dz) {
        this.zMargin = dz;
    }

    public Graphics3D() {
        int i = normixCount;
        while (--i >= 0) {
            this.transformedVectors[i] = new V3();
        }
    }

    @Override
    public void initialize(Viewer vwr, GenericPlatform apiPlatform) {
        this.vwr = vwr;
        this.apiPlatform = apiPlatform;
        this.platform = new Platform3D(apiPlatform);
        this.pixel = this.pixel0 = new Pixelator(this);
        this.graphicsForMetrics = this.platform.getGraphicsForMetrics();
        this.line3d = new LineRenderer(this);
        this.sphere3d = new SphereRenderer(this);
        this.cylinder3d = new CylinderRenderer(this);
    }

    @Override
    public void addRenderer(int tok) {
        switch (tok) {
            case 1073741880: {
                if (this.circle3d != null) break;
                this.circle3d = this.getRenderer("Circle");
                break;
            }
            case 0x21000011: {
                if (this.hermite3d == null) {
                    this.hermite3d = this.getRenderer("Hermite");
                }
            }
            case 1073742182: {
                if (this.triangle3d != null) break;
                this.triangle3d = this.getRenderer("Triangle");
                ((PrecisionRenderer)((Object)this.triangle3d)).isOrthographic = !this.vwr.tm.perspectiveDepth;
            }
        }
    }

    private G3DRenderer getRenderer(String type) {
        G3DRenderer r = (G3DRenderer)Interface.getOption("g3d." + type + "Renderer", this.vwr, "render");
        if (r == null) {
            throw new NullPointerException("Interface");
        }
        r.set(this, this);
        return r;
    }

    @Override
    public void setWindowParameters(int width, int height, boolean antialias) {
        this.setWinParams(width, height, antialias);
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    @Override
    public boolean checkTranslucent(boolean isAlphaTranslucent) {
        if (isAlphaTranslucent) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == isAlphaTranslucent;
    }

    @Override
    public void beginRendering(M3 rotationMatrix, boolean translucentMode, boolean isImageWrite, boolean renderLow) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        this.renderLow = renderLow;
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.setRotationMatrix(rotationMatrix);
        boolean bl = this.line3d.isOrthographic = !this.vwr.tm.perspectiveDepth;
        if (this.triangle3d != null) {
            ((PrecisionRenderer)((Object)this.triangle3d)).isOrthographic = !this.vwr.tm.perspectiveDepth;
        }
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        if (this.strings != null) {
            int i = Math.min(this.strings.length, this.stringCount);
            while (--i >= 0) {
                this.strings[i] = null;
            }
        }
        this.stringCount = 0;
        this.twoPass = true;
        this.isPass2 = false;
        this.pass2Flag01 = 0;
        this.colixCurrent = 0;
        this.wasScreened = false;
        this.haveTranslucentObjects = false;
        this.pixel = this.pixel0;
        this.pixel.bgcolor = this.bgcolor;
        boolean bl2 = this.translucentCoverOnly = !translucentMode;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame, isImageWrite);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
            this.pixel0.setBuf();
            if (this.pixelT0 != null) {
                this.pixelT0.setBuf();
            }
            if (this.pixelShaded != null) {
                this.pixelShaded.setBuf();
            }
        }
        this.setWidthHeight(this.antialiasThisFrame);
        if (this.pixelScreened != null) {
            this.pixelScreened.width = this.width;
        }
        this.platform.clearBuffer();
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, null, (short)0, 0, 0);
        }
        this.textY = 0;
    }

    @Override
    public void setBackgroundTransparent(boolean TF) {
        if (this.platform != null) {
            this.platform.setBackgroundTransparent(TF);
        }
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.platform.releaseBuffers();
        this.line3d.clearLineCache();
    }

    @Override
    public boolean setPass2(boolean antialiasTranslucent) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.pass2Flag01 = 1;
        this.colixCurrent = 0;
        if (this.pbufT == null || this.antialias2 != antialiasTranslucent) {
            this.platform.allocateTBuffers(antialiasTranslucent);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = antialiasTranslucent;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        if (this.pixelT0 == null) {
            this.pixelT0 = new PixelatorT(this);
        }
        if (this.pixel.p0 == null) {
            this.pixel = this.pixelT0;
        } else {
            this.pixel.p0 = this.pixelT0;
        }
        return true;
    }

    @Override
    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2 && this.pbufT != null) {
                int offset = this.pbufT.length;
                while (--offset >= 0) {
                    this.pbuf[offset] = Graphics3D.mergeBufferPixel(this.pbuf[offset], this.pbufT[offset], this.bgcolor);
                }
            }
            if (this.pixel == this.pixelShaded && this.pixelShaded.zShadePower == 0) {
                this.pixelShaded.showZBuffer();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.setBackgroundColor(this.bgcolor);
        this.platform.notifyEndOfRendering();
        this.isPass2 = false;
        this.currentlyRendering = false;
    }

    public static int mergeBufferPixel(int argbA, int argbB, int bgcolor) {
        if (argbB == 0 || argbA == argbB) {
            return argbA;
        }
        if (argbA == 0) {
            argbA = bgcolor;
        }
        int rbA = argbA & 0xFF00FF;
        int gA = argbA & 0xFF00;
        int rbB = argbB & 0xFF00FF;
        int gB = argbB & 0xFF00;
        int logAlpha = argbB >> 24 & 0xF;
        switch (logAlpha) {
            case 0: {
                rbA = rbB;
                gA = gB;
                break;
            }
            case 1: {
                rbA = (rbB << 2) + (rbB << 1) + rbB + rbA >> 3 & 0xFF00FF;
                gA = (gB << 2) + (gB << 1) + gB + gA >> 3 & 0xFF00;
                break;
            }
            case 2: {
                rbA = (rbB << 1) + rbB + rbA >> 2 & 0xFF00FF;
                gA = (gB << 1) + gB + gA >> 2 & 0xFF00;
                break;
            }
            case 3: {
                rbA = (rbB << 2) + rbB + (rbA << 1) + rbA >> 3 & 0xFF00FF;
                gA = (gB << 2) + gB + (gA << 1) + gA >> 3 & 0xFF00;
                break;
            }
            case 4: {
                rbA = rbA + rbB >> 1 & 0xFF00FF;
                gA = gA + gB >> 1 & 0xFF00;
                break;
            }
            case 5: {
                rbA = (rbB << 1) + rbB + (rbA << 2) + rbA >> 3 & 0xFF00FF;
                gA = (gB << 1) + gB + (gA << 2) + gA >> 3 & 0xFF00;
                break;
            }
            case 6: {
                rbA = (rbA << 1) + rbA + rbB >> 2 & 0xFF00FF;
                gA = (gA << 1) + gA + gB >> 2 & 0xFF00;
                break;
            }
            case 7: {
                rbA = (rbA << 2) + (rbA << 1) + rbA + rbB >> 3 & 0xFF00FF;
                gA = (gA << 2) + (gA << 1) + gA + gB >> 3 & 0xFF00;
            }
        }
        return 0xFF000000 | rbA | gA;
    }

    @Override
    public Object getScreenImage(boolean isImageWrite) {
        Object obj = this.platform.bufferedImage;
        boolean dorelease = false;
        if (dorelease) {
            this.releaseBuffers();
        }
        return obj;
    }

    @Override
    public void applyAnaglygh(STER stereoMode, int[] stereoColors) {
        switch (stereoMode) {
            case REDCYAN: {
                int i = this.anaglyphLength;
                while (--i >= 0) {
                    int blue = this.anaglyphChannelBytes[i] & 0xFF;
                    int cyan = blue << 8 | blue;
                    this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | cyan;
                }
                break;
            }
            case CUSTOM: {
                int color1 = stereoColors[0];
                int color2 = stereoColors[1] & 0xFFFFFF;
                int i = this.anaglyphLength;
                while (--i >= 0) {
                    int a = this.anaglyphChannelBytes[i] & 0xFF;
                    a = (a | (a | a << 8) << 8) & color2;
                    this.pbuf[i] = this.pbuf[i] & color1 | a;
                }
                break;
            }
            case REDBLUE: {
                int i = this.anaglyphLength;
                while (--i >= 0) {
                    int blue = this.anaglyphChannelBytes[i] & 0xFF;
                    this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | blue;
                }
                break;
            }
            case REDGREEN: {
                int i = this.anaglyphLength;
                while (--i >= 0) {
                    int green = (this.anaglyphChannelBytes[i] & 0xFF) << 8;
                    this.pbuf[i] = this.pbuf[i] & 0xFFFF0000 | green;
                }
                break;
            }
        }
    }

    @Override
    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int i = this.anaglyphLength;
        while (--i >= 0) {
            this.anaglyphChannelBytes[i] = (byte)this.pbuf[i];
        }
    }

    @Override
    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    @Override
    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    @Override
    public void setSlabAndZShade(int slabValue, int depthValue, int zSlab, int zDepth, int zShadePower) {
        this.setSlab(slabValue);
        this.setDepth(depthValue);
        if (zSlab < zDepth) {
            if (this.pixelShaded == null) {
                this.pixelShaded = new PixelatorShaded(this);
            }
            this.pixel = this.pixelShaded.set(zSlab, zDepth, zShadePower);
        } else {
            this.pixel = this.pixel0;
        }
    }

    private void downsampleFullSceneAntialiasing(boolean downsampleZBuffer) {
        int bgcheck = this.bgcolor;
        if (downsampleZBuffer) {
            bgcheck += (bgcheck & 0xFF) == 255 ? -1 : 1;
        }
        Graphics3D.downsample2d(this.pbuf, this.windowWidth, this.windowHeight, bgcheck);
        if (downsampleZBuffer) {
            Graphics3D.downsample2dZ(this.pbuf, this.zbuf, this.windowWidth, this.windowHeight, bgcheck);
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    public static void downsample2d(int[] pbuf, int width, int height, int bgcheck) {
        int width4 = width << 1;
        if (bgcheck != 0) {
            bgcheck &= 0xFFFFFF;
            int i = pbuf.length;
            while (--i >= 0) {
                if (pbuf[i] != 0) continue;
                pbuf[i] = bgcheck;
            }
        }
        int bg0 = (bgcheck >> 2 & 0x3F3F3F3F) << 2;
        bg0 += (bg0 & 0xC0C0C0C0) >> 6;
        int offset1 = 0;
        int offset4 = 0;
        int i = height;
        while (--i >= 0) {
            int j = width;
            while (--j >= 0) {
                int argb = (pbuf[offset4] >> 2 & 0x3F3F3F3F) + (pbuf[offset4++ + width4] >> 2 & 0x3F3F3F3F) + (pbuf[offset4] >> 2 & 0x3F3F3F3F) + (pbuf[offset4++ + width4] >> 2 & 0x3F3F3F3F);
                if ((argb += (argb & 0xC0C0C0C0) >> 6) == bg0) {
                    argb = bgcheck;
                }
                pbuf[offset1] = argb & 0xFFFFFF;
                ++offset1;
            }
            offset4 += width4;
        }
    }

    private static void downsample2dZ(int[] pbuf, int[] zbuf, int width, int height, int bgcheck) {
        int width4 = width << 1;
        int offset1 = 0;
        int offset4 = 0;
        int i = height;
        while (--i >= 0) {
            int j = width;
            while (--j >= 0) {
                int z = Math.min(zbuf[offset4], zbuf[offset4 + width4]);
                z = Math.min(z, zbuf[++offset4]);
                if ((z = Math.min(z, zbuf[offset4 + width4])) != Integer.MAX_VALUE) {
                    z >>= 1;
                }
                zbuf[offset1] = pbuf[offset1] == bgcheck ? Integer.MAX_VALUE : z;
                ++offset1;
                ++offset4;
            }
            offset4 += width4;
        }
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    @Override
    public boolean setC(short colix) {
        boolean isLast = C.isColixLastAvailable(colix);
        if (!isLast && colix == this.colixCurrent && this.currentShadeIndex == -1) {
            return true;
        }
        int mask = colix & 0x7800;
        if (mask == 16384) {
            return false;
        }
        if (this.renderLow) {
            mask = 0;
        }
        boolean isTranslucent = mask != 0;
        boolean isScreened = isTranslucent && mask == 30720;
        this.setScreened(isScreened);
        if (!this.checkTranslucent(isTranslucent && !isScreened)) {
            return false;
        }
        if (this.isPass2) {
            this.translucencyMask = mask << 13 | 0xFFFFFF;
            this.translucencyLog = mask >> 11;
        } else {
            this.translucencyLog = 0;
        }
        this.colixCurrent = colix;
        if (isLast && this.argbCurrent != this.lastRawColor) {
            if (this.argbCurrent == 0) {
                this.argbCurrent = -1;
            }
            this.lastRawColor = this.argbCurrent;
            this.shader.setLastColix(this.argbCurrent, this.inGreyscaleMode);
        }
        this.shadesCurrent = this.getShades(colix);
        this.currentShadeIndex = -1;
        this.setColor(this.getColorArgbOrGray(colix));
        return true;
    }

    Pixelator setScreened(boolean isScreened) {
        if (this.wasScreened != isScreened) {
            this.wasScreened = isScreened;
            if (isScreened) {
                if (this.pixelScreened == null) {
                    this.pixelScreened = new PixelatorScreened(this, this.pixel0);
                }
                if (this.pixel.p0 == null) {
                    this.pixel = this.pixelScreened;
                } else {
                    this.pixel.p0 = this.pixelScreened;
                }
            } else if (this.pixel.p0 == null || this.pixel == this.pixelScreened) {
                this.pixel = this.isPass2 ? this.pixelT0 : this.pixel0;
            } else {
                this.pixel.p0 = this.isPass2 ? this.pixelT0 : this.pixel0;
            }
        }
        return this.pixel;
    }

    @Override
    public void drawFilledCircle(short colixRing, short colixFill, int diameter, int x, int y, int z) {
        boolean isClipped;
        if (this.isClippedZ(z)) {
            return;
        }
        int r = (diameter + 1) / 2;
        boolean bl = isClipped = x < r || x + r >= this.width || y < r || y + r >= this.height;
        if (isClipped && this.isClippedXY(diameter, x, y)) {
            return;
        }
        if (colixRing != 0 && this.setC(colixRing)) {
            if (isClipped) {
                if (!this.isClippedXY(diameter, x, y)) {
                    ((CircleRenderer)this.circle3d).plotCircleCenteredClipped(x, y, z, diameter);
                }
            } else {
                ((CircleRenderer)this.circle3d).plotCircleCenteredUnclipped(x, y, z, diameter);
            }
        }
        if (colixFill != 0 && this.setC(colixFill)) {
            if (isClipped) {
                ((CircleRenderer)this.circle3d).plotFilledCircleCenteredClipped(x, y, z, diameter);
            } else {
                ((CircleRenderer)this.circle3d).plotFilledCircleCenteredUnclipped(x, y, z, diameter);
            }
        }
    }

    @Override
    public void volumeRender4(int diameter, int x, int y, int z) {
        boolean isClipped;
        if (diameter == 1) {
            this.plotPixelClippedArgb(this.argbCurrent, x, y, z, this.width, this.zbuf, this.pixel);
            return;
        }
        if (this.isClippedZ(z)) {
            return;
        }
        int r = (diameter + 1) / 2;
        boolean bl = isClipped = x < r || x + r >= this.width || y < r || y + r >= this.height;
        if (isClipped && this.isClippedXY(diameter, x, y)) {
            return;
        }
        if (isClipped) {
            ((CircleRenderer)this.circle3d).plotFilledCircleCenteredClipped(x, y, z, diameter);
        } else {
            ((CircleRenderer)this.circle3d).plotFilledCircleCenteredUnclipped(x, y, z, diameter);
        }
    }

    @Override
    public void fillSphereXYZ(int diameter, int x, int y, int z) {
        switch (diameter) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, x, y, z, this.width, this.zbuf, this.pixel);
                return;
            }
            case 0: {
                return;
            }
        }
        if (diameter <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, diameter, x, y, z, null, null, null, -1, null);
        }
    }

    @Override
    public void volumeRender(boolean TF) {
        if (TF) {
            this.saveAmbient = this.getAmbientPercent();
            this.saveDiffuse = this.getDiffusePercent();
            this.setAmbientPercent(100);
            this.setDiffusePercent(0);
            this.addRenderer(1073741880);
        } else {
            this.setAmbientPercent(this.saveAmbient);
            this.setDiffusePercent(this.saveDiffuse);
        }
    }

    @Override
    public void fillSphereI(int diameter, P3i center) {
        this.fillSphereXYZ(diameter, center.x, center.y, center.z);
    }

    @Override
    public void fillSphereBits(int diameter, P3 center) {
        this.fillSphereXYZ(diameter, Math.round(center.x), Math.round(center.y), Math.round(center.z));
    }

    @Override
    public void fillEllipsoid(P3 center, P3[] points, int x, int y, int z, int diameter, M3 mToEllipsoidal, double[] coef, M4 mDeriv, int selectedOctant, P3[] octantPoints) {
        switch (diameter) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, x, y, z, this.width, this.zbuf, this.pixel);
                return;
            }
            case 0: {
                return;
            }
        }
        if (diameter <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, diameter, x, y, z, mToEllipsoidal, coef, mDeriv, selectedOctant, octantPoints);
        }
    }

    @Override
    public void drawRect(int x, int y, int z, int zSlab, int rWidth, int rHeight) {
        if (zSlab != 0 && this.isClippedZ(zSlab)) {
            return;
        }
        int w = rWidth - 1;
        int h = rHeight - 1;
        int xRight = x + w;
        int yBottom = y + h;
        if (y >= 0 && y < this.height) {
            this.drawHLine(x, y, z, w);
        }
        if (yBottom >= 0 && yBottom < this.height) {
            this.drawHLine(x, yBottom, z, w);
        }
        if (x >= 0 && x < this.width) {
            this.drawVLine(x, y, z, h);
        }
        if (xRight >= 0 && xRight < this.width) {
            this.drawVLine(xRight, y, z, h);
        }
    }

    private void drawHLine(int x, int y, int z, int w) {
        if (w < 0) {
            x += w;
            w = -w;
        }
        if (x < 0) {
            w += x;
            x = 0;
        }
        if (x + w >= this.width) {
            w = this.width - 1 - x;
        }
        Pixelator p = this.pixel;
        int c = this.argbCurrent;
        int offset = x + this.width * y;
        for (int i = 0; i <= w; ++i) {
            if (z < this.zbuf[offset]) {
                p.addPixel(offset, z, c);
            }
            ++offset;
        }
    }

    private void drawVLine(int x, int y, int z, int h) {
        if (h < 0) {
            y += h;
            h = -h;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (y + h >= this.height) {
            h = this.height - 1 - y;
        }
        int offset = x + this.width * y;
        Pixelator p = this.pixel;
        int c = this.argbCurrent;
        for (int i = 0; i <= h; ++i) {
            if (z < this.zbuf[offset]) {
                p.addPixel(offset, z, c);
            }
            offset += this.width;
        }
    }

    @Override
    public void fillTextRect(int x, int y, int z, int zSlab, int widthFill, int heightFill) {
        if (this.isClippedZ(zSlab)) {
            return;
        }
        int w = this.width;
        if (x < 0) {
            if ((widthFill += x) <= 0) {
                return;
            }
            x = 0;
        }
        if (x + widthFill > w && (widthFill = w - x) <= 0) {
            return;
        }
        if (y < 0) {
            if ((heightFill += y) <= 0) {
                return;
            }
            y = 0;
        }
        if (y + heightFill > this.height) {
            heightFill = this.height - y;
        }
        int c = this.argbCurrent;
        int[] zb = this.zbuf;
        Pixelator p = this.pixel;
        while (--heightFill >= 0) {
            this.plotPixelsUnclippedCount(c, widthFill, x, y++, z, w, zb, p);
        }
    }

    @Override
    public void drawString(String str, Font font3d, int xBaseline, int yBaseline, int z, int zSlab, short bgColix) {
        this.currentShadeIndex = 0;
        if (str == null) {
            return;
        }
        if (this.isClippedZ(zSlab)) {
            return;
        }
        this.drawStringNoSlab(str, font3d, xBaseline, yBaseline, z, bgColix);
    }

    @Override
    public void drawStringNoSlab(String str, Font font3d, int xBaseline, int yBaseline, int z, short bgColix) {
        if (str == null) {
            return;
        }
        if (this.strings == null) {
            this.strings = new TextString[10];
        }
        if (this.stringCount == this.strings.length) {
            this.strings = (TextString[])AU.doubleLength(this.strings);
        }
        TextString t = new TextString();
        t.setText(str, font3d == null ? this.currentFont : (this.currentFont = font3d), this.argbCurrent, C.isColixTranslucent(bgColix) ? this.getColorArgbOrGray(bgColix) & 0xFFFFFF | (bgColix & 0x7800) << 13 : 0, xBaseline, yBaseline, z);
        this.strings[this.stringCount++] = t;
    }

    @Override
    public void renderAllStrings(Object jmolRenderer) {
        if (this.strings == null) {
            return;
        }
        if (this.stringCount >= 2) {
            if (sort == null) {
                sort = new TextString();
            }
            Arrays.sort(this.strings, sort);
        }
        for (int i = 0; i < this.stringCount; ++i) {
            TextString ts = this.strings[i];
            this.plotText(ts.x, ts.y, ts.z, ts.argb, ts.bgargb, ts.text, ts.font, (JmolRendererInterface)jmolRenderer);
        }
        this.strings = null;
        this.stringCount = 0;
    }

    @Override
    public void plotText(int x, int y, int z, int argb, int bgargb, String text, Font font3d, JmolRendererInterface jmolRenderer) {
        TextRenderer.plot(x, y, z, argb, bgargb, text, font3d, this, jmolRenderer, this.antialiasThisFrame);
    }

    @Override
    public void drawImage(Object objImage, int x, int y, int z, int zSlab, short bgcolix, int width, int height) {
        if (objImage != null && width > 0 && height > 0 && !this.isClippedZ(zSlab)) {
            this.plotImage(x, y, z, objImage, null, bgcolix, width, height);
        }
    }

    @Override
    public void plotImage(int x, int y, int z, Object image, JmolRendererInterface jmolRenderer, short bgcolix, int imageWidth, int imageHeight) {
        int bg;
        this.setC(bgcolix);
        if (!this.isPass2) {
            this.translucencyMask = -1;
        }
        if (bgcolix == 0) {
            this.argbCurrent = 0;
        }
        boolean isBackground = x == Integer.MIN_VALUE;
        int n = bg = isBackground ? this.bgcolor : this.argbCurrent;
        if (isBackground) {
            x = 0;
            z = 0x7FFFFFFE;
            imageWidth = this.width;
            imageHeight = this.height;
        }
        if (x + imageWidth <= 0 || x >= this.width || y + imageHeight <= 0 || y >= this.height) {
            return;
        }
        Object g = this.vwr.isJSNoAWT ? null : this.platform.getGraphicsForTextOrImage(imageWidth, imageHeight);
        int[] buffer = this.apiPlatform.drawImageToBuffer(g, this.platform.offscreenImage, image, imageWidth, imageHeight, isBackground ? bg : 0);
        if (buffer == null) {
            return;
        }
        int[] zb = this.zbuf;
        int w = this.width;
        Pixelator p = this.pixel;
        int h = this.height;
        int t = this.translucencyLog;
        if (jmolRenderer == null && x >= 0 && x + imageWidth <= w && y >= 0 && y + imageHeight <= h) {
            int i = 0;
            int offset = 0;
            int pbufOffset = y * w + x;
            while (i < imageHeight) {
                int j = 0;
                while (j < imageWidth) {
                    int b;
                    if (z < zb[pbufOffset] && ((b = buffer[offset]) & 0xFF000000) == -16777216) {
                        p.addPixel(pbufOffset, z, b);
                    }
                    ++j;
                    ++offset;
                    ++pbufOffset;
                }
                ++i;
                pbufOffset += w - imageWidth;
            }
        } else {
            if (jmolRenderer == null) {
                jmolRenderer = this;
            }
            int offset = 0;
            for (int i = 0; i < imageHeight; ++i) {
                for (int j = 0; j < imageWidth; ++j) {
                    int b;
                    if (((b = buffer[offset++]) & 0xFF000000) != -16777216) continue;
                    jmolRenderer.plotImagePixel(b, x + j, y + i, z, (byte)8, bg, w, h, zb, p, t);
                }
            }
        }
    }

    @Override
    public void setFontFid(byte fid) {
        this.currentFont = Font.getFont3D(fid);
    }

    @Override
    public void setFont(Font font3d) {
        this.currentFont = font3d;
    }

    @Override
    public void drawPixel(int x, int y, int z) {
        this.plotPixelClippedArgb(this.argbCurrent, x, y, z, this.width, this.zbuf, this.pixel);
    }

    @Override
    public void drawPoints(int count, int[] coordinates, int scale) {
        if (scale > 1) {
            float s2 = (float)(scale * scale) * 0.8f;
            for (int i = -scale; i < scale; ++i) {
                for (int j = -scale; j < scale; ++j) {
                    if ((float)(i * i + j * j) > s2) continue;
                    this.plotPoints(count, coordinates, i, j);
                    this.plotPoints(count, coordinates, i, j);
                }
            }
        } else {
            this.plotPoints(count, coordinates, 0, 0);
        }
    }

    @Override
    public void drawDashedLineBits(int run, int rise, P3 pointA, P3 pointB) {
        if (this.isAntialiased()) {
            run += run;
            rise += rise;
        }
        this.setScreeni(pointA, this.sA);
        this.setScreeni(pointB, this.sB);
        this.line3d.plotLineBits(this.argbCurrent, this.argbCurrent, this.sA, this.sB, run, rise, true);
        if (this.isAntialiased()) {
            if (Math.abs(pointA.x - pointB.x) < Math.abs(pointA.y - pointB.y)) {
                ++this.sA.x;
                ++this.sB.x;
                this.line3d.plotLineBits(this.argbCurrent, this.argbCurrent, this.sA, this.sB, run, rise, true);
            } else {
                ++this.sA.y;
                ++this.sB.y;
                this.line3d.plotLineBits(this.argbCurrent, this.argbCurrent, this.sA, this.sB, run, rise, true);
            }
        }
    }

    private void setScreeni(P3 pt, P3i p) {
        p.x = Math.round(pt.x);
        p.y = Math.round(pt.y);
        p.z = Math.round(pt.z);
    }

    @Override
    public void drawLineXYZ(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.line3d.plotLineOld(this.argbCurrent, this.argbCurrent, x1, y1, z1, x2, y2, z2);
    }

    @Override
    public void drawLine(short colixA, short colixB, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (!this.setC(colixA)) {
            colixA = 0;
        }
        int argbA = this.argbCurrent;
        if (!this.setC(colixB)) {
            colixB = 0;
        }
        if (colixA != 0 || colixB != 0) {
            this.line3d.plotLineOld(argbA, this.argbCurrent, x1, y1, z1, x2, y2, z2);
        }
    }

    @Override
    public void drawLineBits(short colixA, short colixB, P3 pointA, P3 pointB) {
        if (!this.setC(colixA)) {
            colixA = 0;
        }
        int argbA = this.argbCurrent;
        if (!this.setC(colixB)) {
            colixB = 0;
        }
        if (colixA != 0 || colixB != 0) {
            this.setScreeni(pointA, this.sA);
            this.setScreeni(pointB, this.sB);
            this.line3d.plotLineBits(argbA, this.argbCurrent, this.sA, this.sB, 0, 0, false);
        }
    }

    @Override
    public void drawLineAB(P3 pointA, P3 pointB) {
        this.setScreeni(pointA, this.sA);
        this.setScreeni(pointB, this.sB);
        this.line3d.plotLineBits(this.argbCurrent, this.argbCurrent, this.sA, this.sB, 0, 0, false);
    }

    @Override
    public void fillCylinderXYZ(short colixA, short colixB, byte endcaps, int diameter, int xA, int yA, int zA, int xB, int yB, int zB) {
        if (diameter > this.ht3) {
            return;
        }
        int screen = 0;
        this.currentShadeIndex = 0;
        if (!this.setC(colixB)) {
            colixB = 0;
        }
        if (this.wasScreened) {
            screen = 2;
        }
        if (!this.setC(colixA)) {
            colixA = 0;
        }
        if (this.wasScreened) {
            ++screen;
        }
        if (colixA == 0 && colixB == 0) {
            return;
        }
        this.cylinder3d.renderOld(colixA, colixB, screen, endcaps, diameter, xA, yA, zA, xB, yB, zB);
    }

    @Override
    public void fillCylinderScreen3I(byte endcaps, int diameter, P3 screenA, P3 screenB, P3 pt0f, P3 pt1f, float radius) {
        if (diameter <= this.ht3) {
            this.cylinder3d.renderOld(this.colixCurrent, this.colixCurrent, 0, endcaps, diameter, (int)screenA.x, (int)screenA.y, (int)screenA.z, (int)screenB.x, (int)screenB.y, (int)screenB.z);
        }
    }

    @Override
    public void fillCylinder(byte endcaps, int diameter, P3i screenA, P3i screenB) {
        if (diameter <= this.ht3) {
            this.cylinder3d.renderOld(this.colixCurrent, this.colixCurrent, 0, endcaps, diameter, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
        }
    }

    @Override
    public void fillCylinderBits(byte endcaps, int diameter, P3 screenA, P3 screenB) {
        if (diameter <= this.ht3 && screenA.z != 1.0f && screenB.z != 1.0f) {
            if (diameter == 0 || diameter == 1) {
                this.setScreeni(screenA, this.sA);
                this.setScreeni(screenB, this.sB);
                this.line3d.plotLineBits(this.getColorArgbOrGray(this.colixCurrent), this.getColorArgbOrGray(this.colixCurrent), this.sA, this.sB, 0, 0, false);
                return;
            }
            this.cylinder3d.renderBitsFloat(this.colixCurrent, this.colixCurrent, 0, endcaps, diameter, screenA, screenB);
        }
    }

    @Override
    public void fillCylinderBits2(short colixA, short colixB, byte endcaps, int diameter, P3 screenA, P3 screenB) {
        if (diameter > this.ht3) {
            return;
        }
        int screen = 0;
        this.currentShadeIndex = 0;
        if (!this.setC(colixB)) {
            colixB = 0;
        }
        if (this.wasScreened) {
            screen = 2;
        }
        if (!this.setC(colixA)) {
            colixA = 0;
        }
        if (this.wasScreened) {
            ++screen;
        }
        if (colixA == 0 && colixB == 0) {
            return;
        }
        this.setScreeni(screenA, this.sA);
        this.setScreeni(screenB, this.sB);
        this.cylinder3d.renderBits(colixA, colixB, screen, endcaps, diameter, this.sA, this.sB);
    }

    @Override
    public void fillConeScreen3f(byte endcap, int screenDiameter, P3 screenBase, P3 screenTip, boolean isBarb) {
        if (screenDiameter <= this.ht3) {
            this.cylinder3d.renderConeOld(this.colixCurrent, endcap, screenDiameter, screenBase.x, screenBase.y, screenBase.z, screenTip.x, screenTip.y, screenTip.z, true, isBarb);
        }
    }

    @Override
    public void drawHermite4(int tension, P3 s0, P3 s1, P3 s2, P3 s3) {
        ((HermiteRenderer)this.hermite3d).renderHermiteRope(false, tension, 0, 0, 0, s0, s1, s2, s3);
    }

    @Override
    public void drawHermite7(boolean fill, boolean border, int tension, P3 s0, P3 s1, P3 s2, P3 s3, P3 s4, P3 s5, P3 s6, P3 s7, int aspectRatio, short colixBack) {
        if (colixBack == 0) {
            ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, 0);
            return;
        }
        ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, 1);
        short colix = this.colixCurrent;
        this.setC(colixBack);
        ((HermiteRenderer)this.hermite3d).renderHermiteRibbon(fill, border, tension, s0, s1, s2, s3, s4, s5, s6, s7, aspectRatio, -1);
        this.setC(colix);
    }

    @Override
    public void fillHermite(int tension, int diameterBeg, int diameterMid, int diameterEnd, P3 s0, P3 s1, P3 s2, P3 s3) {
        ((HermiteRenderer)this.hermite3d).renderHermiteRope(true, tension, diameterBeg, diameterMid, diameterEnd, s0, s1, s2, s3);
    }

    @Override
    public void drawTriangle3C(P3i screenA, short colixA, P3i screenB, short colixB, P3i screenC, short colixC, int check) {
        if ((check & 1) == 1) {
            this.drawLine(colixA, colixB, screenA.x, screenA.y, screenA.z, screenB.x, screenB.y, screenB.z);
        }
        if ((check & 2) == 2) {
            this.drawLine(colixB, colixC, screenB.x, screenB.y, screenB.z, screenC.x, screenC.y, screenC.z);
        }
        if ((check & 4) == 4) {
            this.drawLine(colixA, colixC, screenA.x, screenA.y, screenA.z, screenC.x, screenC.y, screenC.z);
        }
    }

    @Override
    public void fillTriangleTwoSided(short normix, P3 screenA, P3 screenB, P3 screenC) {
        this.setColorNoisy(this.getShadeIndex(normix));
        this.fillTriangleP3f(screenA, screenB, screenC, false);
    }

    private void fillTriangleP3f(P3 screenA, P3 screenB, P3 screenC, boolean useGouraud) {
        this.setScreeni(screenA, this.sA);
        this.setScreeni(screenB, this.sB);
        this.setScreeni(screenC, this.sC);
        ((TriangleRenderer)this.triangle3d).fillTriangle(this.sA, this.sB, this.sC, useGouraud);
    }

    @Override
    public void fillTriangle3f(P3 screenA, P3 screenB, P3 screenC, boolean isSolid) {
        int i = this.getShadeIndexP3(screenA, screenB, screenC, isSolid);
        if (i < 0) {
            return;
        }
        if (isSolid) {
            this.setColorNoisy(i);
        } else {
            this.setColor(this.shadesCurrent[i]);
        }
        this.fillTriangleP3f(screenA, screenB, screenC, false);
    }

    @Override
    public void fillTriangle3i(P3 screenA, P3 screenB, P3 screenC, T3 ptA, T3 ptB, T3 ptC, boolean doShade) {
        if (doShade) {
            int shadeIndex;
            V3 v = this.vectorAB;
            v.set(screenB.x - screenA.x, screenB.y - screenA.y, screenB.z - screenA.z);
            if (screenC == null) {
                shadeIndex = this.shader.getShadeIndex(-v.x, -v.y, v.z);
            } else {
                this.vectorAC.set(screenC.x - screenA.x, screenC.y - screenA.y, screenC.z - screenA.z);
                v.cross(v, this.vectorAC);
                int n = shadeIndex = v.z >= 0.0f ? this.shader.getShadeIndex(-v.x, -v.y, v.z) : this.shader.getShadeIndex(v.x, v.y, -v.z);
            }
            if (shadeIndex > 56) {
                shadeIndex = 56;
            }
            this.setColorNoisy(shadeIndex);
        }
        this.fillTriangleP3f(screenA, screenB, screenC, false);
    }

    @Override
    public void fillTriangle3CN(P3i screenA, short colixA, short normixA, P3i screenB, short colixB, short normixB, P3i screenC, short colixC, short normixC) {
        ((TriangleRenderer)this.triangle3d).fillTriangle(screenA, screenB, screenC, this.checkGouraud(colixA, colixB, colixC, normixA, normixB, normixC));
    }

    @Override
    public void fillTriangle3CNBits(P3 screenA, short colixA, short normixA, P3 screenB, short colixB, short normixB, P3 screenC, short colixC, short normixC, boolean twoSided) {
        this.fillTriangleP3f(screenA, screenB, screenC, this.checkGouraud(colixA, colixB, colixC, normixA, normixB, normixC));
    }

    private boolean checkGouraud(short colixA, short colixB, short colixC, short normixA, short normixB, short normixC) {
        if (!this.isPass2 && normixA == normixB && normixA == normixC && colixA == colixB && colixA == colixC) {
            int shadeIndex = this.getShadeIndex(normixA);
            if (colixA != this.colixCurrent || this.currentShadeIndex != shadeIndex) {
                this.currentShadeIndex = -1;
                this.setC(colixA);
                this.setColorNoisy(shadeIndex);
            }
            return false;
        }
        this.setTriangleTranslucency(colixA, colixB, colixC);
        ((TriangleRenderer)this.triangle3d).setGouraud(this.getShades(colixA)[this.getShadeIndex(normixA)], this.getShades(colixB)[this.getShadeIndex(normixB)], this.getShades(colixC)[this.getShadeIndex(normixC)]);
        return true;
    }

    public int getShadeIndex(short normix) {
        return normix == -10000 || normix == 9999 ? nullShadeIndex : (normix < 0 ? this.shadeIndexes2Sided[~normix] : this.shadeIndexes[normix]);
    }

    private void setTriangleTranslucency(short colixA, short colixB, short colixC) {
        if (this.isPass2) {
            int maskA = colixA & 0x7800;
            int maskB = colixB & 0x7800;
            int maskC = colixC & 0x7800;
            int mask = Graphics3D.roundInt(((maskA &= 0xFFFFBFFF) + (maskB &= 0xFFFFBFFF) + (maskC &= 0xFFFFBFFF)) / 3) & 0x7800;
            this.translucencyMask = mask << 13 | 0xFFFFFF;
        }
    }

    @Override
    public void fillQuadrilateral(P3 screenA, P3 screenB, P3 screenC, P3 screenD, boolean isSolid) {
        int i = this.getShadeIndexP3(screenA, screenB, screenC, isSolid);
        if (i < 0) {
            return;
        }
        this.setColorNoisy(i);
        this.fillTriangleP3f(screenA, screenB, screenC, false);
        this.fillTriangleP3f(screenA, screenC, screenD, false);
    }

    @Override
    public void drawSurface(MeshSurface meshSurface, short colix) {
    }

    @Override
    public void plotPixelClippedP3i(P3i screen) {
        this.plotPixelClippedArgb(this.argbCurrent, screen.x, screen.y, screen.z, this.width, this.zbuf, this.pixel);
    }

    void plotPixelClippedArgb(int argb, int x, int y, int z, int width, int[] zbuf, Pixelator p) {
        if (this.isClipped3(x, y, z)) {
            return;
        }
        int offset = y * width + x;
        if (z < zbuf[offset]) {
            p.addPixel(offset, z, argb);
        }
    }

    void plotPixelUnclipped(int argb, int x, int y, int z, int width, int[] zbuf, Pixelator p) {
        int offset = y * width + x;
        if (z < zbuf[offset]) {
            p.addPixel(offset, z, argb);
        }
    }

    @Override
    public void plotImagePixel(int argb, int x, int y, int z, byte shade, int bgargb, int width, int height, int[] zbuf, Object p, int transpLog) {
        if (x < 0 || x >= width || y < 0 || y >= height) {
            return;
        }
        ((Pixelator)p).addImagePixel(shade, transpLog, y * width + x, z, argb, bgargb);
    }

    void plotPixelsClippedRaster(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        int depth;
        int slab;
        if (count <= 0 || y < 0 || y >= this.height || x >= this.width || zAtLeft < (slab = this.slab) && zPastRight < slab || zAtLeft > (depth = this.depth) && zPastRight > depth) {
            return;
        }
        int[] zb = this.zbuf;
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = Graphics3D.roundInt(((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count);
        if (x < 0) {
            x = -x;
            zScaled += zIncrementScaled * x;
            if ((count -= x) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        int offsetPbuf = y * this.width + x;
        Pixelator p = this.pixel;
        if (rgb16Left == null) {
            int adn = this.argbNoisyDn;
            int aup = this.argbNoisyUp;
            int ac = this.argbCurrent;
            while (--count >= 0) {
                int z = zScaled >> 10;
                if (z >= slab && z <= depth && z < zb[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    p.addPixel(offsetPbuf, z, bits == 0 ? adn : (bits == 1 ? aup : ac));
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
            }
        } else {
            int rScaled = rgb16Left.r << 8;
            int rIncrement = (rgb16Right.r - rgb16Left.r << 8) / count;
            int gScaled = rgb16Left.g;
            int gIncrement = (rgb16Right.g - gScaled) / count;
            int bScaled = rgb16Left.b;
            int bIncrement = (rgb16Right.b - bScaled) / count;
            while (--count >= 0) {
                int z = zScaled >> 10;
                if (z >= slab && z <= depth && z < zb[offsetPbuf]) {
                    p.addPixel(offsetPbuf, z, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclippedRaster(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right) {
        if (count <= 0) {
            return;
        }
        int seed = ((x << 16) + (y << 1) ^ 0x33333333) & Integer.MAX_VALUE;
        int zScaled = (zAtLeft << 10) + 512;
        int dz = zPastRight - zAtLeft;
        int roundFactor = count / 2;
        int zIncrementScaled = Graphics3D.roundInt(((dz << 10) + (dz >= 0 ? roundFactor : -roundFactor)) / count);
        int offsetPbuf = y * this.width + x;
        int[] zb = this.zbuf;
        Pixelator p = this.pixel;
        if (rgb16Left == null) {
            int adn = this.argbNoisyDn;
            int aup = this.argbNoisyUp;
            int ac = this.argbCurrent;
            while (--count >= 0) {
                int z = zScaled >> 10;
                if (z < zb[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    p.addPixel(offsetPbuf, z, bits == 0 ? adn : (bits == 1 ? aup : ac));
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
            }
        } else {
            int rScaled = rgb16Left.r << 8;
            int rIncrement = Graphics3D.roundInt((rgb16Right.r - rgb16Left.r << 8) / count);
            int gScaled = rgb16Left.g;
            int gIncrement = Graphics3D.roundInt((rgb16Right.g - gScaled) / count);
            int bScaled = rgb16Left.b;
            int bIncrement = Graphics3D.roundInt((rgb16Right.b - bScaled) / count);
            while (--count >= 0) {
                int z = zScaled >> 10;
                if (z < zb[offsetPbuf]) {
                    p.addPixel(offsetPbuf, z, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                zScaled += zIncrementScaled;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsClippedRasterBits(int count, int x, int y, int zAtLeft, int zPastRight, Rgb16 rgb16Left, Rgb16 rgb16Right, float a, float b) {
        int depth;
        int slab;
        if (count <= 0 || y < 0 || y >= this.height || x >= this.width || zAtLeft < (slab = this.slab) && zPastRight < slab || zAtLeft > (depth = this.depth) && zPastRight > depth) {
            return;
        }
        int[] zb = this.zbuf;
        int seed = (x << 16) + (y << 1) ^ 0x33333333;
        if (x < 0) {
            if ((count -= (x = -x)) <= 0) {
                return;
            }
            x = 0;
        }
        if (count + x > this.width) {
            count = this.width - x;
        }
        int offsetPbuf = y * this.width + x;
        Pixelator p = this.pixel;
        if (rgb16Left == null) {
            int adn = this.argbNoisyDn;
            int aup = this.argbNoisyUp;
            int ac = this.argbCurrent;
            while (--count >= 0) {
                int zCurrent;
                if ((zCurrent = this.line3d.getZCurrent(a, b, x++)) >= slab && zCurrent <= depth && zCurrent < zb[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    p.addPixel(offsetPbuf, zCurrent, bits < 2 ? adn : (bits < 6 ? aup : ac));
                }
                ++offsetPbuf;
            }
        } else {
            int rScaled = rgb16Left.r << 8;
            int rIncrement = (rgb16Right.r - rgb16Left.r << 8) / count;
            int gScaled = rgb16Left.g;
            int gIncrement = (rgb16Right.g - gScaled) / count;
            int bScaled = rgb16Left.b;
            int bIncrement = (rgb16Right.b - bScaled) / count;
            while (--count >= 0) {
                int zCurrent;
                if ((zCurrent = this.line3d.getZCurrent(a, b, x++)) >= slab && zCurrent <= depth && zCurrent < zb[offsetPbuf]) {
                    p.addPixel(offsetPbuf, zCurrent, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclippedRasterBits(int count, int x, int y, Rgb16 rgb16Left, Rgb16 rgb16Right, float a, float b) {
        if (count <= 0) {
            return;
        }
        int seed = ((x << 16) + (y << 1) ^ 0x33333333) & Integer.MAX_VALUE;
        int offsetPbuf = y * this.width + x;
        int[] zb = this.zbuf;
        Pixelator p = this.pixel;
        if (rgb16Left == null) {
            int adn = this.argbNoisyDn;
            int aup = this.argbNoisyUp;
            int ac = this.argbCurrent;
            while (--count >= 0) {
                int zCurrent;
                if ((zCurrent = this.line3d.getZCurrent(a, b, x++)) < zb[offsetPbuf]) {
                    int bits = (seed = (seed << 16) + (seed << 1) + seed & Integer.MAX_VALUE) >> 16 & 7;
                    int c = bits == 0 ? adn : (bits == 1 ? aup : ac);
                    p.addPixel(offsetPbuf, zCurrent, c);
                }
                ++offsetPbuf;
            }
        } else {
            int rScaled = rgb16Left.r << 8;
            int rIncrement = Graphics3D.roundInt((rgb16Right.r - rgb16Left.r << 8) / count);
            int gScaled = rgb16Left.g;
            int gIncrement = Graphics3D.roundInt((rgb16Right.g - gScaled) / count);
            int bScaled = rgb16Left.b;
            int bIncrement = Graphics3D.roundInt((rgb16Right.b - bScaled) / count);
            while (--count >= 0) {
                int zCurrent;
                if ((zCurrent = this.line3d.getZCurrent(a, b, x++)) < zb[offsetPbuf]) {
                    p.addPixel(offsetPbuf, zCurrent, 0xFF000000 | rScaled & 0xFF0000 | gScaled & 0xFF00 | bScaled >> 8 & 0xFF);
                }
                ++offsetPbuf;
                rScaled += rIncrement;
                gScaled += gIncrement;
                bScaled += bIncrement;
            }
        }
    }

    void plotPixelsUnclippedCount(int c, int count, int x, int y, int z, int width, int[] zbuf, Pixelator p) {
        int offsetPbuf = y * width + x;
        while (--count >= 0) {
            if (z < zbuf[offsetPbuf]) {
                p.addPixel(offsetPbuf, z, c);
            }
            ++offsetPbuf;
        }
    }

    private void plotPoints(int count, int[] coordinates, int xOffset, int yOffset) {
        Pixelator p = this.pixel;
        int c = this.argbCurrent;
        int[] zb = this.zbuf;
        int w = this.width;
        boolean antialias = this.antialiasThisFrame;
        int i = count * 3;
        while (i > 0) {
            int offset;
            int y;
            int x;
            int z = coordinates[--i];
            --i;
            if (this.isClipped3(x = coordinates[--i] + xOffset, y = coordinates[i] + yOffset, z)) continue;
            if (z < zb[offset = y * w + x++]) {
                p.addPixel(offset, z, c);
            }
            if (!antialias) continue;
            offset = y * w + x;
            if (!this.isClipped3(x, y, z) && z < zb[offset]) {
                p.addPixel(offset, z, c);
            }
            offset = ++y * w + x;
            if (!this.isClipped3(x, y, z) && z < zb[offset]) {
                p.addPixel(offset, z, c);
            }
            offset = y * w + --x;
            if (this.isClipped3(x, y, z) || z >= zb[offset]) continue;
            p.addPixel(offset, z, c);
        }
    }

    void setColorNoisy(int shadeIndex) {
        this.currentShadeIndex = shadeIndex;
        this.argbCurrent = this.shadesCurrent[shadeIndex];
        this.argbNoisyUp = this.shadesCurrent[shadeIndex < 63 ? shadeIndex + 1 : 63];
        this.argbNoisyDn = this.shadesCurrent[shadeIndex > 0 ? shadeIndex - 1 : 0];
    }

    private int getShadeIndexP3(P3 screenA, P3 screenB, P3 screenC, boolean isSolid) {
        this.vectorAB.sub2(screenB, screenA);
        this.vectorAC.sub2(screenC, screenA);
        V3 v = this.vectorNormal;
        v.cross(this.vectorAB, this.vectorAC);
        int i = v.z < 0.0f ? this.shader.getShadeIndex(v.x, v.y, -v.z) : (isSolid ? -1 : this.shader.getShadeIndex(-v.x, -v.y, v.z));
        return i;
    }

    @Override
    public void renderBackground(JmolRendererInterface jmolRenderer) {
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, jmolRenderer, (short)0, 0, 0);
        }
    }

    @Override
    public void drawAtom(Atom atom, float radius) {
        this.fillSphereXYZ(atom.sD, atom.sX, atom.sY, atom.sZ);
    }

    @Override
    public int getExportType() {
        return 0;
    }

    @Override
    public String getExportName() {
        return null;
    }

    public boolean canDoTriangles() {
        return true;
    }

    public boolean isCartesianExport() {
        return false;
    }

    @Override
    public JmolRendererInterface initializeExporter(Viewer vwr, double privateKey, GData g3d, Map<String, Object> params) {
        return null;
    }

    @Override
    public String finalizeOutput() {
        return null;
    }

    @Override
    public void drawBond(P3 atomA, P3 atomB, short colixA, short colixB, byte endcaps, short mad, int bondOrder) {
    }

    @Override
    public boolean drawEllipse(P3 ptAtom, P3 ptX, P3 ptY, boolean fillArc, boolean wireframeOnly) {
        return false;
    }

    public double getPrivateKey() {
        return 0.0;
    }

    @Override
    public void clearFontCache() {
        TextRenderer.clearFontCache();
    }

    public void setRotationMatrix(M3 rotationMatrix) {
        V3[] vertexVectors = Normix.getVertexVectors();
        int i = normixCount;
        while (--i >= 0) {
            V3 tv = this.transformedVectors[i];
            rotationMatrix.rotate2(vertexVectors[i], tv);
            this.shadeIndexes[i] = this.shader.getShadeB(tv.x, -tv.y, tv.z);
            this.shadeIndexes2Sided[i] = tv.z >= 0.0f ? this.shadeIndexes[i] : this.shader.getShadeB(-tv.x, tv.y, -tv.z);
        }
    }

    @Override
    public void renderCrossHairs(int[] minMax, int screenWidth, int screenHeight, P3 navOffset, float navDepth) {
        boolean antialiased = this.isAntialiased();
        this.setC((short)(navDepth < 0.0f ? 10 : (navDepth > 100.0f ? 11 : 23)));
        int x = Math.max(Math.min(this.width, Math.round(navOffset.x)), 0);
        int y = Math.max(Math.min(this.height, Math.round(navOffset.y)), 0);
        int z = Math.round(navOffset.z) + 1;
        int off = antialiased ? 8 : 4;
        int h = antialiased ? 20 : 10;
        int w = antialiased ? 2 : 1;
        this.drawRect(x - off, y, z, 0, h, w);
        this.drawRect(x, y - off, z, 0, w, h);
        this.drawRect(x - off, y - off, z, 0, h, h);
        off = h;
        this.setC((float)minMax[1] < navOffset.x ? (short)21 : 11);
        this.drawRect(x - off, y, z, 0, h >>= 1, w);
        this.setC((float)minMax[0] > navOffset.x ? (short)21 : 11);
        this.drawRect(x + h, y, z, 0, h, w);
        this.setC((float)minMax[3] < navOffset.y ? (short)21 : 11);
        this.drawRect(x, y - off, z, 0, w, h);
        this.setC((float)minMax[2] > navOffset.y ? (short)21 : 11);
        this.drawRect(x, y + h, z, 0, w, h);
    }

    @Override
    public boolean initializeOutput(Viewer vwr, double privateKey, Map<String, Object> params) {
        return false;
    }

    static {
        nullShadeIndex = (byte)50;
    }
}

