/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppDataOutputStream
extends DataOutputStream {
    private Log log = LogFactory.getLog((Class)AppDataOutputStream.class);
    private boolean isOpen = true;

    public AppDataOutputStream(OutputStream out) {
        super(out);
    }

    public void flush() throws IOException {
        if (this.isOpen) {
            super.flush();
        } else {
            this.log.warn((Object)"flush() called on closed AppDataOutputStream");
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (!this.isOpen) {
            this.log.debug((Object)"write(b,off,len) called on closed AppDataOutputStream");
            throw new IOException("Attempt to write to closed AppDataOutputStream");
        }
        super.write(b, off, len);
    }

    public synchronized void write(int b) throws IOException {
        if (!this.isOpen) {
            this.log.debug((Object)"write(b) called on closed AppDataOutputStream");
            throw new IOException("Attempt to write to closed AppDataOutputStream");
        }
        super.write(b);
    }

    public void close() throws IOException {
        this.isOpen = false;
        super.flush();
        this.log.debug((Object)"AppDataOutputStream was closed.");
    }

    public void write(byte[] b) throws IOException {
        if (!this.isOpen) {
            this.log.debug((Object)"write(b[]) called on closed AppDataOutputStream");
            throw new IOException("Attempt to write to closed AppDataOutputStream");
        }
        super.write(b);
    }

    public boolean isOpen() {
        return this.isOpen;
    }
}

