/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util.xml;

import com.sun.istack.Nullable;
import com.sun.xml.ws.server.ServerRtException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.xml.catalog.CatalogFeatures;
import javax.xml.catalog.CatalogManager;
import javax.xml.ws.WebServiceException;
import org.xml.sax.EntityResolver;

public class XmlCatalogUtil {
    private static final CatalogFeatures CATALOG_FEATURES = CatalogFeatures.builder().with(CatalogFeatures.Feature.RESOLVE, "continue").build();

    public static EntityResolver createEntityResolver(@Nullable URL uRL) {
        EntityResolver entityResolver;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (uRL != null) {
            arrayList.add(uRL);
        }
        try {
            entityResolver = XmlCatalogUtil.createCatalogResolver(arrayList);
        }
        catch (Exception exception) {
            throw new ServerRtException("server.rt.err", exception);
        }
        return entityResolver;
    }

    public static EntityResolver createDefaultCatalogResolver() {
        EntityResolver entityResolver;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> enumeration = classLoader == null ? ClassLoader.getSystemResources("META-INF/jax-ws-catalog.xml") : classLoader.getResources("META-INF/jax-ws-catalog.xml");
            entityResolver = XmlCatalogUtil.createCatalogResolver(Collections.list(enumeration));
        }
        catch (Exception exception) {
            throw new WebServiceException((Throwable)exception);
        }
        return entityResolver;
    }

    private static EntityResolver createCatalogResolver(ArrayList<URL> arrayList) throws Exception {
        URI[] uRIArray = (URI[])arrayList.stream().map(uRL -> URI.create(uRL.toExternalForm())).toArray(URI[]::new);
        return CatalogManager.catalogResolver(CATALOG_FEATURES, uRIArray);
    }
}

