/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.util.Comparison;
import java.awt.Color;

public class PIDColourScheme
extends ResidueColourScheme {
    private static final Color[] pidColours = new Color[]{new Color(100, 100, 255), new Color(153, 153, 255), new Color(204, 204, 255)};
    private static final float[] thresholds = new float[]{80.0f, 60.0f, 40.0f};
    SequenceGroup group;

    @Override
    public Color findColour(char c, int j, SequenceI seq, String consensusResidue, float pid) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        if (consensusResidue == null || Comparison.isGap(c)) {
            return Color.white;
        }
        Color colour = Color.white;
        boolean matchesConsensus = consensusResidue.contains(String.valueOf(c));
        if (matchesConsensus) {
            for (int i = 0; i < thresholds.length; ++i) {
                if (!(pid > thresholds[i])) continue;
                colour = pidColours[i];
                break;
            }
        }
        return colour;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.PID.toString();
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new PIDColourScheme();
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

