/*
 * Decompiled with CFR 0.152.
 */
package jalview.log;

import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.log.JLogger;
import jalview.log.JLoggerI;
import jalview.util.Log4j;
import jalview.util.Platform;
import java.io.File;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;

public class JLoggerLog4j
extends JLogger
implements JLoggerI {
    private Logger logger = null;
    private static File logfile = null;

    public static JLoggerLog4j getLogger(Class c) {
        return JLoggerLog4j.getLogger(c.getCanonicalName());
    }

    public static JLoggerLog4j getLogger(Class c, JLoggerI.LogLevel loglevel) {
        return JLoggerLog4j.getLogger(c.getCanonicalName(), loglevel);
    }

    public static JLoggerLog4j getLogger(String name) {
        return JLoggerLog4j.getLogger(name, JLoggerI.LogLevel.INFO);
    }

    public static void setLogfile(File f) {
        logfile = f;
    }

    public static JLoggerLog4j getLogger(String name, JLoggerI.LogLevel loglevel) {
        if (!Platform.isJS()) {
            if (!Jalview.quiet()) {
                Console.errPrintln("Setting log level to " + loglevel.name());
            }
            Log4j.init(loglevel, logfile);
        }
        return JLoggerLog4j.registryContainsKey(name) ? (JLoggerLog4j)JLoggerLog4j.registryGet(name) : new JLoggerLog4j(name, loglevel);
    }

    private JLoggerLog4j(String name, JLoggerI.LogLevel level) {
        this.name = name;
        this.level = level;
        this.loggerSetup();
        this.registryStore();
    }

    @Override
    protected void loggerSetup() {
        if (!Platform.isJS()) {
            this.logger = Log4j.isInit() ? Log4j.getLogger(this.name, this.level) : null;
        }
    }

    @Override
    public boolean loggerExists() {
        return this.logger != null;
    }

    @Override
    protected void loggerSetLevel(JLoggerI.LogLevel level) {
        if (this.loggerExists()) {
            Log4j.setLevel(this.logger, level);
        }
    }

    @Override
    protected void loggerLogMessage(JLoggerI.LogLevel level, String message, Throwable t) {
        if (!this.loggerExists()) {
            return;
        }
        if (t != null) {
            switch (level) {
                case FATAL: {
                    this.logger.fatal(message, t);
                    break;
                }
                case ERROR: {
                    this.logger.error(message, t);
                    break;
                }
                case WARN: {
                    this.logger.warn(message, t);
                    break;
                }
                case INFO: {
                    this.logger.info(message, t);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message, t);
                    break;
                }
                case TRACE: {
                    this.logger.trace(message, t);
                    break;
                }
                case ALL: {
                    this.logger.trace(message, t);
                }
            }
        } else {
            switch (level) {
                case FATAL: {
                    this.logger.fatal(message);
                    break;
                }
                case ERROR: {
                    this.logger.error(message);
                    break;
                }
                case WARN: {
                    this.logger.warn(message);
                    break;
                }
                case INFO: {
                    this.logger.info(message);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(message);
                    break;
                }
                case TRACE: {
                    this.logger.trace(message);
                    break;
                }
                case ALL: {
                    this.logger.trace(message);
                }
            }
        }
    }

    private Logger getLoggerObject() {
        return this.logger;
    }

    public static synchronized void addAppender(JLoggerLog4j level, Appender appender) {
        if (!Platform.isJS()) {
            Log4j.addAppender(level.getLoggerObject(), appender);
        }
    }

    public static synchronized void addAppender(JLoggerLog4j l1, JLoggerLog4j l2, String name) {
        if (!Platform.isJS()) {
            Log4j.addAppender(l1.getLoggerObject(), l2.getLoggerObject(), name);
        }
    }
}

