/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.fragseq;

import fr.orsay.lri.varna.applications.fragseq.FragSeqFileModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqModel;
import fr.orsay.lri.varna.applications.fragseq.FragSeqNode;
import fr.orsay.lri.varna.applications.fragseq.FragSeqTree;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FragSeqTreeModel
extends DefaultTreeModel
implements TreeWillExpandListener {
    private FragSeqNode _rootIDs = new FragSeqNode("IDs");
    private FragSeqNode _rootFolders = new FragSeqNode("Folders");
    private TreeSet<String> _folders = new TreeSet();
    private Hashtable<String, FragSeqNode> _folderPathToFolderNode = new Hashtable();
    private Hashtable<String, FragSeqNode> _idsToNode = new Hashtable();
    private Hashtable<String, ArrayList<FragSeqNode>> _pathToIDFileNodes = new Hashtable();
    private SORT_MODE _mode = SORT_MODE.PATH;
    FilenameFilter _f = new FilenameFilter(){

        @Override
        public boolean accept(File file, String string) {
            return string.toLowerCase().endsWith(".dbn") || string.toLowerCase().endsWith(".ct") || string.toLowerCase().endsWith(".bpseq") || string.toLowerCase().endsWith(".rnaml");
        }
    };
    private Hashtable<FragSeqNode, Boolean> _isExpanded = new Hashtable();

    public FragSeqTreeModel() {
        this(new FragSeqNode("Folders"));
    }

    public FragSeqTreeModel(TreeNode treeNode) {
        super(treeNode);
        this.setRoot(this._rootFolders);
    }

    public FragSeqNode getPathViewRoot() {
        return this._rootFolders;
    }

    public FragSeqNode getIDViewRoot() {
        return this._rootIDs;
    }

    public void switchToIDView() {
        if (this._mode != SORT_MODE.ID) {
            this.setRoot(this._rootIDs);
        }
        this._mode = SORT_MODE.ID;
    }

    private void removeAllNodes(ArrayList<FragSeqNode> arrayList) {
        for (FragSeqNode fragSeqNode : arrayList) {
            FragSeqNode fragSeqNode2 = (FragSeqNode)fragSeqNode.getParent();
            fragSeqNode2.remove(fragSeqNode);
            if (fragSeqNode2.getChildCount() == 0) {
                fragSeqNode2.removeFromParent();
                this._folderPathToFolderNode.remove(fragSeqNode2);
                if (!(fragSeqNode2.getUserObject() instanceof String)) continue;
                String string = fragSeqNode2.getUserObject().toString();
                continue;
            }
            this.reload(fragSeqNode2);
        }
    }

    public FragSeqNode getNodeForId(String string) {
        FragSeqNode fragSeqNode;
        if (!this._idsToNode.containsKey(string)) {
            fragSeqNode = new FragSeqNode(string);
            this._idsToNode.put(string, fragSeqNode);
            this._rootIDs.add(fragSeqNode);
        }
        fragSeqNode = this._idsToNode.get(string);
        return fragSeqNode;
    }

    public void removeFolder(String string) {
        ArrayList<FragSeqNode> arrayList = new ArrayList<FragSeqNode>();
        Enumeration<TreeNode> enumeration = this._folderPathToFolderNode.get(string).children();
        while (enumeration.hasMoreElements()) {
            FragSeqNode fragSeqNode = (FragSeqNode)enumeration.nextElement();
            arrayList.add(fragSeqNode);
        }
        this.removeAllNodes(arrayList);
        this._folders.remove(string);
    }

    public FragSeqNode insertGroupNode(String string, TreeSet<String> treeSet) {
        FragSeqNode fragSeqNode = new FragSeqNode(string);
        FragSeqNode fragSeqNode2 = this.getRoot();
        int n = treeSet.headSet(string).size();
        fragSeqNode2.insert(fragSeqNode, n);
        this.reload(fragSeqNode);
        return fragSeqNode;
    }

    public void insertFileNode(FragSeqNode fragSeqNode, FragSeqFileModel fragSeqFileModel) {
        FragSeqNode fragSeqNode2 = new FragSeqNode(fragSeqFileModel);
        fragSeqNode.add(fragSeqNode2);
    }

    public FragSeqNode addFolder(String string) {
        FragSeqNode fragSeqNode = null;
        try {
            File file;
            if (!this._folders.contains(string) && (file = new File(string)).isDirectory()) {
                string = file.getCanonicalPath();
                this._folders.add(string);
                fragSeqNode = this.insertGroupNode(string, this._folders);
                this._folderPathToFolderNode.put(string, fragSeqNode);
                for (File file2 : file.listFiles(this._f)) {
                    this.addFile(string, file2.getCanonicalPath());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return fragSeqNode;
    }

    private void addFile(String string, String string2) {
        System.out.println("  => " + string2);
        FragSeqFileModel fragSeqFileModel = new FragSeqFileModel(string, string2);
        this.addFolder(string);
        this.insertFileNode(this._folderPathToFolderNode.get(string), fragSeqFileModel);
    }

    @Override
    public FragSeqNode getRoot() {
        return (FragSeqNode)super.getRoot();
    }

    public ArrayList<String> getFolders() {
        ArrayList<String> arrayList = new ArrayList<String>(this._folders);
        return arrayList;
    }

    public FilenameFilter getFileNameFilter() {
        return this._f;
    }

    public void setFileNameFilter(FilenameFilter filenameFilter) {
        this._f = filenameFilter;
    }

    public boolean isExpanded(FragSeqNode fragSeqNode) {
        if (this._isExpanded.containsKey(fragSeqNode)) {
            return this._isExpanded.get(fragSeqNode);
        }
        return false;
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (treeExpansionEvent.getSource() instanceof FragSeqTree) {
            FragSeqTree fragSeqTree = (FragSeqTree)treeExpansionEvent.getSource();
            TreePath treePath = treeExpansionEvent.getPath();
            FragSeqNode fragSeqNode = (FragSeqNode)treePath.getLastPathComponent();
            this._isExpanded.put(fragSeqNode, true);
            Object object = fragSeqNode.getUserObject();
            if (object instanceof FragSeqFileModel) {
                FragSeqFileModel fragSeqFileModel = (FragSeqFileModel)object;
                if (!fragSeqFileModel._cached) {
                    String string = fragSeqFileModel.getPath();
                    if (!this._pathToIDFileNodes.containsKey(string)) {
                        this._pathToIDFileNodes.put(string, new ArrayList());
                    }
                    ArrayList<FragSeqNode> arrayList = this._pathToIDFileNodes.get(string);
                    for (FragSeqModel fragSeqModel : fragSeqFileModel.getModels()) {
                        fragSeqNode.add(new FragSeqNode(fragSeqModel));
                        FragSeqNode fragSeqNode2 = this.getNodeForId(fragSeqModel.getID());
                        fragSeqNode2.add(new FragSeqNode(fragSeqModel));
                        arrayList.add(fragSeqNode2);
                    }
                }
            }
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        TreePath treePath = treeExpansionEvent.getPath();
        FragSeqNode fragSeqNode = (FragSeqNode)treePath.getLastPathComponent();
        this._isExpanded.put(fragSeqNode, false);
    }

    public static enum SORT_MODE {
        PATH,
        ID;

    }
}

