/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.simpleclient.simpleapp;

import java.util.Date;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Property;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.test.simpleclient.ClientDoc;

public class VamsasDatastore {
    Log log = LogFactory.getLog((Class)VamsasDatastore.class);
    Entry provEntry = null;
    org.exolab.castor.types.Date date = new org.exolab.castor.types.Date(new Date());
    ClientDoc cdoc;
    Hashtable vobj2jv;
    IdentityHashMap jv2vobj;

    public VamsasDatastore(ClientDoc cdoc, Hashtable vobj2jv, IdentityHashMap jv2vobj, Entry provEntry) {
        this.cdoc = cdoc;
        this.vobj2jv = vobj2jv;
        this.jv2vobj = jv2vobj;
        this.provEntry = provEntry;
    }

    protected Vobject getjv2vObj(Object jvobj) {
        if (this.jv2vobj.containsKey(jvobj)) {
            return this.cdoc.getObject((VorbaId)this.jv2vobj.get(jvobj));
        }
        return null;
    }

    protected Object getvObj2jv(Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null) {
            id = this.cdoc.registerObject(vobj);
            this.log.debug((Object)"Registering new object and returning null for getvObj2jv");
            return null;
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId())) {
            return this.vobj2jv.get(vobj.getVorbaId());
        }
        return null;
    }

    protected void bindjvvobj(Object jvobj, Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null && ((id = this.cdoc.registerObject(vobj)) == null || vobj.getVorbaId() == null)) {
            this.log.error((Object)("Failed to get id for " + (vobj.isRegisterable() ? "registerable" : "unregisterable") + " object " + vobj));
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId()) || this.jv2vobj.containsKey(jvobj)) {
            this.log.error((Object)("Duplicate object binding! " + vobj + " id " + vobj.getVorbaId().getId() + " to " + jvobj));
        } else {
            this.vobj2jv.put(vobj.getVorbaId(), jvobj);
            this.jv2vobj.put(jvobj, vobj.getVorbaId());
        }
    }

    public void storeVAMSAS(Object fromAppsDatamodel) {
        boolean nw = false;
        VAMSAS root = null;
        DataSet dataset = (DataSet)this.getjv2vObj(fromAppsDatamodel);
        if (dataset == null) {
            root = this.cdoc.getVamsasRoots()[0];
            dataset = new DataSet();
            root.addDataSet(dataset);
            this.bindjvvobj(fromAppsDatamodel, dataset);
            dataset.setProvenance(this.dummyProvenance());
            dataset.getProvenance().addEntry(this.provEntry);
            nw = true;
        } else {
            root = (VAMSAS)dataset.getV_parent();
        }
    }

    private Property newProperty(String name, String type, String content) {
        Property vProperty = new Property();
        vProperty.setName(name);
        if (type != null) {
            vProperty.setType(type);
        }
        vProperty.setContent(content);
        return vProperty;
    }

    private int[] getSegRange(Seg visSeg, boolean ensureDirection) {
        boolean incl = visSeg.getInclusive();
        int pol = visSeg.getStart() <= visSeg.getEnd() ? 1 : -1;
        int start = visSeg.getStart() + (incl ? 0 : pol);
        int end = visSeg.getEnd() + (incl ? 0 : -pol);
        if (ensureDirection && pol == -1) {
            int t = end;
            end = start;
            start = t;
        }
        return new int[]{start, end, pol < 0 ? 1 : 0};
    }

    public void updateToJalview() {
        VAMSAS[] _roots = this.cdoc.getVamsasRoots();
        for (int _root = 0; _root < _roots.length; ++_root) {
            VAMSAS root = _roots[_root];
            boolean newds = false;
            int _nds = root.getDataSetCount();
            for (int _ds = 0; _ds < _nds; ++_ds) {
                DataSet dataset = root.getDataSet(_ds);
                int iSize = dataset.getSequenceCount();
                Object appsdataset = this.getvObj2jv(dataset);
                boolean jremain = false;
                if (appsdataset == null) {
                    this.log.debug((Object)"Initialising new dataset fields");
                    newds = true;
                    Vector dsseqs = new Vector();
                    continue;
                }
                this.log.debug((Object)"Update dataset from vamsas dataset.");
            }
        }
    }

    private int[] getBounds(RangeType dseta) {
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error("Invalid vamsas RangeType - cannot resolve both lists of Pos and Seg from choice!");
            }
            if (dseta.getSegCount() > 0) {
                se = this.getSegRange(dseta.getSeg(0), true);
                int sSize = dseta.getSegCount();
                for (int s = 1; s < sSize; ++s) {
                    int[] nse = this.getSegRange(dseta.getSeg(s), true);
                    if (se[0] > nse[0]) {
                        se[0] = nse[0];
                    }
                    if (se[1] >= nse[1]) continue;
                    se[1] = nse[1];
                }
            }
            if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                se = new int[]{pos, pos};
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    if (se[0] > pos) {
                        se[0] = pos;
                    }
                    if (se[1] >= pos) continue;
                    se[1] = pos;
                }
            }
            return se;
        }
        return null;
    }

    private int[] getMapping(RangeType dseta) {
        Vector<Integer> posList = new Vector<Integer>();
        if (dseta != null) {
            int[] se = null;
            if (dseta.getSegCount() > 0 && dseta.getPosCount() > 0) {
                throw new Error("Invalid vamsas RangeType - cannot resolve both lists of Pos and Seg from choice!");
            }
            if (dseta.getSegCount() > 0) {
                int sSize = dseta.getSegCount();
                for (int s = 0; s < sSize; ++s) {
                    se = this.getSegRange(dseta.getSeg(s), false);
                    int se_end = se[1 - se[2]] + (se[2] == 0 ? 1 : -1);
                    for (int p = se[se[2]]; p != se_end; p += se[2] == 0 ? 1 : -1) {
                        posList.add(new Integer(p));
                    }
                }
            } else if (dseta.getPosCount() > 0) {
                int pos = dseta.getPos(0).getI();
                int pSize = dseta.getPosCount();
                for (int p = 0; p < pSize; ++p) {
                    pos = dseta.getPos(p).getI();
                    posList.add(new Integer(pos));
                }
            }
        }
        if (posList != null && posList.size() > 0) {
            int[] range = new int[posList.size()];
            for (int i = 0; i < range.length; ++i) {
                range[i] = (Integer)posList.elementAt(i);
            }
            posList.clear();
            return range;
        }
        return null;
    }

    Provenance dummyProvenance() {
        return this.dummyProvenance(null);
    }

    Entry dummyPEntry(String action) {
        Entry entry = new Entry();
        entry.setApp(this.provEntry.getApp());
        if (action != null) {
            entry.setAction(action);
        } else {
            entry.setAction("created.");
        }
        entry.setDate(new Date());
        entry.setUser(this.provEntry.getUser());
        return entry;
    }

    Provenance dummyProvenance(String action) {
        Provenance prov = new Provenance();
        prov.addEntry(this.dummyPEntry(action));
        return prov;
    }

    void addProvenance(Provenance p, String action) {
        p.addEntry(this.dummyPEntry(action));
    }
}

