/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.slivka;

import jalview.api.FeatureColourI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.FeatureMatcherSetI;
import jalview.io.AnnotationFile;
import jalview.io.DataSourceType;
import jalview.io.FeaturesFile;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.AnnotationWebServiceClientI;
import jalview.ws2.client.slivka.SlivkaWSClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

class SlivkaAnnotationWSClient
extends SlivkaWSClient
implements AnnotationWebServiceClientI {
    SlivkaAnnotationWSClient(SlivkaClient client, SlivkaService service) {
        super(client, service);
    }

    @Override
    public List<AlignmentAnnotation> attachAnnotations(WebServiceJobHandle job, List<SequenceI> sequences, Map<String, FeatureColourI> colours, Map<String, FeatureMatcherSetI> filters) throws IOException {
        Alignment aln = new Alignment(sequences.toArray(new SequenceI[sequences.size()]));
        boolean featPresent = false;
        boolean annotPresent = false;
        for (RemoteFile f : this.client.fetchFilesList(job.getJobId())) {
            FeaturesFile ff;
            Matcher match = mediaTypePattern.matcher(f.getMediaType());
            if (!match.find()) continue;
            String fmt = match.group(1);
            if (fmt.equalsIgnoreCase("jalview-annotations")) {
                annotPresent = new AnnotationFile().readAnnotationFileWithCalcId(aln, this.service.getId(), f.getContentUrl().toString(), DataSourceType.URL);
                if (!annotPresent) continue;
                Console.debug(String.format("loaded annotations for %s", this.service.getId()));
                continue;
            }
            if (!fmt.equalsIgnoreCase("jalview-features") || !(featPresent = (ff = new FeaturesFile(f.getContentUrl().toString(), DataSourceType.URL)).parse(aln, colours, filters, false, true))) continue;
            Console.debug(String.format("loaded features for %s", this.service.getId()));
        }
        if (!annotPresent) {
            Console.debug(String.format("no annotations found for %s", this.service.getId()));
        }
        if (!featPresent) {
            Console.debug(String.format("no features found for %s", this.service.getId()));
        }
        return aln.getAlignmentAnnotation() != null ? Arrays.asList(aln.getAlignmentAnnotation()) : Collections.emptyList();
    }
}

